/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils;

import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.BeanIntrospector;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.IntrospectionContext;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.logging.Log;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.logging.LogFactory;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Locale;

public class FluentPropertyBeanIntrospector
implements BeanIntrospector {
    public static final String DEFAULT_WRITE_METHOD_PREFIX = "set";
    private final Log log = LogFactory.getLog(this.getClass());
    private final String writeMethodPrefix;

    public FluentPropertyBeanIntrospector(String writePrefix) {
        if (writePrefix == null) {
            throw new IllegalArgumentException("Prefix for write methods must not be null!");
        }
        this.writeMethodPrefix = writePrefix;
    }

    public FluentPropertyBeanIntrospector() {
        this(DEFAULT_WRITE_METHOD_PREFIX);
    }

    public String getWriteMethodPrefix() {
        return this.writeMethodPrefix;
    }

    public void introspect(IntrospectionContext icontext) throws IntrospectionException {
        for (Method m : icontext.getTargetClass().getMethods()) {
            if (!m.getName().startsWith(this.getWriteMethodPrefix())) continue;
            String propertyName = this.propertyName(m);
            PropertyDescriptor pd = icontext.getPropertyDescriptor(propertyName);
            try {
                if (pd == null) {
                    icontext.addPropertyDescriptor(this.createFluentPropertyDescritor(m, propertyName));
                    continue;
                }
                if (pd.getWriteMethod() != null) continue;
                pd.setWriteMethod(m);
            }
            catch (IntrospectionException e) {
                this.log.warn("Error when creating PropertyDescriptor for " + m + "! Ignoring this property.", e);
            }
        }
    }

    private String propertyName(Method m) {
        String methodName = m.getName().substring(this.getWriteMethodPrefix().length());
        return methodName.length() > 1 ? Character.toLowerCase(methodName.charAt(0)) + methodName.substring(1) : methodName.toLowerCase(Locale.ENGLISH);
    }

    private PropertyDescriptor createFluentPropertyDescritor(Method m, String propertyName) throws IntrospectionException {
        return new PropertyDescriptor(this.propertyName(m), null, m);
    }
}

