/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.jackson.databind.ser.std;

import com.amazonaws.athena.jdbc.shaded.jackson.core.JsonGenerator;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.JavaType;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.JsonMappingException;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.JsonNode;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.SerializerProvider;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;

public class StdKeySerializer
extends StdSerializer<Object> {
    public StdKeySerializer() {
        super(Object.class);
    }

    @Override
    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        String str;
        Class<?> cls = value.getClass();
        if (cls == String.class) {
            str = (String)value;
        } else {
            if (Date.class.isAssignableFrom(cls)) {
                provider.defaultSerializeDateKey((Date)value, jgen);
                return;
            }
            str = cls == Class.class ? ((Class)value).getName() : value.toString();
        }
        jgen.writeFieldName(str);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string");
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectStringFormat(typeHint);
    }
}

