/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.jackson.databind.ser;

import com.amazonaws.athena.jdbc.shaded.jackson.core.JsonGenerator;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.JavaType;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.JsonSerializer;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.SerializerProvider;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.ser.BeanPropertyWriter;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.ser.BeanSerializerBuilder;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.ser.impl.BeanAsArraySerializer;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.ser.impl.ObjectIdWriter;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.ser.impl.UnwrappingBeanSerializer;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.ser.std.BeanSerializerBase;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.util.NameTransformer;
import java.io.IOException;

public class BeanSerializer
extends BeanSerializerBase {
    private static final long serialVersionUID = -4536893235025590367L;

    public BeanSerializer(JavaType type, BeanSerializerBuilder builder, BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        super(type, builder, properties, filteredProperties);
    }

    protected BeanSerializer(BeanSerializerBase src) {
        super(src);
    }

    protected BeanSerializer(BeanSerializerBase src, ObjectIdWriter objectIdWriter) {
        super(src, objectIdWriter);
    }

    protected BeanSerializer(BeanSerializerBase src, ObjectIdWriter objectIdWriter, Object filterId) {
        super(src, objectIdWriter, filterId);
    }

    protected BeanSerializer(BeanSerializerBase src, String[] toIgnore) {
        super(src, toIgnore);
    }

    public static BeanSerializer createDummy(JavaType forType) {
        return new BeanSerializer(forType, null, NO_PROPS, null);
    }

    @Override
    public JsonSerializer<Object> unwrappingSerializer(NameTransformer unwrapper) {
        return new UnwrappingBeanSerializer((BeanSerializerBase)this, unwrapper);
    }

    @Override
    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return new BeanSerializer((BeanSerializerBase)this, objectIdWriter, this._propertyFilterId);
    }

    @Override
    protected BeanSerializerBase withFilterId(Object filterId) {
        return new BeanSerializer((BeanSerializerBase)this, this._objectIdWriter, filterId);
    }

    @Override
    protected BeanSerializerBase withIgnorals(String[] toIgnore) {
        return new BeanSerializer((BeanSerializerBase)this, toIgnore);
    }

    @Override
    protected BeanSerializerBase asArraySerializer() {
        if (this._objectIdWriter == null && this._anyGetterWriter == null && this._propertyFilterId == null) {
            return new BeanAsArraySerializer(this);
        }
        return this;
    }

    @Override
    public final void serialize(Object bean, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._objectIdWriter != null) {
            this._serializeWithObjectId(bean, gen, provider, true);
            return;
        }
        gen.writeStartObject();
        gen.setCurrentValue(bean);
        if (this._propertyFilterId != null) {
            this.serializeFieldsFiltered(bean, gen, provider);
        } else {
            this.serializeFields(bean, gen, provider);
        }
        gen.writeEndObject();
    }

    public String toString() {
        return "BeanSerializer for " + this.handledType().getName();
    }
}

