/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.AmazonServiceException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.transform.AbstractErrorUnmarshaller;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.DeserializationFeature;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.JsonNode;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.ObjectMapper;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.PropertyNamingStrategy;

@SdkInternalApi
@ThreadSafe
public class JsonErrorUnmarshaller
extends AbstractErrorUnmarshaller<JsonNode> {
    public static final JsonErrorUnmarshaller DEFAULT_UNMARSHALLER = new JsonErrorUnmarshaller(AmazonServiceException.class, null);
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setPropertyNamingStrategy(new PropertyNamingStrategy.PascalCaseStrategy());
    private final String handledErrorCode;

    public JsonErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass, String handledErrorCode) {
        super(exceptionClass);
        this.handledErrorCode = handledErrorCode;
    }

    @Override
    public AmazonServiceException unmarshall(JsonNode jsonContent) throws Exception {
        return (AmazonServiceException)MAPPER.treeToValue(jsonContent, this.exceptionClass);
    }

    public boolean matchErrorCode(String actualErrorCode) {
        if (this.handledErrorCode == null) {
            return true;
        }
        return this.handledErrorCode.equals(actualErrorCode);
    }
}

