/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.AmazonClientException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.DefaultRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.Request;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.http.HttpMethodName;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.Column;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.Order;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.Partition;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.SerDeInfo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.SkewedInfo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.StorageDescriptor;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.UpdatePartitionRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.transform.Marshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringInputStream;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringUtils;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class UpdatePartitionRequestMarshaller
implements Marshaller<Request<UpdatePartitionRequest>, UpdatePartitionRequest> {
    @Override
    public Request<UpdatePartitionRequest> marshall(UpdatePartitionRequest updatePartitionRequest) {
        if (updatePartitionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdatePartitionRequest> request = new DefaultRequest<UpdatePartitionRequest>(updatePartitionRequest, "AmazonDataCatalog");
        String target = "AmazonDataCatalog.UpdatePartition";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Partition partition;
            ListWithAutoConstructFlag partitionValueListList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (updatePartitionRequest.getCatalogId() != null) {
                jsonWriter.key("catalogId").value((Object)updatePartitionRequest.getCatalogId());
            }
            if (updatePartitionRequest.getNamespaceName() != null) {
                jsonWriter.key("namespaceName").value((Object)updatePartitionRequest.getNamespaceName());
            }
            if (updatePartitionRequest.getTableName() != null) {
                jsonWriter.key("tableName").value((Object)updatePartitionRequest.getTableName());
            }
            if (!((partitionValueListList = (ListWithAutoConstructFlag)updatePartitionRequest.getPartitionValueList()) == null || partitionValueListList.isAutoConstruct() && partitionValueListList.isEmpty())) {
                jsonWriter.key("partitionValueList");
                jsonWriter.array();
                for (String partitionValueListListValue : partitionValueListList) {
                    if (partitionValueListListValue == null) continue;
                    jsonWriter.value((Object)partitionValueListListValue);
                }
                jsonWriter.endArray();
            }
            if ((partition = updatePartitionRequest.getPartition()) != null) {
                StorageDescriptor storageDescriptor;
                jsonWriter.key("partition");
                jsonWriter.object();
                ListWithAutoConstructFlag valuesList = (ListWithAutoConstructFlag)partition.getValues();
                if (!(valuesList == null || valuesList.isAutoConstruct() && valuesList.isEmpty())) {
                    jsonWriter.key("values");
                    jsonWriter.array();
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue == null) continue;
                        jsonWriter.value((Object)valuesListValue);
                    }
                    jsonWriter.endArray();
                }
                if (partition.getNamespaceName() != null) {
                    jsonWriter.key("namespaceName").value((Object)partition.getNamespaceName());
                }
                if (partition.getTableName() != null) {
                    jsonWriter.key("tableName").value((Object)partition.getTableName());
                }
                if (partition.getCreationTime() != null) {
                    jsonWriter.key("creationTime").value(partition.getCreationTime());
                }
                if (partition.getLastAccessTime() != null) {
                    jsonWriter.key("lastAccessTime").value(partition.getLastAccessTime());
                }
                if ((storageDescriptor = partition.getStorageDescriptor()) != null) {
                    SkewedInfo skewedInfo;
                    ListWithAutoConstructFlag listWithAutoConstructFlag;
                    ListWithAutoConstructFlag bucketColumnsList;
                    SerDeInfo serdeInfo;
                    jsonWriter.key("storageDescriptor");
                    jsonWriter.object();
                    ListWithAutoConstructFlag columnsList = (ListWithAutoConstructFlag)storageDescriptor.getColumns();
                    if (!(columnsList == null || columnsList.isAutoConstruct() && columnsList.isEmpty())) {
                        jsonWriter.key("columns");
                        jsonWriter.array();
                        for (Object columnsListValue : columnsList) {
                            if (columnsListValue == null) continue;
                            jsonWriter.object();
                            if (((Column)columnsListValue).getName() != null) {
                                jsonWriter.key("name").value((Object)((Column)columnsListValue).getName());
                            }
                            if (((Column)columnsListValue).getType() != null) {
                                jsonWriter.key("type").value((Object)((Column)columnsListValue).getType());
                            }
                            if (((Column)columnsListValue).getComment() != null) {
                                jsonWriter.key("comment").value((Object)((Column)columnsListValue).getComment());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (storageDescriptor.getLocation() != null) {
                        jsonWriter.key("location").value((Object)storageDescriptor.getLocation());
                    }
                    if (storageDescriptor.getInputFormat() != null) {
                        jsonWriter.key("inputFormat").value((Object)storageDescriptor.getInputFormat());
                    }
                    if (storageDescriptor.getOutputFormat() != null) {
                        jsonWriter.key("outputFormat").value((Object)storageDescriptor.getOutputFormat());
                    }
                    if (storageDescriptor.isCompressed() != null) {
                        jsonWriter.key("compressed").value((Object)storageDescriptor.isCompressed());
                    }
                    if (storageDescriptor.getNumberOfBuckets() != null) {
                        jsonWriter.key("numberOfBuckets").value((Object)storageDescriptor.getNumberOfBuckets());
                    }
                    if ((serdeInfo = storageDescriptor.getSerdeInfo()) != null) {
                        jsonWriter.key("serdeInfo");
                        jsonWriter.object();
                        if (serdeInfo.getName() != null) {
                            jsonWriter.key("name").value((Object)serdeInfo.getName());
                        }
                        if (serdeInfo.getSerializationLibrary() != null) {
                            jsonWriter.key("serializationLibrary").value((Object)serdeInfo.getSerializationLibrary());
                        }
                        if (serdeInfo.getParameters() != null) {
                            jsonWriter.key("parameters");
                            jsonWriter.object();
                            for (Map.Entry entry : serdeInfo.getParameters().entrySet()) {
                                if (entry.getValue() == null) continue;
                                jsonWriter.key((String)entry.getKey());
                                jsonWriter.value(entry.getValue());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    if (!((bucketColumnsList = (ListWithAutoConstructFlag)storageDescriptor.getBucketColumns()) == null || bucketColumnsList.isAutoConstruct() && bucketColumnsList.isEmpty())) {
                        jsonWriter.key("bucketColumns");
                        jsonWriter.array();
                        for (Object bucketColumnsListValue : bucketColumnsList) {
                            if (bucketColumnsListValue == null) continue;
                            jsonWriter.value(bucketColumnsListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((listWithAutoConstructFlag = (ListWithAutoConstructFlag)storageDescriptor.getSortColumns()) == null || listWithAutoConstructFlag.isAutoConstruct() && listWithAutoConstructFlag.isEmpty())) {
                        jsonWriter.key("sortColumns");
                        jsonWriter.array();
                        for (Order sortColumnsListValue : listWithAutoConstructFlag) {
                            if (sortColumnsListValue == null) continue;
                            jsonWriter.object();
                            if (sortColumnsListValue.getColumn() != null) {
                                jsonWriter.key("column").value((Object)sortColumnsListValue.getColumn());
                            }
                            if (sortColumnsListValue.getOrder() != null) {
                                jsonWriter.key("order").value((Object)sortColumnsListValue.getOrder());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (storageDescriptor.getParameters() != null) {
                        jsonWriter.key("parameters");
                        jsonWriter.object();
                        for (Map.Entry<String, String> parametersListValue : storageDescriptor.getParameters().entrySet()) {
                            if (parametersListValue.getValue() == null) continue;
                            jsonWriter.key(parametersListValue.getKey());
                            jsonWriter.value((Object)parametersListValue.getValue());
                        }
                        jsonWriter.endObject();
                    }
                    if ((skewedInfo = storageDescriptor.getSkewedInfo()) != null) {
                        ListWithAutoConstructFlag skewedColumnValuesList;
                        jsonWriter.key("skewedInfo");
                        jsonWriter.object();
                        ListWithAutoConstructFlag skewedColumnNamesList = (ListWithAutoConstructFlag)skewedInfo.getSkewedColumnNames();
                        if (!(skewedColumnNamesList == null || skewedColumnNamesList.isAutoConstruct() && skewedColumnNamesList.isEmpty())) {
                            jsonWriter.key("skewedColumnNames");
                            jsonWriter.array();
                            for (String skewedColumnNamesListValue : skewedColumnNamesList) {
                                if (skewedColumnNamesListValue == null) continue;
                                jsonWriter.value((Object)skewedColumnNamesListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if (!((skewedColumnValuesList = (ListWithAutoConstructFlag)skewedInfo.getSkewedColumnValues()) == null || skewedColumnValuesList.isAutoConstruct() && skewedColumnValuesList.isEmpty())) {
                            jsonWriter.key("skewedColumnValues");
                            jsonWriter.array();
                            for (String string : skewedColumnValuesList) {
                                if (string == null) continue;
                                jsonWriter.value((Object)string);
                            }
                            jsonWriter.endArray();
                        }
                        if (skewedInfo.getSkewedColumnValueLocationMaps() != null) {
                            jsonWriter.key("skewedColumnValueLocationMaps");
                            jsonWriter.object();
                            for (Map.Entry entry : skewedInfo.getSkewedColumnValueLocationMaps().entrySet()) {
                                if (entry.getValue() == null) continue;
                                jsonWriter.key((String)entry.getKey());
                                jsonWriter.value(entry.getValue());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    if (storageDescriptor.isStoredAsSubDirectories() != null) {
                        jsonWriter.key("storedAsSubDirectories").value((Object)storageDescriptor.isStoredAsSubDirectories());
                    }
                    jsonWriter.endObject();
                }
                if (partition.getParameters() != null) {
                    jsonWriter.key("parameters");
                    jsonWriter.object();
                    for (Map.Entry<String, String> parametersListValue : partition.getParameters().entrySet()) {
                        if (parametersListValue.getValue() == null) continue;
                        jsonWriter.key(parametersListValue.getKey());
                        jsonWriter.value((Object)parametersListValue.getValue());
                    }
                    jsonWriter.endObject();
                }
                if (partition.getLastAnalyzedTime() != null) {
                    jsonWriter.key("lastAnalyzedTime").value(partition.getLastAnalyzedTime());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

