/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.AmazonClientException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.DefaultRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.Request;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.http.HttpMethodName;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.Function;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.ResourceUri;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.UpdateFunctionRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.transform.Marshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringInputStream;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringUtils;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateFunctionRequestMarshaller
implements Marshaller<Request<UpdateFunctionRequest>, UpdateFunctionRequest> {
    @Override
    public Request<UpdateFunctionRequest> marshall(UpdateFunctionRequest updateFunctionRequest) {
        if (updateFunctionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateFunctionRequest> request = new DefaultRequest<UpdateFunctionRequest>(updateFunctionRequest, "AmazonDataCatalog");
        String target = "AmazonDataCatalog.UpdateFunction";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Function newFunction;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (updateFunctionRequest.getCatalogId() != null) {
                jsonWriter.key("catalogId").value((Object)updateFunctionRequest.getCatalogId());
            }
            if (updateFunctionRequest.getNamespaceName() != null) {
                jsonWriter.key("namespaceName").value((Object)updateFunctionRequest.getNamespaceName());
            }
            if (updateFunctionRequest.getFunctionName() != null) {
                jsonWriter.key("functionName").value((Object)updateFunctionRequest.getFunctionName());
            }
            if ((newFunction = updateFunctionRequest.getNewFunction()) != null) {
                ListWithAutoConstructFlag resourceUrisList;
                jsonWriter.key("newFunction");
                jsonWriter.object();
                if (newFunction.getFunctionName() != null) {
                    jsonWriter.key("functionName").value((Object)newFunction.getFunctionName());
                }
                if (newFunction.getClassName() != null) {
                    jsonWriter.key("className").value((Object)newFunction.getClassName());
                }
                if (newFunction.getOwnerName() != null) {
                    jsonWriter.key("ownerName").value((Object)newFunction.getOwnerName());
                }
                if (newFunction.getOwnerType() != null) {
                    jsonWriter.key("ownerType").value((Object)newFunction.getOwnerType());
                }
                if (newFunction.getCreateTime() != null) {
                    jsonWriter.key("createTime").value(newFunction.getCreateTime());
                }
                if (!((resourceUrisList = (ListWithAutoConstructFlag)newFunction.getResourceUris()) == null || resourceUrisList.isAutoConstruct() && resourceUrisList.isEmpty())) {
                    jsonWriter.key("resourceUris");
                    jsonWriter.array();
                    for (ResourceUri resourceUrisListValue : resourceUrisList) {
                        if (resourceUrisListValue == null) continue;
                        jsonWriter.object();
                        if (resourceUrisListValue.getResourceType() != null) {
                            jsonWriter.key("resourceType").value((Object)resourceUrisListValue.getResourceType());
                        }
                        if (resourceUrisListValue.getUri() != null) {
                            jsonWriter.key("uri").value((Object)resourceUrisListValue.getUri());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

