/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.AmazonClientException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.DefaultRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.Request;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.http.HttpMethodName;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.CreateNamespaceRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.Namespace;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.transform.Marshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringInputStream;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringUtils;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class CreateNamespaceRequestMarshaller
implements Marshaller<Request<CreateNamespaceRequest>, CreateNamespaceRequest> {
    @Override
    public Request<CreateNamespaceRequest> marshall(CreateNamespaceRequest createNamespaceRequest) {
        if (createNamespaceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateNamespaceRequest> request = new DefaultRequest<CreateNamespaceRequest>(createNamespaceRequest, "AmazonDataCatalog");
        String target = "AmazonDataCatalog.CreateNamespace";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Namespace namespace;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createNamespaceRequest.getCatalogId() != null) {
                jsonWriter.key("catalogId").value((Object)createNamespaceRequest.getCatalogId());
            }
            if ((namespace = createNamespaceRequest.getNamespace()) != null) {
                jsonWriter.key("namespace");
                jsonWriter.object();
                if (namespace.getName() != null) {
                    jsonWriter.key("name").value((Object)namespace.getName());
                }
                if (namespace.getDescription() != null) {
                    jsonWriter.key("description").value((Object)namespace.getDescription());
                }
                if (namespace.getLocationUri() != null) {
                    jsonWriter.key("locationUri").value((Object)namespace.getLocationUri());
                }
                if (namespace.getParameters() != null) {
                    jsonWriter.key("parameters");
                    jsonWriter.object();
                    for (Map.Entry<String, String> parametersListValue : namespace.getParameters().entrySet()) {
                        if (parametersListValue.getValue() == null) continue;
                        jsonWriter.key(parametersListValue.getKey());
                        jsonWriter.value((Object)parametersListValue.getValue());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

