/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.Partition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdatePartitionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String catalogId;
    private String namespaceName;
    private String tableName;
    private ListWithAutoConstructFlag<String> partitionValueList;
    private Partition partition;

    public String getCatalogId() {
        return this.catalogId;
    }

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    public UpdatePartitionRequest withCatalogId(String catalogId) {
        this.catalogId = catalogId;
        return this;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public void setNamespaceName(String namespaceName) {
        this.namespaceName = namespaceName;
    }

    public UpdatePartitionRequest withNamespaceName(String namespaceName) {
        this.namespaceName = namespaceName;
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public UpdatePartitionRequest withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public List<String> getPartitionValueList() {
        if (this.partitionValueList == null) {
            this.partitionValueList = new ListWithAutoConstructFlag();
            this.partitionValueList.setAutoConstruct(true);
        }
        return this.partitionValueList;
    }

    public void setPartitionValueList(Collection<String> partitionValueList) {
        if (partitionValueList == null) {
            this.partitionValueList = null;
            return;
        }
        ListWithAutoConstructFlag partitionValueListCopy = new ListWithAutoConstructFlag(partitionValueList.size());
        partitionValueListCopy.addAll(partitionValueList);
        this.partitionValueList = partitionValueListCopy;
    }

    public UpdatePartitionRequest withPartitionValueList(String ... partitionValueList) {
        if (this.getPartitionValueList() == null) {
            this.setPartitionValueList(new ArrayList<String>(partitionValueList.length));
        }
        for (String value : partitionValueList) {
            this.getPartitionValueList().add(value);
        }
        return this;
    }

    public UpdatePartitionRequest withPartitionValueList(Collection<String> partitionValueList) {
        if (partitionValueList == null) {
            this.partitionValueList = null;
        } else {
            ListWithAutoConstructFlag partitionValueListCopy = new ListWithAutoConstructFlag(partitionValueList.size());
            partitionValueListCopy.addAll(partitionValueList);
            this.partitionValueList = partitionValueListCopy;
        }
        return this;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public void setPartition(Partition partition) {
        this.partition = partition;
    }

    public UpdatePartitionRequest withPartition(Partition partition) {
        this.partition = partition;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCatalogId() != null) {
            sb.append("CatalogId: " + this.getCatalogId() + ",");
        }
        if (this.getNamespaceName() != null) {
            sb.append("NamespaceName: " + this.getNamespaceName() + ",");
        }
        if (this.getTableName() != null) {
            sb.append("TableName: " + this.getTableName() + ",");
        }
        if (this.getPartitionValueList() != null) {
            sb.append("PartitionValueList: " + this.getPartitionValueList() + ",");
        }
        if (this.getPartition() != null) {
            sb.append("Partition: " + this.getPartition());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCatalogId() == null ? 0 : this.getCatalogId().hashCode());
        hashCode = 31 * hashCode + (this.getNamespaceName() == null ? 0 : this.getNamespaceName().hashCode());
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getPartitionValueList() == null ? 0 : this.getPartitionValueList().hashCode());
        hashCode = 31 * hashCode + (this.getPartition() == null ? 0 : this.getPartition().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePartitionRequest)) {
            return false;
        }
        UpdatePartitionRequest other = (UpdatePartitionRequest)obj;
        if (other.getCatalogId() == null ^ this.getCatalogId() == null) {
            return false;
        }
        if (other.getCatalogId() != null && !other.getCatalogId().equals(this.getCatalogId())) {
            return false;
        }
        if (other.getNamespaceName() == null ^ this.getNamespaceName() == null) {
            return false;
        }
        if (other.getNamespaceName() != null && !other.getNamespaceName().equals(this.getNamespaceName())) {
            return false;
        }
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getPartitionValueList() == null ^ this.getPartitionValueList() == null) {
            return false;
        }
        if (other.getPartitionValueList() != null && !other.getPartitionValueList().equals(this.getPartitionValueList())) {
            return false;
        }
        if (other.getPartition() == null ^ this.getPartition() == null) {
            return false;
        }
        return other.getPartition() == null || other.getPartition().equals(this.getPartition());
    }

    @Override
    public UpdatePartitionRequest clone() {
        return (UpdatePartitionRequest)super.clone();
    }
}

