/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.Column;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.StorageDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Table
implements Serializable,
Cloneable {
    private String name;
    private String owner;
    private Date createTime;
    private Date lastAccessTime;
    private Date lastAnalyzedTime;
    private Integer retention;
    private StorageDescriptor storageDescriptor;
    private ListWithAutoConstructFlag<Column> partitionKeys;
    private String viewOriginalText;
    private String viewExpandedText;
    private String tableType;
    private Map<String, String> parameters;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Table withName(String name) {
        this.name = name;
        return this;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Table withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Table withCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public Table withLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
        return this;
    }

    public Date getLastAnalyzedTime() {
        return this.lastAnalyzedTime;
    }

    public void setLastAnalyzedTime(Date lastAnalyzedTime) {
        this.lastAnalyzedTime = lastAnalyzedTime;
    }

    public Table withLastAnalyzedTime(Date lastAnalyzedTime) {
        this.lastAnalyzedTime = lastAnalyzedTime;
        return this;
    }

    public Integer getRetention() {
        return this.retention;
    }

    public void setRetention(Integer retention) {
        this.retention = retention;
    }

    public Table withRetention(Integer retention) {
        this.retention = retention;
        return this;
    }

    public StorageDescriptor getStorageDescriptor() {
        return this.storageDescriptor;
    }

    public void setStorageDescriptor(StorageDescriptor storageDescriptor) {
        this.storageDescriptor = storageDescriptor;
    }

    public Table withStorageDescriptor(StorageDescriptor storageDescriptor) {
        this.storageDescriptor = storageDescriptor;
        return this;
    }

    public List<Column> getPartitionKeys() {
        if (this.partitionKeys == null) {
            this.partitionKeys = new ListWithAutoConstructFlag();
            this.partitionKeys.setAutoConstruct(true);
        }
        return this.partitionKeys;
    }

    public void setPartitionKeys(Collection<Column> partitionKeys) {
        if (partitionKeys == null) {
            this.partitionKeys = null;
            return;
        }
        ListWithAutoConstructFlag partitionKeysCopy = new ListWithAutoConstructFlag(partitionKeys.size());
        partitionKeysCopy.addAll(partitionKeys);
        this.partitionKeys = partitionKeysCopy;
    }

    public Table withPartitionKeys(Column ... partitionKeys) {
        if (this.getPartitionKeys() == null) {
            this.setPartitionKeys(new ArrayList<Column>(partitionKeys.length));
        }
        for (Column value : partitionKeys) {
            this.getPartitionKeys().add(value);
        }
        return this;
    }

    public Table withPartitionKeys(Collection<Column> partitionKeys) {
        if (partitionKeys == null) {
            this.partitionKeys = null;
        } else {
            ListWithAutoConstructFlag partitionKeysCopy = new ListWithAutoConstructFlag(partitionKeys.size());
            partitionKeysCopy.addAll(partitionKeys);
            this.partitionKeys = partitionKeysCopy;
        }
        return this;
    }

    public String getViewOriginalText() {
        return this.viewOriginalText;
    }

    public void setViewOriginalText(String viewOriginalText) {
        this.viewOriginalText = viewOriginalText;
    }

    public Table withViewOriginalText(String viewOriginalText) {
        this.viewOriginalText = viewOriginalText;
        return this;
    }

    public String getViewExpandedText() {
        return this.viewExpandedText;
    }

    public void setViewExpandedText(String viewExpandedText) {
        this.viewExpandedText = viewExpandedText;
    }

    public Table withViewExpandedText(String viewExpandedText) {
        this.viewExpandedText = viewExpandedText;
        return this;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public Table withTableType(String tableType) {
        this.tableType = tableType;
        return this;
    }

    public Map<String, String> getParameters() {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Table withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public Table addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, String>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public Table clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getOwner() != null) {
            sb.append("Owner: " + this.getOwner() + ",");
        }
        if (this.getCreateTime() != null) {
            sb.append("CreateTime: " + this.getCreateTime() + ",");
        }
        if (this.getLastAccessTime() != null) {
            sb.append("LastAccessTime: " + this.getLastAccessTime() + ",");
        }
        if (this.getLastAnalyzedTime() != null) {
            sb.append("LastAnalyzedTime: " + this.getLastAnalyzedTime() + ",");
        }
        if (this.getRetention() != null) {
            sb.append("Retention: " + this.getRetention() + ",");
        }
        if (this.getStorageDescriptor() != null) {
            sb.append("StorageDescriptor: " + this.getStorageDescriptor() + ",");
        }
        if (this.getPartitionKeys() != null) {
            sb.append("PartitionKeys: " + this.getPartitionKeys() + ",");
        }
        if (this.getViewOriginalText() != null) {
            sb.append("ViewOriginalText: " + this.getViewOriginalText() + ",");
        }
        if (this.getViewExpandedText() != null) {
            sb.append("ViewExpandedText: " + this.getViewExpandedText() + ",");
        }
        if (this.getTableType() != null) {
            sb.append("TableType: " + this.getTableType() + ",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: " + this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTime() == null ? 0 : this.getCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastAccessTime() == null ? 0 : this.getLastAccessTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastAnalyzedTime() == null ? 0 : this.getLastAnalyzedTime().hashCode());
        hashCode = 31 * hashCode + (this.getRetention() == null ? 0 : this.getRetention().hashCode());
        hashCode = 31 * hashCode + (this.getStorageDescriptor() == null ? 0 : this.getStorageDescriptor().hashCode());
        hashCode = 31 * hashCode + (this.getPartitionKeys() == null ? 0 : this.getPartitionKeys().hashCode());
        hashCode = 31 * hashCode + (this.getViewOriginalText() == null ? 0 : this.getViewOriginalText().hashCode());
        hashCode = 31 * hashCode + (this.getViewExpandedText() == null ? 0 : this.getViewExpandedText().hashCode());
        hashCode = 31 * hashCode + (this.getTableType() == null ? 0 : this.getTableType().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Table)) {
            return false;
        }
        Table other = (Table)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getCreateTime() == null ^ this.getCreateTime() == null) {
            return false;
        }
        if (other.getCreateTime() != null && !other.getCreateTime().equals(this.getCreateTime())) {
            return false;
        }
        if (other.getLastAccessTime() == null ^ this.getLastAccessTime() == null) {
            return false;
        }
        if (other.getLastAccessTime() != null && !other.getLastAccessTime().equals(this.getLastAccessTime())) {
            return false;
        }
        if (other.getLastAnalyzedTime() == null ^ this.getLastAnalyzedTime() == null) {
            return false;
        }
        if (other.getLastAnalyzedTime() != null && !other.getLastAnalyzedTime().equals(this.getLastAnalyzedTime())) {
            return false;
        }
        if (other.getRetention() == null ^ this.getRetention() == null) {
            return false;
        }
        if (other.getRetention() != null && !other.getRetention().equals(this.getRetention())) {
            return false;
        }
        if (other.getStorageDescriptor() == null ^ this.getStorageDescriptor() == null) {
            return false;
        }
        if (other.getStorageDescriptor() != null && !other.getStorageDescriptor().equals(this.getStorageDescriptor())) {
            return false;
        }
        if (other.getPartitionKeys() == null ^ this.getPartitionKeys() == null) {
            return false;
        }
        if (other.getPartitionKeys() != null && !other.getPartitionKeys().equals(this.getPartitionKeys())) {
            return false;
        }
        if (other.getViewOriginalText() == null ^ this.getViewOriginalText() == null) {
            return false;
        }
        if (other.getViewOriginalText() != null && !other.getViewOriginalText().equals(this.getViewOriginalText())) {
            return false;
        }
        if (other.getViewExpandedText() == null ^ this.getViewExpandedText() == null) {
            return false;
        }
        if (other.getViewExpandedText() != null && !other.getViewExpandedText().equals(this.getViewExpandedText())) {
            return false;
        }
        if (other.getTableType() == null ^ this.getTableType() == null) {
            return false;
        }
        if (other.getTableType() != null && !other.getTableType().equals(this.getTableType())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public Table clone() {
        try {
            return (Table)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

