/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.Column;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.Order;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.SerDeInfo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.SkewedInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageDescriptor
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<Column> columns;
    private String location;
    private String inputFormat;
    private String outputFormat;
    private Boolean compressed;
    private Integer numberOfBuckets;
    private SerDeInfo serdeInfo;
    private ListWithAutoConstructFlag<String> bucketColumns;
    private ListWithAutoConstructFlag<Order> sortColumns;
    private Map<String, String> parameters;
    private SkewedInfo skewedInfo;
    private Boolean storedAsSubDirectories;

    public List<Column> getColumns() {
        if (this.columns == null) {
            this.columns = new ListWithAutoConstructFlag();
            this.columns.setAutoConstruct(true);
        }
        return this.columns;
    }

    public void setColumns(Collection<Column> columns) {
        if (columns == null) {
            this.columns = null;
            return;
        }
        ListWithAutoConstructFlag columnsCopy = new ListWithAutoConstructFlag(columns.size());
        columnsCopy.addAll(columns);
        this.columns = columnsCopy;
    }

    public StorageDescriptor withColumns(Column ... columns) {
        if (this.getColumns() == null) {
            this.setColumns(new ArrayList<Column>(columns.length));
        }
        for (Column value : columns) {
            this.getColumns().add(value);
        }
        return this;
    }

    public StorageDescriptor withColumns(Collection<Column> columns) {
        if (columns == null) {
            this.columns = null;
        } else {
            ListWithAutoConstructFlag columnsCopy = new ListWithAutoConstructFlag(columns.size());
            columnsCopy.addAll(columns);
            this.columns = columnsCopy;
        }
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public StorageDescriptor withLocation(String location) {
        this.location = location;
        return this;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    public StorageDescriptor withInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
        return this;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public StorageDescriptor withOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    public Boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(Boolean compressed) {
        this.compressed = compressed;
    }

    public StorageDescriptor withCompressed(Boolean compressed) {
        this.compressed = compressed;
        return this;
    }

    public Boolean getCompressed() {
        return this.compressed;
    }

    public Integer getNumberOfBuckets() {
        return this.numberOfBuckets;
    }

    public void setNumberOfBuckets(Integer numberOfBuckets) {
        this.numberOfBuckets = numberOfBuckets;
    }

    public StorageDescriptor withNumberOfBuckets(Integer numberOfBuckets) {
        this.numberOfBuckets = numberOfBuckets;
        return this;
    }

    public SerDeInfo getSerdeInfo() {
        return this.serdeInfo;
    }

    public void setSerdeInfo(SerDeInfo serdeInfo) {
        this.serdeInfo = serdeInfo;
    }

    public StorageDescriptor withSerdeInfo(SerDeInfo serdeInfo) {
        this.serdeInfo = serdeInfo;
        return this;
    }

    public List<String> getBucketColumns() {
        if (this.bucketColumns == null) {
            this.bucketColumns = new ListWithAutoConstructFlag();
            this.bucketColumns.setAutoConstruct(true);
        }
        return this.bucketColumns;
    }

    public void setBucketColumns(Collection<String> bucketColumns) {
        if (bucketColumns == null) {
            this.bucketColumns = null;
            return;
        }
        ListWithAutoConstructFlag bucketColumnsCopy = new ListWithAutoConstructFlag(bucketColumns.size());
        bucketColumnsCopy.addAll(bucketColumns);
        this.bucketColumns = bucketColumnsCopy;
    }

    public StorageDescriptor withBucketColumns(String ... bucketColumns) {
        if (this.getBucketColumns() == null) {
            this.setBucketColumns(new ArrayList<String>(bucketColumns.length));
        }
        for (String value : bucketColumns) {
            this.getBucketColumns().add(value);
        }
        return this;
    }

    public StorageDescriptor withBucketColumns(Collection<String> bucketColumns) {
        if (bucketColumns == null) {
            this.bucketColumns = null;
        } else {
            ListWithAutoConstructFlag bucketColumnsCopy = new ListWithAutoConstructFlag(bucketColumns.size());
            bucketColumnsCopy.addAll(bucketColumns);
            this.bucketColumns = bucketColumnsCopy;
        }
        return this;
    }

    public List<Order> getSortColumns() {
        if (this.sortColumns == null) {
            this.sortColumns = new ListWithAutoConstructFlag();
            this.sortColumns.setAutoConstruct(true);
        }
        return this.sortColumns;
    }

    public void setSortColumns(Collection<Order> sortColumns) {
        if (sortColumns == null) {
            this.sortColumns = null;
            return;
        }
        ListWithAutoConstructFlag sortColumnsCopy = new ListWithAutoConstructFlag(sortColumns.size());
        sortColumnsCopy.addAll(sortColumns);
        this.sortColumns = sortColumnsCopy;
    }

    public StorageDescriptor withSortColumns(Order ... sortColumns) {
        if (this.getSortColumns() == null) {
            this.setSortColumns(new ArrayList<Order>(sortColumns.length));
        }
        for (Order value : sortColumns) {
            this.getSortColumns().add(value);
        }
        return this;
    }

    public StorageDescriptor withSortColumns(Collection<Order> sortColumns) {
        if (sortColumns == null) {
            this.sortColumns = null;
        } else {
            ListWithAutoConstructFlag sortColumnsCopy = new ListWithAutoConstructFlag(sortColumns.size());
            sortColumnsCopy.addAll(sortColumns);
            this.sortColumns = sortColumnsCopy;
        }
        return this;
    }

    public Map<String, String> getParameters() {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public StorageDescriptor withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public StorageDescriptor addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, String>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public StorageDescriptor clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public SkewedInfo getSkewedInfo() {
        return this.skewedInfo;
    }

    public void setSkewedInfo(SkewedInfo skewedInfo) {
        this.skewedInfo = skewedInfo;
    }

    public StorageDescriptor withSkewedInfo(SkewedInfo skewedInfo) {
        this.skewedInfo = skewedInfo;
        return this;
    }

    public Boolean isStoredAsSubDirectories() {
        return this.storedAsSubDirectories;
    }

    public void setStoredAsSubDirectories(Boolean storedAsSubDirectories) {
        this.storedAsSubDirectories = storedAsSubDirectories;
    }

    public StorageDescriptor withStoredAsSubDirectories(Boolean storedAsSubDirectories) {
        this.storedAsSubDirectories = storedAsSubDirectories;
        return this;
    }

    public Boolean getStoredAsSubDirectories() {
        return this.storedAsSubDirectories;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getColumns() != null) {
            sb.append("Columns: " + this.getColumns() + ",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: " + this.getLocation() + ",");
        }
        if (this.getInputFormat() != null) {
            sb.append("InputFormat: " + this.getInputFormat() + ",");
        }
        if (this.getOutputFormat() != null) {
            sb.append("OutputFormat: " + this.getOutputFormat() + ",");
        }
        if (this.isCompressed() != null) {
            sb.append("Compressed: " + this.isCompressed() + ",");
        }
        if (this.getNumberOfBuckets() != null) {
            sb.append("NumberOfBuckets: " + this.getNumberOfBuckets() + ",");
        }
        if (this.getSerdeInfo() != null) {
            sb.append("SerdeInfo: " + this.getSerdeInfo() + ",");
        }
        if (this.getBucketColumns() != null) {
            sb.append("BucketColumns: " + this.getBucketColumns() + ",");
        }
        if (this.getSortColumns() != null) {
            sb.append("SortColumns: " + this.getSortColumns() + ",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: " + this.getParameters() + ",");
        }
        if (this.getSkewedInfo() != null) {
            sb.append("SkewedInfo: " + this.getSkewedInfo() + ",");
        }
        if (this.isStoredAsSubDirectories() != null) {
            sb.append("StoredAsSubDirectories: " + this.isStoredAsSubDirectories());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getColumns() == null ? 0 : this.getColumns().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        hashCode = 31 * hashCode + (this.getInputFormat() == null ? 0 : this.getInputFormat().hashCode());
        hashCode = 31 * hashCode + (this.getOutputFormat() == null ? 0 : this.getOutputFormat().hashCode());
        hashCode = 31 * hashCode + (this.isCompressed() == null ? 0 : this.isCompressed().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfBuckets() == null ? 0 : this.getNumberOfBuckets().hashCode());
        hashCode = 31 * hashCode + (this.getSerdeInfo() == null ? 0 : this.getSerdeInfo().hashCode());
        hashCode = 31 * hashCode + (this.getBucketColumns() == null ? 0 : this.getBucketColumns().hashCode());
        hashCode = 31 * hashCode + (this.getSortColumns() == null ? 0 : this.getSortColumns().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getSkewedInfo() == null ? 0 : this.getSkewedInfo().hashCode());
        hashCode = 31 * hashCode + (this.isStoredAsSubDirectories() == null ? 0 : this.isStoredAsSubDirectories().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageDescriptor)) {
            return false;
        }
        StorageDescriptor other = (StorageDescriptor)obj;
        if (other.getColumns() == null ^ this.getColumns() == null) {
            return false;
        }
        if (other.getColumns() != null && !other.getColumns().equals(this.getColumns())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        if (other.getLocation() != null && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        if (other.getInputFormat() == null ^ this.getInputFormat() == null) {
            return false;
        }
        if (other.getInputFormat() != null && !other.getInputFormat().equals(this.getInputFormat())) {
            return false;
        }
        if (other.getOutputFormat() == null ^ this.getOutputFormat() == null) {
            return false;
        }
        if (other.getOutputFormat() != null && !other.getOutputFormat().equals(this.getOutputFormat())) {
            return false;
        }
        if (other.isCompressed() == null ^ this.isCompressed() == null) {
            return false;
        }
        if (other.isCompressed() != null && !other.isCompressed().equals(this.isCompressed())) {
            return false;
        }
        if (other.getNumberOfBuckets() == null ^ this.getNumberOfBuckets() == null) {
            return false;
        }
        if (other.getNumberOfBuckets() != null && !other.getNumberOfBuckets().equals(this.getNumberOfBuckets())) {
            return false;
        }
        if (other.getSerdeInfo() == null ^ this.getSerdeInfo() == null) {
            return false;
        }
        if (other.getSerdeInfo() != null && !other.getSerdeInfo().equals(this.getSerdeInfo())) {
            return false;
        }
        if (other.getBucketColumns() == null ^ this.getBucketColumns() == null) {
            return false;
        }
        if (other.getBucketColumns() != null && !other.getBucketColumns().equals(this.getBucketColumns())) {
            return false;
        }
        if (other.getSortColumns() == null ^ this.getSortColumns() == null) {
            return false;
        }
        if (other.getSortColumns() != null && !other.getSortColumns().equals(this.getSortColumns())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getSkewedInfo() == null ^ this.getSkewedInfo() == null) {
            return false;
        }
        if (other.getSkewedInfo() != null && !other.getSkewedInfo().equals(this.getSkewedInfo())) {
            return false;
        }
        if (other.isStoredAsSubDirectories() == null ^ this.isStoredAsSubDirectories() == null) {
            return false;
        }
        return other.isStoredAsSubDirectories() == null || other.isStoredAsSubDirectories().equals(this.isStoredAsSubDirectories());
    }

    public StorageDescriptor clone() {
        try {
            return (StorageDescriptor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

