/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.StorageDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Partition
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<String> values;
    private String namespaceName;
    private String tableName;
    private Date creationTime;
    private Date lastAccessTime;
    private StorageDescriptor storageDescriptor;
    private Map<String, String> parameters;
    private Date lastAnalyzedTime;

    public List<String> getValues() {
        if (this.values == null) {
            this.values = new ListWithAutoConstructFlag();
            this.values.setAutoConstruct(true);
        }
        return this.values;
    }

    public void setValues(Collection<String> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        ListWithAutoConstructFlag valuesCopy = new ListWithAutoConstructFlag(values.size());
        valuesCopy.addAll(values);
        this.values = valuesCopy;
    }

    public Partition withValues(String ... values) {
        if (this.getValues() == null) {
            this.setValues(new ArrayList<String>(values.length));
        }
        for (String value : values) {
            this.getValues().add(value);
        }
        return this;
    }

    public Partition withValues(Collection<String> values) {
        if (values == null) {
            this.values = null;
        } else {
            ListWithAutoConstructFlag valuesCopy = new ListWithAutoConstructFlag(values.size());
            valuesCopy.addAll(values);
            this.values = valuesCopy;
        }
        return this;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public void setNamespaceName(String namespaceName) {
        this.namespaceName = namespaceName;
    }

    public Partition withNamespaceName(String namespaceName) {
        this.namespaceName = namespaceName;
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Partition withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Partition withCreationTime(Date creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public Partition withLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
        return this;
    }

    public StorageDescriptor getStorageDescriptor() {
        return this.storageDescriptor;
    }

    public void setStorageDescriptor(StorageDescriptor storageDescriptor) {
        this.storageDescriptor = storageDescriptor;
    }

    public Partition withStorageDescriptor(StorageDescriptor storageDescriptor) {
        this.storageDescriptor = storageDescriptor;
        return this;
    }

    public Map<String, String> getParameters() {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Partition withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public Partition addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, String>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public Partition clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public Date getLastAnalyzedTime() {
        return this.lastAnalyzedTime;
    }

    public void setLastAnalyzedTime(Date lastAnalyzedTime) {
        this.lastAnalyzedTime = lastAnalyzedTime;
    }

    public Partition withLastAnalyzedTime(Date lastAnalyzedTime) {
        this.lastAnalyzedTime = lastAnalyzedTime;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getValues() != null) {
            sb.append("Values: " + this.getValues() + ",");
        }
        if (this.getNamespaceName() != null) {
            sb.append("NamespaceName: " + this.getNamespaceName() + ",");
        }
        if (this.getTableName() != null) {
            sb.append("TableName: " + this.getTableName() + ",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: " + this.getCreationTime() + ",");
        }
        if (this.getLastAccessTime() != null) {
            sb.append("LastAccessTime: " + this.getLastAccessTime() + ",");
        }
        if (this.getStorageDescriptor() != null) {
            sb.append("StorageDescriptor: " + this.getStorageDescriptor() + ",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: " + this.getParameters() + ",");
        }
        if (this.getLastAnalyzedTime() != null) {
            sb.append("LastAnalyzedTime: " + this.getLastAnalyzedTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        hashCode = 31 * hashCode + (this.getNamespaceName() == null ? 0 : this.getNamespaceName().hashCode());
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastAccessTime() == null ? 0 : this.getLastAccessTime().hashCode());
        hashCode = 31 * hashCode + (this.getStorageDescriptor() == null ? 0 : this.getStorageDescriptor().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getLastAnalyzedTime() == null ? 0 : this.getLastAnalyzedTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Partition)) {
            return false;
        }
        Partition other = (Partition)obj;
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        if (other.getValues() != null && !other.getValues().equals(this.getValues())) {
            return false;
        }
        if (other.getNamespaceName() == null ^ this.getNamespaceName() == null) {
            return false;
        }
        if (other.getNamespaceName() != null && !other.getNamespaceName().equals(this.getNamespaceName())) {
            return false;
        }
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getLastAccessTime() == null ^ this.getLastAccessTime() == null) {
            return false;
        }
        if (other.getLastAccessTime() != null && !other.getLastAccessTime().equals(this.getLastAccessTime())) {
            return false;
        }
        if (other.getStorageDescriptor() == null ^ this.getStorageDescriptor() == null) {
            return false;
        }
        if (other.getStorageDescriptor() != null && !other.getStorageDescriptor().equals(this.getStorageDescriptor())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getLastAnalyzedTime() == null ^ this.getLastAnalyzedTime() == null) {
            return false;
        }
        return other.getLastAnalyzedTime() == null || other.getLastAnalyzedTime().equals(this.getLastAnalyzedTime());
    }

    public Partition clone() {
        try {
            return (Partition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

