/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.EntityPrivilege;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeletePrivilegesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String catalogId;
    private ListWithAutoConstructFlag<EntityPrivilege> catalogEntityPrivileges;
    private Boolean grantOption;

    public String getCatalogId() {
        return this.catalogId;
    }

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    public DeletePrivilegesRequest withCatalogId(String catalogId) {
        this.catalogId = catalogId;
        return this;
    }

    public List<EntityPrivilege> getCatalogEntityPrivileges() {
        if (this.catalogEntityPrivileges == null) {
            this.catalogEntityPrivileges = new ListWithAutoConstructFlag();
            this.catalogEntityPrivileges.setAutoConstruct(true);
        }
        return this.catalogEntityPrivileges;
    }

    public void setCatalogEntityPrivileges(Collection<EntityPrivilege> catalogEntityPrivileges) {
        if (catalogEntityPrivileges == null) {
            this.catalogEntityPrivileges = null;
            return;
        }
        ListWithAutoConstructFlag catalogEntityPrivilegesCopy = new ListWithAutoConstructFlag(catalogEntityPrivileges.size());
        catalogEntityPrivilegesCopy.addAll(catalogEntityPrivileges);
        this.catalogEntityPrivileges = catalogEntityPrivilegesCopy;
    }

    public DeletePrivilegesRequest withCatalogEntityPrivileges(EntityPrivilege ... catalogEntityPrivileges) {
        if (this.getCatalogEntityPrivileges() == null) {
            this.setCatalogEntityPrivileges(new ArrayList<EntityPrivilege>(catalogEntityPrivileges.length));
        }
        for (EntityPrivilege value : catalogEntityPrivileges) {
            this.getCatalogEntityPrivileges().add(value);
        }
        return this;
    }

    public DeletePrivilegesRequest withCatalogEntityPrivileges(Collection<EntityPrivilege> catalogEntityPrivileges) {
        if (catalogEntityPrivileges == null) {
            this.catalogEntityPrivileges = null;
        } else {
            ListWithAutoConstructFlag catalogEntityPrivilegesCopy = new ListWithAutoConstructFlag(catalogEntityPrivileges.size());
            catalogEntityPrivilegesCopy.addAll(catalogEntityPrivileges);
            this.catalogEntityPrivileges = catalogEntityPrivilegesCopy;
        }
        return this;
    }

    public Boolean isGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(Boolean grantOption) {
        this.grantOption = grantOption;
    }

    public DeletePrivilegesRequest withGrantOption(Boolean grantOption) {
        this.grantOption = grantOption;
        return this;
    }

    public Boolean getGrantOption() {
        return this.grantOption;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCatalogId() != null) {
            sb.append("CatalogId: " + this.getCatalogId() + ",");
        }
        if (this.getCatalogEntityPrivileges() != null) {
            sb.append("CatalogEntityPrivileges: " + this.getCatalogEntityPrivileges() + ",");
        }
        if (this.isGrantOption() != null) {
            sb.append("GrantOption: " + this.isGrantOption());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCatalogId() == null ? 0 : this.getCatalogId().hashCode());
        hashCode = 31 * hashCode + (this.getCatalogEntityPrivileges() == null ? 0 : this.getCatalogEntityPrivileges().hashCode());
        hashCode = 31 * hashCode + (this.isGrantOption() == null ? 0 : this.isGrantOption().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePrivilegesRequest)) {
            return false;
        }
        DeletePrivilegesRequest other = (DeletePrivilegesRequest)obj;
        if (other.getCatalogId() == null ^ this.getCatalogId() == null) {
            return false;
        }
        if (other.getCatalogId() != null && !other.getCatalogId().equals(this.getCatalogId())) {
            return false;
        }
        if (other.getCatalogEntityPrivileges() == null ^ this.getCatalogEntityPrivileges() == null) {
            return false;
        }
        if (other.getCatalogEntityPrivileges() != null && !other.getCatalogEntityPrivileges().equals(this.getCatalogEntityPrivileges())) {
            return false;
        }
        if (other.isGrantOption() == null ^ this.isGrantOption() == null) {
            return false;
        }
        return other.isGrantOption() == null || other.isGrantOption().equals(this.isGrantOption());
    }

    @Override
    public DeletePrivilegesRequest clone() {
        return (DeletePrivilegesRequest)super.clone();
    }
}

