/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.Partition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreatePartitionsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String catalogId;
    private ListWithAutoConstructFlag<Partition> partitions;
    private Boolean ifNotExists;
    private Boolean needResults;

    public String getCatalogId() {
        return this.catalogId;
    }

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    public CreatePartitionsRequest withCatalogId(String catalogId) {
        this.catalogId = catalogId;
        return this;
    }

    public List<Partition> getPartitions() {
        if (this.partitions == null) {
            this.partitions = new ListWithAutoConstructFlag();
            this.partitions.setAutoConstruct(true);
        }
        return this.partitions;
    }

    public void setPartitions(Collection<Partition> partitions) {
        if (partitions == null) {
            this.partitions = null;
            return;
        }
        ListWithAutoConstructFlag partitionsCopy = new ListWithAutoConstructFlag(partitions.size());
        partitionsCopy.addAll(partitions);
        this.partitions = partitionsCopy;
    }

    public CreatePartitionsRequest withPartitions(Partition ... partitions) {
        if (this.getPartitions() == null) {
            this.setPartitions(new ArrayList<Partition>(partitions.length));
        }
        for (Partition value : partitions) {
            this.getPartitions().add(value);
        }
        return this;
    }

    public CreatePartitionsRequest withPartitions(Collection<Partition> partitions) {
        if (partitions == null) {
            this.partitions = null;
        } else {
            ListWithAutoConstructFlag partitionsCopy = new ListWithAutoConstructFlag(partitions.size());
            partitionsCopy.addAll(partitions);
            this.partitions = partitionsCopy;
        }
        return this;
    }

    public Boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(Boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public CreatePartitionsRequest withIfNotExists(Boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
        return this;
    }

    public Boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public Boolean isNeedResults() {
        return this.needResults;
    }

    public void setNeedResults(Boolean needResults) {
        this.needResults = needResults;
    }

    public CreatePartitionsRequest withNeedResults(Boolean needResults) {
        this.needResults = needResults;
        return this;
    }

    public Boolean getNeedResults() {
        return this.needResults;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCatalogId() != null) {
            sb.append("CatalogId: " + this.getCatalogId() + ",");
        }
        if (this.getPartitions() != null) {
            sb.append("Partitions: " + this.getPartitions() + ",");
        }
        if (this.isIfNotExists() != null) {
            sb.append("IfNotExists: " + this.isIfNotExists() + ",");
        }
        if (this.isNeedResults() != null) {
            sb.append("NeedResults: " + this.isNeedResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCatalogId() == null ? 0 : this.getCatalogId().hashCode());
        hashCode = 31 * hashCode + (this.getPartitions() == null ? 0 : this.getPartitions().hashCode());
        hashCode = 31 * hashCode + (this.isIfNotExists() == null ? 0 : this.isIfNotExists().hashCode());
        hashCode = 31 * hashCode + (this.isNeedResults() == null ? 0 : this.isNeedResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePartitionsRequest)) {
            return false;
        }
        CreatePartitionsRequest other = (CreatePartitionsRequest)obj;
        if (other.getCatalogId() == null ^ this.getCatalogId() == null) {
            return false;
        }
        if (other.getCatalogId() != null && !other.getCatalogId().equals(this.getCatalogId())) {
            return false;
        }
        if (other.getPartitions() == null ^ this.getPartitions() == null) {
            return false;
        }
        if (other.getPartitions() != null && !other.getPartitions().equals(this.getPartitions())) {
            return false;
        }
        if (other.isIfNotExists() == null ^ this.isIfNotExists() == null) {
            return false;
        }
        if (other.isIfNotExists() != null && !other.isIfNotExists().equals(this.isIfNotExists())) {
            return false;
        }
        if (other.isNeedResults() == null ^ this.isNeedResults() == null) {
            return false;
        }
        return other.isNeedResults() == null || other.isNeedResults().equals(this.isNeedResults());
    }

    @Override
    public CreatePartitionsRequest clone() {
        return (CreatePartitionsRequest)super.clone();
    }
}

