/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Column;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Table;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.transform.ColumnJsonUnmarshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.transform.StorageDescriptorJsonUnmarshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.transform.Unmarshaller;
import com.amazonaws.athena.jdbc.shaded.jackson.core.JsonToken;
import java.util.Date;

public class TableJsonUnmarshaller
implements Unmarshaller<Table, JsonUnmarshallerContext> {
    private static TableJsonUnmarshaller instance;

    @Override
    public Table unmarshall(JsonUnmarshallerContext context) throws Exception {
        Table table = new Table();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    table.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Owner", targetDepth)) {
                    context.nextToken();
                    table.setOwner(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreateTime", targetDepth)) {
                    context.nextToken();
                    table.setCreateTime(context.getUnmarshaller(Date.class).unmarshall(context));
                }
                if (context.testExpression("LastAccessTime", targetDepth)) {
                    context.nextToken();
                    table.setLastAccessTime(context.getUnmarshaller(Date.class).unmarshall(context));
                }
                if (context.testExpression("LastAnalyzedTime", targetDepth)) {
                    context.nextToken();
                    table.setLastAnalyzedTime(context.getUnmarshaller(Date.class).unmarshall(context));
                }
                if (context.testExpression("Retention", targetDepth)) {
                    context.nextToken();
                    table.setRetention(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("StorageDescriptor", targetDepth)) {
                    context.nextToken();
                    table.setStorageDescriptor(StorageDescriptorJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("PartitionKeys", targetDepth)) {
                    context.nextToken();
                    table.setPartitionKeys(new ListUnmarshaller<Column>(ColumnJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ViewOriginalText", targetDepth)) {
                    context.nextToken();
                    table.setViewOriginalText(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ViewExpandedText", targetDepth)) {
                    context.nextToken();
                    table.setViewExpandedText(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TableType", targetDepth)) {
                    context.nextToken();
                    table.setTableType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    context.nextToken();
                    table.setParameters(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return table;
    }

    public static TableJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TableJsonUnmarshaller();
        }
        return instance;
    }
}

