/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.SdkClientException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.MarshallingType;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.QueryExecutionStats;

@SdkInternalApi
public class QueryExecutionStatsMarshaller {
    private static final MarshallingInfo<Long> ENGINEEXECUTIONTIMEINMILLIS_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineExecutionTimeInMillis").build();
    private static final MarshallingInfo<Long> PROCESSEDROWS_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessedRows").build();
    private static final MarshallingInfo<Long> PROCESSEDBYTES_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessedBytes").build();
    private static final MarshallingInfo<Long> PROCESSEDINPUTROWS_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessedInputRows").build();
    private static final MarshallingInfo<Long> PROCESSEDINPUTBYTES_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessedInputBytes").build();
    private static final QueryExecutionStatsMarshaller instance = new QueryExecutionStatsMarshaller();

    public static QueryExecutionStatsMarshaller getInstance() {
        return instance;
    }

    public void marshall(QueryExecutionStats queryExecutionStats, ProtocolMarshaller protocolMarshaller) {
        if (queryExecutionStats == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(queryExecutionStats.getEngineExecutionTimeInMillis(), ENGINEEXECUTIONTIMEINMILLIS_BINDING);
            protocolMarshaller.marshall(queryExecutionStats.getProcessedRows(), PROCESSEDROWS_BINDING);
            protocolMarshaller.marshall(queryExecutionStats.getProcessedBytes(), PROCESSEDBYTES_BINDING);
            protocolMarshaller.marshall(queryExecutionStats.getProcessedInputRows(), PROCESSEDINPUTROWS_BINDING);
            protocolMarshaller.marshall(queryExecutionStats.getProcessedInputBytes(), PROCESSEDINPUTBYTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

