/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.SdkClientException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.MarshallingType;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Function;

@SdkInternalApi
public class FunctionMarshaller {
    private static final MarshallingInfo<String> FUNCTIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionName").build();
    private static final MarshallingInfo<String> FUNCTIONDESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionDescription").build();
    private static final MarshallingInfo<String> FUNCTIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionType").build();
    private static final FunctionMarshaller instance = new FunctionMarshaller();

    public static FunctionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Function function, ProtocolMarshaller protocolMarshaller) {
        if (function == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(function.getFunctionName(), FUNCTIONNAME_BINDING);
            protocolMarshaller.marshall(function.getFunctionDescription(), FUNCTIONDESCRIPTION_BINDING);
            protocolMarshaller.marshall(function.getFunctionType(), FUNCTIONTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

