/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.SdkClientException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.MarshallingType;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.EncryptionConfiguration;

@SdkInternalApi
public class EncryptionConfigurationMarshaller {
    private static final MarshallingInfo<String> ENCRYPTIONOPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionOption").build();
    private static final MarshallingInfo<String> AWSKMSKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AwsKmsKey").build();
    private static final MarshallingInfo<String> KMSKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKey").build();
    private static final EncryptionConfigurationMarshaller instance = new EncryptionConfigurationMarshaller();

    public static EncryptionConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(EncryptionConfiguration encryptionConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (encryptionConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(encryptionConfiguration.getEncryptionOption(), ENCRYPTIONOPTION_BINDING);
            protocolMarshaller.marshall(encryptionConfiguration.getAwsKmsKey(), AWSKMSKEY_BINDING);
            protocolMarshaller.marshall(encryptionConfiguration.getKmsKey(), KMSKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

