/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.SdkClientException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.MarshallingType;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.DataType;

@SdkInternalApi
public class DataTypeMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> PRECISION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Precision").build();
    private static final MarshallingInfo<Boolean> NULLABLE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Nullable").build();
    private static final MarshallingInfo<Boolean> CASESENSITIVE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CaseSensitive").build();
    private static final MarshallingInfo<String> SEARCHABLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Searchable").build();
    private static final MarshallingInfo<Boolean> ISUNSIGNED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsUnsigned").build();
    private static final MarshallingInfo<Boolean> AUTOINCREMENTABLE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoIncrementable").build();
    private static final MarshallingInfo<Integer> MINIMUMSCALE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinimumScale").build();
    private static final MarshallingInfo<Integer> MAXIMUMSCALE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaximumScale").build();
    private static final DataTypeMarshaller instance = new DataTypeMarshaller();

    public static DataTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataType dataType, ProtocolMarshaller protocolMarshaller) {
        if (dataType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(dataType.getName(), NAME_BINDING);
            protocolMarshaller.marshall(dataType.getPrecision(), PRECISION_BINDING);
            protocolMarshaller.marshall(dataType.getNullable(), NULLABLE_BINDING);
            protocolMarshaller.marshall(dataType.getCaseSensitive(), CASESENSITIVE_BINDING);
            protocolMarshaller.marshall(dataType.getSearchable(), SEARCHABLE_BINDING);
            protocolMarshaller.marshall(dataType.getIsUnsigned(), ISUNSIGNED_BINDING);
            protocolMarshaller.marshall(dataType.getAutoIncrementable(), AUTOINCREMENTABLE_BINDING);
            protocolMarshaller.marshall(dataType.getMinimumScale(), MINIMUMSCALE_BINDING);
            protocolMarshaller.marshall(dataType.getMaximumScale(), MAXIMUMSCALE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

