/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.DataType;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Function;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.transform.ExecutionEngineMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExecutionEngine
implements Serializable,
Cloneable,
StructuredPojo {
    private String executionEngineId;
    private String executionEngineName;
    private String executionEngineVersion;
    private Map<String, String> executionEngineProperties;
    private List<Function> functionList;
    private List<DataType> dataTypeList;

    public void setExecutionEngineId(String executionEngineId) {
        this.executionEngineId = executionEngineId;
    }

    public String getExecutionEngineId() {
        return this.executionEngineId;
    }

    public ExecutionEngine withExecutionEngineId(String executionEngineId) {
        this.setExecutionEngineId(executionEngineId);
        return this;
    }

    public void setExecutionEngineName(String executionEngineName) {
        this.executionEngineName = executionEngineName;
    }

    public String getExecutionEngineName() {
        return this.executionEngineName;
    }

    public ExecutionEngine withExecutionEngineName(String executionEngineName) {
        this.setExecutionEngineName(executionEngineName);
        return this;
    }

    public void setExecutionEngineVersion(String executionEngineVersion) {
        this.executionEngineVersion = executionEngineVersion;
    }

    public String getExecutionEngineVersion() {
        return this.executionEngineVersion;
    }

    public ExecutionEngine withExecutionEngineVersion(String executionEngineVersion) {
        this.setExecutionEngineVersion(executionEngineVersion);
        return this;
    }

    public Map<String, String> getExecutionEngineProperties() {
        return this.executionEngineProperties;
    }

    public void setExecutionEngineProperties(Map<String, String> executionEngineProperties) {
        this.executionEngineProperties = executionEngineProperties;
    }

    public ExecutionEngine withExecutionEngineProperties(Map<String, String> executionEngineProperties) {
        this.setExecutionEngineProperties(executionEngineProperties);
        return this;
    }

    public ExecutionEngine addExecutionEnginePropertiesEntry(String key, String value) {
        if (null == this.executionEngineProperties) {
            this.executionEngineProperties = new HashMap<String, String>();
        }
        if (this.executionEngineProperties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.executionEngineProperties.put(key, value);
        return this;
    }

    public ExecutionEngine clearExecutionEnginePropertiesEntries() {
        this.executionEngineProperties = null;
        return this;
    }

    public List<Function> getFunctionList() {
        return this.functionList;
    }

    public void setFunctionList(Collection<Function> functionList) {
        if (functionList == null) {
            this.functionList = null;
            return;
        }
        this.functionList = new ArrayList<Function>(functionList);
    }

    public ExecutionEngine withFunctionList(Function ... functionList) {
        if (this.functionList == null) {
            this.setFunctionList(new ArrayList<Function>(functionList.length));
        }
        for (Function ele : functionList) {
            this.functionList.add(ele);
        }
        return this;
    }

    public ExecutionEngine withFunctionList(Collection<Function> functionList) {
        this.setFunctionList(functionList);
        return this;
    }

    public List<DataType> getDataTypeList() {
        return this.dataTypeList;
    }

    public void setDataTypeList(Collection<DataType> dataTypeList) {
        if (dataTypeList == null) {
            this.dataTypeList = null;
            return;
        }
        this.dataTypeList = new ArrayList<DataType>(dataTypeList);
    }

    public ExecutionEngine withDataTypeList(DataType ... dataTypeList) {
        if (this.dataTypeList == null) {
            this.setDataTypeList(new ArrayList<DataType>(dataTypeList.length));
        }
        for (DataType ele : dataTypeList) {
            this.dataTypeList.add(ele);
        }
        return this;
    }

    public ExecutionEngine withDataTypeList(Collection<DataType> dataTypeList) {
        this.setDataTypeList(dataTypeList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExecutionEngineId() != null) {
            sb.append("ExecutionEngineId: ").append(this.getExecutionEngineId()).append(",");
        }
        if (this.getExecutionEngineName() != null) {
            sb.append("ExecutionEngineName: ").append(this.getExecutionEngineName()).append(",");
        }
        if (this.getExecutionEngineVersion() != null) {
            sb.append("ExecutionEngineVersion: ").append(this.getExecutionEngineVersion()).append(",");
        }
        if (this.getExecutionEngineProperties() != null) {
            sb.append("ExecutionEngineProperties: ").append(this.getExecutionEngineProperties()).append(",");
        }
        if (this.getFunctionList() != null) {
            sb.append("FunctionList: ").append(this.getFunctionList()).append(",");
        }
        if (this.getDataTypeList() != null) {
            sb.append("DataTypeList: ").append(this.getDataTypeList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionEngine)) {
            return false;
        }
        ExecutionEngine other = (ExecutionEngine)obj;
        if (other.getExecutionEngineId() == null ^ this.getExecutionEngineId() == null) {
            return false;
        }
        if (other.getExecutionEngineId() != null && !other.getExecutionEngineId().equals(this.getExecutionEngineId())) {
            return false;
        }
        if (other.getExecutionEngineName() == null ^ this.getExecutionEngineName() == null) {
            return false;
        }
        if (other.getExecutionEngineName() != null && !other.getExecutionEngineName().equals(this.getExecutionEngineName())) {
            return false;
        }
        if (other.getExecutionEngineVersion() == null ^ this.getExecutionEngineVersion() == null) {
            return false;
        }
        if (other.getExecutionEngineVersion() != null && !other.getExecutionEngineVersion().equals(this.getExecutionEngineVersion())) {
            return false;
        }
        if (other.getExecutionEngineProperties() == null ^ this.getExecutionEngineProperties() == null) {
            return false;
        }
        if (other.getExecutionEngineProperties() != null && !other.getExecutionEngineProperties().equals(this.getExecutionEngineProperties())) {
            return false;
        }
        if (other.getFunctionList() == null ^ this.getFunctionList() == null) {
            return false;
        }
        if (other.getFunctionList() != null && !other.getFunctionList().equals(this.getFunctionList())) {
            return false;
        }
        if (other.getDataTypeList() == null ^ this.getDataTypeList() == null) {
            return false;
        }
        return other.getDataTypeList() == null || other.getDataTypeList().equals(this.getDataTypeList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExecutionEngineId() == null ? 0 : this.getExecutionEngineId().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionEngineName() == null ? 0 : this.getExecutionEngineName().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionEngineVersion() == null ? 0 : this.getExecutionEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionEngineProperties() == null ? 0 : this.getExecutionEngineProperties().hashCode());
        hashCode = 31 * hashCode + (this.getFunctionList() == null ? 0 : this.getFunctionList().hashCode());
        hashCode = 31 * hashCode + (this.getDataTypeList() == null ? 0 : this.getDataTypeList().hashCode());
        return hashCode;
    }

    public ExecutionEngine clone() {
        try {
            return (ExecutionEngine)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExecutionEngineMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

