/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc;

import com.amazonaws.athena.jdbc.shaded.guava.base.Ascii;
import com.amazonaws.athena.jdbc.shaded.guava.base.CharMatcher;
import com.amazonaws.athena.jdbc.shaded.guava.base.Preconditions;
import com.amazonaws.athena.jdbc.shaded.guava.base.Splitter;
import com.amazonaws.athena.jdbc.shaded.guava.collect.Iterables;
import com.amazonaws.athena.jdbc.shaded.guava.collect.LinkedListMultimap;
import com.amazonaws.athena.jdbc.shaded.guava.collect.ListMultimap;
import com.amazonaws.athena.jdbc.shaded.guava.net.HostAndPort;
import com.amazonaws.athena.jdbc.shaded.guava.primitives.Bytes;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class HttpUriBuilder {
    private String scheme;
    private String host;
    private int port = -1;
    private String path = "";
    private final ListMultimap<String, String> params = LinkedListMultimap.create();
    private static final byte[] PCHAR = new byte[]{97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 46, 95, 126, 33, 36, 39, 40, 41, 42, 43, 44, 59, 61, 58, 64};
    private static final byte[] ALLOWED_PATH_CHARS = Bytes.concat(PCHAR, {47, 38});
    private static final byte[] ALLOWED_QUERY_CHARS = Bytes.concat(PCHAR, {47, 63});

    private HttpUriBuilder() {
    }

    private HttpUriBuilder(URI previous) {
        this.scheme = previous.getScheme();
        this.host = previous.getHost();
        this.port = previous.getPort();
        this.path = HttpUriBuilder.percentDecode(previous.getRawPath());
        this.params.putAll(this.parseParams(previous.getRawQuery()));
    }

    public static HttpUriBuilder uriBuilder() {
        return new HttpUriBuilder();
    }

    public static HttpUriBuilder uriBuilderFrom(URI uri) {
        Objects.requireNonNull(uri, "uri is null");
        return new HttpUriBuilder(uri);
    }

    public HttpUriBuilder scheme(String scheme) {
        Objects.requireNonNull(scheme, "scheme is null");
        this.scheme = scheme;
        return this;
    }

    public HttpUriBuilder host(String host) {
        Objects.requireNonNull(host, "host is null");
        Preconditions.checkArgument(!host.startsWith("["), "host starts with a bracket");
        Preconditions.checkArgument(!host.endsWith("]"), "host ends with a bracket");
        if (host.contains(":")) {
            host = "[" + host + "]";
        }
        this.host = host;
        return this;
    }

    public HttpUriBuilder port(int port) {
        Preconditions.checkArgument(port >= 1 && port <= 65535, "port must be in the range 1-65535");
        this.port = port;
        return this;
    }

    public HttpUriBuilder defaultPort() {
        this.port = -1;
        return this;
    }

    public HttpUriBuilder hostAndPort(HostAndPort hostAndPort) {
        Objects.requireNonNull(hostAndPort, "hostAndPort is null");
        this.host = HttpUriBuilder.bracketedHostString(hostAndPort);
        this.port = hostAndPort.hasPort() ? hostAndPort.getPort() : -1;
        return this;
    }

    public HttpUriBuilder replacePath(String path) {
        Objects.requireNonNull(path, "path is null");
        if (!path.equals("") && !path.startsWith("/")) {
            path = "/" + path;
        }
        this.path = path;
        return this;
    }

    public HttpUriBuilder appendPath(String path) {
        Objects.requireNonNull(path, "path is null");
        StringBuilder builder = new StringBuilder(this.path);
        if (!this.path.endsWith("/")) {
            builder.append('/');
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        builder.append(path);
        this.path = builder.toString();
        return this;
    }

    public HttpUriBuilder replaceParameter(String name, String ... values) {
        return this.replaceParameter(name, Arrays.asList(values));
    }

    public HttpUriBuilder replaceParameter(String name, Iterable<String> values) {
        Objects.requireNonNull(name, "name is null");
        this.params.removeAll(name);
        this.addParameter(name, values);
        return this;
    }

    public HttpUriBuilder addParameter(String name, String ... values) {
        return this.addParameter(name, Arrays.asList(values));
    }

    public HttpUriBuilder addParameter(String name, Iterable<String> values) {
        Objects.requireNonNull(name, "name is null");
        if (Iterables.isEmpty(values)) {
            this.params.put(name, null);
        }
        for (String value : values) {
            this.params.put(name, value);
        }
        return this;
    }

    public String toString() {
        String path;
        StringBuilder builder = new StringBuilder();
        builder.append(this.scheme);
        builder.append("://");
        if (this.host != null) {
            builder.append(this.host);
        }
        if (this.port != -1) {
            builder.append(':');
            builder.append(this.port);
        }
        if ((path = this.path).equals("") && !this.params.isEmpty()) {
            path = "/";
        }
        builder.append(this.encode(path, ALLOWED_PATH_CHARS));
        if (!this.params.isEmpty()) {
            builder.append('?');
            Iterator iterator = this.params.entries().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                builder.append(this.encode((String)entry.getKey(), ALLOWED_QUERY_CHARS));
                if (entry.getValue() != null) {
                    builder.append('=');
                    builder.append(this.encode((String)entry.getValue(), ALLOWED_QUERY_CHARS));
                }
                if (!iterator.hasNext()) continue;
                builder.append('&');
            }
        }
        return builder.toString();
    }

    public URI build() {
        Preconditions.checkState(this.scheme != null, "scheme has not been set");
        return URI.create(this.toString());
    }

    private ListMultimap<String, String> parseParams(String query) {
        LinkedListMultimap<String, String> result = LinkedListMultimap.create();
        if (query != null) {
            Iterable<String> pairs = Splitter.on("&").omitEmptyStrings().split(query);
            for (String pair : pairs) {
                String[] parts = pair.split("=", 2);
                result.put(HttpUriBuilder.percentDecode(parts[0]), HttpUriBuilder.percentDecode(parts[1]));
            }
        }
        return result;
    }

    private String encode(String input, byte ... allowed) {
        StringBuilder builder = new StringBuilder();
        ByteBuffer buffer = StandardCharsets.UTF_8.encode(input);
        while (buffer.remaining() > 0) {
            byte b = buffer.get();
            if (Bytes.contains(allowed, b)) {
                builder.append((char)b);
                continue;
            }
            builder.append('%');
            builder.append(Ascii.toUpperCase(Character.forDigit(b >>> 4 & 0xF, 16)));
            builder.append(Ascii.toUpperCase(Character.forDigit(b & 0xF, 16)));
        }
        return builder.toString();
    }

    private static String percentDecode(String encoded) {
        Preconditions.checkArgument(CharMatcher.ASCII.matchesAllOf(encoded), "string must be ASCII");
        ByteArrayOutputStream out = new ByteArrayOutputStream(encoded.length());
        for (int i = 0; i < encoded.length(); ++i) {
            char c = encoded.charAt(i);
            if (c == '%') {
                Preconditions.checkArgument(i + 2 < encoded.length(), "percent encoded value is truncated");
                int high = Character.digit(encoded.charAt(i + 1), 16);
                int low = Character.digit(encoded.charAt(i + 2), 16);
                Preconditions.checkArgument(high != -1 && low != -1, "percent encoded value is not a valid hex string: ", encoded.substring(i, i + 2));
                int value = high << 4 | low;
                out.write(value);
                i += 2;
                continue;
            }
            out.write(c);
        }
        try {
            return StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).decode(ByteBuffer.wrap(out.toByteArray())).toString();
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("input does not represent a proper UTF8-encoded string");
        }
    }

    private static String bracketedHostString(HostAndPort hostAndPort) {
        String host = hostAndPort.getHostText();
        if (hostAndPort.toString().startsWith("[")) {
            return "[" + host + "]";
        }
        return host;
    }
}

