/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc;

import com.amazonaws.athena.jdbc.AbstractAthenaClient;
import com.amazonaws.athena.jdbc.AthenaResultSetUtils;
import com.amazonaws.athena.jdbc.AthenaServiceClient;
import com.amazonaws.athena.jdbc.ColumnInfo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.ColumnInfo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.ColumnNullable;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.GetQueryResultsResult;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.InvalidRequestException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.QueryExecutionState;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.QueryExecutionStatus;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Row;
import com.amazonaws.athena.jdbc.shaded.guava.annotations.VisibleForTesting;
import com.amazonaws.athena.jdbc.shaded.guava.base.Splitter;
import com.amazonaws.athena.jdbc.shaded.guava.base.Strings;
import com.amazonaws.athena.jdbc.shaded.guava.collect.ImmutableList;
import com.amazonaws.athena.jdbc.shaded.guava.collect.Lists;
import com.amazonaws.athena.jdbc.shaded.spi.type.TypeSignature;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

public class AthenaStatementClient
extends AbstractAthenaClient {
    private final String queryExecutionId;
    private volatile QueryExecutionStatus status;
    private volatile QueryExecutionState state;
    private volatile long updateCount;
    private volatile String updateType;
    private ResultFetcher resultFetcher;

    public AthenaStatementClient(String queryExecutionId, AthenaServiceClient athenaServiceClient) {
        super(athenaServiceClient);
        this.queryExecutionId = Objects.requireNonNull(queryExecutionId, "queryExecutionId is null");
        this.status = null;
        this.state = null;
        this.updateCount = 0L;
        this.updateType = null;
        this.resultFetcher = null;
    }

    public String getQueryExecutionId() {
        return this.queryExecutionId;
    }

    public QueryExecutionStatus getQueryStatus() {
        this.status = this.getAthenaServiceClient().getQueryExecutionStatus(this.queryExecutionId);
        this.state = QueryExecutionState.valueOf(this.status.getState());
        return this.status;
    }

    public QueryExecutionState getQueryState() {
        return this.state;
    }

    public String getStateChangeReason() {
        return this.status.getStateChangeReason();
    }

    public boolean isFinished() {
        return this.state == QueryExecutionState.SUCCEEDED || this.state == QueryExecutionState.FAILED || this.state == QueryExecutionState.CANCELLED;
    }

    public boolean isFailed() {
        return this.state == QueryExecutionState.FAILED;
    }

    public boolean isCancelled() {
        return this.state == QueryExecutionState.CANCELLED;
    }

    public boolean isSuccessful() {
        return this.state == QueryExecutionState.SUCCEEDED;
    }

    boolean isQueryType(GetQueryResultsResult resultsResult) {
        return resultsResult.getResultSet() != null && Strings.isNullOrEmpty(resultsResult.getOutput());
    }

    private void fetchResultMetaData(GetQueryResultsResult result) {
        ResultSetMetaData metaData = this.resultFetcher.fetchMetaData(result);
        this.updateCount = metaData.getUpdateCount();
        this.updateType = metaData.getUpdateType();
        this.columns = metaData.getColumnInfos();
    }

    static List<Row> removeFirstRow(List<Row> resultRows) {
        if (resultRows != null && !resultRows.isEmpty()) {
            resultRows.remove(0);
        }
        return resultRows;
    }

    @VisibleForTesting
    synchronized List<Row> paginateQueryResult(int fetchSize) {
        GetQueryResultsResult result = this.athenaServiceClient.fetchQueryResult(this.queryExecutionId, this.currentNextToken, fetchSize);
        this.currentNextToken = result.getNextToken();
        if (this.resultFetcher == null) {
            this.resultFetcher = this.isQueryType(result) ? new QueryResultFetcher() : new DDLResultFetcher();
        }
        if (!this.started.get()) {
            this.fetchResultMetaData(result);
            this.started.compareAndSet(false, true);
        }
        return this.resultFetcher.fetchRows(result);
    }

    @Override
    List<Row> nextQueryResult(int fetchSize) throws SQLException {
        if (fetchSize < 0) {
            return null;
        }
        try {
            return this.paginateQueryResult(fetchSize);
        }
        catch (InvalidRequestException e) {
            throw new SQLException("The requested fetchSize is more than the allowed value in Athena. Please reduce the fetchSize and try again. Refer to the Athena documentation for valid fetchSize values.");
        }
    }

    @Override
    public synchronized void cancel() {
        this.cancelQuery();
    }

    public synchronized void cancelQuery() {
        this.getQueryStatus();
        if (!this.isFinished()) {
            this.athenaServiceClient.cancelQuery(this.queryExecutionId);
        }
    }

    public long getUpdateCount() {
        return this.updateCount;
    }

    public String getUpdateType() {
        return this.updateType;
    }

    @VisibleForTesting
    static List<com.amazonaws.athena.jdbc.ColumnInfo> toColumnInfoList(List<ColumnInfo> list) {
        if (list != null && !list.isEmpty()) {
            return list.stream().map(columnInfo -> {
                ColumnInfo.Builder builder = new ColumnInfo.Builder().setCatalogName(columnInfo.getCatalogName() == null ? "" : columnInfo.getCatalogName()).setSchemaName(columnInfo.getSchemaName() == null ? "" : columnInfo.getSchemaName()).setTableName(columnInfo.getTableName() == null ? "" : columnInfo.getTableName()).setColumnLabel(columnInfo.getLabel() == null ? columnInfo.getName() : columnInfo.getLabel()).setColumnName(columnInfo.getName()).setNullable(Strings.isNullOrEmpty(columnInfo.getNullable()) ? 2 : AthenaStatementClient.toNullable(columnInfo.getNullable())).setCaseSensitive(columnInfo.getCaseSensitive() == null ? false : columnInfo.isCaseSensitive()).setColumnTypeSignature(TypeSignature.parseTypeSignature(columnInfo.getType().toUpperCase(Locale.ENGLISH))).setCurrency(false);
                if (columnInfo.getPrecision() != null && columnInfo.getPrecision() > 0) {
                    builder.setPrecision(columnInfo.getPrecision());
                }
                if (columnInfo.getScale() != null && columnInfo.getScale() >= 0) {
                    builder.setScale(columnInfo.getScale());
                }
                com.amazonaws.athena.jdbc.ColumnInfo.setTypeInfo(builder, TypeSignature.parseTypeSignature(columnInfo.getType()));
                return builder.build();
            }).collect(Collectors.toList());
        }
        return ImmutableList.of();
    }

    private static int toNullable(String nullableAsString) {
        try {
            int isNullable;
            ColumnNullable nullable = ColumnNullable.fromValue(nullableAsString);
            switch (nullable) {
                case NOTNULL: {
                    isNullable = 0;
                    break;
                }
                case NULLABLE: {
                    isNullable = 1;
                    break;
                }
                case UNKNOWN: {
                    isNullable = 2;
                    break;
                }
                default: {
                    isNullable = 2;
                }
            }
            return isNullable;
        }
        catch (IllegalArgumentException e) {
            return 2;
        }
    }

    public int getQueryStatusCheckBackoffInterval() {
        return this.getAthenaServiceClient().getQueryStatusCheckBackoffInterval();
    }

    static class DDLResultFetcher
    implements ResultFetcher {
        DDLResultFetcher() {
        }

        @Override
        public ResultSetMetaData fetchMetaData(GetQueryResultsResult result) {
            ResultSetMetaData metaData = new ResultSetMetaData();
            if (result.getUpdateCount() != null) {
                metaData.setUpdateCount(result.getUpdateCount());
            } else {
                metaData.setUpdateCount(0L);
            }
            if (result.getUpdateType() != null && !result.getUpdateType().isEmpty()) {
                metaData.setUpdateType(result.getUpdateType());
            } else {
                metaData.setUpdateType("");
            }
            if (result.getResultSet() != null) {
                metaData.setColumnInfos(AthenaStatementClient.toColumnInfoList(result.getResultSet().getResultSetMetadata().getColumnInfo()));
            } else {
                metaData.setColumnInfos(Lists.newArrayList(com.amazonaws.athena.jdbc.ColumnInfo.buildSimpleColumnInfoBuilder("col_1", "varchar").build()));
            }
            return metaData;
        }

        @Override
        public List<Row> fetchRows(GetQueryResultsResult result) {
            List<Row> resultRows;
            if (result.getResultSet() != null) {
                resultRows = result.getResultSet().getRows();
            } else {
                resultRows = new ArrayList<Row>();
                if (!Strings.isNullOrEmpty(result.getOutput())) {
                    Iterable<String> output = Splitter.on("\n").split(result.getOutput());
                    for (String o : output) {
                        resultRows.add(new Row().withData(AthenaResultSetUtils.toDatumList(Lists.newArrayList(o))));
                    }
                }
            }
            return resultRows;
        }
    }

    static class QueryResultFetcher
    implements ResultFetcher {
        private boolean firstPage = true;

        QueryResultFetcher() {
        }

        @Override
        public ResultSetMetaData fetchMetaData(GetQueryResultsResult result) {
            ResultSetMetaData metaData = new ResultSetMetaData();
            if (result.getUpdateCount() != null) {
                metaData.setUpdateCount(result.getUpdateCount());
            }
            if (result.getUpdateType() != null && !result.getUpdateType().isEmpty()) {
                metaData.setUpdateType(result.getUpdateType());
            }
            if (result.getResultSet() != null) {
                metaData.setColumnInfos(AthenaStatementClient.toColumnInfoList(result.getResultSet().getResultSetMetadata().getColumnInfo()));
            } else {
                metaData.setColumnInfos(ImmutableList.of());
            }
            return metaData;
        }

        @Override
        public synchronized List<Row> fetchRows(GetQueryResultsResult result) {
            List<Row> resultRows = null;
            if (result.getResultSet() != null) {
                resultRows = result.getResultSet().getRows();
            }
            if (this.firstPage) {
                resultRows = AthenaStatementClient.removeFirstRow(resultRows);
                this.firstPage = false;
            }
            return resultRows;
        }
    }

    static interface ResultFetcher {
        public ResultSetMetaData fetchMetaData(GetQueryResultsResult var1);

        public List<Row> fetchRows(GetQueryResultsResult var1);
    }

    static class ResultSetMetaData {
        private long updateCount;
        private String updateType;
        private List<com.amazonaws.athena.jdbc.ColumnInfo> columnInfos;

        ResultSetMetaData() {
        }

        public long getUpdateCount() {
            return this.updateCount;
        }

        public void setUpdateCount(long updateCount) {
            this.updateCount = updateCount;
        }

        public String getUpdateType() {
            return this.updateType;
        }

        public void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        public List<com.amazonaws.athena.jdbc.ColumnInfo> getColumnInfos() {
            return this.columnInfos;
        }

        public void setColumnInfos(List<com.amazonaws.athena.jdbc.ColumnInfo> columnInfos) {
            this.columnInfos = columnInfos;
        }
    }
}

