/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc;

import com.amazonaws.athena.jdbc.AthenaServiceClientConfig;
import com.amazonaws.athena.jdbc.AthenaServiceClientRetryCondition;
import com.amazonaws.athena.jdbc.HttpUriBuilder;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.ClientConfiguration;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.Protocol;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.retry.PredefinedBackoffStrategies;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.retry.RetryPolicy;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.AmazonAthenaClient;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Catalog;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.EncryptionConfiguration;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.EntityNotFoundException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.ExecutionEngine;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.GetCatalogsRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.GetCatalogsResult;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.GetExecutionEngineRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.GetNamespaceRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.GetNamespacesRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.GetNamespacesResult;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.GetQueryExecutionRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.GetQueryExecutionResult;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.GetQueryResultsRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.GetQueryResultsResult;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.GetTableRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.GetTablesRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.GetTablesResult;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Namespace;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.QueryExecutionContext;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.QueryExecutionStatus;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.ResultConfiguration;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.StartQueryExecutionRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.StartQueryExecutionResult;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.StopQueryExecutionRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Table;
import com.amazonaws.athena.jdbc.shaded.guava.annotations.VisibleForTesting;
import com.amazonaws.athena.jdbc.shaded.guava.base.Preconditions;
import com.amazonaws.athena.jdbc.shaded.guava.base.Strings;
import com.amazonaws.athena.jdbc.shaded.guava.collect.ImmutableList;
import com.amazonaws.athena.jdbc.shaded.guava.net.HostAndPort;
import com.amazonaws.athena.jdbc.shaded.guava.primitives.Ints;
import com.amazonaws.auth.AWSCredentialsProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class AthenaServiceClient {
    private static final Logger LOGGER = LogManager.getLogger(AthenaServiceClient.class);
    private static final String WS_SERVICE_NAME = "athena";
    private static final String USER_AGENT_PREFIX = String.format("AthenaJDBC-%s", "1.0");
    private final AWSCredentialsProvider credentialsProvider;
    private final AmazonAthenaClient client;
    private final AthenaServiceClientConfig clientConfig;

    public AthenaServiceClient(AthenaServiceClientConfig clientConfig, URI endpointURI) throws SQLException {
        this.clientConfig = Objects.requireNonNull(clientConfig, "clientConfig is null");
        this.credentialsProvider = AthenaServiceClient.createAWSCredentialsProvider(clientConfig);
        ClientConfiguration clientConfiguration = AthenaServiceClient.createClientConfiguration(clientConfig);
        this.client = new AmazonAthenaClient(this.credentialsProvider, clientConfiguration);
        this.client.setServiceNameIntern(WS_SERVICE_NAME);
        this.client.setEndpoint(AthenaServiceClient.getEndpoint(endpointURI));
    }

    @VisibleForTesting
    AthenaServiceClient(AmazonAthenaClient client, AWSCredentialsProvider credentialsProvider, AthenaServiceClientConfig clientConfig, URI endpoint) {
        this.client = client;
        this.clientConfig = clientConfig;
        this.credentialsProvider = credentialsProvider;
    }

    static ClientConfiguration createClientConfiguration(AthenaServiceClientConfig clientConfig) {
        RetryPolicy retryPolicy = new RetryPolicy(new AthenaServiceClientRetryCondition(), new PredefinedBackoffStrategies.ExponentialBackoffStrategy(Ints.checkedCast(clientConfig.getBaseDelayInMills()), Ints.checkedCast(clientConfig.getMaxBackoffTimeInMills())), clientConfig.getMaxErrorRetries(), true);
        ClientConfiguration config = new ClientConfiguration().withRetryPolicy(retryPolicy).withProtocol(Protocol.HTTPS).withTcpKeepAlive(true).withConnectionTimeout(Ints.checkedCast(clientConfig.getConnectTimeoutInMills())).withSocketTimeout(Ints.checkedCast(clientConfig.getSocketTimeoutInMills())).withUserAgentPrefix(USER_AGENT_PREFIX).withProxyDomain(clientConfig.getProxyDomain()).withProxyHost(clientConfig.getProxyHost()).withProxyPort(clientConfig.getProxyPort()).withProxyUsername(clientConfig.getProxyUsername()).withProxyPassword(clientConfig.getProxyPassword()).withProxyWorkstation(clientConfig.getProxyWorkstation()).withNonProxyHosts(clientConfig.getNonProxyHosts()).withPreemptiveBasicProxyAuth(clientConfig.isPreemptiveBasicProxyAuth());
        return config;
    }

    static AWSCredentialsProvider createAWSCredentialsProvider(AthenaServiceClientConfig clientConfig) throws SQLException {
        Class providerClass = clientConfig.getAwsCredentialsProviderClass();
        if (providerClass != null) {
            LOGGER.debug("Using custom AWS credentials provider class " + providerClass.getName());
            List<String> arguments = clientConfig.getAwsCredentialsProviderArguments();
            try {
                if (arguments == null || arguments.isEmpty()) {
                    Constructor constructor = providerClass.getConstructor(new Class[0]);
                    return (AWSCredentialsProvider)constructor.newInstance(new Object[0]);
                }
                Class[] argumentClasses = new Class[arguments.size()];
                for (int i = 0; i < arguments.size(); ++i) {
                    argumentClasses[i] = String.class;
                }
                Constructor constructor = providerClass.getConstructor(argumentClasses);
                return (AWSCredentialsProvider)constructor.newInstance(arguments.toArray());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Failed to create AWS credentials provider", e);
                throw new SQLException("Failed to create AWS credentials provider", e);
            }
        }
        LOGGER.debug("Using AWS accessId and SecretKey");
        return new AWSStaticCredentialsProvider(new BasicAWSCredentials(clientConfig.getAwsAccessId(), clientConfig.getAwsSecretKey()));
    }

    public AmazonAthenaClient getClient() {
        return this.client;
    }

    public String runQuery(String query, String schema) {
        StartQueryExecutionRequest startQueryExecutionRequest = new StartQueryExecutionRequest().withQueryString(query).withResultConfiguration(this.createResultConfiguration()).withQueryExecutionContext(new QueryExecutionContext().withDatabase(schema));
        StartQueryExecutionResult result = this.client.startQueryExecution(startQueryExecutionRequest);
        return result.getQueryExecutionId();
    }

    public QueryExecutionStatus getQueryExecutionStatus(String queryExecutionId) {
        GetQueryExecutionRequest request = new GetQueryExecutionRequest().withQueryExecutionId(queryExecutionId);
        GetQueryExecutionResult result = this.client.getQueryExecution(request);
        return result.getQueryExecution().getStatus();
    }

    public void cancelQuery(String queryId) {
        StopQueryExecutionRequest stopQueryExecutionRequest = new StopQueryExecutionRequest().withQueryExecutionId(queryId);
        this.client.stopQueryExecution(stopQueryExecutionRequest);
    }

    public GetQueryResultsResult fetchQueryResult(String queryExecutionId, String marker, int fetchSize) {
        GetQueryResultsRequest request = fetchSize == 0 ? new GetQueryResultsRequest().withQueryExecutionId(queryExecutionId).withNextToken(marker) : new GetQueryResultsRequest().withQueryExecutionId(queryExecutionId).withMaxResults(fetchSize).withNextToken(marker);
        return this.client.getQueryResults(request);
    }

    public List<Catalog> getCatalogs() {
        return this.getCatalogs(null);
    }

    public List<Catalog> getCatalogs(String catalogName) throws EntityNotFoundException {
        List<Catalog> results = new ArrayList<Catalog>();
        GetCatalogsRequest request = new GetCatalogsRequest();
        GetCatalogsResult result = this.client.getCatalogs(request);
        results.addAll(result.getCatalogs());
        if (catalogName != null) {
            results = results.stream().filter(catalog -> catalog.getCatalogName().equals(catalogName)).collect(Collectors.toList());
        }
        results.sort(new Comparator<Catalog>(){

            @Override
            public int compare(Catalog o1, Catalog o2) {
                return o1.getCatalogName().compareTo(o2.getCatalogName());
            }
        });
        return results;
    }

    private List<Namespace> getNamespace(String catalogId, String namespaceName) {
        try {
            Preconditions.checkArgument(namespaceName != null, "Namespace cannot be null.");
            GetNamespaceRequest request = new GetNamespaceRequest().withCatalogId(catalogId).withNamespaceName(namespaceName);
            return Arrays.asList(this.client.getNamespace(request).getNamespace());
        }
        catch (EntityNotFoundException e) {
            return new ArrayList<Namespace>();
        }
    }

    private List<Namespace> getAllNamespaces(String catalogId) throws EntityNotFoundException {
        try {
            GetNamespacesResult response;
            Preconditions.checkArgument(catalogId != null);
            ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
            String nextToken = null;
            do {
                response = this.client.getNamespaces(new GetNamespacesRequest().withCatalogId(catalogId).withNextToken(nextToken));
                namespaces.addAll(response.getNamespaceList());
            } while ((nextToken = response.getNextToken()) != null);
            return namespaces;
        }
        catch (Exception e) {
            return new ArrayList<Namespace>();
        }
    }

    public List<Namespace> getNamespaces(String catalogId, String namespaceName) {
        Preconditions.checkArgument(catalogId != null);
        if (catalogId != null && namespaceName != null) {
            return this.getNamespace(catalogId, namespaceName);
        }
        List<Namespace> namespaces = this.getAllNamespaces(catalogId);
        namespaces.sort(new Comparator<Namespace>(){

            @Override
            public int compare(Namespace o1, Namespace o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return namespaces;
    }

    private List<Table> getTable(String catalogId, String schema, String tableName) {
        try {
            GetTableRequest getTableRequest = new GetTableRequest().withCatalogId(catalogId).withNamespaceName(schema).withName(tableName);
            return ImmutableList.of(this.client.getTable(getTableRequest).getTable());
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    private List<Table> getAllTables(String catalogId, String namespaceName) {
        try {
            GetTablesResult response;
            Preconditions.checkArgument(namespaceName != null);
            ArrayList<Table> tables = new ArrayList<Table>();
            String nextToken = null;
            do {
                response = this.client.getTables(new GetTablesRequest().withCatalogId(catalogId).withNamespaceName(namespaceName).withNextToken(nextToken));
                tables.addAll(response.getTableList());
            } while ((nextToken = response.getNextToken()) != null);
            return tables;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public List<Table> getTables(String catalogId, String namespaceName, String tableFilter) {
        Preconditions.checkArgument(namespaceName != null);
        if (catalogId != null && namespaceName != null && tableFilter != null) {
            return this.getTable(catalogId, namespaceName, tableFilter);
        }
        List<Table> tables = this.getAllTables(catalogId, namespaceName);
        tables.sort(new Comparator<Table>(){

            @Override
            public int compare(Table o1, Table o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return tables;
    }

    public ExecutionEngine getExecutionEngine() {
        return this.client.getExecutionEngine(new GetExecutionEngineRequest().withExecutionEngineId(this.clientConfig.getExecutionEngine())).getExecutionEngine();
    }

    public void close() {
        this.client.shutdown();
    }

    @VisibleForTesting
    ResultConfiguration createResultConfiguration() {
        ResultConfiguration resultConfiguration = new ResultConfiguration().withOutputLocation(this.clientConfig.getS3StagingDir());
        if (!Strings.isNullOrEmpty(this.clientConfig.getQueryResultsEncryptionOption())) {
            EncryptionConfiguration encryptionConfiguration = new EncryptionConfiguration().withKmsKey(this.clientConfig.getQueryResultsAwsKmsKey()).withAwsKmsKey(this.clientConfig.getQueryResultsAwsKmsKey()).withEncryptionOption(this.clientConfig.getQueryResultsEncryptionOption());
            resultConfiguration.withEncryptionConfiguration(encryptionConfiguration);
        }
        return resultConfiguration;
    }

    @VisibleForTesting
    static String getEndpoint(URI endpointURI) {
        return AthenaServiceClient.createHttpUri(HostAndPort.fromParts(endpointURI.getHost(), endpointURI.getPort()));
    }

    private static String createHttpUri(HostAndPort address) {
        return HttpUriBuilder.uriBuilder().scheme(address.getPort() == 443 ? "https" : "http").host(address.getHostText()).port(address.getPort()).build().toString();
    }

    public int getQueryStatusCheckBackoffInterval() {
        return this.clientConfig.getQueryStatusCheckBackoffInterval();
    }
}

