/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc;

import com.amazonaws.athena.jdbc.AbstractAthenaClient;
import com.amazonaws.athena.jdbc.AthenaIntervalDayTime;
import com.amazonaws.athena.jdbc.AthenaIntervalYearMonth;
import com.amazonaws.athena.jdbc.AthenaResultSetMetaData;
import com.amazonaws.athena.jdbc.ColumnInfo;
import com.amazonaws.athena.jdbc.IntervalDayTime;
import com.amazonaws.athena.jdbc.IntervalYearMonth;
import com.amazonaws.athena.jdbc.NotImplementedException;
import com.amazonaws.athena.jdbc.TimeLog;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Datum;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Row;
import com.amazonaws.athena.jdbc.shaded.guava.annotations.VisibleForTesting;
import com.amazonaws.athena.jdbc.shaded.guava.collect.ImmutableMap;
import com.amazonaws.athena.jdbc.shaded.joda.time.DateTimeZone;
import com.amazonaws.athena.jdbc.shaded.joda.time.format.DateTimeFormat;
import com.amazonaws.athena.jdbc.shaded.joda.time.format.DateTimeFormatter;
import com.amazonaws.athena.jdbc.shaded.joda.time.format.DateTimeFormatterBuilder;
import com.amazonaws.athena.jdbc.shaded.joda.time.format.DateTimeParser;
import com.amazonaws.athena.jdbc.shaded.joda.time.format.ISODateTimeFormat;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class AthenaResultSet
implements ResultSet {
    private static final DateTimeFormatter DATE_FORMATTER = ISODateTimeFormat.date();
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormat.forPattern("HH:mm:ss.SSS");
    private static final DateTimeFormatter TIME_WITH_TIME_ZONE_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormat.forPattern("HH:mm:ss.SSS ZZZ").getPrinter(), new DateTimeParser[]{DateTimeFormat.forPattern("HH:mm:ss.SSS Z").getParser(), DateTimeFormat.forPattern("HH:mm:ss.SSS ZZZ").getParser()}).toFormatter().withOffsetParsed();
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateTimeFormatter TIMESTAMP_WITH_TIME_ZONE_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss.SSS ZZZ").getPrinter(), new DateTimeParser[]{DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss.SSS Z").getParser(), DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss.SSS ZZZ").getParser()}).toFormatter().withOffsetParsed();
    private final AbstractAthenaClient client;
    private final DateTimeZone sessionTimeZone;
    private Iterator<List<Datum>> fetchedRowsItr;
    private final Map<String, Integer> fieldMap;
    private final List<ColumnInfo> columnInfoList;
    private final ResultSetMetaData resultSetMetaData;
    private final AtomicReference<List<Datum>> row = new AtomicReference();
    private final AtomicBoolean wasNull = new AtomicBoolean();
    private long maxRows;
    private int fetchSize;
    private long rowsFetched;
    private TimeLog timeLog = new TimeLog();

    AthenaResultSet(AbstractAthenaClient client, long maxRows, int fetchSize) throws SQLException {
        this.client = Objects.requireNonNull(client, "client is null");
        this.sessionTimeZone = DateTimeZone.forID(client.getTimeZoneId());
        this.maxRows = maxRows;
        this.fetchSize = fetchSize;
        this.rowsFetched = 0L;
        this.fetchedRowsItr = this.fetchRows(fetchSize);
        this.columnInfoList = client.getColumns();
        this.fieldMap = AthenaResultSet.getFieldMap(this.columnInfoList);
        this.resultSetMetaData = new AthenaResultSetMetaData(this.columnInfoList);
    }

    public AbstractAthenaClient getClient() {
        return this.client;
    }

    @VisibleForTesting
    Iterator<List<Datum>> fetchRows(int fetchSize) throws SQLException {
        List<Row> resultRows;
        ArrayList<List<Datum>> list = new ArrayList<List<Datum>>();
        if (this.maxRows > 0L && this.rowsFetched != this.maxRows && this.maxRows - this.rowsFetched < (long)fetchSize) {
            fetchSize = (int)(this.maxRows - this.rowsFetched);
        }
        if ((resultRows = this.client.nextQueryResult(fetchSize)) != null && !resultRows.isEmpty()) {
            for (Row resultRow : resultRows) {
                if (resultRow.getData() == null) continue;
                list.add(resultRow.getData());
            }
        }
        return list.iterator();
    }

    private boolean hasNext() {
        return this.client.hasNextQueryResult();
    }

    @Override
    public boolean next() throws SQLException {
        this.timeLog.addObservation("Next Called");
        this.checkOpen();
        if (this.maxRows > 0L && this.rowsFetched >= this.maxRows) {
            return false;
        }
        try {
            if (!this.fetchedRowsItr.hasNext()) {
                if (this.hasNext()) {
                    this.timeLog.addObservation("Fetching next batch of rows.");
                    this.fetchedRowsItr = this.fetchRows(this.fetchSize);
                    this.timeLog.addObservation("Completed fetching next batch of rows. hasNext() = " + this.fetchedRowsItr.hasNext());
                    if (this.fetchedRowsItr.hasNext()) {
                        this.row.set(this.fetchedRowsItr.next());
                        ++this.rowsFetched;
                        return true;
                    }
                }
                this.timeLog.addFinalObservation("No more rows available to obtain. Finishing.");
                this.row.set(null);
                return false;
            }
            this.row.set(this.fetchedRowsItr.next());
            ++this.rowsFetched;
            return true;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw new SQLException("Error fetching results", e);
        }
    }

    long getRowsFetched() {
        return this.rowsFetched;
    }

    @Override
    public void close() throws SQLException {
        this.client.close();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull.get();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.column(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        String value = this.column(columnIndex);
        return Boolean.parseBoolean(value);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.toByte(AthenaResultSet.toNumberString(this.column(columnIndex)));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.toShort(AthenaResultSet.toNumberString(this.column(columnIndex)));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try {
            return Integer.parseInt(AthenaResultSet.toNumberString(this.column(columnIndex)));
        }
        catch (NumberFormatException e) {
            throw new SQLException("Invalid int format", e);
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.toLong(AthenaResultSet.toNumberString(this.column(columnIndex)));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.toFloat(AthenaResultSet.toNumberString(this.column(columnIndex)));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.toDouble(AthenaResultSet.toNumberString(this.column(columnIndex)));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(columnIndex);
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(scale, 4);
        }
        return bigDecimal;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.column(columnIndex).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, this.sessionTimeZone);
    }

    private Date getDate(int columnIndex, DateTimeZone localTimeZone) throws SQLException {
        String value = this.column(columnIndex);
        if (value == null) {
            return null;
        }
        try {
            return new Date(DATE_FORMATTER.withZone(localTimeZone).parseMillis(value));
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Invalid date from server: " + value, e);
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, this.sessionTimeZone);
    }

    private Time getTime(int columnIndex, DateTimeZone localTimeZone) throws SQLException {
        String value = this.column(columnIndex);
        if (value == null) {
            return null;
        }
        ColumnInfo columnInfo = this.columnInfo(columnIndex);
        if (columnInfo.getColumnTypeName().equalsIgnoreCase("time")) {
            try {
                return new Time(TIME_FORMATTER.withZone(localTimeZone).parseMillis(value));
            }
            catch (IllegalArgumentException e) {
                throw new SQLException("Invalid time from server: " + value, e);
            }
        }
        if (columnInfo.getColumnTypeName().equalsIgnoreCase("time with time zone")) {
            try {
                return new Time(TIME_WITH_TIME_ZONE_FORMATTER.parseMillis(value));
            }
            catch (IllegalArgumentException e) {
                throw new SQLException("Invalid time from server: " + value, e);
            }
        }
        throw new IllegalArgumentException("Expected column to be a time type but is " + columnInfo.getColumnTypeName());
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, this.sessionTimeZone);
    }

    private Timestamp getTimestamp(int columnIndex, DateTimeZone localTimeZone) throws SQLException {
        String value = this.column(columnIndex);
        if (value == null) {
            return null;
        }
        ColumnInfo columnInfo = this.columnInfo(columnIndex);
        if (columnInfo.getColumnTypeName().equalsIgnoreCase("timestamp")) {
            try {
                return new Timestamp(TIMESTAMP_FORMATTER.withZone(localTimeZone).parseMillis(value));
            }
            catch (IllegalArgumentException e) {
                throw new SQLException("Invalid timestamp from server: " + value, e);
            }
        }
        if (columnInfo.getColumnTypeName().equalsIgnoreCase("timestamp with time zone")) {
            try {
                return new Timestamp(TIMESTAMP_WITH_TIME_ZONE_FORMATTER.parseMillis(value));
            }
            catch (IllegalArgumentException e) {
                throw new SQLException("Invalid timestamp from server: " + value, e);
            }
        }
        throw new IllegalArgumentException("Expected column to be a timestamp type but is " + columnInfo.getColumnTypeName());
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new NotImplementedException("ResultSet", "getAsciiStream");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new NotImplementedException("ResultSet", "getBinaryStream");
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.column(columnLabel);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        String value = this.column(columnLabel);
        return Boolean.parseBoolean(value);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.toByte(AthenaResultSet.toNumberString(this.column(columnLabel)));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.toShort(AthenaResultSet.toNumberString(this.column(columnLabel)));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.toInt(AthenaResultSet.toNumberString(this.column(columnLabel)));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.toLong(AthenaResultSet.toNumberString(this.column(columnLabel)));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.toFloat(AthenaResultSet.toNumberString(this.column(columnLabel)));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.toDouble(AthenaResultSet.toNumberString(this.column(columnLabel)));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.columnIndex(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        String value = this.column(columnLabel);
        return value == null ? null : value.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.columnIndex(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.columnIndex(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.columnIndex(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new NotImplementedException("ResultSet", "getAsciiStream");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw new NotImplementedException("ResultSet", "getBinaryStream");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException("getCursorName");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        ColumnInfo columnInfo = this.columnInfo(columnIndex);
        if (this.column(columnIndex) == null) {
            return null;
        }
        switch (columnInfo.getSQLColumnType()) {
            case 16: {
                return this.getBoolean(columnIndex);
            }
            case -5: {
                return this.getLong(columnIndex);
            }
            case 4: {
                return this.getInt(columnIndex);
            }
            case -6: 
            case 5: {
                return this.getShort(columnIndex);
            }
            case 8: {
                return this.getDouble(columnIndex);
            }
            case 6: {
                return Float.valueOf(this.getFloat(columnIndex));
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
            case 2003: {
                return this.getArray(columnIndex);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(columnIndex);
            }
            case 2000: {
                if (columnInfo.getColumnTypeName().equalsIgnoreCase("interval year to month")) {
                    return this.getIntervalYearMonth(columnIndex);
                }
                if (!columnInfo.getColumnTypeName().equalsIgnoreCase("interval day to second")) break;
                return this.getIntervalDayTime(columnIndex);
            }
        }
        return this.column(columnIndex);
    }

    private AthenaIntervalYearMonth getIntervalYearMonth(int columnIndex) throws SQLException {
        String value = this.column(columnIndex);
        if (value == null) {
            return null;
        }
        return new AthenaIntervalYearMonth(IntervalYearMonth.parseMonths(value));
    }

    private AthenaIntervalDayTime getIntervalDayTime(int columnIndex) throws SQLException {
        String value = this.column(columnIndex);
        if (value == null) {
            return null;
        }
        return new AthenaIntervalDayTime(IntervalDayTime.parseMillis(value));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.columnIndex(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkOpen();
        return this.columnIndex(columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String value = this.column(columnIndex);
        if (value == null) {
            return null;
        }
        return this.getCharacterStreamFromString(value);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.columnIndex(columnLabel));
    }

    private Reader getCharacterStreamFromString(String stringVal) {
        if (stringVal != null) {
            return new StringReader(stringVal);
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        String value = this.column(columnIndex);
        if (value == null) {
            return null;
        }
        return new BigDecimal(value);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.columnIndex(columnLabel));
    }

    private byte toByte(String value) throws SQLException {
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Invalid byte format", e);
        }
    }

    private short toShort(String value) throws SQLException {
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Invalid short format", e);
        }
    }

    private int toInt(String value) throws SQLException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Invalid int format", e);
        }
    }

    private long toLong(String value) throws SQLException {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Invalid long format", e);
        }
    }

    private float toFloat(String value) throws SQLException {
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Invalid float format", e);
        }
    }

    private double toDouble(String value) throws SQLException {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Invalid double format", e);
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException("isBeforeFirst");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("isAfterLast");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException("isFirst");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("isLast");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException("beforeFirst");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("afterLast");
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLFeatureNotSupportedException("first");
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLFeatureNotSupportedException("last");
    }

    @Override
    public int getRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("getRow");
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLFeatureNotSupportedException("absolute");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new SQLFeatureNotSupportedException("relative");
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLFeatureNotSupportedException("previous");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        if (direction != 1000) {
            throw new SQLException("Fetch direction must be FETCH_FORWARD");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        if (rows < 0) {
            throw new SQLException("Rows is negative");
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        this.checkOpen();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkOpen();
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLFeatureNotSupportedException("rowUpdated");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLFeatureNotSupportedException("rowInserted");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLFeatureNotSupportedException("rowDeleted");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNull");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBoolean");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateByte");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateShort");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateInt");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateLong");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateFloat");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDouble");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBigDecimal");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateString");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBytes");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDate");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTime");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTimestamp");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNull");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBoolean");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateByte");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateShort");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateInt");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateLong");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateFloat");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDouble");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBigDecimal");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateString");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBytes");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDate");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTime");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTimestamp");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("insertRow");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRow");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("deleteRow");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("refreshRow");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException("cancelRowUpdates");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("moveToInsertRow");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("moveToCurrentRow");
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new NotImplementedException("ResultSet", "getStatement");
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getObject");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRef");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBlob");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getClob");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getArray");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getObject");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRef");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBlob");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getClob");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.columnIndex(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(columnIndex, DateTimeZone.forTimeZone(cal.getTimeZone()));
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.columnIndex(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime(columnIndex, DateTimeZone.forTimeZone(cal.getTimeZone()));
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.columnIndex(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex, DateTimeZone.forTimeZone(cal.getTimeZone()));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.columnIndex(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getURL");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getURL");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRef");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRef");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateArray");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateArray");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRowId");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRowId");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRowId");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRowId");
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkOpen();
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.client.isClosed();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNString");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNString");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNClob");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNClob");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getSQLXML");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getSQLXML");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateSQLXML");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateSQLXML");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNString");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNString");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNCharacterStream");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("getObject");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("getObject");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException("No wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet is closed");
        }
    }

    private void checkValidRow() throws SQLException {
        if (this.row.get() == null) {
            throw new SQLException("Not on a valid row");
        }
    }

    private String column(int index) throws SQLException {
        this.checkOpen();
        this.checkValidRow();
        if (index <= 0 || index > this.resultSetMetaData.getColumnCount()) {
            throw new SQLException("Invalid column index: " + index);
        }
        String value = this.row.get().get(index - 1).getVarCharValue();
        this.wasNull.set(value == null);
        return value;
    }

    private ColumnInfo columnInfo(int index) throws SQLException {
        this.checkOpen();
        this.checkValidRow();
        if (index <= 0 || index > this.columnInfoList.size()) {
            throw new SQLException("Invalid column index: " + index);
        }
        return this.columnInfoList.get(index - 1);
    }

    private String column(String label) throws SQLException {
        this.checkOpen();
        this.checkValidRow();
        String value = this.row.get().get(this.columnIndex(label) - 1).getVarCharValue();
        this.wasNull.set(value == null);
        return value;
    }

    private int columnIndex(String label) throws SQLException {
        if (label == null) {
            throw new SQLException("Column label is null");
        }
        Integer index = this.fieldMap.get(label.toLowerCase(Locale.ENGLISH));
        if (index == null) {
            throw new SQLException("Invalid column label: " + label);
        }
        return index;
    }

    private static String toNumberString(String value) throws SQLException {
        if (value == null || value.equals("null")) {
            return "0";
        }
        return value;
    }

    private static Map<String, Integer> getFieldMap(List<ColumnInfo> columns) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (columns != null && !columns.isEmpty()) {
            for (int i = 0; i < columns.size(); ++i) {
                String name = columns.get(i).getColumnName().toLowerCase(Locale.ENGLISH);
                if (map.containsKey(name)) continue;
                map.put(name, i + 1);
            }
        }
        return ImmutableMap.copyOf(map);
    }
}

