/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc;

import com.amazonaws.athena.jdbc.AbstractAthenaClient;
import com.amazonaws.athena.jdbc.AthenaServiceClient;
import com.amazonaws.athena.jdbc.CatalogColumnInfo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Row;
import com.amazonaws.athena.jdbc.shaded.guava.base.Preconditions;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class AthenaProvidedResultsClient
extends AbstractAthenaClient {
    private static List<Row> resultsRows = new ArrayList<Row>();

    protected AthenaProvidedResultsClient(AthenaServiceClient athenaServiceClient, CatalogColumnInfo ... columns) {
        super(athenaServiceClient);
        this.columns = Arrays.asList(columns).stream().map(enumVal -> enumVal.getColumn()).collect(Collectors.toList());
    }

    public void addResultRow(Row row) {
        Preconditions.checkArgument(row.getData().size() == this.columns.size(), "Row being added has incorrect number of fields. Expected: %s, recieved: %s ", this.columns.size(), row.getData().size());
        resultsRows.add(row);
    }

    @Override
    public boolean hasNextQueryResult() {
        return !resultsRows.isEmpty();
    }

    @Override
    public List<Row> nextQueryResult(int maxResults) throws SQLException {
        List<Row> results = resultsRows;
        resultsRows = new ArrayList<Row>();
        return results;
    }

    @Override
    public void cancel() {
    }
}

