/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc;

import com.amazonaws.athena.jdbc.AbstractAthenaClient;
import com.amazonaws.athena.jdbc.AthenaCatalogClient;
import com.amazonaws.athena.jdbc.AthenaResultSetUtils;
import com.amazonaws.athena.jdbc.AthenaServiceClient;
import com.amazonaws.athena.jdbc.CatalogColumnInfo;
import com.amazonaws.athena.jdbc.CatalogHierarchy;
import com.amazonaws.athena.jdbc.ColumnInfo;
import com.amazonaws.athena.jdbc.SQLPatternMatcher;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Catalog;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Namespace;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Row;
import com.amazonaws.athena.jdbc.shaded.guava.base.Preconditions;
import com.amazonaws.athena.jdbc.shaded.guava.collect.ImmutableList;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AthenaNamespacesClient
extends AbstractAthenaClient {
    private final String namespacePattern;
    private final String catalogPattern;
    private AtomicReference<Iterator<CatalogHierarchy>> namespaceIterator = new AtomicReference();

    protected AthenaNamespacesClient(AthenaServiceClient athenaServiceClient, String catalogPattern, String namespacePattern) {
        super(athenaServiceClient);
        this.namespacePattern = namespacePattern;
        this.catalogPattern = catalogPattern;
        this.namespaceIterator.set(this.iterator());
    }

    private synchronized List<CatalogHierarchy> getNextPage(int maxResults) throws SQLException {
        if (!this.started.get()) {
            this.started.compareAndSet(false, true);
        }
        Iterator<CatalogHierarchy> iterator = this.namespaceIterator.get();
        ArrayList<CatalogHierarchy> resultRows = new ArrayList<CatalogHierarchy>();
        for (int rowsProcessed = 0; (maxResults == 0 || rowsProcessed < maxResults) && iterator.hasNext(); ++rowsProcessed) {
            resultRows.add(iterator.next());
        }
        return resultRows;
    }

    @Override
    public List<Row> nextQueryResult(int maxResults) throws SQLException {
        return this.getNextPage(maxResults).stream().map(hierarchy -> this.toResultRow((CatalogHierarchy)hierarchy)).collect(Collectors.toList());
    }

    @Override
    public List<ColumnInfo> getColumns() {
        return ImmutableList.of(CatalogColumnInfo.TABLE_SCHEM.getColumn(), CatalogColumnInfo.TABLE_CATALOG.cloneColumn(true));
    }

    @Override
    public boolean hasNextQueryResult() {
        return this.namespaceIterator.get().hasNext();
    }

    private Row toResultRow(CatalogHierarchy next) {
        return new Row().withData(AthenaResultSetUtils.toDatum(next.getNamespace().getName()), AthenaResultSetUtils.toDatum(next.getCatalog().getCatalogName()));
    }

    @Override
    public void cancel() {
        if (!this.cancelled.getAndSet(true)) {
            this.namespaceIterator.set(Collections.emptyIterator());
        }
    }

    public Iterator<CatalogHierarchy> getIterator() {
        return this.namespaceIterator.get();
    }

    Iterator<CatalogHierarchy> iterator() {
        AthenaCatalogClient catalogClient = new AthenaCatalogClient(this.athenaServiceClient, this.catalogPattern);
        NamespaceIterator namespaces = new NamespaceIterator(catalogClient.getIterator(), this.athenaServiceClient, this.namespacePattern);
        return namespaces;
    }

    public static class NamespaceIterator
    implements Iterator<CatalogHierarchy> {
        private final AthenaServiceClient serviceClient;
        private Catalog currentCatalog;
        private Iterator<Catalog> catalogIter;
        private final String namespacePattern;
        private Namespace currentNamespace;
        private Iterator<Namespace> namespaceIter;
        private Pattern patternMatcher;

        public NamespaceIterator(Iterator<Catalog> catalogIter, AthenaServiceClient serviceClient, String namespacePattern) {
            this.serviceClient = serviceClient;
            this.catalogIter = catalogIter;
            this.namespacePattern = namespacePattern;
            if (catalogIter.hasNext()) {
                this.currentCatalog = this.catalogIter.next();
                if (SQLPatternMatcher.hasWildCardCharacters(namespacePattern)) {
                    this.patternMatcher = SQLPatternMatcher.getSqlPattern(namespacePattern);
                }
                this.namespaceIter = this.getResults();
            } else {
                this.namespaceIter = ImmutableList.of().iterator();
            }
            this.moveIterators();
        }

        private Iterator<Namespace> getResults() {
            if (this.patternMatcher == null) {
                return this.serviceClient.getNamespaces(this.currentCatalog.getCatalogId(), SQLPatternMatcher.removeEscapeCharacters(this.namespacePattern)).iterator();
            }
            List<Namespace> namespaces = this.serviceClient.getNamespaces(this.currentCatalog.getCatalogId(), null);
            return namespaces.stream().filter(namespace -> this.patternMatcher.matcher(namespace.getName()).matches()).collect(Collectors.toList()).iterator();
        }

        private void moveIterators() {
            if (this.namespaceIter.hasNext()) {
                this.currentNamespace = this.namespaceIter.next();
                return;
            }
            while (!this.namespaceIter.hasNext() && this.catalogIter.hasNext()) {
                this.currentCatalog = this.catalogIter.next();
                this.namespaceIter = this.getResults();
            }
            this.currentNamespace = this.namespaceIter.hasNext() ? this.namespaceIter.next() : null;
        }

        @Override
        public boolean hasNext() {
            return this.currentNamespace != null;
        }

        @Override
        public CatalogHierarchy next() {
            Preconditions.checkArgument(this.currentNamespace != null);
            CatalogHierarchy hierarchy = new CatalogHierarchy(this.currentCatalog, this.currentNamespace);
            this.moveIterators();
            return hierarchy;
        }
    }
}

