/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc;

import com.amazonaws.athena.jdbc.AthenaDriver;
import com.amazonaws.athena.jdbc.AthenaDriverProperties;
import com.amazonaws.athena.jdbc.AthenaServiceClientConfig;
import com.amazonaws.athena.jdbc.shaded.guava.annotations.VisibleForTesting;
import com.amazonaws.athena.jdbc.shaded.guava.base.Strings;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.opencsv.CSVReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class AthenaDriverPropertiesFactory {
    private static final Logger LOGGER = LogManager.getLogger(AthenaDriver.class);

    @VisibleForTesting
    AthenaServiceClientConfig parseProperties(Properties origProperties, URI uri) throws SQLException {
        AthenaServiceClientConfig clientConfig = new AthenaServiceClientConfig();
        Properties info = new Properties(origProperties);
        this.getPropertiesFromUrl(info, uri);
        this.setClientConfigProperty(AthenaDriverProperties.USER_PROPERTY, info, value -> clientConfig.setAwsAccessId(value));
        this.setClientConfigProperty(AthenaDriverProperties.PASSWORD_PROPERTY, info, value -> clientConfig.setAwsSecretKey(value));
        this.setClientConfigProperty(AthenaDriverProperties.AWS_CREDENTIALS_PROVIDER_PROPERTY, info, value -> {
            if (!Strings.isNullOrEmpty(value)) {
                try {
                    Class<?> providerClass = Class.forName(value);
                    if (!AWSCredentialsProvider.class.isAssignableFrom(providerClass)) {
                        throw new SQLException("Custom AWS credentials provider " + value + " must implement the interface com.amazonaws.auth.AWSCredentialsProvider");
                    }
                    clientConfig.setAwsCredentialsProviderClass(providerClass);
                }
                catch (ClassNotFoundException | ExceptionInInitializerError e) {
                    throw new SQLException("Failed to load AWS credentials provider class: " + value, e);
                }
            }
        });
        this.setClientConfigProperty(AthenaDriverProperties.AWS_CREDENTIALS_PROVIDER_ARGUMENTS, info, value -> clientConfig.setAwsCredentialsProviderArguments(this.parseAWSCredentialsProviderArguments(value)));
        this.setClientConfigProperty(AthenaDriverProperties.S3_STAGING_DIR, info, value -> {
            if (!value.startsWith("s3://")) {
                throw new SQLException(String.format("S3 staging dir property (%s) must be a s3 path", AthenaDriverProperties.S3_STAGING_DIR.getPropertyName()));
            }
            clientConfig.setS3StagingDir(value);
        });
        this.setClientConfigProperty(AthenaDriverProperties.MAX_ERROR_RETRIES, info, value -> clientConfig.setMaxErrorRetries(Integer.parseInt(value.trim())));
        this.setClientConfigProperty(AthenaDriverProperties.CONNECTION_TIMEOUT, info, value -> clientConfig.setConnectTimeoutInMills(Long.parseLong(value.trim())));
        this.setClientConfigProperty(AthenaDriverProperties.SOCKET_TIMEOUT, info, value -> clientConfig.setSocketTimeoutInMills(Long.parseLong(value.trim())));
        this.setClientConfigProperty(AthenaDriverProperties.RETRY_BASE_DELAY, info, value -> clientConfig.setBaseDelayInMills(Long.parseLong(value.trim())));
        this.setClientConfigProperty(AthenaDriverProperties.RETRY_MAX_BACKOFF_TIME, info, value -> clientConfig.setMaxBackoffTimeInMills(Long.parseLong(value.trim())));
        this.setClientConfigProperty(AthenaDriverProperties.EXECUTION_ENGINE_ID, info, value -> clientConfig.setExecutionEngineId(value));
        this.setClientConfigProperty(AthenaDriverProperties.LOG_PATH, info, value -> clientConfig.setLogPath(value));
        this.setClientConfigProperty(AthenaDriverProperties.LOG_LEVEL, info, value -> clientConfig.setLogLevel(value));
        this.setClientConfigProperty(AthenaDriverProperties.QUERY_STATUS_CHECK_BACKOFF_INTERVAL, info, value -> clientConfig.setQueryStatusCheckBackoffInterval(Strings.isNullOrEmpty(value) ? 5 : Integer.parseInt(value)));
        this.setClientConfigProperty(AthenaDriverProperties.QUERY_RESULTS_ENCRYPTION_OPTION, info, value -> clientConfig.setQueryResultsEncryptionOption(value));
        this.setClientConfigProperty(AthenaDriverProperties.QUERY_RESULTS_AWS_KMS_KEY, info, value -> clientConfig.setQueryResultsAwsKmsKey(value));
        this.setClientConfigProperty(AthenaDriverProperties.PROXY_HOST, info, value -> clientConfig.setProxyHost(value));
        this.setClientConfigProperty(AthenaDriverProperties.NONPROXY_HOSTS, info, value -> clientConfig.setNonProxyHosts(value));
        this.setClientConfigProperty(AthenaDriverProperties.PROXY_PORT, info, value -> clientConfig.setProxyPort(value != null ? Integer.parseInt(value) : -1));
        this.setClientConfigProperty(AthenaDriverProperties.PROXY_USERNAME, info, value -> clientConfig.setProxyUsername(value));
        this.setClientConfigProperty(AthenaDriverProperties.PROXY_PASSWORD, info, value -> clientConfig.setProxyPassword(value));
        this.setClientConfigProperty(AthenaDriverProperties.PROXY_DOMAIN, info, value -> clientConfig.setProxyDomain(value));
        this.setClientConfigProperty(AthenaDriverProperties.PROXY_WORKSTATION, info, value -> clientConfig.setProxyWorkstation(value));
        this.setClientConfigProperty(AthenaDriverProperties.PREEMPTIVE_BASIC_PROXY_AUTH, info, value -> clientConfig.setPreemptiveBasicProxyAuth(Boolean.valueOf(value)));
        this.checkAWSCredentials(clientConfig);
        LOGGER.info("STARTING DRIVER");
        return clientConfig;
    }

    @VisibleForTesting
    void getPropertiesFromUrl(Properties info, URI uri) throws SQLException {
        try {
            String[] parts;
            String queryPortion = uri.getRawQuery();
            if (queryPortion == null || queryPortion.length() == 0) {
                return;
            }
            for (String property : parts = queryPortion.split("&(?=(?:[^']*'[^']*')*[^']*$)")) {
                List<String> keyValue = this.parseString(property, '=', '\'');
                if (keyValue.size() != 2) {
                    throw new SQLException("Invalid property encountered in Connection String: " + uri);
                }
                info.put(keyValue.get(0), keyValue.get(1));
            }
        }
        catch (IOException e) {
            throw new SQLException("Failed to parse Query portion of Connection String: " + uri);
        }
    }

    void checkAWSCredentials(AthenaServiceClientConfig clientConfig) throws SQLException {
        Objects.requireNonNull(clientConfig, "clientConfig is null");
        if (clientConfig.getAwsCredentialsProviderClass() == null && (Strings.isNullOrEmpty(clientConfig.getAwsAccessId()) || Strings.isNullOrEmpty(clientConfig.getAwsSecretKey()))) {
            throw new SQLException("AWS accessId/secretKey or AWS credentials provider must be provided");
        }
    }

    void setClientConfigProperty(AthenaDriverProperties property, Properties info, AthenaDriver.UpdateClientConfig updater) throws SQLException {
        boolean included;
        String value = info.getProperty(property.getPropertyName());
        boolean bl = included = !Strings.isNullOrEmpty(value);
        if (property.isRequired() && !included) {
            throw new SQLException(String.format("property %s must be set", property.getPropertyName()));
        }
        if (included) {
            try {
                updater.update(value);
            }
            catch (NumberFormatException e) {
                throw new SQLException(String.format("property %s has an incorrect type, %s expected", property.getPropertyName(), property.getDataType().getName()));
            }
        } else {
            updater.update(property.getDefaultValue());
        }
    }

    List<String> parseAWSCredentialsProviderArguments(String value) throws SQLException {
        try {
            return this.parseString(value, ',', '\"');
        }
        catch (IOException e) {
            LOGGER.error("Failed to parse AWS credentials provider arguments: " + value, e);
            throw new SQLException("Failed to parse AWS credentials provider arguments: " + value, e);
        }
    }

    @VisibleForTesting
    List<String> parseString(String value, char delimiter, char escapeCharacter) throws IOException {
        if (Strings.isNullOrEmpty(value)) {
            return null;
        }
        try (CSVReader reader = new CSVReader((Reader)new StringReader(value), delimiter, escapeCharacter);){
            String[] nextLine;
            ArrayList<String> result = new ArrayList<String>();
            while ((nextLine = reader.readNext()) != null) {
                result.addAll(Arrays.asList(nextLine));
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }
}

