/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc;

public enum AthenaDriverProperties {
    USER_PROPERTY("user", 32, "", "AWS Access Key Id.", String.class, false),
    PASSWORD_PROPERTY("password", 32, "", "AWS Secret Access Key.", String.class, false),
    AWS_CREDENTIALS_PROVIDER_PROPERTY("aws_credentials_provider_class", 128, "", "AWS credentials provider class name", String.class, false),
    AWS_CREDENTIALS_PROVIDER_ARGUMENTS("aws_credentials_provider_arguments", 256, "", "Constructor arguments for AWS credentials provider in CSV format", String.class, false),
    S3_STAGING_DIR("s3_staging_dir", 128, "", "S3 Location to store Query Output. Required Property.", String.class, true),
    MAX_ERROR_RETRIES("max_error_retries", 16, "10", "Maximum number of Retries when sending requests to Athena.", Integer.class, false),
    CONNECTION_TIMEOUT("connection_timeout", 16, "10000", "Timeout value in Milliseconds of when attempting to create a connection with Athena", Integer.class, false),
    SOCKET_TIMEOUT("socket_timeout", 16, "10000", "Timeout value in Milliseconds of when data has not been submitted to ", Integer.class, false),
    RETRY_BASE_DELAY("retry_base_delay", 128, "100", "Minimum delay amount in Milliseconds between retry attempts to Athena.", Integer.class, false),
    RETRY_MAX_BACKOFF_TIME("retry_max_backoff_time", 128, "1000", "Maximum delay amount in Milliseconds between retry attempts to Athena.", Integer.class, false),
    EXECUTION_ENGINE_ID("execution_engine_id", 128, "athena-0.1", "The Execution ID of the execution engine that is requested.", String.class, false),
    LOG_PATH("log_path", 128, "", "Path of Athena's JDBC Driver's logs.", String.class, false),
    LOG_LEVEL("log_level", 128, "INFO", "Log Level of Athena's JDBC Driver's logs", String.class, false),
    QUERY_STATUS_CHECK_BACKOFF_INTERVAL("query_status_check_backoff_interval", 128, "5", "Number of attempts after which we exponentially increase the sleep time.", Integer.class, false),
    QUERY_RESULTS_ENCRYPTION_OPTION("query_results_encryption_option", 128, "", "Encryption option for query results", String.class, false),
    QUERY_RESULTS_AWS_KMS_KEY("query_results_aws_kms_key", 128, "", "AWS KMS Key id, if encrypting query results with KMS", String.class, false),
    PROXY_HOST("proxy_host", 128, null, "Optionally specifies the proxy host to connect through.", String.class, false),
    PROXY_PORT("proxy_port", 16, "-1", "Optionally specifies the port on the proxy host to connect through", Integer.class, false),
    PROXY_USERNAME("proxy_username", 128, null, "Optionally specifies the user name to use when connecting through a proxy", String.class, false),
    PROXY_PASSWORD("proxy_password", 128, null, "Optionally specifies the password to use when connecting through a proxy", String.class, false),
    PROXY_DOMAIN("proxy_domain", 128, null, "Optional Windows domain name for configuring NTLM proxy support", String.class, false),
    PROXY_WORKSTATION("proxy_workstation", 128, null, "Optional Windows workstation name for configuring NTLM proxy support", String.class, false),
    NONPROXY_HOSTS("nonproxy_hosts", 128, null, "Optional specifies the hosts that should be accessed without going through the proxy", String.class, false),
    PREEMPTIVE_BASIC_PROXY_AUTH("preemptive_basic_proxy_auth", 8, null, "Whether to pre-emptively authenticate against a proxy server using basic authentication", Boolean.class, false);

    private final String propertyName;
    private final int maxLength;
    private final String defaultValue;
    private final String description;
    private final Class<? extends Object> dataType;
    private final boolean isRequired;

    private AthenaDriverProperties(String propertyName, int maxLength, String defaultValue, String description, Class<? extends Object> dataType, boolean isRequired) {
        this.propertyName = propertyName;
        this.maxLength = maxLength;
        this.defaultValue = defaultValue;
        this.description = description;
        this.dataType = dataType;
        this.isRequired = isRequired;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public Class<? extends Object> getDataType() {
        return this.dataType;
    }

    public boolean isRequired() {
        return this.isRequired;
    }
}

