/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc;

import com.amazonaws.athena.jdbc.AthenaCatalogClient;
import com.amazonaws.athena.jdbc.AthenaColumnsClient;
import com.amazonaws.athena.jdbc.AthenaConnection;
import com.amazonaws.athena.jdbc.AthenaNamespacesClient;
import com.amazonaws.athena.jdbc.AthenaProvidedResultsClient;
import com.amazonaws.athena.jdbc.AthenaResultSet;
import com.amazonaws.athena.jdbc.AthenaResultSetUtils;
import com.amazonaws.athena.jdbc.AthenaServiceClient;
import com.amazonaws.athena.jdbc.AthenaTableClient;
import com.amazonaws.athena.jdbc.CatalogColumnInfo;
import com.amazonaws.athena.jdbc.ColumnInfo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.DataType;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.ExecutionEngine;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Row;
import com.amazonaws.athena.jdbc.shaded.guava.collect.Lists;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class AthenaDatabaseMetaData
implements DatabaseMetaData {
    private static final Logger LOGGER = LogManager.getLogger(AthenaDatabaseMetaData.class);
    private static final String DATABASE_PRODUCT_VERSION = "1.0";
    private static final String DATABASE_PRODUCT_NAME = "AWS.Athena";
    private static final long UNLIMITED_RESULTS = 0L;
    private static final long MAX_METADATA_RESULTS = 0L;
    private static final int DEFAULT_PAGE_SIZE = 100;
    private final AthenaConnection connection;
    private final AthenaServiceClient serviceClient;
    private final AtomicReference<ExecutionEngine> executionEngine = new AtomicReference();

    AthenaDatabaseMetaData(AthenaConnection connection, AthenaServiceClient serviceClient) {
        this.connection = Objects.requireNonNull(connection, "connection is null");
        this.serviceClient = Objects.requireNonNull(serviceClient, "serviceClient is null");
        this.executionEngine.set(serviceClient.getExecutionEngine());
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("PROCEDURES_CALLABLE", "false"));
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("ALL_TABLES_SELECTABLE", "false"));
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getURI().toString();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getUser();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("NULLS_SORTED_HIGH", "false"));
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("NULLS_SORTED_LOW", "false"));
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("NULLS_SORTED_AT_START", "false"));
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("NULLS_SORTED_AT_END", "false"));
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return DATABASE_PRODUCT_NAME;
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return DATABASE_PRODUCT_VERSION;
    }

    @Override
    public String getDriverName() throws SQLException {
        return "Amazon Athena JDBC Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return DATABASE_PRODUCT_VERSION;
    }

    @Override
    public int getDriverMajorVersion() {
        return 1;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_MIXED_CASE_IDENTIFIERS", "false"));
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("STORES_IDENTIFIERS_UPPER_CASE", "false"));
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("STORES_IDENTIFIERS_LOWER_CASE", "true"));
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("STORES_IDENTIFIERS_MIXED_CASE", "false"));
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_MIXED_CASE_IDENTIFIERS", "false"));
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("STORES_IDENTIFIERS_UPPER_CASE", "false"));
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("STORES_IDENTIFIERS_LOWER_CASE", "true"));
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("STORES_IDENTIFIERS_MIXED_CASE", "false"));
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return this.executionEngine.get().getExecutionEngineProperties().getOrDefault("IDENTIFIER_QUOTE_STRING", "\"");
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SQL_KEYWORDS", "LIMIT");
    }

    private String getFunctionsOfType(String type) {
        return this.executionEngine.get().getFunctionList().stream().filter(function -> function.getFunctionType().equals(type)).map(function -> function.getFunctionName()).collect(Collectors.joining(","));
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return this.getFunctionsOfType("NUMERIC");
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return this.getFunctionsOfType("STRING");
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return this.getFunctionsOfType("SYSTEM");
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return this.getFunctionsOfType("TIMEDATE");
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SEARCH_STRING_ESCAPE", "\\");
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return this.executionEngine.get().getExecutionEngineProperties().getOrDefault("EXTRA_NAME_CHARACTERS", "");
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_ALTER_TABLE_WITH_ADD_COLUMN", "false"));
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_ALTER_TABLE_WITH_DROP_COLUMN", "false"));
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_COLUMN_ALIASING", "true"));
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("NULL_PLUS_NON_NULL_IS_NULL", "true"));
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_CONVERT", "false"));
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return this.supportsConvert();
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_TABLE_CORRELATION_NAMES", "true"));
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_DIFFERENT_TABLE_CORRELATION_NAMES", "false"));
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_EXPRESSIONS_IN_ORDER_BY", "true"));
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_ORDER_BY_UNRELATED", "true"));
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_GROUP_BY", "true"));
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_GROUP_BY_UNRELATED", "true"));
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_GROUP_BY_BEYOND_SELECT", "true"));
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_LIKE_ESCAPE_CLAUSE", "true"));
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_MULTPLE_RESULT_SETS", "false"));
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_MULTIPLE_TRANSACTIONS", "true"));
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_NON_NULLABLE_COLUMNS", "true"));
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_MINIMUM_SQL_GRAMMER", "true"));
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_CORE_SQL_GRAMMER", "false"));
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_EXTENDED_SQL_GRAMMER", "false"));
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_ANSI_92_ENTRY_LEVEL_SQL", "true"));
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_ANSI_92_INTERMEDIATE_SQL", "false"));
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_ANSI_92_FULL_SQL", "false"));
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_INTEGRITY_ENHANCEMENT_FACILITY", "false"));
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_OUTER_JOINS", "true"));
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_FULL_OUTER_JOINS", "true"));
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_LIMITED_OUTER_JOINS", "true"));
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SCHEMA_KEYWORD", "schema");
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return this.executionEngine.get().getExecutionEngineProperties().getOrDefault("PROCEDURE_KEYWORD", "procedure");
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return this.executionEngine.get().getExecutionEngineProperties().getOrDefault("CATALOG_KEYWORD", "catalog");
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("IS_CATALOG_AT_START", "true"));
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return this.executionEngine.get().getExecutionEngineProperties().getOrDefault("GET_CATALOG_SEPARATOR", ".");
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_SCHEMAS_IN_DATA_MANIPULATION", "true"));
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_SCHEMAS_IN_PROCEDURE_CALLS", "true"));
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_SCHEMAS_IN_TABLE_DEFINITIONS", "true"));
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_SCHEMAS_IN_INDEX_DEFINITIONS", "true"));
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_SCHEMAS_IN_PRIVILEGE_DEFINITION", "true"));
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_CATALOGS_IN_DATA_MANIPULATION", "true"));
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_CATALOGS_IN_PROCEDURE_CALLS", "true"));
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_CATALOGS_IN_TABLE_DEFINITIONS", "true"));
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_CATALOGS_IN_INDEX_DEFINITIONS", "true"));
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_CATALOGS_IN_PRIVILEGE_DEFINITIONS", "true"));
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_POSITIONED_DELETE", "false"));
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_POSITIONED_UPDATE", "false"));
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_SELECT_FOR_UPDATE", "false"));
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_STORED_PROCEDURES", "false"));
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_SUBQUERIES_IN_COMPARISONS", "false"));
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_SUBQUERIES_IN_EXISTS", "false"));
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_SUBQUERIES_IN_INS", "true"));
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_SUBQUERIES_IN_QUANTITIEDS", "false"));
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_CORRELATED_SUBQUERIES", "false"));
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_UNION", "true"));
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_UNION_ALL", "true"));
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_OPEN_CURSORS_ACROSS_COMMIT", "false"));
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_OPEN_CURSORS_ACROSS_ROLLBACK", "false"));
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_OPEN_STATEMENTS_ACROSS_COMMIT", "false"));
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_OPEN_STATEMENTS_ACROSS_ROLLBACK", "false"));
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_BINARY_LITERAL_LENGTH", "0"));
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_CHAR_LITERAL_LENGTH", "0"));
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_COLUMN_NAME_LENGTH", "0"));
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_COLUMNS_IN_GROUPBY", "0"));
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_COLUMNS_IN_INDEX", "0"));
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_COLUMNS_IN_ORDER_BY", "0"));
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_COLUMNS_IN_SELECT", "0"));
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_COLUMNS_IN_TABLE", "0"));
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_CONNECTIONS", "0"));
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_CURSOR_NAME_LENGTH", "0"));
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_INDEX_LENGTH", "0"));
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_SCHEMA_NAME_LENGTH", "0"));
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_PROCEDURE_NAME_LENGTH", "0"));
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_CATALOG_NAME_LENGTH", "0"));
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_ROW_SIZE", "0"));
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_ROW_SIZE_INCLUDES_BLOBS", "true"));
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_STATEMENT_LENGTH", "0"));
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_STATEMENTS", "0"));
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_TABLE_NAME_LENGTH", "0"));
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_TABLES_IN_SELECT", "0"));
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return Integer.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("MAX_USER_NAME_LENGTH", "0"));
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_TRANSACTIONS", "false"));
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 0;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_DATA_DEFINITION_AND_DATA_MANUPLICATION_TRANSACTIONS", "true"));
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_DATA_MANIPULATION_TRANSACTIONS_ONLY", "false"));
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("DATA_DEFINITION_CAUSES_TRANSACTION_COMMIT", "false"));
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("DATA_DEFINITION_IGNORED_IN_TRANSACTIONS", "false"));
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return new AthenaResultSet(new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.PROCEDURE_CAT, CatalogColumnInfo.PROCEDURE_SCHEM, CatalogColumnInfo.PROCEDURE_NAME, CatalogColumnInfo.RESERVED_1, CatalogColumnInfo.RESERVED_2, CatalogColumnInfo.RESERVED_3, CatalogColumnInfo.REMARKS, CatalogColumnInfo.PROCEDURE_TYPE, CatalogColumnInfo.SPECIFIC_NAME), 0L, 100);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return new AthenaResultSet(new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.PROCEDURE_CAT, CatalogColumnInfo.PROCEDURE_SCHEM, CatalogColumnInfo.PROCEDURE_NAME, CatalogColumnInfo.COLUMN_NAME, CatalogColumnInfo.COLUMN_TYPE, CatalogColumnInfo.DATA_TYPE, CatalogColumnInfo.TYPE_NAME, CatalogColumnInfo.PRECISION, CatalogColumnInfo.LENGTH, CatalogColumnInfo.SCALE, CatalogColumnInfo.RADIX, CatalogColumnInfo.NULLABLE, CatalogColumnInfo.REMARKS, CatalogColumnInfo.COLUMN_DEF, CatalogColumnInfo.SQL_DATA_TYPE, CatalogColumnInfo.SQL_DATETIME_SUB, CatalogColumnInfo.CHAR_OCTET_LENGTH, CatalogColumnInfo.ORDINAL_POSITION, CatalogColumnInfo.IS_NULLABLE, CatalogColumnInfo.SPECIFIC_NAME), 0L, 100);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            LOGGER.debug("----------------> Calling getTables() Catalog:" + catalog + " schemaPattern:" + schemaPattern + " tableNamePattern:" + tableNamePattern + " types:" + Arrays.toString(types));
            return new AthenaResultSet(new AthenaTableClient(this.serviceClient, catalog, schemaPattern, tableNamePattern, types), 0L, 100);
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception ", e);
            throw new SQLException("Internal Driver Exception", e);
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        try {
            LOGGER.debug("----------------> Calling getSchemas()");
            return new AthenaResultSet(new AthenaNamespacesClient(this.serviceClient, null, null), 0L, 100);
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception ", e);
            throw new SQLException("Internal Driver Exception", e);
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        try {
            LOGGER.debug("----------------> Calling getCatalogs()");
            return new AthenaResultSet(new AthenaCatalogClient(this.serviceClient, null), 0L, 100);
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception ", e);
            throw new SQLException("Internal Driver Exception", e);
        }
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            if (columnNamePattern != null && columnNamePattern.equals("%")) {
                columnNamePattern = null;
            }
            LOGGER.debug("----------------> Calling getColumns() Catalog:" + catalog + " schemaPattern:" + schemaPattern + " tableNamePattern:" + tableNamePattern + " columnNamePattern:'" + columnNamePattern + "'");
            return new AthenaResultSet(new AthenaColumnsClient(this.serviceClient, catalog, schemaPattern, tableNamePattern, columnNamePattern), 0L, 100);
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception ", e);
            throw new SQLException("Internal Driver Exception", e);
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return this.splitValuesToResultSet("table_type", this.executionEngine.get().getExecutionEngineProperties().getOrDefault("TABLE_TYPES", "TABLE,VIEW,EXTERNAL_TABLE"));
    }

    private ResultSet splitValuesToResultSet(String columnName, String listAsStr) throws SQLException {
        String[] str = listAsStr.split(",");
        AthenaProvidedResultsClient athenaStubbedClient = new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.TABLE_TYPE);
        for (int i = 0; i < str.length; ++i) {
            athenaStubbedClient.addResultRow(new Row().withData(Arrays.asList(AthenaResultSetUtils.toDatum(str[i]))));
        }
        return new AthenaResultSet(athenaStubbedClient, str.length, str.length);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        LOGGER.debug("--------------> Called Column Privileges");
        return new AthenaResultSet(new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.TABLE_CAT, CatalogColumnInfo.TABLE_SCHEM, CatalogColumnInfo.TABLE_NAME, CatalogColumnInfo.COLUMN_NAME, CatalogColumnInfo.GRANTOR, CatalogColumnInfo.GRANTEE, CatalogColumnInfo.PRIVILEGE, CatalogColumnInfo.IS_GRANTABLE), 0L, 100);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        LOGGER.debug("--------------> Called Table Privileges");
        return new AthenaResultSet(new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.TABLE_CAT, CatalogColumnInfo.TABLE_SCHEM, CatalogColumnInfo.TABLE_NAME, CatalogColumnInfo.GRANTOR, CatalogColumnInfo.GRANTEE, CatalogColumnInfo.PRIVILEGE, CatalogColumnInfo.IS_GRANTABLE), 0L, 100);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        LOGGER.debug("--------------> Best Row Identifier");
        return new AthenaResultSet(new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.SCOPE, CatalogColumnInfo.COLUMN_NAME, CatalogColumnInfo.DATA_TYPE, CatalogColumnInfo.TYPE_NAME, CatalogColumnInfo.COLUMN_SIZE, CatalogColumnInfo.BUFFER_LENGTH, CatalogColumnInfo.DECIMAL_DIGITS, CatalogColumnInfo.PSEUDO_COLUMN), 0L, 100);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        LOGGER.debug("--------------> Version Columns");
        return new AthenaResultSet(new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.SCOPE, CatalogColumnInfo.COLUMN_NAME, CatalogColumnInfo.DATA_TYPE, CatalogColumnInfo.TYPE_NAME, CatalogColumnInfo.COLUMN_SIZE, CatalogColumnInfo.BUFFER_LENGTH, CatalogColumnInfo.DECIMAL_DIGITS, CatalogColumnInfo.PSEUDO_COLUMN), 0L, 100);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        LOGGER.debug("--------------> Primary Keys");
        return new AthenaResultSet(new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.TABLE_CAT, CatalogColumnInfo.TABLE_SCHEM, CatalogColumnInfo.TABLE_NAME, CatalogColumnInfo.COLUMN_NAME, CatalogColumnInfo.KEY_SEQ, CatalogColumnInfo.PK_NAME), 0L, 100);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        LOGGER.debug("--------------> Imported Keys");
        return new AthenaResultSet(new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.PKTABLE_CAT, CatalogColumnInfo.PKTABLE_SCHEM, CatalogColumnInfo.PKTABLE_NAME, CatalogColumnInfo.PKCOLUMN_NAME, CatalogColumnInfo.FKTABLE_CAT, CatalogColumnInfo.FKTABLE_SCHEM, CatalogColumnInfo.FKTABLE_NAME, CatalogColumnInfo.FKCOLUMN_NAME, CatalogColumnInfo.KEY_SEQ, CatalogColumnInfo.UPDATE_RULE, CatalogColumnInfo.DELETE_RULE, CatalogColumnInfo.FK_NAME, CatalogColumnInfo.PK_NAME, CatalogColumnInfo.DEFERRABILITY), 0L, 100);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        LOGGER.debug("--------------> Exported Keys");
        return new AthenaResultSet(new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.PKTABLE_CAT, CatalogColumnInfo.PKTABLE_SCHEM, CatalogColumnInfo.PKTABLE_NAME, CatalogColumnInfo.PKCOLUMN_NAME, CatalogColumnInfo.FKTABLE_CAT, CatalogColumnInfo.FKTABLE_SCHEM, CatalogColumnInfo.FKTABLE_NAME, CatalogColumnInfo.FKCOLUMN_NAME, CatalogColumnInfo.KEY_SEQ, CatalogColumnInfo.UPDATE_RULE, CatalogColumnInfo.DELETE_RULE, CatalogColumnInfo.FK_NAME, CatalogColumnInfo.PK_NAME, CatalogColumnInfo.DEFERRABILITY), 0L, 100);
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        LOGGER.debug("--------------> Cross Reference");
        return new AthenaResultSet(new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.PKTABLE_CAT, CatalogColumnInfo.PKTABLE_SCHEM, CatalogColumnInfo.PKTABLE_NAME, CatalogColumnInfo.PKCOLUMN_NAME, CatalogColumnInfo.FKTABLE_CAT, CatalogColumnInfo.FKTABLE_SCHEM, CatalogColumnInfo.FKTABLE_NAME, CatalogColumnInfo.FKCOLUMN_NAME, CatalogColumnInfo.KEY_SEQ, CatalogColumnInfo.UPDATE_RULE, CatalogColumnInfo.DELETE_RULE, CatalogColumnInfo.FK_NAME, CatalogColumnInfo.PK_NAME, CatalogColumnInfo.DEFERRABILITY), 0L, 100);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        LOGGER.debug("--------------> Type Info");
        AthenaProvidedResultsClient results = new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.TYPE_NAME, CatalogColumnInfo.DATA_TYPE, CatalogColumnInfo.PRECISION, CatalogColumnInfo.LITERAL_PREFIX, CatalogColumnInfo.LITERAL_SUFFIX, CatalogColumnInfo.CREATE_PARAMS, CatalogColumnInfo.NULLABLE, CatalogColumnInfo.CASE_SENSITIVE, CatalogColumnInfo.SEARCHABLE, CatalogColumnInfo.UNSIGNED_ATTRIBUTE, CatalogColumnInfo.FIXED_PREC_SCALE, CatalogColumnInfo.AUTO_INCREMENT, CatalogColumnInfo.LOCAL_TYPE_NAME, CatalogColumnInfo.MINIMUM_SCALE, CatalogColumnInfo.MAXIMUM_SCALE, CatalogColumnInfo.SQL_DATA_TYPE, CatalogColumnInfo.SQL_DATETIME_SUB, CatalogColumnInfo.NUM_PREC_RADIX);
        for (DataType dataType : this.executionEngine.get().getDataTypeList()) {
            List<String> columns = Collections.unmodifiableList(Lists.newArrayList(dataType.getName(), String.valueOf(ColumnInfo.convertDataTypeStringToSQL(dataType.getName())), dataType.getPrecision(), null, null, null, String.valueOf(dataType.isNullable() != false ? 1 : 0), String.valueOf(dataType.isCaseSensitive() != false ? "true" : "false"), String.valueOf(0), String.valueOf(dataType.isUnsigned() != false ? "true" : "false"), "true", "false", dataType.getName(), String.valueOf(dataType.getMinimumScale()), String.valueOf(dataType.getMaximumScale()), null, null, null));
            results.addResultRow(new Row().withData(AthenaResultSetUtils.toDatumList(columns)));
        }
        return new AthenaResultSet(results, 0L, 100);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return new AthenaResultSet(new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.TABLE_CAT, CatalogColumnInfo.TABLE_SCHEM, CatalogColumnInfo.TABLE_NAME, CatalogColumnInfo.NON_UNIQUE, CatalogColumnInfo.INDEX_QUALIFIER, CatalogColumnInfo.INDEX_NAME, CatalogColumnInfo.TYPE, CatalogColumnInfo.ORDINAL_POSITION, CatalogColumnInfo.COLUMN_NAME, CatalogColumnInfo.ASC_OR_DESC, CatalogColumnInfo.CARDINALITY, CatalogColumnInfo.PAGES, CatalogColumnInfo.FILTER_CONDITION), 0L, 100);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return type == 1003 && concurrency == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("OWN_UPDATES_ARE_VISIBLE", "false"));
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("OWN_DELETES_ARE_VISIBLE", "false"));
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("OWN_INSERTS_ARE_VISIBLE", "false"));
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("OTHERS_UPDATES_ARE_VISIBLE", "false"));
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("OTHERS_DELETES_ARE_VISIBLE", "false"));
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("OTHERS_INSERTS_ARE_VISIBLE", "false"));
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("UPDATES_ARE_DETECTED", "false"));
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("DELETES_ARE_DETECTED", "false"));
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("INSERTS_ARE_DETECTED", "false"));
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_BATCH_UPDATES", "false"));
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return new AthenaResultSet(new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.TYPE_CAT, CatalogColumnInfo.TYPE_SCHEM, CatalogColumnInfo.TYPE_NAME, CatalogColumnInfo.CLASS_NAME, CatalogColumnInfo.DATA_TYPE, CatalogColumnInfo.REMARKS, CatalogColumnInfo.BASE_TYPE), 0L, 100);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_SAVE_POINTS", "false"));
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_NAMED_PARAMETERS", "true"));
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_MULTIPLE_OPEN_RESULTS", "false"));
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_GET_GENERATED_KEYS", "false"));
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return new AthenaResultSet(new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.TYPE_CAT, CatalogColumnInfo.TYPE_SCHEM, CatalogColumnInfo.TYPE_NAME, CatalogColumnInfo.SUPERTYPE_CAT, CatalogColumnInfo.SUPERTYPE_SCHEM, CatalogColumnInfo.SUPERTYPE_NAME), 0L, 100);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return new AthenaResultSet(new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.TABLE_CAT, CatalogColumnInfo.TABLE_SCHEM, CatalogColumnInfo.TABLE_NAME, CatalogColumnInfo.SUPERTYPE_NAME), 0L, 100);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return new AthenaResultSet(new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.TYPE_CAT, CatalogColumnInfo.TYPE_SCHEM, CatalogColumnInfo.TYPE_NAME, CatalogColumnInfo.ATTR_NAME, CatalogColumnInfo.DATA_TYPE, CatalogColumnInfo.ATTR_TYPE_NAME, CatalogColumnInfo.ATTR_SIZE, CatalogColumnInfo.DECIMAL_DIGITS, CatalogColumnInfo.NUM_PREC_RADIX, CatalogColumnInfo.NULLABLE, CatalogColumnInfo.REMARKS, CatalogColumnInfo.ATTR_DEF, CatalogColumnInfo.SQL_DATA_TYPE, CatalogColumnInfo.SQL_DATETIME_SUB, CatalogColumnInfo.CHAR_OCTET_LENGTH, CatalogColumnInfo.ORDINAL_POSITION, CatalogColumnInfo.IS_NULLABLE, CatalogColumnInfo.SCOPE_CATALOG, CatalogColumnInfo.SCOPE_SCHEMA, CatalogColumnInfo.SCOPE_TABLE, CatalogColumnInfo.SOURCE_DATA_TYPE), 0L, 100);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 1;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("LOCATORS_UPDATE_COPY", "true"));
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("SUPPORTS_STATEMENT_POOLING", "false"));
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("ROW_ID_LIFETIME", "ROWID_UNSUPPORTED"));
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        try {
            LOGGER.debug("----------------> Calling getSchemas() Catalog:" + catalog + " schemaPattern:" + schemaPattern);
            return new AthenaResultSet(new AthenaNamespacesClient(this.serviceClient, catalog, schemaPattern), 0L, 100);
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception ", e);
            throw new SQLException("Internal Driver Exception", e);
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("", "false"));
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("", "false"));
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        AthenaResultSet resultSet = new AthenaResultSet(new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.NAME, CatalogColumnInfo.MAX_LEN, CatalogColumnInfo.DEFAULT_VALUE, CatalogColumnInfo.DESCRIPTION), 0L, 100);
        return resultSet;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return new AthenaResultSet(new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.FUNCTION_CAT, CatalogColumnInfo.FUNCTION_SCHEM, CatalogColumnInfo.FUNCTION_NAME, CatalogColumnInfo.REMARKS, CatalogColumnInfo.FUNCTION_TYPE, CatalogColumnInfo.SPECIFIC_NAME), 0L, 100);
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return new AthenaResultSet(new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.FUNCTION_CAT, CatalogColumnInfo.FUNCTION_SCHEM, CatalogColumnInfo.FUNCTION_NAME, CatalogColumnInfo.COLUMN_NAME, CatalogColumnInfo.COLUMN_TYPE, CatalogColumnInfo.DATA_TYPE, CatalogColumnInfo.TYPE_NAME, CatalogColumnInfo.PRECISION, CatalogColumnInfo.LENGTH, CatalogColumnInfo.SCALE, CatalogColumnInfo.RADIX, CatalogColumnInfo.NULLABLE, CatalogColumnInfo.REMARKS, CatalogColumnInfo.CHAR_OCTET_LENGTH, CatalogColumnInfo.ORDINAL_POSITION, CatalogColumnInfo.IS_NULLABLE, CatalogColumnInfo.SPECIFIC_NAME), 0L, 100);
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return new AthenaResultSet(new AthenaProvidedResultsClient(this.serviceClient, CatalogColumnInfo.TABLE_CAT, CatalogColumnInfo.TABLE_SCHEM, CatalogColumnInfo.TABLE_NAME, CatalogColumnInfo.COLUMN_NAME, CatalogColumnInfo.DATA_TYPE, CatalogColumnInfo.COLUMN_SIZE, CatalogColumnInfo.DECIMAL_DIGITS, CatalogColumnInfo.NUM_PREC_RADIX, CatalogColumnInfo.COLUMN_USAGE, CatalogColumnInfo.REMARKS, CatalogColumnInfo.CHAR_OCTET_LENGTH, CatalogColumnInfo.IS_NULLABLE), 0L, 100);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return Boolean.valueOf(this.executionEngine.get().getExecutionEngineProperties().getOrDefault("GENERATED_KEYS_ALWAYS_RETURNED", "false"));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException("No wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

