/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc;

import com.amazonaws.athena.jdbc.AbstractAthenaClient;
import com.amazonaws.athena.jdbc.AthenaResultSetUtils;
import com.amazonaws.athena.jdbc.AthenaServiceClient;
import com.amazonaws.athena.jdbc.AthenaTableClient;
import com.amazonaws.athena.jdbc.CatalogColumnInfo;
import com.amazonaws.athena.jdbc.CatalogHierarchy;
import com.amazonaws.athena.jdbc.ColumnInfo;
import com.amazonaws.athena.jdbc.SQLPatternMatcher;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Column;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Row;
import com.amazonaws.athena.jdbc.shaded.guava.collect.ImmutableList;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AthenaColumnsClient
extends AbstractAthenaClient {
    private final String catalogName;
    private final String namespaceName;
    private final String tableName;
    private final String columnName;
    private final AtomicReference<Iterator<CatalogHierarchy>> columnsIterator = new AtomicReference();

    protected AthenaColumnsClient(AthenaServiceClient athenaServiceClient, String catalogName, String namespaceName, String tableName, String columnPattern) {
        super(athenaServiceClient);
        this.catalogName = catalogName;
        this.namespaceName = namespaceName;
        this.tableName = tableName;
        this.columnName = columnPattern;
        this.columnsIterator.set(this.iterator());
    }

    @Override
    public List<ColumnInfo> getColumns() {
        return ImmutableList.of(CatalogColumnInfo.TABLE_CAT.cloneColumn(true), CatalogColumnInfo.TABLE_SCHEM.cloneColumn(true), CatalogColumnInfo.TABLE_NAME.getColumn(), CatalogColumnInfo.COLUMN_NAME.getColumn(), CatalogColumnInfo.DATA_TYPE.getColumn(), CatalogColumnInfo.TYPE_NAME.cloneColumn(true), CatalogColumnInfo.COLUMN_SIZE.getColumn(), CatalogColumnInfo.BUFFER_LENGTH.getColumn(), CatalogColumnInfo.DECIMAL_DIGITS.getColumn(), CatalogColumnInfo.NUM_PREC_RADIX.getColumn(), CatalogColumnInfo.NULLABLE.getColumn(), CatalogColumnInfo.REMARKS.cloneColumn(true), new ColumnInfo[]{CatalogColumnInfo.COLUMN_DEF.cloneColumn(true), CatalogColumnInfo.SQL_DATA_TYPE.getColumn(), CatalogColumnInfo.SQL_DATETIME_SUB.getColumn(), CatalogColumnInfo.CHAR_OCTET_LENGTH.getColumn(), CatalogColumnInfo.ORDINAL_POSITION.getColumn(), CatalogColumnInfo.IS_NULLABLE.getColumn(), CatalogColumnInfo.SCOPE_CATALOG.cloneColumn(true), CatalogColumnInfo.SCOPE_SCHEMA.cloneColumn(true), CatalogColumnInfo.SCOPE_TABLE.cloneColumn(true), CatalogColumnInfo.SOURCE_DATA_TYPE.getColumn(), CatalogColumnInfo.IS_AUTOINCREMENT.getColumn(), CatalogColumnInfo.IS_GENERATEDCOLUMN.getColumn()});
    }

    private synchronized List<CatalogHierarchy> getNextPage(int maxResults) throws SQLException {
        ArrayList<CatalogHierarchy> resultRows = new ArrayList<CatalogHierarchy>();
        Iterator<CatalogHierarchy> iterator = this.columnsIterator.get();
        for (int rowsProcessed = 0; (maxResults == 0 || rowsProcessed < maxResults) && iterator.hasNext(); ++rowsProcessed) {
            resultRows.add(iterator.next());
        }
        return resultRows;
    }

    @Override
    public List<Row> nextQueryResult(int maxResults) throws SQLException {
        return this.getNextPage(maxResults).stream().map(hierarchy -> this.toResultRow((CatalogHierarchy)hierarchy)).collect(Collectors.toList());
    }

    @Override
    public void cancel() {
        if (!this.cancelled.getAndSet(true)) {
            this.columnsIterator.set(Collections.emptyIterator());
        }
    }

    private Row toResultRow(CatalogHierarchy next) {
        ColumnInfo columnInfo = ColumnInfo.buildSimpleColumnInfoBuilder(next.getColumn().getName(), next.getColumn().getType()).build();
        return new Row().withData(AthenaResultSetUtils.toDatum(next.getCatalog().getCatalogName()), AthenaResultSetUtils.toDatum(next.getNamespace().getName()), AthenaResultSetUtils.toDatum(next.getTable().getName()), AthenaResultSetUtils.toDatum(next.getColumn().getName()), AthenaResultSetUtils.toDatum(this.getDataType(next.getColumn().getType())), AthenaResultSetUtils.toDatum(next.getColumn().getType()), AthenaResultSetUtils.toDatum(String.valueOf(columnInfo.getColumnDisplaySize())), AthenaResultSetUtils.toDatum(""), AthenaResultSetUtils.toDatum(String.valueOf(columnInfo.getPrecision())), AthenaResultSetUtils.toDatum(this.getNumPrecRadix(columnInfo)), AthenaResultSetUtils.toDatum(String.valueOf(2)), AthenaResultSetUtils.toDatum(next.getColumn().getComment()), AthenaResultSetUtils.toDatum(null), AthenaResultSetUtils.toDatum("0"), AthenaResultSetUtils.toDatum("0"), AthenaResultSetUtils.toDatum(String.valueOf(this.getCharOctetLength(columnInfo))), AthenaResultSetUtils.toDatum(String.valueOf(next.getColumnOrder() + 1)), AthenaResultSetUtils.toDatum(""), AthenaResultSetUtils.toDatum(null), AthenaResultSetUtils.toDatum(null), AthenaResultSetUtils.toDatum(null), AthenaResultSetUtils.toDatum(null), AthenaResultSetUtils.toDatum(""), AthenaResultSetUtils.toDatum(""));
    }

    private String getNumPrecRadix(ColumnInfo columnInfo) {
        if (columnInfo.getNumPrecRadix() == null) {
            return null;
        }
        return String.valueOf(columnInfo.getNumPrecRadix());
    }

    private String getCharOctetLength(ColumnInfo columnInfo) {
        switch (columnInfo.getSQLColumnType()) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 12: {
                return String.valueOf(0x40000000);
            }
            case -4: 
            case -3: 
            case -2: {
                return String.valueOf(0x40000000);
            }
            case 1: {
                return String.valueOf(2);
            }
        }
        return null;
    }

    private String getDataType(String name) {
        return String.valueOf(ColumnInfo.convertDataTypeStringToSQL(name));
    }

    private Iterator<CatalogHierarchy> iterator() {
        return new ColumnsIterator(this.athenaServiceClient, this.catalogName, this.namespaceName, this.tableName, this.columnName);
    }

    public static class ColumnsIterator
    implements Iterator<CatalogHierarchy> {
        private final Iterator<CatalogHierarchy> tablesIterator;
        private final String columnName;
        private Iterator<CatalogHierarchy> resultsIterator;
        private CatalogHierarchy currentColumn;
        private Pattern patternMatcher;

        public ColumnsIterator(AthenaServiceClient serviceClient, String catalogName, String namespaceName, String tableName, String columnName) {
            AthenaTableClient tablesClient = new AthenaTableClient(serviceClient, catalogName, namespaceName, tableName, null);
            this.columnName = columnName;
            this.tablesIterator = tablesClient.getIterator();
            if (SQLPatternMatcher.hasWildCardCharacters(columnName)) {
                this.patternMatcher = SQLPatternMatcher.getSqlPattern(columnName);
            }
            this.resultsIterator = this.populateResultsFromTable();
            if (this.resultsIterator.hasNext()) {
                this.currentColumn = this.resultsIterator.next();
            }
        }

        private boolean shouldKeepColumn(Column column) {
            if (this.patternMatcher == null) {
                return this.columnName == null || column.getName().equals(SQLPatternMatcher.removeEscapeCharacters(this.columnName));
            }
            return this.patternMatcher.matcher(column.getName()).matches();
        }

        private Iterator<CatalogHierarchy> populateResultsFromTable() {
            ArrayList<CatalogHierarchy> results = new ArrayList<CatalogHierarchy>();
            while (results.isEmpty() && this.tablesIterator.hasNext()) {
                CatalogHierarchy next = this.tablesIterator.next();
                int columnOrder = 0;
                if (next.getTable().getStorageDescriptor() == null) continue;
                ArrayList<Column> columns = new ArrayList<Column>(next.getTable().getStorageDescriptor().getColumns());
                if (next.getTable().getPartitionKeys() != null) {
                    columns.addAll(next.getTable().getPartitionKeys());
                }
                for (Column column : columns) {
                    if (this.shouldKeepColumn(column)) {
                        results.add(new CatalogHierarchy(next.getCatalog(), next.getNamespace(), next.getTable(), column, columnOrder));
                    }
                    ++columnOrder;
                }
            }
            return results.iterator();
        }

        private CatalogHierarchy getNextColumn() {
            if (this.resultsIterator.hasNext()) {
                return this.resultsIterator.next();
            }
            if (this.tablesIterator.hasNext()) {
                this.resultsIterator = this.populateResultsFromTable();
                if (this.resultsIterator.hasNext()) {
                    return this.resultsIterator.next();
                }
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.currentColumn != null;
        }

        @Override
        public CatalogHierarchy next() {
            CatalogHierarchy next = this.currentColumn;
            this.currentColumn = this.getNextColumn();
            return next;
        }
    }
}

