/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.Angiulli;

import java.util.Vector;
import moa.clusterers.outliers.Angiulli.ISBIndex;
import moa.clusterers.outliers.MyBaseOutlierDetector;
import moa.options.FlagOption;

public abstract class STORMBase
extends MyBaseOutlierDetector {
    public FlagOption waitWinFullOption = new FlagOption("waitWinFull", 'a', "Output outliers when windows is full.");
    protected static final Long FIRST_OBJ_ID = 1L;
    protected Long objId;
    protected Vector<ISBIndex.ISBNode> windowNodes;
    protected ISBIndex ISB;
    protected int m_WindowSize;
    protected double m_radius;
    protected int m_k;
    protected int m_QueryFreq;
    public int m_nBothInlierOutlier;
    public int m_nOnlyInlier;
    public int m_nOnlyOutlier;

    public String getStatistics() {
        StringBuilder sb = new StringBuilder();
        sb.append("Statistics:\n\n");
        int nBothInlierOutlier = this.m_nBothInlierOutlier;
        int nOnlyInlier = this.m_nOnlyInlier;
        int nOnlyOutlier = this.m_nOnlyOutlier;
        for (ISBIndex.ISBNode node : this.windowNodes) {
            if (node.nInlier > 0 && node.nOutlier > 0) {
                ++nBothInlierOutlier;
                continue;
            }
            if (node.nInlier > 0) {
                ++nOnlyInlier;
                continue;
            }
            ++nOnlyOutlier;
        }
        int sum = nBothInlierOutlier + nOnlyInlier + nOnlyOutlier;
        if (sum > 0) {
            sb.append(String.format("  Nodes always inlier: %d (%.1f%%)\n", nOnlyInlier, (double)(100 * nOnlyInlier) / (double)sum));
            sb.append(String.format("  Nodes always outlier: %d (%.1f%%)\n", nOnlyOutlier, (double)(100 * nOnlyOutlier) / (double)sum));
            sb.append(String.format("  Nodes both inlier and outlier: %d (%.1f%%)\n", nBothInlierOutlier, (double)(100 * nBothInlierOutlier) / (double)sum));
            sb.append("  (Sum: " + sum + ")\n");
        }
        sb.append("\n  Total range queries: " + this.nRangeQueriesExecuted + "\n");
        sb.append("  Max memory usage: " + this.iMaxMemUsage + " MB\n");
        sb.append("  Total process time: " + String.format("%.2f ms", (double)this.nTotalRunTime.longValue() / 1000.0) + "\n");
        return sb.toString();
    }

    Long GetWindowEnd() {
        return this.objId - 1L;
    }

    Long GetWindowStart() {
        Long x = this.GetWindowEnd() - (long)this.m_WindowSize + 1L;
        if (x < FIRST_OBJ_ID) {
            x = FIRST_OBJ_ID;
        }
        return x;
    }

    boolean IsWinFull() {
        return this.GetWindowEnd() >= FIRST_OBJ_ID + (long)this.m_WindowSize - 1L;
    }

    boolean CanSearch() {
        return (this.IsWinFull() || !this.waitWinFullOption.isSet()) && (this.GetWindowEnd() - FIRST_OBJ_ID + 1L) % (long)this.m_QueryFreq == 0L;
    }

    void SaveOutlier(ISBIndex.ISBNode node) {
        this.AddOutlier(new MyBaseOutlierDetector.Outlier(node.inst, node.id, node));
        ++node.nOutlier;
    }

    void RemoveOutlier(ISBIndex.ISBNode node) {
        this.RemoveOutlier(new MyBaseOutlierDetector.Outlier(node.inst, node.id, node));
        ++node.nInlier;
    }

    protected void UpdateStatistics(ISBIndex.ISBNode node) {
        if (node.nInlier > 0 && node.nOutlier > 0) {
            ++this.m_nBothInlierOutlier;
        } else if (node.nInlier > 0) {
            ++this.m_nOnlyInlier;
        } else {
            ++this.m_nOnlyOutlier;
        }
    }

    protected boolean IsNodeIdInWin(long id) {
        return this.GetWindowStart() <= id && id <= this.GetWindowEnd();
    }

    void PrintWindow() {
        this.Println("Window [" + this.GetWindowStart() + "-" + this.GetWindowEnd() + "]: ");
        for (int i = 0; i < this.windowNodes.size(); ++i) {
            ISBIndex.ISBNode node = this.windowNodes.get(i);
            this.Print("   Node: ");
            this.PrintNode(node);
        }
    }

    void PrintNode(ISBIndex.ISBNode n) {
        this.Print("id=" + n.id + " (");
        int dim = n.obj.dimensions();
        for (int d = 0; d < dim; ++d) {
            this.Print(Double.toString(n.obj.get(d)));
            if (d >= dim - 1) continue;
            this.Print(", ");
        }
        this.Println(")");
    }
}

