/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.DebugFun;
import jdistlib.math.Bessel;
import jdistlib.math.MathFunctions;
import jdistlib.math.PolyGamma;
import jdistlib.util.Utilities;
import org.junit.Test;

public class TestMathFun {
    /*
     * Opcode count of 37255 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    @Test
    public static final boolean test_besselIJ() {
        double[] x = Utilities.seq(0.0, 4.0, 0.008);
        double[] nus = Utilities.c(0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 10.0, 20.0);
        double[][] besselI = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0000160000640002, 0.004000032000085333, 8.000042666752001E-6, 1.0666709333401602E-8, 1.0666700800045515E-11, 8.533356088914898E-15, 2.8895985593101615E-31, 4.519345463993799E-67}, {1.0000640010240072, 0.008000256002730681, 3.200068267212802E-5, 8.533469867540483E-8, 1.706688512116509E-10, 2.7306957939109305E-13, 2.9589618365349903E-28, 4.738888020983496E-61}, {1.0001440051840829, 0.01200086402073625, 7.200345606220861E-5, 2.880103681493004E-7, 8.640248834986006E-10, 2.073649766911887E-12, 1.7062989082740736E-26, 1.5758079315519675E-57}, {1.000256016384466, 0.0160020480873832, 1.28010923016198E-4, 6.827103584518305E-7, 2.7308064797826534E-9, 8.73850616717304E-12, 3.0300298078791716E-25, 4.969129677310129E-55}, {1.0004000400017778, 0.020004000266675554, 2.0002666800003553E-4, 1.3334666720001186E-6, 6.667200017778117E-9, 2.6668444495238943E-11, 2.8219721036823426E-24, 4.31006250779349E-53}, {1.0005760829493087, 0.024006912663583853, 2.880552999814649E-4, 2.304331795110909E-6, 1.3825592601243287E-8, 6.636157036129037E-11, 1.747318702508902E-23, 1.6523883692482302E-51}, {1.0007841536773863, 0.028010977434291033, 3.9210245270657266E-4, 3.6593838215563174E-6, 2.5614682681572296E-8, 1.4343847456130652E-10, 8.162970627657284E-23, 3.6062200496321803E-50}, {1.0010242621738281, 0.03201638679644129, 5.121747850378153E-4, 5.462731577840389E-6, 4.369961527878698E-8, 2.7966799201617314E-10, 3.1029671581805366E-22, 5.210700679534348E-49}, {1.0012964199644712, 0.03602333303939224, 6.482799813535507E-4, 7.778519750540865E-6, 7.000214181202505E-8, 5.03993649192737E-10, 1.007657965516079E-21, 5.494803935214582E-48}, {1.0016006401137891, 0.040032008534471204, 8.004267520091029E-4, 1.0670934016060686E-5, 1.067008045514579E-7, 8.535609148969722E-10, 2.89001468891612E-21, 4.519686364026378E-47}, {1.0019369372255886, 0.04404260574523609, 9.686248338593849E-4, 1.4204206173133968E-5, 1.562311457054103E-7, 1.3747453693955356E-9, 7.496182776700975E-21, 3.0406676286021807E-46}, {1.0023053274437876, 0.04805531723774134, 0.0011528849908431099, 1.8442619278431223E-5, 2.212859411582919E-7, 2.1241819068975326E-9, 1.7895354459734412E-20, 1.7327973648311586E-45}, {1.0027058284532766, 0.052070335690809696, 0.0013532190146286261, 2.3450512785608992E-5, 3.048154588767922E-7, 3.169795086513345E-9, 3.9845305397426075E-20, 8.590099142024217E-45}, {1.0031384594808617, 0.056087853906310256, 0.0015696397253214193, 2.929228768814909E-5, 4.100277420036307E-7, 4.591830746901859E-9, 8.360669368202734E-20, 3.781819333013007E-44}, {1.0036032412962919, 0.06010806481944351, 0.001802160972233315, 3.60324116663331E-5, 5.403889166599978E-7, 6.48388899992141E-9, 1.6668311259628752E-19, 1.5030548904457276E-43}, {1.004100196213363, 0.06413116150903359, 0.002050797634713436, 4.3735424238697734E-5, 6.996235244796644E-7, 8.95395871871317E-9, 3.1783258485633577E-19, 5.464615007957101E-43}, {1.0046293480911128, 0.06815733720782889, 0.00231556562304096, 5.246594191831738E-5, 8.917148798995874E-7, 1.2125453635768714E-8, 5.827853857109577E-19, 1.8371696584895153E-42}, {1.0051907223350893, 0.0721867853128111, 0.0025964818793797265, 6.228866337425985E-5, 1.1209054522336773E-6, 1.61382501666658E-8, 1.0322065213545432E-18, 5.762786363661163E-42}, {1.0057843458987086, 0.07621969939551344, 0.0028935643787947655, 7.326837459856257E-5, 1.391697272558258E-6, 2.1149727075298615E-8, 1.7725599360739016E-18, 1.6992867836234236E-41}, {1.0064102472846912, 0.08025627321234884, 0.00320683213033079, 8.546995407907603E-5, 1.7088523654395887E-6, 2.7335807096579936E-8, 2.9606666477507557E-18, 4.7403180169084E-41}, {1.0070684565465833, 0.08429670071494816, 0.0035363051781527248, 9.895837797852131E-5, 2.07739320553566E-6, 3.489200063275362E-8, 4.8229015912796585E-18, 1.2577867812692151E-40}, {1.0077590052903591, 0.08834117606050974, 0.003882004602748344, 1.1379872532011096E-4, 2.5026031991063694E-6, 4.403445163962685E-8, 7.680145060973743E-18, 3.1892530243918296E-40}, {1.0084819266761076, 0.09238989362216013, 0.004243952522193083, 1.3005618318008016E-4, 2.9900271904680013E-6, 5.50009858192112E-8, 1.1979795367501255E-17, 7.759021759073269E-40}, {1.0092372554198008, 0.09644304799932707, 0.0046221720934771, 1.4779605188747745E-4, 3.5454719934298075E-6, 6.805216123545123E-8, 1.8336360747458115E-17, 1.8175678632065032E-39}, {1.010025027795146, 0.10050083402812514, 0.005016687513894679, 1.6708375023156424E-4, 4.175006947752358E-6, 8.347232146991894E-8, 2.7582381773426824E-17, 4.112275362322554E-39}, {1.0108452816355207, 0.10456344679175457, 0.005427524022496025, 1.879848206771723E-4, 4.884964500669182E-6, 1.0157065143456101E-7, 4.0831691602551916E-17, 9.010851838178418E-39}, {1.0116980563359916, 0.10863108163091412, 0.00585470790160159, 2.1056493458837067E-4, 5.68194081351512E-6, 1.226822359588045E-7, 5.95573014698988E-17, 1.9168658019659957E-38}, {1.0125833928554149, 0.11270393415422804, 0.006298266478378966, 2.3488989746079048E-4, 6.572796393506614E-6, 1.4716912126855429E-7, 8.568650398135791E-17, 3.967301911976273E-38}, {1.0135013337186232, 0.11678220024868832, 0.006758228126482471, 2.61025654162961E-4, 7.564656750721099E-6, 1.7542137947485307E-7, 1.2171611809658596E-16, 8.004117270321763E-38}, {1.0144519230186926, 0.12086607609011243, 0.007234622267755526, 2.890382941870081E-4, 8.664913080324535E-6, 2.0785817619022405E-7, 1.7085115832742828E-16, 1.5768780263585622E-37}, {1.0154352064192964, 0.12495575815361727, 0.007727479373995908, 3.189940569090668E-4, 9.88122297009795E-6, 2.449288413909709E-7, 2.371705977286047E-16, 3.038274910738117E-37}, {1.0164512311571405, 0.12905144322410966, 0.008236830968783993, 3.509593368597622E-4, 1.1221511133315785E-5, 2.871139436439772E-7, 3.2582431084776495E-16, 5.733417959490399E-37}, {1.0175000460444854, 0.1331533284067947, 0.008762709629374112, 3.850006890051116E-4, 1.2693970167030728E-5, 3.3492636781682643E-7, 4.4326573005954306E-16, 1.0609974516141272E-36}, {1.0185817014717475, 0.13726161113770138, 0.009305148988649098, 4.211848340382018E-4, 1.430706133582159E-5, 3.889123963903448E-7, 5.975252277669885E-16, 1.9276849330867165E-36}, {1.019696249410192, 0.14137648919422754, 0.00986418373713819, 4.595786636819992E-4, 1.606951538106272E-5, 4.4965279449297257E-7, 7.985297489538399E-16, 3.442242240384105E-36}, {1.0208437434147029, 0.14549816070570307, 0.01043984962509836, 5.002492460036441E-4, 1.799033335577523E-5, 5.177638987766649E-7, 1.0584747646588559E-15, 6.04719607129789E-36}, {1.0220242386266418, 0.14962682416397338, 0.011032183464659227, 5.432638307405892E-4, 2.0078787485122385E-5, 5.938987102543512E-7, 1.3922551982716564E-15, 1.0460746315504726E-35}, {1.0232377917767905, 0.15376267843400332, 0.011641223132031692, 5.8868985463894E-4, 2.2344422052613386E-5, 6.787479912192986E-7, 1.8179625942777757E-15, 1.783302164594018E-35}, {1.0244844611883785, 0.15790592276450133, 0.012267007569780367, 6.365949468043508E-4, 2.4797054312081366E-5, 7.730413663670595E-7, 2.357456454375173E-15, 2.998269191499099E-35}, {1.0257643067801958, 0.16205675679856577, 0.012909576789159995, 6.870469340658395E-4, 2.7446775425503943E-5, 8.775484282410383E-7, 3.037018359919046E-15, 4.975130159186468E-35}, {1.02707739006979, 0.16621538058435292, 0.013568971872516003, 7.401138463528798E-4, 3.030395142673603E-5, 9.930798471230556E-7, 3.88809823360695E-15, 8.152833173597242E-35}, {1.0284237741767495, 0.17038199458576803, 0.01424523497574928, 7.958639220861311E-4, 3.33792242112269E-5, 1.120488485490664E-6, 4.948162868380662E-15, 1.3202150875220261E-34}, {1.0298035238260728, 0.17455679969317914, 0.014938409330845342, 8.543656135821635E-4, 3.668351255179501E-5, 1.2606705171633276E-6, 6.261657668890812E-15, 2.1137621609532325E-34}, {1.0312167053516232, 0.1787399972341553, 0.01564853924846808, 9.156875924725492E-4, 4.022801314053673E-5, 1.4145665512599913E-6, 7.881093411749516E-15, 3.3478756834051672E-34}, {1.0326633866996693, 0.18293178898422918, 0.016375670120618236, 9.798987551376773E-4, 4.402420165694638E-5, 1.5831627610909295E-6, 9.868270736397023E-15, 5.24802041796759E-34}, {1.0341436374325115, 0.18713237717768452, 0.017119848423356655, 0.001047068228155652, 4.808383386232706E-5, 1.7674920181071834E-6, 1.2295656029951736E-14, 8.145766993232184E-34}, {1.0356575287321956, 0.19134196451836935, 0.017881121719592653, 0.0011172653737666503, 5.24189467205741E-5, 1.9686350310313163E-6, 1.5247923368128637E-14, 1.252458310324927E-33}, {1.0372051334043122, 0.19556075419053595, 0.018659538661937557, 0.0011905597953530973, 5.704185954541457E-5, 2.1877214902936367E-6, 1.882367822143655E-14, 1.9083687651806214E-33}, {1.038786525881885, 0.19978894986970722, 0.01945514899562358, 0.0012670213429360267, 6.196517517418829E-5, 2.425931217898461E-6, 2.313737973264819E-14, 2.88264556168709E-33}, {1.0404017822293412, 0.2040267557335706, 0.020268003561488262, 0.0013467201186880004, 6.720178116825776E-5, 2.6844953228454613E-6, 2.8321479519234516E-14, 4.318197366179402E-33}, {1.0420509801465767, 0.20827437647290062, 0.02109815429902464, 0.0014297264824629462, 7.276485104013646E-5, 2.964697362231566E-6, 3.4528796154333664E-14, 6.417107880718437E-33}, {1.0437341989731008, 0.21253201730250953, 0.021945654249497293, 0.0015161110573432975, 7.86678455074272E-5, 3.2678745081593853E-6, 4.193514573315916E-14, 9.46317278585063E-33}, {1.0454515196922751, 0.2167998839722279, 0.02281055755912445, 0.0016059447352047892, 8.492451377366316E-5, 3.5954187205785566E-6, 5.0742250239830545E-14, 1.3852304493801168E-32}, {1.047203024935636, 0.22107818277791488, 0.02369291948232648, 0.001699298682299304, 9.15488948361483E-5, 3.948777926186969E-6, 6.118094679372638E-14, 2.0133312554454262E-32}, {1.0489887989873083, 0.22536712057249886, 0.0245927963850407, 0.0017962443448561194, 9.8555318820893E-5, 4.3294572035192275E-6, 7.351472227592102E-14, 2.9062294043575037E-32}, {1.0508089277885044, 0.22966690477704996, 0.025510245748102976, 0.001896853454701948, 1.0595840834474547E-4, 4.739019974350302E-6, 8.804359931639417E-14, 4.1674784977328775E-32}, {1.0526634989421162, 0.23397774339188376, 0.026445326170696132, 0.00200119803490014, 1.1377307990482003E-4, 5.179089201542798E-6, 1.0510840116281786E-13, 5.938097547206714E-32}, {1.0545526017173905, 0.23829984500769782, 0.027398097373865456, 0.0021093504054094233, 1.2201454529532551E-4, 5.651348593466804E-6, 1.250954245531753E-13, 8.409073211003436E-32}, {1.0564763270547002, 0.24263341881674128, 0.02836862020410149, 0.0022213831887625676, 1.306983130518993E-4, 6.157543815121803E-6, 1.4844155137859513E-13, 1.1837696599398056E-31}, {1.0584347675703982, 0.2469786746240179, 0.029356956636990304, 0.00233736931576534, 1.3984018992355493E-4, 6.699483706090727E-6, 1.756398316509614E-13, 1.6568811261154318E-31}, {1.060428017561767, 0.2513358228585239, 0.03036316978093154, 0.0024573820312161474, 1.4945628237235213E-4, 7.279041505456756E-6, 2.072455720834531E-13, 2.306232436716795E-31}, {1.0624561730120545, 0.2557050745845203, 0.03138732388092432, 0.002581494899646736, 1.5956299810090116E-4, 7.898156083813995E-6, 2.4388296645256503E-13, 3.192867234555551E-31}, {1.0645193315956005, 0.26008664151284117, 0.03242948432242136, 0.002709781811084338, 1.7017704760781554E-4, 8.558833182503876E-6, 2.862523058387724E-13, 4.397434861296612E-31}, {1.0666175926830566, 0.26448073601223815, 0.03348971763525152, 0.0028423169868356515, 1.813154457712283E-4, 9.263146660209568E-6, 3.3513780884121463E-13, 6.02601103905577E-31}, {1.0687510573466936, 0.2688875711207615, 0.0345680914976109, 0.0029791749852930358, 1.9299551346048965E-4, 1.0013239747041363E-5, 3.914161139310418E-13, 8.21751025816156E-31}, {1.0709198283658017, 0.27330736055717925, 0.03566467474012291, 0.003120430707763314, 2.0523487917616646E-4, 1.0811326306246643E-5, 4.560654782498033E-13, 1.1153089137223053E-30}, {1.0731240102321828, 0.27774031873243377, 0.036779537349967306, 0.0032661594043195633, 2.1805148071846428E-4, 1.1659692103678528E-5, 5.301757293749281E-13, 1.5068031454159387E-30}, {1.0753637091557329, 0.28218666076113796, 0.037912750475078784, 0.0034164366796763093, 2.3146356688419828E-4, 1.256069608515819E-5, 6.149590188654096E-13, 2.0266715988171857E-30}, {1.0776390330701184, 0.2866466024731102, 0.03906438642841499, 0.003571338499088475, 2.4548969919243604E-4, 1.3516771661866097E-5, 7.117614287687379E-13, 2.7141401326998075E-30}, {1.0799500916385434, 0.2911203604249497, 0.04023451869229453, 0.0037309411942745225, 2.601487536389437E-4, 1.4530428003898514E-5, 8.220754847164259E-13, 3.619572154341484E-30}, {1.0822969962596105, 0.2956081519116528, 0.041423221922804995, 0.003895321469364142, 2.7545992247956315E-4, 1.5604251342125876E-5, 9.475536317616405E-13, 4.807397797903419E-30}, {1.084679860073275, 0.3001101949782702, 0.04263057195428149, 0.00406455640687093, 2.9144271604265566E-4, 1.6740906278490698E-5, 1.0900227317200171E-12, 6.359754092860509E-30}, {1.087098797966892, 0.30462670843160655, 0.04385664580385576, 0.004238723473690409, 3.081169645707433E-4, 1.7943137104883007E-5, 1.2514996434652062E-12, 8.380994733179534E-30}, {1.0895539265813563, 0.3091579118519629, 0.04510152167607619, 0.004417900527123823, 3.255028200914887E-4, 1.9213769130732296E-5, 1.4342079504057269E-12, 1.1003260421787022E-29}, {1.0920453643173398, 0.31370402560492217, 0.04636527896759911, 0.0046021658209280955, 3.43620758318148E-4, 2.055571001945543E-5, 1.6405959022306088E-12, 1.4393339135003644E-29}, {1.0945732313416174, 0.3182652708531784, 0.04764799827195148, 0.0047915980113923465, 3.6249158057964187E-4, 2.1971951133900976E-5, 1.873355640960098E-12, 1.8761091035210313E-29}, {1.0971376495934961, 0.3228418695684122, 0.048949761384365506, 0.004986276163441406, 3.8213641578038656E-4, 2.346556889093091E-5, 2.1354437843754357E-12, 2.4369766315599167E-29}, {1.09973874279133, 0.32743404454320924, 0.050270651306685045, 0.005186279756766682, 4.025767223900292E-4, 2.5039726125281385E-5, 2.4301034430305383E-12, 3.154860731860825E-29}, {1.1023766364391392, 0.3320420194030271, 0.05161075225234467, 0.005391688691984844, 4.2383429046323793E-4, 2.669767346284532E-5, 2.7608877502695137E-12, 4.0708200353864764E-29}, {1.1050514578333168, 0.3366660186182066, 0.052970149651421106, 0.005602583296824685, 4.4593124368969315E-4, 2.844275070351987E-5, 3.1316849879893297E-12, 5.235912949585242E-29}, {1.10776333606944, 0.34130626751603305, 0.054348930155757855, 0.005819044332342609, 4.6889004147443653E-4, 3.027838821376307E-5, 3.5467453942980007E-12, 6.713458625715346E-29}, {1.1105124020491721, 0.34596299229284305, 0.05574718164416286, 0.006041152999167145, 4.927334810487275E-4, 3.220810832900441E-5, 4.0107097427272175E-12, 8.581770767967732E-29}, {1.1132987884872634, 0.3506364200261818, 0.057164993227679886, 0.006268990943772894, 5.174846996115677E-4, 3.423552676605503E-5, 4.528639786266122E-12, 1.0937455364670928E-28}, {1.1161226299186504, 0.3553267786870089, 0.05860245525493372, 0.006502640264784347, 5.431671765020494E-4, 3.636435404566412E-5, 5.106050663191475E-12, 1.3899379502750454E-28}, {1.118984062705652, 0.3600342971519548, 0.06005965931754962, 0.006742183519309985, 5.698047354026924E-4, 3.85983969253688E-5, 5.748945365480751E-12, 1.7613437095241805E-28}, {1.1218832250452626, 0.3647592052156277, 0.06153669825564715, 0.006987703729307064, 5.974215465739279E-4, 4.0941559842785466E-5, 6.463851374510288E-12, 2.2258258985047207E-28}, {1.124820256976548, 0.36950173360297234, 0.0630336661634091, 0.007239284387977547, 6.260421291199009E-4, 4.339784636949213E-5, 7.2578595727623655E-12, 2.8052039912655E-28}, {1.1277953003881354, 0.3742621139816803, 0.0645506583947253, 0.007497009466195574, 6.556913532857532E-4, 4.5971360675650835E-5, 8.138665544394734E-12, 3.526068373267385E-28}, {1.1308084990258067, 0.3790405789746544, 0.06608777156891237, 0.007760963418966929, 6.863944427865651E-4, 4.866630900552192E-5, 9.11461338176576E-12, 4.42075015766626E-28}, {1.1338599985001891, 0.38383736217252495, 0.06764510357650873, 0.008031231191920873, 7.181769771681167E-4, 5.148700116402057E-5, 1.0194742119358939E-11, 5.528473599915596E-28}, {1.1369499462945476, 0.38865269814622205, 0.06922275358514647, 0.008307898227834879, 7.510648941996572E-4, 5.4437852014469354E-5, 1.1388834921015585E-11, 6.896722819737611E-28}, {1.1400784917726783, 0.3934868224596019, 0.07082082204549932, 0.008591050473192592, 7.8508449229885E-4, 5.7523382987699387E-5, 1.2707471150963663E-11, 8.582859593474448E-28}, {1.143245786186902, 0.39833997168212903, 0.07243941069730775, 0.008880774384775516, 8.20262432989076E-4, 6.074822360265485E-5, 1.4162081463828068E-11, 1.065603476896281E-27}, {1.1464519826861594, 0.40321238340161497, 0.0740786225754813, 0.009177156936288868, 8.566257433892798E-4, 6.411711299865619E-5, 1.5765006053623544E-11, 1.3199442476329593E-27}, {1.1496972363242106, 0.4081042962370142, 0.07573856201627853, 0.009480285625021984, 8.94201818736538E-4, 6.7634901479478E-5, 1.752955620666853E-11, 1.631297386993946E-27}, {1.1529817040679347, 0.413015949851278, 0.07741933466356496, 0.009790248478543798, 9.330184249415423E-4, 7.130655206939919E-5, 1.9470079308418187E-11, 2.011633576031175E-27}, {1.1563055448057327, 0.41794758496426626, 0.07912104747514952, 0.010107134061433756, 9.731037011771802E-4, 7.513714208138314E-5, 2.1602027459400246E-11, 2.4752709315382653E-27}, {1.159668919356036, 0.4228994433657199, 0.08084380872919955, 0.010431031482048686, 0.0010144861625004118, 7.91318646975475E-5, 2.3942029860748744E-11, 3.039303517873806E-27}, {1.1630719904759166, 0.42787176792829185, 0.08258772803073523, 0.010762030399326043, 0.0010571947025076322, 8.329603056208373E-5, 2.6507969135272288E-11, 3.724102403618141E-27}, {1.1665149228698029, 0.43286480262063987, 0.0843529163182032, 0.011100221029623932, 0.0011012585960237145, 8.763506938678692E-5, 2.9319061755564985E-11, 4.5539006047835555E-27}, {1.1699978831983007, 0.4378787925205808, 0.08613948587013043, 0.011445694153598474, 0.0011467075018249406, 9.215453156935932E-5, 3.239594275637367E-11, 5.557474885820214E-27}, {1.1735210400871185, 0.4429139838283062, 0.08794755031185823, 0.011798541123118863, 0.0011935714653960097, 9.686008982464954E-5, 3.5760754914275025E-11, 6.768939233124127E-27}, {1.177084564136101, 0.4479706238796626, 0.08977722462235704, 0.012158853868220635, 0.0012418809217213391, 1.0175754082899272E-4, 3.94372425836939E-11, 8.228666898657275E-27}, {1.1806886279283657, 0.4530489611594933, 0.09162862514112231, 0.01252672490409759, 0.0012916666981108566, 1.0685280687781642E-4, 4.3450850384411305E-11, 9.984360261868946E-27}, {1.1843334060395503, 0.45814924531504725, 0.09350186957515202, 0.012902247338132816, 0.0013429600170604943, 1.1215193755667867E-4, 4.78288269419683E-11, 1.2092290407596446E-26}, {1.1880190750471644, 0.4632717271694511, 0.09539707700600612, 0.013285514876969337, 0.0013957924991476035, 1.1766111142590672E-4, 5.2600333888776284E-11, 1.4618731300541098E-26}, {1.1917458135400516, 0.4684166587352482, 0.09731436789694826, 0.013676621833620782, 0.0014501961659614902, 1.2338663771900316E-4, 5.779656034028931E-11, 1.7641616791371737E-26}, {1.1955138021279588, 0.4735842932280045, 0.0992538641001705, 0.014075663134622572, 0.001506203443069299, 1.293349580549912E-4, 6.345084306729461E-11, 2.1252452457539842E-26}, {1.1993232234512148, 0.4787748850799816, 0.10121568886410114, 0.014482734327224162, 0.0015638471630174627, 1.3551264816486874E-4, 6.95987925922208E-11, 2.5558518509818865E-26}, {1.2031742621905197, 0.4839886899538783, 0.10319996684079624, 0.01489793158662267, 0.0016231605683689357, 1.419264196323435E-4, 7.627842544436547E-11, 3.068540473440486E-26}, {1.2070671050768422, 0.4892259647566415, 0.10520682409341545, 0.015321351723238572, 0.0016841773147764402, 1.4858312164902317E-4, 8.353030281609842E-11, 3.677992374623454E-26}, {1.2110019409014299, 0.49448696765334627, 0.10723638810378201, 0.015753092190033714, 0.001746931474091942, 1.5548974278423272E-4, 9.139767586940702E-11, 4.40134547636395E-26}, {1.2149789605259307, 0.49977195808114794, 0.10928878778002829, 0.016193251089872362, 0.0018114575375126076, 1.6265341276963823E-4, 9.992663794962614E-11, 5.258577674526017E-26}, {1.2189983568926244, 0.505081196763304, 0.11136415346432628, 0.016641927182925554, 0.0018777904187634441, 1.700814042988492E-4, 1.0916628397082525E-10, 6.27294571315565E-26}, {1.2230603250347678, 0.5104149457232691, 0.11346261694070443, 0.017099219894119427, 0.0019459654573168832, 1.7778113484218146E-4, 1.1916887724512642E-10, 7.471487068669346E-26}, {1.2271650620870538, 0.5157734682988638, 0.11558431144295073, 0.017565229320627918, 0.002016018421649535, 1.857601684767577E-4, 1.2999002403619409E-10, 8.885593213121907E-26}, {1.2313127672961823, 0.5211570291565154, 0.1177293716626026, 0.018040056239410338, 0.0020879855125363507, 1.9402621773212609E-4, 1.4168885612526856E-10, 1.055166364893833E-25}, {1.2355036420315477, 0.5265658943055751, 0.11989793375702427, 0.01852380211479432, 0.0021619033663824432, 2.0258714545157947E-4, 1.5432822168642753E-10, 1.2511851245389655E-25}, {1.2397378897960378, 0.5320003311127097, 0.12209013535757202, 0.019016569106104702, 0.0022378090585928063, 2.1145096666935715E-4, 1.679748847762393E-10, 1.4814910671200655E-25}, {1.2440157162369518, 0.5374606083163701, 0.12430611557784751, 0.01951846007533877, 0.0023157401069801827, 2.2062585050391465E-4, 1.826997337516305E-10, 1.751716312073224E-25}, {1.2483373291570317, 0.5429469960413359, 0.1265460150220403, 0.020029578594888405, 0.002395734475211336, 2.3012012206744597E-4, 1.9857799893863273E-10, 2.068359208707535E-25}, {1.2527029385256128, 0.5484597658133397, 0.12880997579335932, 0.020550028955309625, 0.0024778305762919693, 2.399422643918445E-4, 2.1568947988368795E-10, 2.438908665927182E-25}, {1.2571127564898874, 0.5539991905737678, 0.13109814150255442, 0.021079916173140076, 0.0025620672760905605, 2.501009203712936E-4, 2.341187825284071E-10, 2.8719850729245176E-25}, {1.2615669973862922, 0.559565544694443, 0.13341065727652815, 0.021619345998764958, 0.0026484838969013675, 2.606048947216725E-4, 2.5395556665806313E-10, 3.377499860484088E-25}, {1.2660658777520082, 0.565159103992485, 0.13574766976703828, 0.022168424924331902, 0.002737120221046866, 2.714631559569719E-4, 2.752948039836873E-10, 3.9668359858190206E-25}, {1.2706096163365865, 0.5707801457452556, 0.13810932715949212, 0.022727260191715334, 0.0028280164945198856, 2.8268483838290873E-4, 2.9823704722741625E-10, 4.653051881467005E-25}, {1.2751984341136862, 0.5764289487053819, 0.14049577918183215, 0.02329595980053085, 0.0029212134306657103, 2.942792441079358E-4, 3.228887105907078E-10, 5.451111693011817E-25}, {1.27983255429294, 0.5821057931158659, 0.14290717711351447, 0.02387463251620011, 0.003016752213904419, 3.062558450718395E-4, 3.493623619952176E-10, 6.378144943774297E-25}, {1.2845122023319353, 0.5878109607252755, 0.14534367379457985, 0.02446338787806681, 0.003114674503493735, 3.186242850921233E-4, 3.777770274965049E-10, 7.453739109853516E-25}, {1.289237605948323, 0.5935447348030221, 0.14780542363481902, 0.025062336207564297, 0.00321502243733267, 3.313943819283752E-4, 4.0825850828130953E-10, 8.700268968942893E-25}, {1.2940089951320428, 0.5993074001547223, 0.1502925826230312, 0.025671588616435294, 0.0033178386358062324, 3.4457612936481685E-4, 4.4093971066993164E-10, 1.0143267004392771E-24}, {1.298826602157676, 0.6050992431376457, 0.15280530833637734, 0.026291257015004236, 0.003423166205671476, 3.5817969931123514E-4, 4.759609895562403E-10, 1.1811839605500811E-24}, {1.3036906615969197, 0.6109205516762523, 0.1553437599498293, 0.026921454120503018, 0.0035310487439852087, 3.7221544392250245E-4, 5.134705057290481E-10, 1.373913430972921E-24}, {1.3086014103311887, 0.6167716152778145, 0.1579080982457136, 0.02756229346545035, 0.003641530342073605, 3.866938977368828E-4, 5.536245975300165E-10, 1.596286388652428E-24}, {1.3135590875643381, 0.6226527250481322, 0.16049848562335262, 0.02821388940608554, 0.003754655589544048, 4.0162577983333443E-4, 5.965881673148926E-10, 1.8525893670027635E-24}, {1.3185639348355176, 0.6285641737073335, 0.1631150861088016, 0.028876357130857132, 0.0038704695783394806, 4.1702199600801435E-4, 6.425350831967644E-10, 2.1476899213950334E-24}, {1.323616196032147, 0.6345062556057698, 0.165758065364684, 0.02954981266896698, 0.003989017906835561, 4.328936409701898E-4, 6.916485965620923E-10, 2.487110207133889E-24}, {1.3287161174030242, 0.6404792667400008, 0.16842759070012436, 0.03023437289897039, 0.004110346683980941, 4.492520005577738E-4, 7.441217758626222E-10, 2.8771092300407647E-24}, {1.3338639475715568, 0.646483504768872, 0.1711238310807801, 0.030930155557432774, 0.004234502533480952, 4.66108553972687E-4, 8.00157957198813E-10, 3.324774717098898E-24}, {1.3390599375491272, 0.6525192690296869, 0.17384695713897216, 0.03163727924764347, 0.004361532598025009, 4.8347497603626723E-4, 8.599712122232274E-10, 3.8381256500871036E-24}, {1.3443043407485837, 0.6585868605544727, 0.1765971411839161, 0.03235586344838732, 0.004491484543558056, 5.013631394649361E-4, 9.237868339053457E-10, 4.42622660942533E-24}, {1.3495974129978643, 0.6646865820863409, 0.17937455721205287, 0.03308602852277444, 0.00462440656359635, 5.197851171663411E-4, 9.918418407125364E-10, 5.0993151893186746E-24}, {1.3549394125537508, 0.670818738095946, 0.18217938091748168, 0.03382789572712908, 0.004760347383587923, 5.387531845561916E-4, 1.0643854997754402E-9, 5.868943869517997E-24}, {1.3603306001157562, 0.6769836347980396, 0.18501178970249335, 0.03458158721993767, 0.004899356265318, 5.582798218960061E-4, 1.1416798696197785E-9, 6.748137864474488E-24}, {1.3657712388401428, 0.6831815801681227, 0.187871962688207, 0.035347226070857135, 0.005041483011359745, 5.783777166519938E-4, 1.2240003630606147E-9, 7.75157061827805E-24}, {1.3712615943540756, 0.6894128839591994, 0.19076008072530934, 0.036124936269783796, 0.00518677796957064, 5.990597658752952E-4, 1.3116363308693894E-9, 8.895758774529035E-24}, {1.3768019347699112, 0.6956778577186279, 0.19367632640489746, 0.036914842735983486, 0.005335292037634813, 6.203390786038011E-4, 1.4048916668385294E-9, 1.0199278625266597E-23}, {1.3823925306996168, 0.7019768148050731, 0.19662088406942574, 0.037717071327283413, 0.00548707666765165, 6.422289782857798E-4, 1.5040854348832974E-9, 1.1683006233412548E-23}, {1.3880336552693322, 0.7083100704055623, 0.19959393982375814, 0.03853174884932676, 0.005642183870771081, 6.647430052255446E-4, 1.6095525188355462E-9, 1.3370383630114014E-23}, {1.393725584134064, 0.714677941552643, 0.20259568154632587, 0.039359003064890014, 0.005800666221875794, 6.878949190513821E-4, 1.7216442955993952E-9, 1.528771371320258E-23}, {1.399468595492519, 0.7210807471416453, 0.2056262989003911, 0.040198962703264174, 0.005962576864310787, 7.116987012059828E-4, 1.8407293323544642E-9, 1.7464486717144245E-23}, {1.405262970102075, 0.7275188079480477, 0.20868598334541766, 0.041051757469700106, 0.006127969514660556, 7.361685574595983E-4, 1.9671941085081463E-9, 1.9933741389848232E-23}, {1.4111089912938926, 0.7339924466449499, 0.21177492814854948, 0.04191751805491893, 0.006296898467574332, 7.613189204461706E-4, 2.101443763114601E-9, 2.2732464299155162E-23}, {1.417006944988166, 0.7405019878206528, 0.2148933283961972, 0.042796376144687814, 0.006469418600639635, 7.8716445222266E-4, 2.2439028684945646E-9, 2.5902031003474122E-23}, {1.4229571197095163, 0.7470477579963452, 0.21804138100573378, 0.04368846442946203, 0.006645585379304582, 8.137200468518195E-4, 2.3950162308068248E-9, 2.9488693158738723E-23}, {1.4289598066025242, 0.7536300856439001, 0.2212192847372996, 0.04459391661409367, 0.006825454861849263, 8.41000833008651E-4, 2.555249718339238E-9, 3.354411599959519E-23}, {1.4350152994474081, 0.7602493012037812, 0.22442724020571844, 0.045512867427607955, 0.007009083704406554, 8.690221766107894E-4, 2.7250911183044805E-9, 3.812597102864167E-23}, {1.441123894675845, 0.766905737103059, 0.22766544989252366, 0.04644545263304742, 0.00719652916603275, 8.977996834730549E-4, 2.9050510229433555E-9, 4.329858917587943E-23}, {1.4472858913869338, 0.7735997277735399, 0.23093411815809728, 0.047391809037385005, 0.007387849113828373, 9.273492019864273E-4, 3.095663745756419E-9, 4.9133680153737176E-23}, {1.4535015913633094, 0.7803316096700087, 0.23423345125392075, 0.048352074501506394, 0.007583102028109552, 9.576868258216848E-4, 3.2974882687029096E-9, 5.571112423368008E-23}, {1.4597712990873968, 0.7871017212885827, 0.23756365733493914, 0.0493263879502623, 0.007782347007630299, 9.88828896657956E-4, 3.5111092212245095E-9, 6.311984321127374E-23}, {1.4660953217578165, 0.7939104031851835, 0.24092494647203974, 0.050314889382591654, 0.007985643774856143, 0.001020792006936449, 3.7371378919703915E-9, 7.145875791059635E-23}, {1.4724739693059392, 0.8007579979941238, 0.24431753066464498, 0.051317719881715934, 0.00819305268128944, 0.0010535930026395971, 3.976213274119118E-9, 8.08378402092128E-23}, {1.4789075544125847, 0.8076448504468113, 0.24774162385342113, 0.05233502162540559, 0.008404634712846791, 0.0010872489860958919, 4.2290031452125205E-9, 9.137926824490249E-23}, {1.4853963925248748, 0.8145713073905696, 0.2511974419331027, 0.05336693789631904, 0.008620451495288886, 0.0011217773188106444, 4.496205182436525E-9, 1.0321869419853575E-22}, {1.4919408018732376, 0.8215377178075809, 0.254685202765435, 0.054413613092415276, 0.008840565299703325, 0.0011571956243229618, 4.7785481143041E-9, 1.165066348377227E-22}, {1.498541103488561, 0.828544432833947, 0.2582051261922333, 0.055475192737440226, 0.009065039048040626, 0.0011935217910891722, 5.076792909715936E-9, 1.3140999585716582E-22}, {1.505197621219502, 0.8355918057788723, 0.2617574340485611, 0.056551823491488004, 0.009293936318703962, 0.0012307739753929859, 5.391734005395446E-9, 1.4811374196834888E-22}, {1.511910681749947, 0.8426801921439693, 0.26534235017602814, 0.057643653161637526, 0.009527321352192974, 0.0012689706042826462, 5.724200572715777E-9, 1.6682272567786218E-22}, {1.51868061461663, 0.8498099496426874, 0.26896010043620755, 0.058750830712665236, 0.009765259056802082, 0.0013081303785353446, 6.0750578249581716E-9, 1.8776368875519185E-22}, {1.525507752226906, 0.8569814382198678, 0.2726109127241753, 0.05987350627783475, 0.010007815014373733, 0.0013482722756491738, 6.4452083660629E-9, 2.111874515323664E-22}, {1.5323924298766778, 0.8641950200714213, 0.2762950169821702, 0.06101183116976385, 0.010255055486106966, 0.0013894155528628863, 6.8355935819562745E-9, 2.3737130640496455E-22}, {1.539334985768488, 0.8714510596641365, 0.2800126452133773, 0.06216595789136977, 0.010507047418421725, 0.001431579750203734, 7.247195075559849E-9, 2.6662163322251463E-22}, {1.546335761029762, 0.8787499237556136, 0.28376403149583457, 0.0633360401468936, 0.010763858448879407, 0.0014747846935636794, 7.681036146611114E-9, 2.992767556724604E-22}, {1.5533950997312167, 0.8860919814143275, 0.2875494119964632, 0.0645222328530041, 0.011025556912159977, 0.0015190504978042363, 8.1381833174481E-9, 3.3571005928225055E-22}, {1.5605133489054266, 0.8934776040398227, 0.2913690249852239, 0.06572469214998197, 0.011292211846096144, 0.001564397569890244, 8.619747905934372E-9, 3.7633339329571815E-22}, {1.567690858565557, 0.9009071653830396, 0.29522311084939906, 0.06694357541298562, 0.011563892997765099, 0.0016108466120528537, 9.12688764672497E-9, 4.2160078043021885E-22}, {1.5749279817242507, 0.9083810415667701, 0.2991119121080005, 0.06817904126339801, 0.01184067082963805, 0.0016584186249819935, 9.660808362098101E-9, 4.720124603978222E-22}, {1.5822250744126924, 0.9158996111062524, 0.30303567342630633, 0.06943124958025698, 0.012122616525788292, 0.0017071349110486436, 1.0222765683603073E-8, 5.281192950856587E-22}, {1.5895824956998257, 0.9234632549298958, 0.3069946416305259, 0.07070036151176831, 0.012409801998158004, 0.0017570170775571678, 1.0814066825799414E-8, 5.9052756544604885E-22}, {1.5970006077117438, 0.9310723564001447, 0.3109890657225935, 0.07198653948690313, 0.012702299892884393, 0.0018080870400280335, 1.1436072413388675E-8, 6.599041924557964E-22}, {1.6044797756512454, 0.9387273013344789, 0.3150191968950931, 0.07328994722708022, 0.013000183596685564, 0.001860367025511185, 1.2090198363065965E-8, 7.369824169758746E-22}, {1.6120203678175606, 0.9464284780265523, 0.31908528854631435, 0.07461074975793389, 0.013303527243306638, 0.0019138795759303983, 1.2777917821445442E-8, 8.225679759882695E-22}, {1.6196227556262432, 0.9541762772674715, 0.32318759629543964, 0.07594911342116803, 0.01361240572002648, 0.0019686475514588907, 1.3500763160440352E-8, 9.175458155170492E-22}, {1.6272873136292378, 0.9619710923672156, 0.32732637799786557, 0.07730520588649784, 0.013926894674225693, 0.002024694133926516, 1.4260328031506357E-8, 1.022887383567701E-21}, {1.6350144195351157, 0.9698133191761974, 0.33150189376065686, 0.0786791961636789, 0.014247070520016131, 0.0020820428302588266, 1.505826948018414E-8, 1.1396585496547787E-21}, {1.6428044542294853, 0.977703356106969, 0.33571440595813645, 0.08007125461462548, 0.014573010444932626, 0.0021407174759483344, 1.5896310122405997E-8, 1.2690282009462817E-21}, {1.6506578017955778, 0.9856416041560714, 0.3399641792476104, 0.08148155296561808, 0.014904792416687246, 0.002200742238558264, 1.677624038405983E-8, 1.4122775687477636E-21}, {1.6585748495350048, 0.9936284669260299, 0.34425148058523, 0.08291026431960132, 0.015242495189986674, 0.0022621416212591184, 1.769992080533287E-8, 1.5708103429948103E-21}, {1.666555987988696, 1.001664350647496, 0.34857657924199076, 0.084357563168573, 0.015586198313413176, 0.002324940466398383, 1.866928441138769E-8, 1.7461636366347505E-21}, {1.674601610958014, 1.0097496642015409, 0.35293974681987167, 0.08582362540606518, 0.015935982136369653, 0.0023891639591036708, 1.968633915095264E-8, 1.940019866273842E-21}, {1.6827121155260454, 1.0178848191420928, 0.357341257268112, 0.08730862833971784, 0.016291927816089253, 0.0024548376309196387, 2.075317040443972E-8, 2.154219620261943E-21}, {1.6908879020790748, 1.0260702297185316, 0.36178138689962996, 0.08881275070394605, 0.016654117324710137, 0.0025219873634790076, 2.187194356323414E-8, 2.3907755905013912E-21}, {1.6991293743282403, 1.0343063128984304, 0.36626041440758267, 0.09033617267270183, 0.017022633456415803, 0.0025906393922079975, 2.3044906681830882E-8, 2.651887649719762E-21}, {1.70743693933137, 1.042593488390455, 0.3707786208820684, 0.09187907587233099, 0.017397559834641575, 0.0026608203100665184, 2.4274393204526338E-8, 2.9399591617577896E-21}, {1.7158110075149997, 1.0509321786674137, 0.3753362898269721, 0.09344164339452588, 0.017778980919347674, 0.0027325570713234437, 2.5562824768404664E-8, 3.257614618615665E-21}, {1.7242519926965856, 1.0593228089894677, 0.37993370717695635, 0.09502405980937542, 0.0181669820143596, 0.0028058769953673126, 2.6912714084392936E-8, 3.607718704595986E-21}, {1.7327603121068886, 1.067765807427495, 0.384571161314597, 0.09662651117851274, 0.018561649274776073, 0.0028808077705527826, 2.8326667898190937E-8, 3.993396894903555E-21}, {1.7413363864125608, 1.0762616048866167, 0.38924894308766567, 0.09824918506836113, 0.01896306971444531, 0.0029573774580831883, 2.980739003291738E-8, 4.418057703536825E-21}, {1.7499806397389095, 1.0848106351298799, 0.39396734582655996, 0.09989227056347998, 0.019371331213510087, 0.0030356144959295434, 3.135768451534738E-8, 4.885416703258952E-21}, {1.7586934996928583, 1.0934133348021047, 0.39872666536188195, 0.10155595828001046, 0.019786522526022053, 0.003115547702786328, 3.2980458787651896E-8, 5.399522448897312E-21}, {1.7674753973860948, 1.1020701434538938, 0.403527200042167, 0.10324044037922304, 0.020208733287626044, 0.0031972062820644262, 3.4678727006585573E-8, 5.964784444217221E-21}, {1.7763267674584178, 1.110781503565804, 0.4083692507517628, 0.1049459105811666, 0.02063805402331475, 0.0032806198259215514, 3.6455613432105154E-8, 6.58600330218094E-21}, {1.7852480481012694, 1.119547860572686, 0.41325312092886024, 0.10667256417842079, 0.021074576155254415, 0.003365818319330521, 3.831435590743741E-8, 7.268403258568686E-21}, {1.79423968108147, 1.1283696628881899, 0.4181791165836775, 0.1084205980499521, 0.021518392010682105, 0.003452832144185737, 4.0258309432653555E-8, 8.017667209739304E-21}, {1.8033021117651464, 1.1372473619294392, 0.42314754631679813, 0.11019021067507487, 0.021969594829875087, 0.0035416920834482374, 4.2290949833843445E-8, 8.839974456780611E-21}, {1.8124357891418599, 1.1461814121418747, 0.42815872133766375, 0.11198160214751794, 0.02242827877419297, 0.0036324293253296846, 4.4415877530023325E-8, 9.742041350481708E-21}, {1.82164116584893, 1.1551722710242682, 0.43321295548322303, 0.11379497418959766, 0.022894538934193066, 0.0037250754675156412, 4.6636821399947605E-8, 1.0731165044491223E-20}, {1.8309186981959646, 1.1642203991539126, 0.4383105652367389, 0.11563053016649882, 0.02336847133781969, 0.0038196625214285324, 4.895764275103677E-8, 1.1815270577750024E-20}, {1.84026884618959, 1.1733262602119825, 0.4434518697467537, 0.117488475100664, 0.023850172958668, 0.003916222916530662, 5.1382339392672333E-8, 1.3002961521847404E-20}, {1.84969207355838, 1.1824903210090694, 0.4486371908462123, 0.11936901568629162, 0.024339741724322666, 0.0040147895046676076, 5.3915049816150486E-8, 1.430357444439343E-20}, {1.8591888477779979, 1.1917130515108996, 0.45386685307174857, 0.12127236030394523, 0.024837276524772463, 0.004115395564452467, 5.656005748362881E-8, 1.5727237455877388E-20}, {1.8687596400965398, 1.200994924864223, 0.45914118368313245, 0.12319871903527373, 0.025342877220901058, 0.0042180748056912755, 5.932179522844082E-8, 1.728493312484119E-20}, {1.8784049255600859, 1.2103364174228888, 0.4644605126828794, 0.12514830367784333, 0.025856644653054577, 0.004322861373849969, 6.220484976919631E-8, 1.8988566064595657E-20}, {1.8881251830384636, 1.2197380087740965, 0.46982517283602554, 0.12712132776008375, 0.026378680649686882, 0.004429789854563357, 6.521396634012904E-8, 2.085103551419986E-20}, {1.8979208952512179, 1.2292001817648348, 0.47523549969006657, 0.12911800655634734, 0.026909088036082763, 0.004538895278186396, 6.835405344019613E-8, 2.288631325707155E-20}, {1.9077925487938008, 1.2387234225285022, 0.4806918315950653, 0.13113855710208458, 0.027447970643160093, 0.004650213124388273, 7.163018770347985E-8, 2.5109527242460747E-20}, {1.9177406341639627, 1.2483082205117133, 0.48619450972392436, 0.1331831982091346, 0.027995433316351213, 0.0047637793267895825, 7.504761889348496E-8, 2.753705129816609E-20}, {1.927765645788372, 1.2579550685012946, 0.49174387809283043, 0.13525215048113368, 0.02855158192456444, 0.0048796302776431015, 7.861177502397345E-8, 3.0186601347372183E-20}, {1.9378680820494432, 1.2676644626514668, 0.4973402835818671, 0.13734563632904134, 0.029116523369226224, 0.0049978028325584995, 8.232826760902244E-8, 3.3077338568409504E-20}, {1.9480484453123839, 1.2774369025112202, 0.5029840759558, 0.1394638799867858, 0.029690365593404676, 0.005118334315271438, 8.620289704504048E-8, 3.622997996366091E-20}, {1.958307241952465, 1.2872728910518794, 0.5086756078850334, 0.14160710752702943, 0.030273217591014985, 0.005241262522457427, 9.024165812752269E-8, 3.9666916832841E-20}, {1.9686449823825107, 1.2971729346948648, 0.5144152349667429, 0.14377554687705557, 0.030865189416107615, 0.005366625728590921, 9.445074570537687E-8, 4.341234167654018E-20}, {1.9790621810806095, 1.3071375433396473, 0.5202033157461816, 0.14596942783477734, 0.03146639219223973, 0.005494462690849995, 9.88365604756986E-8, 4.7492384088338303E-20}, {1.9895593566180507, 1.3171672303918989, 0.5260402117381632, 0.14818898208486975, 0.0320769381219306, 0.005624812654067089, 1.0340571492192583E-7, 5.193525622805201E-20}, {2.0001370316874905, 1.327262512791846, 0.5319262874487226, 0.15043444321502628, 0.03269694049620181, 0.005757715355726237, 1.0816503939835298E-7, 5.677140850486983E-20}, {2.0107957331313377, 1.3374239110428179, 0.5378619103969569, 0.15270604673234028, 0.03332651370420262, 0.005893211031007161, 1.131215883640359E-7, 6.20336961373655E-20}, {2.0215359919703766, 1.3476519492399988, 0.5438474511370446, 0.1550040300798134, 0.033965773242921556, 0.006031340417876739, 1.1828264676917167E-7, 6.775755729774916E-20}, {2.032358343432619, 1.3579471550993873, 0.5498832832804494, 0.1573286326529912, 0.034614835726984726, 0.006172144762228244, 1.236557365970897E-7, 7.398120359034853E-20}, {2.043263326982382, 1.368310059986952, 0.5559697835183035, 0.15968009581672704, 0.0352738188985414, 0.0063156658230687805, 1.2924862356504393E-7, 8.074582365930423E-20}, {2.0542514863496093, 1.3787411989480032, 0.5621073316439783, 0.16205866292207602, 0.03594284163723806, 0.006461945877755417, 1.3506932398705134E-7, 8.809580076794973E-20}, {2.0653233695594246, 1.389241110736767, 0.5682963105758396, 0.16446457932331945, 0.03662202397028106, 0.006611027727280412, 1.4112611180207593E-7, 9.607894524244702E-20}, {2.0764795289619182, 1.3998103378461715, 0.5745371063801894, 0.1668980923951212, 0.03731148708258904, 0.006762954701606018, 1.4742752577091419E-7, 1.0474674272509293E-19}, {2.0877205212621783, 1.4104494265378438, 0.5808301082943967, 0.16935945154981671, 0.03801135332703557, 0.006917770665049307, 1.5398237684519377E-7, 1.1415461923844599E-19}, {2.099046907550564, 1.4211589268723241, 0.5871757087502192, 0.17184890825483667, 0.03872174623478301, 0.007075520021717492, 1.6079975571195572E-7, 1.2436222412018267E-19}, {2.110459253333213, 1.4319393927394892, 0.5935743033973137, 0.17436671605026527, 0.039442790525707976, 0.007236247720994197, 1.6788904051734924E-7, 1.3543373195053535E-19}, {2.1219581285628033, 1.4427913818891966, 0.6000262911269417, 0.17691313056653502, 0.04017461211891952, 0.00739999926307714, 1.7525990477302423E-7, 1.4743816465944526E-19}, {2.133544107669554, 1.453715455962149, 0.6065320740958676, 0.1794884095422591, 0.04091733814337055, 0.007566820704567727, 1.8292232544887128E-7, 1.60449735069342E-19}, {2.1452177695924752, 1.4647121805209737, 0.6130920577504528, 0.18209281284220216, 0.04167109694856331, 0.0077367586641130075, 1.9088659125581632E-7, 1.7454821320193063E-19}, {2.1569796978108724, 1.475782125081529, 0.6197066508509462, 0.18472660247539088, 0.042436018115349694, 0.00790986032810048, 1.9916331112243873E-7, 1.8981931675367036E-19}, {2.1688304803760956, 1.4869258631444355, 0.6263762654959755, 0.18739004261336625, 0.04321223246682735, 0.008086173456406281, 2.0776342286924954E-7, 2.0635512722500204E-19}, {2.1807707099435425, 1.4981439722268268, 0.6331013171472334, 0.19008339960857626, 0.04399987207933176, 0.008265746388197107, 2.166982020845182E-7, 2.2425453327296343E-19}, {2.1928009838049225, 1.5094370338943357, 0.6398822246543711, 0.19280694201291382, 0.04479907029352592, 0.008448628047786564, 2.2597927120561666E-7, 2.436237029458981E-19}, {2.20492190392077, 1.5208056337933036, 0.6467194102800898, 0.195560940596398, 0.04560996172558782, 0.008634867950546276, 2.3561860880989976E-7, 2.6457658655265346E-19}, {2.2171340769532226, 1.5322503616832266, 0.6536132997254402, 0.1983456683660016, 0.046432682278496666, 0.00882451620887234, 2.456285591192174E-7, 2.8723545201725955E-19}, {2.2294381142990543, 1.5437718114694303, 0.6605643221553241, 0.20116140058462498, 0.04726736915341868, 0.009017623538207587, 2.5602184172221395E-7, 3.1173145467378777E-19}, {2.2418346321229734, 1.5553705812359815, 0.6675729102242066, 0.20400841479021903, 0.04811416086119341, 0.009214241263120211, 2.668115615186442E-7, 3.382052435651549E-19}, {2.2543242513911887, 1.5670472732788394, 0.6746395001020362, 0.2068869908150567, 0.048973197233921135, 0.009414421323439231, 2.7801121888999987E-7, 3.6680760642432353E-19}, {2.2669075979052344, 1.578802494139241, 0.6817645315003744, 0.2097974108051557, 0.04984461943665238, 0.009618216280447359, 2.896347201008127E-7, 3.977001556369131E-19}, {2.2795853023360673, 1.590636854637329, 0.6889484476987382, 0.21273995923985264, 0.05072856997918024, 0.009825679323131702, 3.016963879350684E-7, 4.3105605761095475E-19}, {2.2923580002584334, 1.602550969906026, 0.6961916955711565, 0.21571492295153094, 0.05162519272793653, 0.010036864274492978, 3.142109725722433E-7, 4.670608081126974E-19}, {2.305226332185509, 1.6145454594251483, 0.7034947256129414, 0.2187225911455028, 0.05253463291799247, 0.010251825597913624, 3.271936627075394E-7, 5.05913056267276E-19}, {2.3181909436038075, 1.6266209470557669, 0.7108579919676744, 0.22176325542004663, 0.053457037165164686, 0.010470618403585418, 3.4066009692097703E-7, 5.478254800700362E-19}, {2.3312524850083745, 1.6387780610748222, 0.7182819524544156, 0.2248372097866023, 0.0543925534782277, 0.010693298454997165, 3.5462637530007087E-7, 5.930257164086708E-19}, {2.344411611938249, 1.6510174342099833, 0.7257670685951283, 0.22794475069012424, 0.05534133127123352, 0.010919922175482951, 3.6910907132089633E-7, 6.417573487584004E-19}, {2.3576689850122117, 1.6633397036747624, 0.7333138056423265, 0.23108617702959358, 0.056303521375939095, 0.011150546654831504, 3.841252439924279E-7, 6.9428095588262605E-19}, {2.3710252699648118, 1.6757455112038837, 0.7409226326069482, 0.23426179017869275, 0.05727927605434301, 0.011385229655957325, 3.99692450269109E-7, 7.508752250500865E-19}, {2.3844811376826813, 1.68823550308891, 0.7485940222864509, 0.23747189400664098, 0.0582687490113318, 0.011624029621633997, 4.1582875773669306E-7, 8.118381334670286E-19}, {2.3980372642411303, 1.7008103302141242, 0.7563284512931339, 0.24071679489919395, 0.05927209540743703, 0.01186700568129035, 4.325527575764715E-7, 8.774882018195989E-19}, {2.4116943309410344, 1.7134706480926771, 0.7641264000826915, 0.24399680177980895, 0.060289471871704116, 0.012114217657870041, 4.498835778130951E-7, 9.4816582402805E-19}, {2.4254530243460137, 1.726217116902993, 0.7719883529829933, 0.24731222613097528, 0.06132103651467349, 0.012365726074755022, 4.678408968512619E-7, 1.024234677530759E-18}, {2.4393140363198937, 1.7390504015254422, 0.7799147982230978, 0.2506633820157135, 0.06236694894147548, 0.012621592162753645, 4.864449573066467E-7, 1.1060832186431368E-18}, {2.453278064064479, 1.7519711715792818, 0.7879062279625005, 0.2540505860992431, 0.06342737026503946, 0.012881877867153835, 5.057165801365129E-7, 1.1941262677744544E-18}, {2.4673458101576053, 1.764980101459863, 0.7959631383206143, 0.25747415767082094, 0.06450246311941843, 0.01314664585484203, 5.256771790755524E-7, 1.2888066895352072E-18}, {2.481517982591501, 1.7780778703761113, 0.8040860294064904, 0.26093441866575207, 0.06559239167322987, 0.01341595952148841, 5.463487753825637E-7, 1.3905971730291431E-18}, {2.495795294811445, 1.7912651623882796, 0.8122754053487761, 0.26443169368757274, 0.06669732164321382, 0.013689882998799025, 5.677540129036894E-7, 1.5000021178982377E-18}, {2.51017846575473, 1.804542666445977, 0.8205317743259131, 0.2679663100304094, 0.06781742030790923, 0.013968481161835524, 5.899161734580076E-7, 1.617559631976069E-18}, {2.524668219889933, 1.817911076426475, 0.8288556485965796, 0.2715385977015131, 0.06895285652144954, 0.014251819636402903, 6.128591925513639E-7, 1.743843646705965E-18}, {2.5392652872564856, 1.8313710911732948, 0.8372475445303754, 0.2751488894439724, 0.07010380072747843, 0.014539964806506142, 6.366076754244317E-7, 1.8794661567954914E-18}, {2.553970403504564, 1.8449234145350748, 0.8457079826387541, 0.27879752075960434, 0.07127042497318664, 0.014832983821876068, 6.611869134410699E-7, 2.0250795909088755E-18}, {2.5687843099352827, 1.858568755404724, 0.8542374876062019, 0.28248482993202684, 0.07245290292347106, 0.015130944605565345, 6.866229008231466E-7, 2.1813793205446506E-18}, {2.5837077535412094, 1.8723078277588612, 0.862836588321668, 0.2862111580499129, 0.07365140987521702, 0.015433915861614984, 7.129423517380912E-7, 2.349106314607631E-18}, {2.5987414870471914, 1.886141350697545, 0.8715058179102455, 0.28997684903042886, 0.0748661227717048, 0.015741967082792237, 7.401727177455378E-7, 2.5290499475631107E-18}, {2.613886268951503, 1.900070048484291, 0.8802457137651062, 0.2937822496428566, 0.07609722021714103, 0.016055168558400272, 7.683422056095122E-7, 2.722050969457613E-18}, {2.6291428635673144, 1.9140946505863863, 0.8890568175796906, 0.2976277095324037, 0.07734488249131688, 0.016373591382160515, 7.974797954827221E-7, 2.9290046465053454E-18}, {2.644512041064487, 1.9282158917155003, 0.8979396753801572, 0.3015135812442012, 0.07860929156439313, 0.016697307460168172, 8.276152594696071E-7, 3.150864081373574E-18}, {2.659994577511686, 1.9424345118685875, 0.9068948375580876, 0.3054402202474906, 0.07989063111181363, 0.01702638951892157, 8.587791805749017E-7, 3.3886437227540983E-18}, {2.6755912549188334, 1.9567512563690985, 0.9159228589034574, 0.30940798496000305, 0.08118908652934839, 0.017360911113426112, 8.91002972044583E-7, 3.643423074282996E-18}, {2.6913028612798815, 1.9711668759084902, 0.9250242986378653, 0.31341723677253064, 0.08250484494826688, 0.017700946635373412, 9.243188971061572E-7, 3.916350613367339E-18}, {2.7071301906159255, 1.9856821265880389, 0.9341997204480339, 0.3174683400736926, 0.08383809525064298, 0.018046571321396306, 9.587600891153644E-7, 4.2086479309969166E-18}, {2.723074043018651, 2.000297769960966, 0.9434496925195708, 0.32156166227489696, 0.08518902808479253, 0.018397861261400427, 9.94360572116479E-7, 4.521614104161875E-18}, {2.739135224694118, 2.0150145730748714, 0.9527747875710053, 0.32569757383550035, 0.08655783588084473, 0.01875489340697306, 1.031155281823489E-6, 4.856630313064602E-18}, {2.7553145480068877, 2.029833308514477, 0.9621755828880917, 0.3298764482881669, 0.08794471286644806, 0.01911774557986992, 1.0691800870295552E-6, 5.2151647159073095E-18}, {2.7716128315244912, 2.0447547544446913, 0.9716526603583899, 0.33409866226442775, 0.08934985508261258, 0.019486496480580623, 1.1084718114522624E-6, 5.598777594656485E-18}, {2.788030900062244, 2.0597796946539835, 0.981206606506118, 0.3383645955204432, 0.09077346039968887, 0.01986122569697344, 1.1490682560222725E-6, 6.0091267858328475E-18}, {2.8045695847284065, 2.074908918598083, 0.9908380125272852, 0.342674630962969, 0.09221572853348538, 0.020242013713020195, 1.1910082216231325E-6, 6.447973411052054E-18}, {2.8212297229697056, 2.090143221444003, 1.000547474325104, 0.3470291546755295, 0.09367686106152523, 0.020628941917601933, 1.2343315322900717E-6, 6.917187922747628E-18}, {2.838012158617194, 2.1054834041143824, 1.0103355925456818, 0.3514285559447957, 0.09515706143944312, 0.02102209261339604, 1.2790790588757713E-6, 7.418756481245816E-18}, {2.854917741932475, 2.1209302733321573, 1.0202029726139998, 0.35587322728717524, 0.09665653501752423, 0.021421549025845674, 1.3252927431911852E-6, 7.954787680132321E-18}, {2.871947329654293, 2.136484641665574, 1.0301502247701773, 0.3603635644756126, 0.09817548905738609, 0.02182739531221222, 1.3730156226296374E-6, 8.527519637655495E-18}, {2.889101785045462, 2.1521473275735095, 1.0401779641060211, 0.36489996656660034, 0.09971413274880372, 0.022239716570711283, 1.4222918552824905E-6, 9.139327472749886E-18}, {2.906381977940189, 2.167919155451157, 1.05028681060187, 0.369482835927407, 0.10127267722668071, 0.022658598849733334, 1.4731667455548827E-6, 9.792731185141355E-18}, {2.9237887847917374, 2.183800955676026, 1.060477389163729, 0.3741125782635197, 0.10285133558816645, 0.02308412915714954, 1.5256867702900945E-6, 1.0490403959908764E-17}, {2.9413230887204747, 2.1997935646542963, 1.0707503296606988, 0.37878960264630507, 0.10445032290992085, 0.023516395469703535, 1.5798996054112373E-6, 1.1235180917832432E-17}, {2.9589857795622887, 2.2158978248675085, 1.0811062669627052, 0.3835143215408897, 0.10606985626552791, 0.023955486742489998, 1.635854153089123E-6, 1.2030068333854852E-17}, {2.9767777539173768, 2.232114584919604, 1.0915458409785221, 0.3882871508342625, 0.10771015474305955, 0.02440149291852075, 1.6936005694452698E-6, 1.2878253347018449E-17}, {2.994699915199417, 2.248444699584313, 1.1020696966941033, 0.39310850986359985, 0.10937143946279053, 0.024854504938379204, 1.7531902927991332E-6, 1.3783114186328232E-17}, {3.012753173685113, 2.264889029852889, 1.112678484211212, 0.39797882144481544, 0.11105393359506577, 0.025314614749963826, 1.8146760724688067E-6, 1.4748230938117398E-17}, {3.0309384465641305, 2.281448442982211, 1.1233728587863618, 0.40289851190133846, 0.11275786237832203, 0.025781915318321646, 1.878111998134549E-6, 1.5777396881672335E-17}, {3.049256657989414, 2.2981238125432224, 1.134153480870062, 0.40786801109311915, 0.11448345313726405, 0.026256500635572343, 1.9435535297746457E-6, 1.6874630421101552E-17}, {3.067708739127893, 2.3149160184697464, 1.1450210161463763, 0.41288775244586506, 0.1162309353011973, 0.02673846573092388, 2.0110575281832367E-6, 1.8044187642714232E-17}, {3.0862956282115857, 2.331825947107658, 1.1559761355727962, 0.4179581729805117, 0.11800054042251877, 0.027227906680780605, 2.080682286079913E-6, 1.9290575528508487E-17}, {3.1050182705890874, 2.348854491264418, 1.1670195154204255, 0.42307971334292405, 0.11979250219536587, 0.027724920618944247, 2.1524875598209765E-6, 2.0618565857760996E-17}, {3.1238776187774673, 2.3660025502589828, 1.178151837314488, 0.4282528178338383, 0.12160705647442645, 0.02822960574690915, 2.2265346017224626E-6, 2.2033209830158973E-17}, {3.1428746325145593, 2.383271029972076, 1.1893737882751527, 0.4334779344390388, 0.12344444129390991, 0.028742061344252185, 2.302886193005112E-6, 2.3539853445426325E-17}, {3.16201027881166, 2.4006608428968423, 1.200686060758684, 0.43875551485977693, 0.1253048968866815, 0.029262387779118403, 2.381606677371686E-6, 2.5144153675969008E-17}, {3.1812855320066267, 2.418172908189871, 1.2120893526989143, 0.4440860145434312, 0.12718866570356083, 0.02979068651880315, 2.4627619952270953E-6, 2.6852095470704104E-17}, {3.2007013738174015, 2.43580815172261, 1.2235843675490494, 0.4494698927144123, 0.12909599243278602, 0.030327060140431652, 2.5464197185520538E-6, 2.867000962994395E-17}, {3.220258793395924, 2.4535675061331443, 1.2351718143238004, 0.4549076124053121, 0.13102712401964478, 0.030871612341736698, 2.6326490864410297E-6, 3.0604591592984925E-17}, {3.23995878738248, 2.4714519108783826, 1.2468524076418488, 0.4603996404883041, 0.13298230968627422, 0.03142444795193569, 2.721521041315509E-6, 3.2662921181901325E-17}, {3.2598023599604637, 2.4894623122866153, 1.2586268677686507, 0.4659464477067912, 0.13496180095163007, 0.031985672942707384, 2.813108265823654E-6, 3.4852483346972E-17}, {3.2797905229115547, 2.507599663610471, 1.270495920659575, 0.47154850870730625, 0.13696585165162736, 0.03255539443926983, 2.9074852204377033E-6, 3.7181189961174586E-17}, {3.299924295671329, 2.525864925080267, 1.2824602980033837, 0.4772063020716669, 0.1389947179594535, 0.03313372073155985, 3.0047281817605118E-6, 3.9657402713269543E-17}, {3.3202047053852963, 2.5442590639577625, 1.2945207372660592, 0.482920310349388, 0.14104865840605596, 0.03372076128551549, 3.1049152815528783E-6, 4.228995715117E-17}, {3.340632786965365, 2.5627830545902994, 1.3066779817349687, 0.4886910200903489, 0.14312793390080447, 0.03431662675446169, 3.2081265464934282E-6, 4.508818792955583E-17}, {3.361209583146748, 2.5814378784653664, 1.3189327805633888, 0.49451892187772567, 0.1452328077523314, 0.034921428990600946, 3.314443938683008E-6, 4.8061955318042214E-17}, {3.3819361445453007, 2.600224524265551, 1.3312858888153707, 0.5004045103611805, 0.14736354568954918, 0.035535281056609025, 3.423951396905698E-6, 5.1221673028663084E-17}, {3.4028135297153024, 2.6191439879239162, 1.343738067510966, 0.5063482842903216, 0.149520415882849, 0.036158297237337336, 3.5367348786587435E-6, 5.4578337423975276E-17}, {3.4238428052076886, 2.6381972726797844, 1.3562900836718073, 0.5123507465484246, 0.1517036889654799, 0.03679059305162254, 3.652882402963867E-6, 5.81435581697394E-17}, {3.445025045628717, 2.6573853891349377, 1.3689427103670473, 0.5184124041864262, 0.15391363805511096, 0.037432285264204404, 3.7724840939725913E-6, 6.192959039888666E-17}, {3.466361333699103, 2.676709355310243, 1.3816967267596616, 0.5245337684571876, 0.15615053877557844, 0.03808349189775305, 3.895632225378423E-6, 6.594936845634872E-17}, {3.4878527603135914, 2.6961701967026936, 1.3945529181531147, 0.5307153548500314, 0.1584146692788181, 0.03874433224500625, 4.022421265648841E-6, 7.021654129730365E-17}, {3.509500424600999, 2.7157689463428842, 1.4075120760383955, 0.536957683125554, 0.16070631026698512, 0.03941492688101804, 4.1529479240903414E-6, 7.474550961448884E-17}, {3.5313054339847167, 2.73550664485291, 1.4205749981414217, 0.5432612773507163, 0.16302574501476377, 0.040095397675519485, 4.287311197759847E-6, 7.955146477345218E-17}, {3.5532689042436716, 2.755384340504707, 1.4337424884708205, 0.5496266659342134, 0.16537325939186673, 0.04078586780539263, 4.425612419236082E-6, 8.465042963795796E-17}, {3.575391959573761, 2.7754030892788153, 1.4470153573660807, 0.5560543816621271, 0.16774914188572712, 0.04148646176725857, 4.567955305264628E-6, 9.005930137123948E-17}, {3.5976757326497584, 2.7955639549236007, 1.4603944215460885, 0.5625449617338631, 0.17015368362438413, 0.04219730539018081, 4.7144460062906055E-6, 9.579589630241002E-17}, {3.6201213646876957, 2.8158680090149044, 1.4738805041580434, 0.569098947798375, 0.172587178399564, 0.04291852584848476, 4.865193156893138E-6, 1.0187899695109109E-16}, {3.642730005507718, 2.836316331016144, 1.4874744348267577, 0.5757168859906762, 0.175049922689958, 0.04365025167469442, 5.020307927135885E-6, 1.0832840130722459E-16}, {3.6655028135974317, 2.85691000833887, 1.5011770497043484, 0.5823993269686456, 0.1775422156846992, 0.04439261277258753, 5.179904074848226E-6, 1.1516497446708445E-16}, {3.6884409561757345, 2.8776501364037754, 1.514989191520316, 0.5891468259501261, 0.18006435930703932, 0.0451457404303699, 5.344097998851777E-6, 1.2241070273071386E-16}, {3.7115456092571253, 2.898537818702147, 1.5289117096320153, 0.5959599427503169, 0.18261665823822718, 0.04590976733397001, 5.51300879314721E-6, 1.3008875027038633E-16}, {3.7348179577165257, 2.919574166857805, 1.5429454600755317, 0.6028392418194694, 0.18519941994159167, 0.04668482758045534, 5.686758302076515E-6, 1.38223518484228E-16}, {3.7582591953545865, 2.940760300689485, 1.5570913056169484, 0.6097852922808797, 0.18781295468682915, 0.04747105669157103, 5.865471176476043E-6, 1.4684070815385676E-16}, {3.7818705249634923, 2.9620973482736934, 1.5713501158040197, 0.6167986679691865, 0.19045757557449783, 0.048268591627402, 6.0492749308359006E-6, 1.5596738452978023E-16}, {3.8056531583932873, 2.983586446008044, 1.5857227670182545, 0.6238799474689747, 0.1931335985607217, 0.04907757080016017, 6.2383000014814946E-6, 1.656320454733891E-16}, {3.8296083166186903, 3.005228738675056, 1.6002101425274025, 0.6310297141536875, 0.195841342482104, 0.04989813408809704, 6.432679805793215E-6, 1.7586469278964288E-16}, {3.8537372298064363, 3.027025379506443, 1.614813132538358, 0.6382485562248487, 0.1985811290808532, 0.05073042284954341, 6.632550802480454E-6, 1.8669690689003216E-16}, {3.8780411373831245, 3.048977530247874, 1.6295326342504746, 0.6455370667515989, 0.20135328303012293, 0.05157457993707713, 6.838052552926424E-6, 1.9816192493107633E-16}, {3.9025212881035936, 3.0710863612242325, 1.6443695519093056, 0.652895843710548, 0.20415813195956758, 0.05243074971181978, 7.049327783620476E-6, 2.1029472257951587E-16}, {3.9271789401198176, 3.093353051405356, 1.6593247968607587, 0.6603254900259445, 0.20699600648111546, 0.05329907805786396, 7.266522449694719E-6, 2.2313209956147307E-16}, {3.9520153610503272, 3.115778788472276, 1.6743992876056815, 0.6678266136101686, 0.20986724021496123, 0.05417971239683176, 7.489785799582181E-6, 2.367127691592084E-16}, {3.977031828050173, 3.138364768883952, 1.689593949854873, 0.6753998274045456, 0.21277216981577904, 0.05507280170256596, 7.719270440813776E-6, 2.510774518256784E-16}, {4.00222962788141, 3.1611121979445103, 1.704909716584527, 0.6830457494204886, 0.2157111349991596, 0.05597849651595496, 7.955132406971769E-6, 2.66268973093937E-16}, {4.0276100569841295, 3.1840222898709847, 1.720347528092112, 0.6907650027809671, 0.21868447856827072, 0.05689694895989264, 8.197531225817468E-6, 2.8233236596550433E-16}, {4.053174421548044, 3.2070962678615715, 1.7359083320526891, 0.6985582157623099, 0.2216925464407457, 0.05782831275437436, 8.446629988611339E-6, 2.9931497796917425E-16}, {4.078924037584603, 3.2303353641643975, 1.7515930835756717, 0.7064260218363407, 0.22473568767579982, 0.058772743231730463, 8.702595420643792E-6, 3.172665830893552E-16}, {4.104860230999671, 3.2537408201467986, 1.7674027452620285, 0.7143690597128497, 0.22781425450157644, 0.05973039735199787, 8.965597952995222E-6, 3.3623949877093436E-16}, {4.130984337666758, 3.277313886365128, 1.7833382872619394, 0.7223879733824069, 0.23092860234272722, 0.06070143371843209, 9.23581179554421E-6, 3.562887082158475E-16}, {4.15729770350082, 3.301055822635088, 1.799400687332901, 0.7304834121595156, 0.23407908984822468, 0.06168601259315958, 9.513415011242842E-6, 3.77471988195035E-16}, {4.18380168453261, 3.3249678981025905, 1.8155909308982872, 0.7386560307261134, 0.23726607891941237, 0.06268429591297284, 9.798589591678583E-6, 3.9985004260825363E-16}, {4.2104976469836055, 3.3490513913151476, 1.83191001110637, 0.7469064891754177, 0.2404899347382925, 0.06369644730526862, 1.0091521533942291E-5, 4.2348664203335043E-16}, {4.2373869673415125, 3.3733075902938108, 1.8483589288898057, 0.7552354530561257, 0.24375102579605404, 0.06472263210413134, 1.0392400918822256E-5, 4.48448769516057E-16}, {4.26447103243634, 3.3977377926056365, 1.86493869302558, 0.7636435934169641, 0.24704972392184235, 0.06576301736656186, 1.0701421990344239E-5, 4.748067728611431E-16}, {4.29175123951706, 3.422343305436712, 1.881650320195431, 0.7721315868515978, 0.25038640431177395, 0.06681777188885424, 1.1018783236678218E-5, 5.026345236959624E-16}, {4.319228996328855, 3.4471254456657263, 1.8984948350467428, 0.7807001155438967, 0.25376144555819624, 0.06788706622312063, 1.1344687472432238E-5, 5.320095835878923E-16}, {4.346905721190952, 3.472085539938092, 1.9154732702539126, 0.7893498673135646, 0.25717522967919654, 0.06897107269396634, 1.1679341922354479E-5, 5.630133775081137E-16}, {4.374782843075063, 3.497224924740634, 1.9325866665802058, 0.798081535662134, 0.2606281421483608, 0.070069965415316, 1.202295830646473E-5, 5.957313749454249E-16}, {4.402861801684403, 3.5225449464768332, 1.9498360729400899, 0.8068958198193263, 0.2641205719247843, 0.07118392030739236, 1.2375752926636802E-5, 6.30253278985519E-16}, {4.431144047533343, 3.548046961542648, 1.96722254646206, 0.8157934247897867, 0.26765291148333764, 0.07231311511384884, 1.2737946754653636E-5, 6.666732236832256E-16}, {4.4596310420276355, 3.5737323364028897, 1.9847471525519504, 0.8247750614001882, 0.2712255568451882, 0.0734577294190574, 1.3109765521757368E-5, 7.050899800677881E-16}, {4.488324257545295, 3.599602447668204, 2.0024109649567556, 0.8338414463467185, 0.2748389076085818, 0.07461794466555331, 1.349143980971652E-5, 7.456071711342258E-16}, {4.517225177518049, 3.625658682172599, 2.020215065828932, 0.8429933022429399, 0.27849336697988286, 0.07579394417163726, 1.3883205143433183E-5, 7.88333496187275E-16}, {4.546335296513465, 3.651902437051586, 2.0381605457912224, 0.8522313576680384, 0.2821893418048799, 0.07698591314913747, 1.4285302085113178E-5, 8.333829649183304E-16}, {4.575656120317652, 3.6783351198208942, 2.0562485040019713, 0.8615563472154536, 0.28592724260035435, 0.07819403872133217, 1.469797633002229E-5, 8.808751416102214E-16}, {4.605189166018637, 3.704958148455791, 2.0744800482209658, 0.8709690115419033, 0.28970748358591797, 0.07941850994103457, 1.5121478803852631E-5, 9.30935399879591E-16}, {4.634935962090349, 3.7317729514709885, 2.0928562948757787, 0.8804700974167937, 0.29353048271611865, 0.08065951780884102, 1.5556065761722407E-5, 9.836951883820428E-16}, {4.664898048477261, 3.758780968001166, 2.1113783691286434, 0.8900603577720311, 0.29739666171281903, 0.08191725529154466, 1.6001998888834045E-5, 1.039292307921285E-15}, {4.695076976679678, 3.785983647882095, 2.1300474049438414, 0.8997405517522286, 0.30130644609784846, 0.08319191734071511, 1.6459545402814647E-5, 1.097871200419956E-15}, {4.725474309839662, 3.8133824517323753, 2.1488645451556243, 0.9095114447653152, 0.30526026522593136, 0.08448370091144665, 1.6928978157764016E-5, 1.1595832502269902E-15}, {4.756091622827632, 3.840978851035795, 2.1678309415366646, 0.9193738085335516, 0.30925855231789456, 0.08579280498127512, 1.7410575750035336E-5, 1.2245870982540778E-15}, {4.786930502329614, 3.8687743282243083, 2.1869477548670413, 0.9293284211449516, 0.31330174449415493, 0.08711943056926633, 1.790462262577399E-5, 1.2930489694520822E-15}, {4.817992546935161, 3.8967703767616406, 2.2062161550037667, 0.9393760671051173, 0.31739028280849063, 0.08846378075527651, 1.841140919024062E-5, 1.3651430141572528E-15}, {4.8492793672259475, 3.924968501227534, 2.2256373209508578, 0.9495175373894883, 0.32152461228209794, 0.0898260606993869, 1.893123191894435E-5, 1.4410516638566758E-15}, {4.880792585865024, 3.9533702174026093, 2.245212440929951, 0.959753629496008, 0.32570518193793546, 0.09120647766151335, 1.9464393470612973E-5, 1.5209660019426685E-15}, {4.912533837686782, 3.9819770523538995, 2.264942712451476, 0.9700851474982132, 0.32993244483535944, 0.09260524102119352, 2.0011202802026917E-5, 1.6050861500468557E-15}, {4.944504769787578, 4.010790544521004, 2.284829342386381, 0.9805129020987484, 0.3342068581050511, 0.09402256229755197, 2.0571975284744278E-5, 1.6936216705662591E-15}, {4.976707041617065, 4.03981224380291, 2.30487354703842, 0.9910377106833069, 0.3385288829842395, 0.09545865516944568, 2.1147032823744515E-5, 1.7867919860162974E-15}, {5.009142325070216, 4.069043711645464, 2.3250765522170083, 1.0016603973750051, 0.34289898485222214, 0.09691373549579115, 2.173670397801883E-5, 1.8848268158686724E-15}, {5.04181230458006, 4.098486521129513, 2.345439593310643, 1.0123817930891925, 0.34731763326618476, 0.09838802133607467, 2.234132408313556E-5, 1.9879666315561643E-15}, {5.074718677211097, 4.128142257059697, 2.3659639153609016, 1.023202735588697, 0.3517853019973245, 0.09988173297104744, 2.2961235375809266E-5, 2.0964631303511508E-15}, {5.107863152753462, 4.158012516053934, 2.3866507731370135, 1.0341240695395184, 0.3563024690672781, 0.10139509292360722, 2.3596787120502744E-5, 2.210579728850264E-15}, {5.141247453817788, 4.188098906633567, 2.4075014312110206, 1.0451466465669612, 0.36086961678485674, 0.10292832597986795, 2.4248335738091143E-5, 2.3305920768241307E-15}, {5.174873315930793, 4.218403049314206, 2.428517164033525, 1.0562713253122213, 0.3654872317830921, 0.10448165921041923, 2.491624493661849E-5, 2.456788592218514E-15}, {5.208742487631605, 4.248926576697242, 2.4496992560100193, 1.0674989714894247, 0.3701558050565944, 0.10605532199177706, 2.5600885844176356E-5, 2.5894710181214536E-15}, {5.2428567305688105, 4.279671133562073, 2.47104900157783, 1.0788304579431216, 0.37487583199922625, 0.10764954602802777, 2.6302637143935698E-5, 2.7289550025402964E-15}, {5.277217819598252, 4.3106383769590115, 2.4925677052836446, 1.0902666647062405, 0.37964781244209317, 0.1092645653726664, 2.702188521136258E-5, 2.875570701862688E-15}, {5.311827542881573, 4.341829976302911, 2.5142566818616556, 1.1018084790585096, 0.3844722506918564, 0.11090061645063216, 2.7759024253649636E-5, 3.0296634089068575E-15}, {5.346687701985505, 4.3732476134674885, 2.5361172563123113, 1.1134567955853405, 0.389349655569367, 0.11255793808054101, 2.851445645139452E-5, 3.191594206498746E-15}, {5.3818001119819225, 4.404892982880374, 2.5581507639816836, 1.1252125162371895, 0.39428054044862737, 0.11423677149711935, 2.9288592102558198E-5, 3.361740647546977E-15}, {5.417166601548661, 4.43676779161887, 2.580358550641454, 1.1370765503893885, 0.39926542329608006, 0.11593736037383831, 3.008184976873524E-5, 3.5404974626208984E-15}, {5.452789013071081, 4.468873759506442, 2.6027419725695236, 1.1490498149024584, 0.4043048267102289, 0.11765995084575216, 3.0894656423769507E-5, 3.7282772960727234E-15}, {5.488669202744454, 4.501212619209947, 2.6253023966312568, 1.161133234182904, 0.4093992779615926, 0.11940479153254127, 3.1727447604748665E-5, 3.925511471781363E-15}, {5.524809040677077, 4.533786116337583, 2.648041200361353, 1.1733277402444964, 0.414549309032997, 0.12117213356176265, 3.258066756541137E-5, 4.132650789633557E-15}, {5.561210410994214, 4.566596009537598, 2.670959772046367, 1.185634272770045, 0.4197554566602058, 0.12296223059230887, 3.345476943200161E-5, 4.350166353897117E-15}, {5.597875211942798, 4.599644070597735, 2.6940595108078638, 1.198053779173665, 0.4250182623728927, 0.12477533883807733, 3.4350215361604955E-5, 4.578550434681433E-15}, {5.634805355996959, 4.632932084545441, 2.717341826686228, 1.2105872146635417, 0.4303382725359605, 0.1266117170918527, 3.526747670300196E-5, 4.818317363722389E-15}, {5.672002769964344, 4.66646184974883, 2.7408081407251292, 1.223235542305201, 0.43571603839120765, 0.12847162674940285, 3.6207034160074584E-5, 5.070004465771711E-15}, {5.709469395093246, 4.70023517801842, 2.764459885056643, 1.2359997330852828, 0.441152116099345, 0.13035533183379153, 3.71693779578015E-5, 5.334173026915509E-15}, {5.74720718718055, 4.73425389470962, 2.7882985029870366, 1.248880765975824, 0.44664706678236643, 0.13226309901990832, 3.8155008010879154E-5, 5.611409301192619E-15}, {5.785218116680512, 4.7685198388260375, 2.8123254490832323, 1.261879627999065, 0.45220145656627797, 0.1341951976592196, 3.916443409500578E-5, 5.90232555693092E-15}, {5.823504168814352, 4.803034863123514, 2.8365421892599274, 1.2749973142927589, 0.45781585662418356, 0.1361518998047401, 4.019817602086537E-5, 6.207561164268601E-15}, {5.862067343680697, 4.837800834215003, 2.8609502008674195, 1.2882348281760216, 0.4634908432197364, 0.1381334802362293, 4.125676381085046E-5, 6.527783725378149E-15}, {5.900909656366862, 4.8728196326762125, 2.8855509727800963, 1.3015931812156976, 0.4692269977509543, 0.1401402164856127, 4.2340737878561533E-5, 6.863690248962738E-15}, {5.940033137060962, 4.908093153152051, 2.9103460054856223, 1.3150733932932581, 0.47502490679440385, 0.14217238886263153, 4.345064921112255E-5, 7.216008370648818E-15}, {5.979439831164918, 4.943623304463904, 2.935336811174831, 1.3286764926722403, 0.4808851621497568, 0.14423028048072126, 4.458705955435169E-5, 7.585497620953907E-15}, {6.019131799408283, 4.979412009717698, 2.960524913832302, 1.342403516066221, 0.48680836088472107, 0.14631417728312263, 4.575054160082792E-5, 7.972950742566375E-15}, {6.059111117962956, 5.0154612064128035, 2.9859118493276604, 1.3562555087073374, 0.4927951053803495, 0.14842436806922593, 4.6941679180893157E-5, 8.37919505873257E-15}, {6.099379878558774, 5.051772846551758, 3.011499165507577, 1.3702335244153554, 0.49884600337672974, 0.1505611445211507, 4.8161067456631625E-5, 8.805093894608283E-15}, {6.13994018859997, 5.088348896750821, 3.037288422288494, 1.3843386256672916, 0.5049616680190585, 0.15272480123056395, 4.9409313118867823E-5, 9.251548053493922E-15}, {6.180794171282537, 5.125191338351375, 3.0632811917500713, 1.398571883667591, 0.511142717904102, 0.15491563572573724, 5.0687034587224934E-5, 9.719497349938012E-15}, {6.221943965712478, 5.162302167532174, 3.0894790582293625, 1.4129343784188704, 0.5173897771270498, 0.15713394849884676, 5.199486221328668E-5, 1.0209922201760663E-14}, {6.26339172702494, 5.1996833954224275, 3.1158836184157233, 1.427427198793222, 0.5237034753287585, 0.15938004303351644, 5.3333438486905394E-5, 1.0723845283117316E-14}, {6.305139626504294, 5.237337048215766, 3.1424964814464644, 1.4420514426040942, 0.5300844477433955, 0.16165422583260763, 5.470341824570013E-5, 1.1262333240794741E-14}, {6.347189851705101, 5.275265167285072, 3.169319269003252, 1.4568082166787457, 0.5365333352464827, 0.16395680644625732, 5.6105468887789306E-5, 1.1826498476004548E-14}, {6.389544606574004, 5.313469809298158, 3.1963536154092465, 1.4716986369312755, 0.5430507844033414, 0.16628809750016615, 5.754027058780204E-5, 1.24175009940151E-14}, {6.43220611157255, 5.351953046334348, 3.2236011677270184, 1.4867238284362436, 0.5496374475179475, 0.1686484147241393, 5.900851651621404E-5, 1.3036550324040878E-14}, {6.4751766038009775, 5.390716966001954, 3.2510635858572243, 1.5018849255028826, 0.5562939826821959, 0.17103807698088294, 6.051091306205444E-5, 1.3684907511889284E-14}, {6.518458337122881, 5.42976367155661, 3.27874254263803, 1.517183071749891, 0.5630210538255758, 0.1734574062950561, 6.204818005902806E-5, 1.436388718794667E-14}, {6.562053582290895, 5.4690952820205325, 3.3066397239453407, 1.5326194201808407, 0.5698193307652681, 0.1759067278825831, 6.362105101510308E-5, 1.507485971317286E-14}, {6.605964627073299, 5.508713932302689, 3.3347568287937936, 1.548195133260178, 0.5766894892566594, 0.17838637018022693, 6.523027334560931E-5, 1.5819253405859622E-14}, {6.650193776381599, 5.548621773319871, 3.363095569438547, 1.5639113829898397, 0.5836322110442822, 0.18089666487542685, 6.687660860989668E-5, 1.6598556852000964E-14}, {6.694743352399058, 5.588820972118684, 3.3916576714778506, 1.5797693509864739, 0.5906481839131807, 0.18343794693640111, 6.856083275160222E-5, 1.7414321302216175E-14}, {6.739615694710255, 5.629313711998481, 3.4204448739564346, 1.595770228559289, 0.5977381017407105, 0.18601055464251887, 7.028373634257526E-5, 1.8268163158263042E-14}, {6.784813160431585, 5.670102192635219, 3.4494589294696922, 1.611915216788522, 0.6049026645487711, 0.18861482961494294, 7.204612483051097E-5, 1.9161766552278773E-14}, {6.830338124342768, 5.711188630206258, 3.4787016042686734, 1.6282055266045286, 0.6121425785564751, 0.19125111684754448, 7.384881879034248E-5, 2.0096886021987847E-14}, {6.8761929790193665, 5.752575257516114, 3.508174678365903, 1.6446423788675162, 0.6194585562332632, 0.19391976473809405, 7.569265417944357E-5, 2.1075349285222885E-14}, {6.922380134966318, 5.794264324123181, 3.53787994564203, 1.6612270044479132, 0.626851316352462, 0.1966211251197306, 7.75784825966935E-5, 2.2099060117212128E-14}, {6.96890202075246, 5.836258096467382, 3.5678192139532863, 1.6779606443073734, 0.6343215840452907, 0.19935555329270943, 7.950717154545656E-5, 2.3170001334200598E-14}, {7.015761083146107, 5.878558857998827, 3.5979943052398116, 1.6948445495804403, 0.6418700908553227, 0.20212340805643433, 8.147960470052996E-5, 2.4290237887086736E-14}, {7.062959787251645, 5.921168909307439, 3.628407055634801, 1.7118799816568575, 0.6494975747934012, 0.20492505174177347, 8.349668217911337E-5, 2.5461920068875784E-14}, {7.110500616647177, 5.964090568253561, 3.6590593155745137, 1.7290682122645409, 0.6572047803930188, 0.20776085024366395, 8.555932081585561E-5, 2.6687286839873868E-14}, {7.158386073523208, 6.0073261700995655, 3.6899529499091392, 1.7464105235532148, 0.6649924587661576, 0.2106311730540054, 8.766845444203275E-5, 2.796866927467257E-14}, {7.20661867882239, 6.050878067642455, 3.721089838014525, 1.763908208178717, 0.6728613676595995, 0.2135363932948469, 8.982503416891431E-5, 2.930849413510468E-14}, {7.255200972380338, 6.094748631347486, 3.7524718739047724, 1.781562569387978, 0.6808122715117076, 0.2164768877518684, 9.203002867537392E-5, 3.070928757348535E-14}, {7.3041355130675045, 6.138940249482797, 3.784100966345717, 1.7993749211046808, 0.688845941509683, 0.21945303690816, 9.428442449980146E-5, 3.217367897059067E-14}, {7.353424878932156, 6.18345532825508, 3.815979038969295, 1.817346588015613, 0.6969631556473048, 0.2224652249783023, 9.658922633637584E-5, 3.370440491296857E-14}, {7.403071667344419, 6.228296291946265, 3.848108030388788, 1.8354789056576943, 0.7051646987831468, 0.2255138399427472, 9.894545733575528E-5, 3.5304313314322396E-14}, {7.453078495141433, 6.273465583051252, 3.880489894314979, 1.8537732205057171, 0.7134513626992891, 0.22859927358250717, 1.0135415941024681E-4, 3.6976367685859105E-14}, {7.503447998773622, 6.318965662416711, 3.9131265996732165, 1.872230890060783, 0.7218239461605183, 0.2317219215141506, 1.0381639354351329E-4, 3.872365156064832E-14}, {7.554182834452042, 6.364799009380904, 3.9460201307213705, 1.890853282939441, 0.7302832549740209, 0.23488218322510784, 1.0633324010487974E-4, 4.054937307719864E-14}, {7.605285678296898, 6.410968121914602, 3.9791724871687295, 1.9096417789635507, 0.7388301020495822, 0.2380804621092921, 1.089057991683012E-4, 4.245686972762228E-14}, {7.656759226487166, 6.457475516763067, 4.012585684295819, 1.9285977692508558, 0.7474653074602846, 0.2413171655030352, 1.115351908360532E-4, 4.444961327592789E-14}, {7.708606195411353, 6.504323729589108, 4.046261753075145, 1.9477226563062868, 0.7561896985037153, 0.24459270472134248, 1.1422255556720915E-4, 4.653121485215578E-14}, {7.7608293218194255, 6.5515153151172365, 4.080202740292887, 1.967017854113992, 0.7650041097636875, 0.2479074950944698, 1.1696905451096857E-4, 4.870543022824927E-14}, {7.813431362975865, 6.5990528472789185, 4.114410708671539, 1.9864847882301087, 0.7739093831724767, 0.2512619560048245, 1.1977586984490007E-4, 5.097616528174068E-14}, {7.8664150968139355, 6.646938919358937, 4.148887736993501, 2.006124895876274, 0.7829063680735796, 0.25465651092419395, 1.2264420511816593E-4, 5.334748165351952E-14}, {7.919783322091074, 6.695176144142855, 4.183635920225641, 2.0259396260338796, 0.7919959212849942, 0.25809158745130334, 1.2557528559979325E-4, 5.582360260614711E-14}, {7.973538858545498, 6.743767154065619, 4.218657369644819, 2.0459304395390947, 0.8011789071630349, 0.2615676173497076, 1.285703586320599E-4, 5.840891908938222E-14}, {8.02768454705401, 6.7927146013613, 4.253954212964399, 2.0660988091786336, 0.810456197666677, 0.26508503658601806, 1.3163069398906257E-4, 6.110799601978958E-14}, {8.082223249790978, 6.842021158213947, 4.289528594461739, 2.086446219786298, 0.8198286724224413, 0.2686442853684683, 1.347575842405366E-4, 6.392557878151653E-14}, {8.137157850388549, 6.891689516909625, 4.325382675106677, 2.106974168340292, 0.8292972187898209, 0.27224580818582134, 1.3795234512099577E-4, 6.686659995554095E-14}, {8.192491254098076, 6.9417223899895895, 4.361518632691019, 2.1276841640613133, 0.8388627319272552, 0.2758900538466216, 1.4121631590426412E-4, 6.993618628492054E-14}, {8.24822638795278, 6.9921225104046405, 4.397938661959036, 2.14857772851143, 0.8485261148586564, 0.27957747551879464, 1.445508597834704E-4, 7.313966588380561E-14}, {8.304366200931643, 7.04289263167065, 4.434644974738979, 2.16965639569375, 0.8582882785404901, 0.2833085307695963, 1.4795736425657647E-4, 7.64825756982128E-14}, {8.360913664124558, 7.094035528025272, 4.471639800075615, 2.1909217121528877, 0.8681501419294185, 0.28708368160591696, 1.5143724151751503E-4, 7.997066922680859E-14}, {8.417871770898728, 7.145553994585854, 4.508925384363796, 2.2123752370762295, 0.8781126320505088, 0.29090339451494124, 1.5499192885300817E-4, 8.360992451019752E-14}, {8.475243537066346, 7.19745084750855, 4.5465039914830765, 2.2340185423960217, 0.888176684066011, 0.29476814050516775, 1.5862288904514298E-4, 8.740655239747455E-14}, {8.533032001053545, 7.2497289241486484, 4.584377902933366, 2.2558532128922577, 0.89834324134471, 0.2986783951477917, 1.6233161077977993E-4, 9.136700509906492E-14}, {8.591240224070633, 7.302391083222119, 4.622549417971655, 2.277880846296408, 0.9086132555318592, 0.3026346386184535, 1.6611960906087042E-4, 9.54979850351516E-14}, {8.649871290283633, 7.3554402049684064, 4.6610208537497915, 2.300103053395965, 0.9189876866196967, 0.30663735573935624, 1.699884256307605E-4, 9.980645398927127E-14}, {8.708928306987119, 7.408879191314433, 4.699794545453335, 2.322521458139828, 0.9294675030185496, 0.3106870360217551, 1.7393962939656052E-4, 1.0429964257695119E-13}, {8.768414404778383, 7.462710966039901, 4.738872846441504, 2.3451376977445393, 0.9400536816285364, 0.3147841737088235, 1.7797481686265967E-4, 1.0898506003955712E-13}, {8.828332737732929, 7.516938474943817, 4.778258128388201, 2.3679534228013606, 0.9507472079118635, 0.3189292678188961, 1.8209561256946524E-4, 1.1387050437383137E-13}, {8.888686483581271, 7.571564686012295, 4.817952781424123, 2.390970297384206, 0.9615490759657267, 0.3231228221890951, 1.8630366953844898E-4, 1.1896407280791158E-13}, {8.94947884388714, 7.626592589587664, 4.857959214280026, 2.4141899991584506, 0.9724602885958249, 0.3273653455193419, 1.9060066972358185E-4, 1.2427417263495136E-13}, {9.010713044226993, 7.682025198538823, 4.898279854431048, 2.4376142194905923, 0.9834818573904818, 0.33165735141675584, 1.949883244692421E-4, 1.2980953241579176E-13}, {9.07239233437091, 7.73786554843295, 4.938917148242198, 2.4612446635588068, 0.9946148027953924, 0.3359993584404472, 1.994683749746792E-4, 1.3557921356247903E-13}, {9.134519988464888, 7.794116697708467, 4.9798735611149585, 2.4850830504643744, 1.0058601541889878, 0.3403918901467029, 2.0404259276512017E-4, 1.4159262231477592E-13}, {9.19709930521449, 7.850781727849367, 5.021151577635039, 2.509131113344006, 1.0172189499584334, 0.3448354751345732, 2.0871278016960492E-4, 1.4785952212217566E-13}, {9.26013360806992, 7.907863743560851, 5.062753701721272, 2.533390599483068, 1.0286922375762595, 0.3493306470918591, 2.134807708056366E-4, 1.5439004644429923E-13}, {9.323626245412498, 7.965365872946315, 5.104682456775679, 2.5578632704297055, 1.0402810736776302, 0.3538779448415059, 2.1834843007073702E-4, 1.6119471198294344E-13}, {9.387580590742559, 8.023291267685675, 5.146940385834697, 2.5825509021098862, 1.0519865241382602, 0.35847791238840565, 2.2331765564099584E-4, 1.6828443235943439E-13}, {9.452000042868784, 8.08164310321508, 5.189530051721589, 2.6074552849433617, 1.0638096641529793, 0.3631310989666127, 2.2839037797670457E-4, 1.756705322513506E-13}, {9.516888026098957, 8.140424578907956, 5.232454037200034, 2.6325782239605533, 1.07575157831495, 0.3678380590869745, 2.3356856083516574E-4, 1.8336476200309388E-13}, {9.582247990432233, 8.199638918257492, 5.275714945128929, 2.6579215389203816, 1.0878133606955545, 0.3725993525851835, 2.3885420179077307E-4, 1.9137931272521065E-13}, {9.648083411752777, 8.259289369060443, 5.319315398618373, 2.6834870644290265, 1.099996114924936, 0.37741554467025085, 2.442493327624519E-4, 1.9972683189780782E-13}, {9.714397792024977, 8.31937920360242, 5.363258041186892, 2.709276650059646, 1.1123009542732218, 0.38228720597340843, 2.497560205485602E-4, 2.0842043949385812E-13}, {9.781194659490072, 8.379911718844518, 5.407545536919866, 2.735292160473051, 1.1247290017324174, 0.38721491259744073, 2.5537636736934076E-4, 2.174737446386504E-13}, {9.848477568864327, 8.44089023661143, 5.452180570629206, 2.7615354755393406, 1.1372813900989867, 0.3921992461664518, 2.611125114170271E-4, 2.2690086282211565E-13}, {9.916250101538681, 8.502318103780967, 5.497165848014271, 2.7880084904605194, 1.1499592620571202, 0.3972407938760698, 2.6696662741369846E-4, 2.36716433681257E-13}, {9.98451586577996, 8.56419869247503, 5.5425040958240315, 2.814713115894085, 1.1627637702626956, 0.4023401485440935, 2.729409271769818E-4, 2.4693563937039386E-13}, {10.05327849693356, 8.626535400252035, 5.588198062020497, 2.8416512780776073, 1.175696077427939, 0.4074979086615845, 2.7903766019370644E-4, 2.5757422353747404E-13}, {10.122541657627755, 8.68933165030084, 5.634250515943436, 2.868824918954313, 1.1887573564067935, 0.4127146784444094, 2.8525911420161057E-4, 2.6864851092521096E-13}, {10.192309037979491, 8.7525908916361, 5.680664248476346, 2.89623599629966, 1.201948790280996, 0.41799106788523493, 2.916076157792006E-4, 2.801754276163616E-13}, {10.262584355801799, 8.816316599295174, 5.727442072213746, 2.923886483848933, 1.215271572446875, 0.42332769280598037, 2.9808553094387206E-4, 2.921725219430178E-13}, {10.33337135681275, 8.880512274536484, 5.774586821629751, 2.951778371425857, 1.2287269067028663, 0.428725174910731, 3.046952657583948E-4, 3.0465798608035277E-13}, {10.404673814846046, 8.945181445039431, 5.822101353247975, 2.9799136650722433, 1.2423160073377653, 0.43418414183911774, 3.114392669458706E-4, 3.176506783458589E-13}, {10.476495532063167, 9.010327665105812, 5.86998854581275, 3.0082943871786645, 1.2560400992197065, 0.43970522722016503, 3.1832002251327014E-4, 3.311701462257129E-13}, {10.548840339167176, 9.075954515862787, 5.918251300461674, 3.03692257661618, 1.2699004178858886, 0.4452890707266114, 3.2534006238365973E-4, 3.452366501505311E-13}, {10.621712095618143, 9.142065605467392, 5.9668925408995115, 3.065800288869112, 1.2838982096330471, 0.4509363181297089, 3.325019590372285E-4, 3.5987118804341035E-13}, {10.69511468985019, 9.208664569312633, 6.015915213573445, 3.0949295961688876, 1.2980347316086773, 0.4566476213545027, 3.3980832816122707E-4, 3.750955206638104E-13}, {10.769052039490226, 9.275755070235128, 6.065322287849695, 3.124312587628947, 1.3123112519030213, 0.4624236385355971, 3.472618293089328E-4, 3.909321977715013E-13}, {10.843528091578321, 9.343340798724354, 6.115116756191503, 3.153951369380727, 1.3267290496418152, 0.46826503407340947, 3.548651665677527E-4, 4.0740458513548855E-13}, {10.918546822789775, 9.41142547313349, 6.165301634338518, 3.1838480647107454, 1.3412894150798131, 0.4741724786909205, 3.6262108923658593E-4, 4.2453689241354927E-13}, {10.994112239658874, 9.480012839891872, 6.215879961487568, 3.2140048141987596, 1.3559936496950882, 0.4801466494909205, 3.7053239251255655E-4, 4.4235420192872137E-13}, {11.070228378804362, 9.549106673719075, 6.266854800474848, 3.244423775857056, 1.3708430662841184, 0.4861882300137596, 3.7860191818723924E-4, 4.608824983698515E-13}, {11.146899307156614, 9.618710777840622, 6.318229237959513, 3.275107125270829, 1.3858389890576621, 0.4922979102956035, 3.868325553524975E-4, 4.801486994440642E-13}, {11.224129122186552, 9.68882898420535, 6.370006384608722, 3.3060570557396964, 1.4009827537374353, 0.498476386927201, 3.952272411160568E-4, 5.001806875098075E-13}, {11.301921952136333, 9.75946515370445, 6.422189375284106, 3.337275778420345, 1.4162757076535895, 0.5047243631131665, 4.0378896132693074E-4, 5.210073422199309E-13}};
        double[][] besselJ = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.9999840000639999, 0.003999968000085334, 7.999957333418669E-6, 1.0666624000068269E-8, 1.0666632533378848E-11, 8.533310577803787E-15, 2.8895901532174896E-31, 4.519338577377384E-67}, {0.9999360010239927, 0.007999744002730652, 3.199931733879464E-5, 8.533196800873811E-8, 1.7066448214498418E-10, 2.730637539688709E-13, 2.958927405179403E-28, 4.738859136420727E-61}, {0.999856005183917, 0.01199913602073575, 7.19965440622074E-5, 2.8798963214929794E-7, 8.639751170985962E-10, 2.0735502341118802E-12, 1.7062542348511106E-26, 1.5757863206199524E-57}, {0.9997440163835338, 0.015997952087379468, 1.279890776828527E-4, 6.826229771184652E-7, 2.7305268595159134E-9, 8.737760513128448E-12, 3.0298887770466754E-25, 4.96900852667298E-55}, {0.9996000399982223, 0.01999600026665778, 1.9997333466663107E-4, 1.3332000053332146E-6, 6.666133351110771E-9, 2.6664888939681686E-11, 2.8217668768104155E-24, 4.309898318063496E-53}, {0.9994240829386918, 0.023993088663520155, 2.879447079811592E-4, 2.3036682431096867E-6, 1.3822407551639098E-8, 6.634883016287781E-11, 1.7471357201683895E-23, 1.6522977264296296E-51}, {0.9992161536506148, 0.02798902543410364, 3.9189756737219E-4, 3.6579496242180874E-6, 2.560665117648604E-8, 1.434009942042602E-10, 8.161807116227301E-23, 3.6059507952540965E-50}, {0.9989762621141759, 0.03198361879596407, 5.118252597014276E-4, 5.459935375157431E-6, 4.368171958164583E-8, 2.795725482981864E-10, 3.1023894958900224E-22, 5.210192536932192E-49}, {0.9987044198435386, 0.035976677038303845, 6.477201093457141E-4, 7.773480902493844E-6, 6.996586210618321E-8, 5.037759709580486E-10, 1.0074205526299342E-21, 5.494125761268457E-48}, {0.9984006398862336, 0.039968008532195655, 7.995734186575652E-4, 1.0662400682605991E-5, 1.0663253788409773E-7, 8.531058037823935E-10, 2.889174079646545E-21, 4.518997702384547E-47}, {0.99806493682246, 0.043957421740801673, 9.673754684870287E-4, 1.419046315418113E-5, 1.561102071393448E-7, 1.3738584865810197E-9, 7.493544584712255E-21, 3.0401070390915387E-46}, {0.9976973267643102, 0.047944725229587606, 0.001151115518764834, 1.842138561380502E-5, 2.21082097979598E-7, 2.1225511614765696E-9, 1.7887859503027147E-20, 1.7324171812939036E-45}, {0.9972978273549091, 0.05192972767653091, 0.0013507818091467935, 2.3418829114988662E-5, 3.0448594870616503E-7, 3.1669393317219567E-9, 3.9825720811009365E-20, 8.587887271785778E-45}, {0.996866457767474, 0.05591223788232283, 0.0015663615597194265, 2.9246393370974934E-5, 4.0951372565930406E-7, 4.587033261068283E-9, 8.355903625338583E-20, 3.780689998294561E-44}, {0.9964032387042916, 0.059892064780563505, 0.0017978409717667552, 3.59676116616675E-5, 5.396113166200069E-7, 6.476112999621478E-9, 1.6657404662075144E-19, 1.502539645673134E-43}, {0.9959081923956143, 0.06386901744794961, 0.0020452052285982285, 4.3645945745024415E-5, 6.984781997911465E-7, 8.941741922238986E-9, 3.175959743781656E-19, 5.462483703397277E-43}, {0.9953813425984747, 0.06784290511445405, 0.0023084384964377285, 5.234478077325853E-5, 8.90067088382711E-7, 1.2106778665640242E-8, 5.822956280478337E-19, 1.836360782085525E-42}, {0.9948227145954183, 0.07181353717349702, 0.0025875239253736037, 6.212742021418636E-5, 1.118583550827664E-6, 1.6110387350536483E-8, 1.0312340781467203E-18, 5.759941895942624E-42}, {0.9942323351931561, 0.07578072319210795, 0.002882443650369669, 7.305708077806691E-5, 1.3884856066568006E-6, 2.1109045975226595E-8, 1.7706994029752193E-18, 1.6983522711145078E-41}, {0.9936102327211342, 0.0797442729210777, 0.0031931787923371187, 8.519688735027151E-5, 1.7044832980627754E-6, 2.7277552867256247E-8, 2.95722351204132E-18, 4.737429560592903E-41}, {0.9929564370300235, 0.08370399630510043, 0.0035197094592672837, 9.860986793012513E-5, 2.071538237185306E-6, 3.4810031079897295E-8, 4.816718214176201E-18, 1.2569418324866648E-40}, {0.9922709794901281, 0.08765970349290468, 0.0038620147474251617, 1.1335894857625984E-4, 2.4948631291513644E-6, 4.392093062037389E-8, 7.669339025938884E-18, 3.1869017415214515E-40}, {0.9915538929897125, 0.0916112048473731, 0.004220072742603669, 1.295069483588203E-4, 2.979921270905996E-6, 5.484602839694006E-8, 1.1961373729704879E-17, 7.752769768768011E-40}, {0.9908052119332476, 0.09555831095564986, 0.004593860521438498, 1.4711657431885984E-4, 3.5324260258711663E-6, 6.784342577210113E-8, 1.8305661402173494E-17, 1.815973257833636E-39}, {0.9900249722395763, 0.099500832639236, 0.004983354152783563, 1.6625041643526784E-4, 4.1583402744719336E-6, 8.319454360946917E-8, 2.753227755130292E-17, 4.1083607739809384E-39}, {0.9892132113399991, 0.10343858096407117, 0.005388528699146879, 1.8697094259956498E-4, 4.8638758405709415E-6, 1.0120511470194804E-7, 4.075147312718954E-17, 9.001574581654713E-39}, {0.9883699681762769, 0.10737136725060209, 0.005809358218186854, 2.0934049359890548E-4, 5.655492893854116E-6, 1.2220617346916014E-7, 5.943113051016062E-17, 1.9147376201689412E-38}, {0.987495283198556, 0.11129900308383639, 0.006245815764268864, 2.3342127810762418E-4, 6.53989932821222E-6, 1.465550428122518E-7, 8.549129912287707E-17, 3.9625651386191935E-38}, {0.9865891983632107, 0.11522130032338197, 0.00669787339008204, 2.592753676876639E-4, 7.524050116164673E-6, 1.7463631801444693E-7, 1.2141869805339001E-16, 7.993866373247342E-38}, {0.9856517571306067, 0.11913807111347074, 0.007165502148316139, 2.8696469179822045E-4, 8.615146639373892E-6, 2.0686284757596442E-7, 1.7040442399884914E-16, 1.5747169330095185E-37}, {0.9846830044627837, 0.1230491278929666, 0.007648672093398454, 3.1655103281494183E-4, 9.820635995300233E-6, 2.4367671087216563E-7, 2.365084809258215E-16, 3.033828974893969E-37}, {0.9836829868210593, 0.1269542834053568, 0.008147352283290612, 3.480960210590149E-4, 1.1148210280049247E-5, 2.85550192524059E-7, 3.248551540686063E-16, 5.724478619508906E-37}, {0.982651752163551, 0.1308533507087263, 0.008661510781345144, 3.8166112983647484E-4, 1.26058058474649E-5, 3.3298675337056314E-7, 4.4186368622172227E-16, 1.0592382621554264E-36}, {0.9815893499426198, 0.13474614318571446, 0.009191114658221772, 4.173076704880722E-4, 1.420160254452415E-5, 3.8652199793220564E-7, 5.9551917969145955E-16, 1.924292259191558E-36}, {0.9804958311022349, 0.13863247455345376, 0.009736129993863266, 4.5509678745003E-4, 1.594402292309002E-5, 4.467246382562284E-7, 7.95689143712737E-16, 3.435822714949131E-36}, {0.9793712480752567, 0.1425121588734894, 0.010296521879530712, 4.950894533260221E-4, 1.7841731428082E-5, 5.141974540333615E-7, 1.0544916355641973E-15, 6.035265507384077E-36}, {0.978215654780643, 0.14638501056168007, 0.010872254419898158, 5.373464639707073E-4, 1.9903633562124614E-5, 5.895782488768462E-7, 1.3867215049729942E-15, 1.0438946948081595E-35}, {0.9770291066205745, 0.1502508443980787, 0.011463290735206452, 5.819284335851481E-4, 2.2138875026736504E-5, 6.735408026545916E-7, 1.810341846631139E-15, 1.7793825343937367E-35}, {0.9758116604775018, 0.15410947553679252, 0.012069592963476126, 6.28895789824445E-4, 2.4556840840124212E-5, 7.667958197656815E-7, 2.3470483956810347E-15, 2.9913281069818137E-35}, {0.9745633747111133, 0.15796071951582283, 0.012691122262779261, 6.783087689179151E-4, 2.7167154431646713E-5, 8.700918732527839E-7, 3.0229152667957853E-15, 4.963015092856802E-35}, {0.9732843091552256, 0.1618043922668825, 0.013327838813570143, 7.302274108021462E-4, 2.997967671301833E-5, 9.842163446423542E-7, 3.8691311398995185E-15, 8.131976221456915E-35}, {0.9719745251145938, 0.16564031012519229, 0.013979701821074603, 7.847115542672517E-4, 3.300450512631958E-5, 1.1099963594048798E-6, 4.922835735557134E-15, 1.31667111459182E-34}, {0.9706340853616447, 0.16946828983925383, 0.014646669517737862, 8.418208321166538E-4, 3.625197266888701E-5, 1.2482997179277701E-6, 6.228067201516743E-15, 2.107814967834918E-34}, {0.9692630541331316, 0.17328814858059977, 0.015328699165730764, 9.016146663407206E-4, 3.9732646895155036E-5, 1.4000358218938668E-6, 7.836831849709182E-15, 3.3380136853347852E-34}, {0.9678614971267102, 0.1770997039535204, 0.01602574705951425, 9.641522633045866E-4, 4.3457328895524545E-5, 1.5661565959589462E-6, 9.810308541087917E-15, 5.231851485523907E-34}, {0.9664294814974399, 0.18090277400476595, 0.01673776852846191, 0.0010294926089504737, 4.743705225233439E-5, 1.7476574046219272E-6, 1.2220200914910431E-14, 8.119544236005366E-34}, {0.9649670758542025, 0.18469717723322365, 0.01746471793954042, 0.0010976944640148417, 5.168308197301411E-5, 1.945577964181959E-6, 1.515025160029478E-14, 1.248249503950493E-33}, {0.963474350256049, 0.18848273259957063, 0.018206548700047807, 0.0011688163592606913, 5.6206913400497684E-5, 2.1610032496769123E-6, 1.869793353199582E-14, 1.9016805026801392E-33}, {0.9619513762084656, 0.19225925953589948, 0.018963213260409232, 0.0012429165907253338, 6.102027110097958E-5, 2.395064396698238E-6, 2.2976334520194237E-14, 2.8721181922233267E-33}, {0.9603982266595634, 0.19602657795531875, 0.01973466311703027, 0.001320053214983958, 6.613510772909678E-5, 2.648939597977586E-6, 2.811625229652568E-14, 4.3017783845276596E-33}, {0.9588149759961935, 0.1997845082615258, 0.020520848815207424, 0.0014002840444293071, 7.156360287062136E-5, 2.9238549946409885E-6, 3.42685183764367E-14, 6.391724467767283E-33}, {0.9572017000399826, 0.20353287135835232, 0.021321719952095693, 0.0014836666425677857, 7.731816186275025E-5, 3.2210855620268674E-6, 4.1606570242071225E-14, 9.424261129213535E-33}, {0.955558476043295, 0.20727148865928194, 0.022137225179733114, 0.0015702583193323136, 8.341141459208074E-5, 3.541955989964567E-6, 5.032929256108617E-14, 1.3793138070892647E-32}, {0.9538853826851165, 0.21100018209693952, 0.022967312208121992, 0.0016601161264122497, 8.985621427036165E-5, 3.887841557410587E-6, 6.06641494158826E-14, 2.0044050080212905E-32}, {0.952182500066864, 0.21471877413255078, 0.02381192780836666, 0.001753296852600683, 9.666563618811128E-5, 4.260169001340109E-6, 7.287063082551758E-14, 2.892863898602665E-32}, {0.9504499097081185, 0.2184270877653729, 0.02467101781586762, 0.001849857019159432, 1.0385297644619654E-4, 4.660417379791973E-6, 8.724403819983503E-14, 4.1476110148486126E-32}, {0.9486876945422837, 0.22212494654209508, 0.025544527133571873, 0.001949852875202038, 1.1143175066546723E-4, 5.0901189289656275E-6, 1.0411963477289135E-13, 5.908771528678308E-32}, {0.9468959389121689, 0.22581217456620797, 0.026432399735279156, 0.0020533403930950863, 1.1941569267454262E-4, 5.55085991426919E-6, 1.238771885213393E-13, 8.366077793937575E-32}, {0.9450747285654969, 0.22948859650734224, 0.027334578669004007, 0.002160375263878149, 1.2781875317584865E-4, 6.044281475218151E-6, 1.4694593658383052E-13, 1.177507118781397E-31}, {0.9432241506503378, 0.2331540376105755, 0.028251006060393376, 0.0022710128927026707, 1.366550983900053E-4, 6.572080464084819E-6, 1.7381000176045203E-13, 1.647816834350748E-31}, {0.9413442937104688, 0.23680832370570712, 0.02918162311619966, 0.0023853083942901037, 1.4593910867866648E-4, 7.136010278199137E-6, 2.0501429328747672E-13, 2.293192881715802E-31}, {0.9394352476806584, 0.2404512812164999, 0.03012637012780877, 0.002503316588409587, 1.5568537714591413E-4, 7.737881685801934E-6, 2.411709257530064E-13, 3.1742196062786186E-31}, {0.9374971038818788, 0.24408273716988893, 0.03108518647482332, 0.0026250919953754973, 1.6590870821831351E-4, 8.379563645352355E-6, 2.8296619174414394E-13, 4.37091943839892E-31}, {0.9355299550164438, 0.24770251920515696, 0.03205801062870043, 0.0027506888315651555, 1.766241162037342E-4, 9.062984118191609E-6, 3.311681255968575E-13, 5.988516679886724E-31}, {0.9335338951630722, 0.25131045558307424, 0.033044780156444055, 0.0028801610049570023, 1.8784682382904543E-4, 9.790130874465795E-6, 3.8663469745639627E-13, 8.164775082971533E-31}, {0.9315090197718807, 0.25490637519500536, 0.03404543172435173, 0.0030135621106895504, 1.9959226075679626E-4, 1.0563052292211163E-5, 4.5032267874965977E-13, 1.1079303272712033E-30}, {0.9294554256593028, 0.2584901075719797, 0.03505990110181523, 0.003150945426641395, 2.1187606208099036E-4, 1.1383858149505623E-5, 5.232972221220154E-13, 1.4965312097519199E-30}, {0.9273732110029347, 0.2620614828937259, 0.036088123165175165, 0.003292363909032602, 2.2471406680206918E-4, 1.2254720409590985E-5, 6.067422009003274E-13, 2.012441669076241E-30}, {0.9252624753363099, 0.2656203319976712, 0.03713003190162922, 0.0034378701880477605, 2.381223162812176E-4, 1.3177873998870987E-5, 7.019713552120963E-13, 2.694520687619254E-30}, {0.9231233195436019, 0.2691664863879028, 0.038185560413193737, 0.003587516563480999, 2.521170526741083E-4, 1.4155617577690684E-5, 8.104402940182196E-13, 3.592646662026332E-30}, {0.9209558458542552, 0.2726997782440926, 0.03925464092071841, 0.003741355000403261, 2.667147173442016E-4, 1.5190314303803417E-5, 9.337594045046337E-13, 4.770611126274438E-30}, {0.9187601578375445, 0.2762200404303836, 0.040337204767953945, 0.0038994371248521286, 2.819319492557204E-4, 1.6284392588432285E-5, 1.0737077225265662E-12, 6.309713574607874E-30}, {0.9165363603970647, 0.27972710650423926, 0.04143318242567242, 0.0040618142195445, 2.9778558334642136E-4, 1.74403468448334E-5, 1.2322478201089435E-12, 8.313213439139694E-30}, {0.9142845597651476, 0.2832208107252523, 0.04254250349583997, 0.004228537219612397, 3.142926488802833E-4, 1.8660738229269203E-5, 1.411541768378269E-12, 1.0911827031066079E-29}, {0.9120048634972108, 0.2867009880639157, 0.043665096715841685, 0.004399656708362192, 3.3147036778023687E-4, 1.9948195374300234E-5, 1.6139682367355028E-12, 1.4270494881211018E-29}, {0.9096973804660354, 0.2901674742103533, 0.04480088996275845, 0.004575222913057551, 3.49336152941061E-4, 2.130541511430502E-5, 1.842140791576895E-12, 1.8596689395354832E-29}, {0.9073622208559741, 0.29362010558301016, 0.045949810257695435, 0.004755285700726382, 3.6790760652257305E-4, 2.273516320313779E-5, 2.0989274604306126E-12, 2.4150585199352705E-29}, {0.9049994961570893, 0.2970587193373024, 0.04711178377016193, 0.004939894573992058, 3.872025182232396E-4, 2.424027502383482E-5, 2.3874716300022284E-12, 3.125747628118219E-29}, {0.9026093191592239, 0.3004831533742256, 0.04828673582250246, 0.00512909866692921, 4.0723886353433977E-4, 2.582365629028058E-5, 2.711214349311916E-12, 4.032289652208146E-29}, {0.9001918039460021, 0.3038932463489218, 0.049474590894378584, 0.005322946740944362, 4.280348019748086E-4, 2.748828374074564E-5, 3.073918111861322E-12, 5.185098513884546E-29}, {0.8977470658887615, 0.3072888376792044, 0.05067527262730155, 0.005521487180681714, 4.496086753068987E-4, 2.9237205823209162E-5, 3.4796921935888463E-12, 6.646673786463477E-29}, {0.8952752216404186, 0.3106697675540399, 0.051888703829215045, 0.005724767989954297, 4.7197900573278743E-4, 3.107354337237891E-5, 3.933019626258986E-12, 8.494290057515104E-29}, {0.8927763891292653, 0.31403587694198665, 0.05311480647912813, 0.005932836787700845, 4.95164494072271E-4, 3.300049027832316E-5, 4.43878588888517E-12, 1.082323970209728E-28}, {0.8902506875526984, 0.31738700759959076, 0.05435350173179798, 0.006145740803968602, 5.191840179216794E-4, 3.502131414662897E-5, 5.002309402806162E-12, 1.3750733919350994E-28}, {0.8876982373708832, 0.3207230020797375, 0.05560470992246218, 0.0063635268759223845, 5.44056629794153E-4, 3.713935695000246E-5, 5.629373919124631E-12, 1.7420585084830887E-28}, {0.885119160300348, 0.32404370373995706, 0.05686835057162, 0.0065862414438801085, 5.698015552414149E-4, 3.935803567122669E-5, 6.326262890372653E-12, 2.2008814547560166E-28}, {0.8825135793075155, 0.32734895675068776, 0.05814434238986294, 0.006813930547375136, 5.964381909571902E-4, 4.1680842937394765E-5, 7.0997959214939855E-12, 2.773035436572247E-28}, {0.8798816186021653, 0.3306386061034915, 0.05943260328275373, 0.0070466398212456266, 6.239861028624046E-4, 4.411134764533492E-5, 7.957367398526342E-12, 3.4847039592182787E-28}, {0.877223403630833, 0.33391249761922487, 0.06073305035575374, 0.007284414491751224, 6.52465024172314E-4, 4.665319557814662E-5, 8.906987396729912E-12, 4.367712011346333E-28}, {0.8745390610701429, 0.3371704779561629, 0.062045599919198426, 0.007527299372717295, 6.818948534457053E-4, 4.93101100127659E-5, 9.957324973340608E-12, 5.46065583015171E-28}, {0.871828718820077, 0.3404123946180767, 0.06337016749332064, 0.007775338861707019, 7.122956526163203E-4, 5.2085892318480594E-5, 1.111775395362924E-11, 6.810242151737364E-28}, {0.8690925059971776, 0.3436380959622635, 0.06470666781332125, 0.008028576936221556, 7.43687645006644E-4, 5.498442254631515E-5, 1.2398401322520147E-11, 8.472872755073844E-28}, {0.8663305529276886, 0.34684743120752937, 0.06605501483448718, 0.008287057149928615, 7.760912133242174E-4, 5.8009660009207206E-5, 1.3810198337666325E-11, 1.0516515722046476E-27}, {0.8635429911406303, 0.3500402504421228, 0.06741512173735596, 0.008550822628919572, 8.095268976406121E-4, 6.116564385289697E-5, 1.5364934483592198E-11, 1.302291125268159E-27}, {0.8607299533608135, 0.35321640463162146, 0.06878690093292722, 0.008819916067995523, 8.440153933532327E-4, 6.44564936174533E-5, 1.7075314390300817E-11, 1.6090167197622761E-27}, {0.8578915735017886, 0.3563757456267681, 0.0701702640679201, 0.009094379726982425, 8.795775491300913E-4, 6.788640978935926E-5, 1.8955017843599005E-11, 1.9835807815212042E-27}, {0.8550279866587336, 0.3595181261712584, 0.0715651220300768, 0.009374255427075609, 9.162343648377101E-4, 7.145967434408193E-5, 2.1018763018322967E-11, 2.4400348757361057E-27}, {0.8521393291012792, 0.362643399909478, 0.07297138495351164, 0.009659584547213957, 9.54006989452315E-4, 7.518065127905175E-5, 2.328237306964749E-11, 2.995148208068157E-27}, {0.8492257382662727, 0.3657514213941897, 0.07438896222410538, 0.009950408020483902, 9.92916718954467E-4, 7.905378713697714E-5, 2.5762846221734957E-11, 3.668896732714548E-27}, {0.8462873527504802, 0.36884204609417004, 0.07581776248494473, 0.010246766330553603, 0.0010329849942073027, 8.308361151942145E-5, 2.8478429497126216E-11, 4.485033859967947E-27}, {0.8433243123032284, 0.37191513040179397, 0.07725769364180615, 0.010548699508137457, 0.0010742333988185307, 8.727473759056967E-5, 3.1448696234493014E-11, 5.471755326990356E-27}, {0.8403367578189852, 0.37497053164056915, 0.07870866286868432, 0.010856247127491213, 0.0011166836569863573, 9.16318625711134E-5, 3.469462754666354E-11, 6.662472571644169E-27}, {0.8373248313298813, 0.3780081080726173, 0.0801705766133644, 0.011169448302937961, 0.001160357631329495, 9.61597682221835E-5, 3.823869787519622E-11, 8.09671095450949E-27}, {0.834288675998171, 0.38102771890610293, 0.08164334060303785, 0.011488341685425181, 0.001205277320701422, 1.008633213192601E-4, 4.210496480221459E-11, 9.821151435462378E-27}, {0.8312284361086343, 0.38402922430261044, 0.08312685984996196, 0.011812965459113142, 0.0012514648579890588, 1.0574747411599144E-4, 4.6319163284726956E-11, 1.1890836858003026E-26}, {0.828144257060921, 0.38701248538446714, 0.08462103865716195, 0.012143357337994858, 0.0012989425078960273, 1.108172647978533E-4, 5.090880448123871E-11, 1.4370566859594727E-26}, {0.8250362853618345, 0.3899773642420124, 0.08612578062417589, 0.012479554562547814, 0.0013477326647106532, 1.1607781792558068E-4, 5.590327934512196E-11, 1.7336508645651497E-26}, {0.8219046686175594, 0.3929237239408134, 0.08764098865284191, 0.012821593896417715, 0.0013978578500588904, 1.2153434486830655E-4, 6.133396716394105E-11, 2.087805447821779E-26}, {0.8187495555258315, 0.3958514285288261, 0.08916656495312741, 0.013169511623134537, 0.0014493407106423355, 1.2719214422634144E-4, 6.723434922873543E-11, 2.5099960781535157E-26}, {0.815571095868049, 0.3987603430435014, 0.09070241104899975, 0.013523343542860979, 0.001502204015961496, 1.3305660224352894E-4, 7.364012782214107E-11, 3.01248083036737E-26}, {0.8123694405013295, 0.4016503335188365, 0.09224842778433828, 0.01388312496917369, 0.0015564706560244911, 1.391331932091131E-4, 8.058935071918537E-11, 3.6095827849048616E-26}, {0.8091447413505088, 0.4045212669923695, 0.0938045153288873, 0.014248890725877348, 0.001612163639041357, 1.454274798490553E-4, 8.812254139961614E-11, 4.318014176893894E-26}, {0.8058971514000856, 0.4073730115121194, 0.09537057318424953, 0.014620675143851954, 0.0016693060891041322, 1.5194511370673824E-4, 9.628283517572707E-11, 5.157247772968107E-26}, {0.8026268246861085, 0.4102054361434689, 0.09694650018991974, 0.014998512057933441, 0.0017279212438528937, 1.5869183551299503E-4, 1.0511612144481486E-10, 6.149941834073178E-26}, {0.7993339162880118, 0.4130184109759902, 0.09853219452935814, 0.015382434803827866, 0.0017880324521279262, 1.6567347554540427E-4, 1.1467119228065373E-10, 7.322425809359839E-26}, {0.7960185823203937, 0.41581180713021476, 0.10012755373610362, 0.01577247621505943, 0.001849663171608202, 1.728959539767909E-4, 1.2499989758369444E-10, 8.705254782121791E-26}, {0.7926809799247414, 0.4185854967643441, 0.1017324746999254, 0.016168668619952434, 0.001912836966436341, 1.8036528121287396E-4, 1.3615730701508845E-10, 1.03338416626993E-25}, {0.7893212672611045, 0.421339353080904, 0.10334685367301415, 0.01657104383864752, 0.00197757750483025, 1.8808755821900488E-4, 1.4820187894511315E-10, 1.2249177205306134E-25}, {0.7859396034997119, 0.42407325033333937, 0.10497058627621102, 0.016979633180152293, 0.0020439085566816, 1.960689768359382E-4, 1.6119563665211028E-10, 1.4498649126726956E-25}, {0.7825361488125409, 0.4267870638325515, 0.10660356750527474, 0.01739446743942657, 0.0021118539911413377, 2.0431582008457953E-4, 1.7520435201367162E-10, 1.713697293664056E-25}, {0.7791110643648287, 0.4294806699533753, 0.10824569173718641, 0.01781557689450245, 0.002181437774192415, 2.128344624596567E-4, 1.9029773693749553E-10, 2.022724856487982E-25}, {0.7756645123065378, 0.4321539461409983, 0.1098968527364916, 0.018242991303639444, 0.0022526839662099078, 2.216313702122578E-4, 2.065496427850943E-10, 2.3842158504320204E-25}, {0.7721966557637658, 0.4348067709173189, 0.1115569436616791, 0.018676739902514807, 0.002325616719508727, 2.3071310162118644E-4, 2.240382680473813E-10, 2.806532499461641E-25}, {0.7687076588301078, 0.43743902388724515, 0.11322585707159623, 0.019116851401449253, 0.002400260275879089, 2.4008630725307886E-4, 2.428463745370622E-10, 3.299284576833348E-25}, {0.7651976865579666, 0.44005058574493355, 0.11490348493190049, 0.019563353982668407, 0.0024766389641099553, 2.497577302112344E-4, 2.6306151236874534E-10, 3.8735030085246576E-25}, {0.7616669049498139, 0.44264133827996566, 0.11658971862154653, 0.020016275297599914, 0.0025547771975006008, 2.5973420637310775E-4, 2.8477625400373683E-10, 4.541835921236017E-25}, {0.758115480949403, 0.44521116438346553, 0.11828444893930871, 0.020475642464206658, 0.0026346994713605304, 2.7002266461641385E-4, 3.080884376426133E-10, 5.318769818784493E-25}, {0.7545435824329316, 0.4477599480541544, 0.1199875661103387, 0.020941482064356115, 0.002716430360497909, 2.8063012703379817E-4, 3.331014202548609E-10, 6.22087886597265E-25}, {0.7509513782001573, 0.4502875744043438, 0.12169895979275704, 0.02141382014122605, 0.0027999945166967076, 2.9156370913602334E-4, 3.5992434054114314E-10, 7.267105583983873E-25}, {0.7473390379654652, 0.45279392966586735, 0.12341851908427968, 0.02189268219674682, 0.0028854166661827587, 3.028306200436283E-4, 3.886723921300993E-10, 8.47907661873945E-25}, {0.7437067323488877, 0.45527890119594916, 0.12514613252887774, 0.022378093189080434, 0.0029727216070789156, 3.144381626670129E-4, 4.1946710731798427E-10, 9.8814576363897E-25}, {0.7400546328670792, 0.45774237748301044, 0.12688168812347075, 0.02287007753013636, 0.003061934206849487, 3.263937338749026E-4, 4.5243665166595055E-10, 1.1502351831374574E-24}, {0.7363829119242418, 0.4601842481524118, 0.12862507332465267, 0.0233686590831246, 0.003153079399734175, 3.387048246511532E-4, 4.877161297763193E-10, 1.3373747005711593E-24}, {0.7326917428030083, 0.4626044039721343, 0.1303761750554511, 0.02387386116014595, 0.0032461821841716972, 3.513790202398511E-4, 5.254479025758167E-10, 1.5532016697055339E-24}, {0.7289812996552792, 0.46500273685839444, 0.1321348797121178, 0.02438570651981959, 0.0033412676202132646, 3.644240002786658E-4, 5.657819164404405E-10, 1.8018481401625084E-24}, {0.725251757493013, 0.4673791398811967, 0.1339010731709515, 0.024904217364948484, 0.0034383608269261713, 3.778475389204197E-4, 6.088760445033877E-10, 2.088003656063185E-24}, {0.7215032921789748, 0.46973350726982155, 0.135674640795152, 0.025429415340222312, 0.0035374869797876246, 3.9165750494283E-4, 6.548964404943027E-10, 2.416985466000616E-24}, {0.7177360804174404, 0.47206573441824834, 0.1374554674417051, 0.025961321529958448, 0.0036386713080690677, 4.058618618463878E-4, 7.040179054650039E-10, 2.7948169538049973E-24}, {0.713950299744857, 0.4743757178905142, 0.1392434374682979, 0.026499956455881015, 0.003741939092211168, 4.2046866794033625E-4, 7.564242677638235E-10, 3.2283151809510488E-24}, {0.7101461285204618, 0.47666335542600685, 0.1410384347402646, 0.027045340074938137, 0.003847315661189679, 4.354860764167109E-4, 8.123087766277114E-10, 3.725188520331311E-24}, {0.7063237459168579, 0.47892854594469275, 0.14284034263756182, 0.027597491777157628, 0.0039548263898723755, 4.509223354124072E-4, 8.718745097683847E-10, 4.2941454581053115E-24}, {0.7024833319105489, 0.48117118955227883, 0.14464904406177292, 0.02815643038354121, 0.004064496696367264, 4.6678578805924107E-4, 9.35334795335935E-10, 4.94501574610487E-24}, {0.6986250672724331, 0.4833911875453088, 0.1464644214431416, 0.028722174143997404, 0.004176352039362271, 4.830848725219689E-4, 1.0029136486505857E-9, 5.688885202553666E-24}, {0.6947491335582563, 0.48558844241619276, 0.1482863567476338, 0.029294740735313362, 0.0042904179154566145, 4.998281220242351E-4, 1.0748462241005467E-9, 6.538245584419951E-24}, {0.6908557130990252, 0.4877628578581704, 0.15011473148402743, 0.029874147259165547, 0.004406719856484054, 5.170241648624141E-4, 1.15137928261131E-9, 7.507161091398495E-24}, {0.6869449889913799, 0.4899143387702074, 0.15194942671103012, 0.030460410240169763, 0.004525283426828255, 5.346817244073236E-4, 1.2327716750991614E-9, 8.611453210205562E-24}, {0.6830171450879308, 0.4920427912618244, 0.1537903230444236, 0.031053545623970186, 0.0046461342207304, 5.528096190937639E-4, 1.3192948423291216E-9, 9.868905769526742E-24}, {0.6790723659875539, 0.4941481226578592, 0.15563730066423528, 0.031653568775368054, 0.004769297859589358, 5.71416762397878E-4, 1.4112333316051879E-9, 1.1299492251610862E-23}, {0.6751108370256493, 0.49623024150316075, 0.15749023932193584, 0.03226049447648982, 0.004894799989254524, 5.905121628022842E-4, 1.5088853307282575E-9, 1.2925627597252672E-23}, {0.6711327442643628, 0.4982890575672155, 0.1593490183476631, 0.03287433692499493, 0.0050226662773115854, 6.101049237489683E-4, 1.612563219664871E-9, 1.4772446947933054E-23}, {0.6671382744827704, 0.5003244818487057, 0.1612135166574708, 0.03349510973232356, 0.005152922410361422, 6.302042435799043E-4, 1.7225941403776164E-9, 1.686811399344884E-23}, {0.6631276151670272, 0.5023364265799991, 0.1630836127606029, 0.034122825921984096, 0.005285594091292321, 6.508194154653827E-4, 1.8393205852758534E-9, 1.9244161836814254E-23}, {0.65910095450048, 0.5043248052315706, 0.1649591847667922, 0.03475749792788094, 0.005420707036545747, 6.719598273200214E-4, 1.9631010047532775E-9, 2.1935869551996497E-23}, {0.6550584813537444, 0.5062895325163538, 0.16684011039358307, 0.03539913759268223, 0.005558286973375855, 6.936349617064381E-4, 2.0943104342867502E-9, 2.4982677895700052E-23}, {0.6510003852747486, 0.5082305243940247, 0.16872626697367843, 0.036047756166228156, 0.005698359637102982, 7.158543957265657E-4, 2.2333411415788324E-9, 2.8428647943587293E-23}, {0.6469268564787422, 0.5101476980752159, 0.17061753146230896, 0.036703364303979406, 0.005840950768361279, 7.386278009005841E-4, 2.380603294234446E-9, 3.232296675577396E-23}, {0.6428380858382724, 0.5120409720256603, 0.1725137804446264, 0.03736597206550646, 0.005986086110340768, 7.619649430334598E-4, 2.5365256484702457E-9, 3.672050453804725E-23}, {0.6387342648731262, 0.5139102659702666, 0.17441489014311834, 0.038035588913019315, 0.006133791406023964, 7.858756820690675E-4, 2.701556259363375E-9, 4.168242815602386E-23}, {0.6346155857402414, 0.5157555008971223, 0.1763207364250452, 0.03871222370993806, 0.006284092395417319, 8.103699719318787E-4, 2.8761632131544997E-9, 4.7276876281530017E-23}, {0.6304822412235853, 0.5175765990614299, 0.17823119480989896, 0.03939588471950435, 0.0064370148127776885, 8.354578603562067E-4, 3.0608353821283267E-9, 5.357970190612889E-23}, {0.626334424724002, 0.5193734839893699, 0.18014614047688285, 0.04008657960343389, 0.006592584383834039, 8.611494887029882E-4, 3.2560832026030253E-9, 6.067528844835853E-23}, {0.6221723302490302, 0.521146080481894, 0.18206544827241125, 0.04078431542060982, 0.006750826823004573, 8.874550917640867E-4, 3.462439476568415E-9, 6.865744621147342E-23}, {0.6179961524026885, 0.522894314618448, 0.18398899271763056, 0.04148909862581752, 0.006911767830609578, 9.143849975541169E-4, 3.680460197521212E-9, 7.763039652004374E-23}, {0.6138060863752343, 0.5246181137606227, 0.18591664801595903, 0.04220093506852055, 0.007075433090080091, 9.419496270897614E-4, 3.910725401053976E-9, 8.770985147959591E-23}, {0.6096023279328918, 0.5263174065557353, 0.1878482880606464, 0.042919829991678, 0.007241848265162708, 9.701594941565875E-4, 4.153840040763104E-9, 9.90241979666844E-23}, {0.605385073407552, 0.5279921229403363, 0.18978378644235197, 0.04364578803060328, 0.0074110389971206595, 9.990252050633384E-4, 4.410434890049577E-9, 1.1171579517068592E-22}, {0.6011545196864452, 0.5296421941436485, 0.19172301645674136, 0.04437881321186449, 0.007583030901931449, 0.0010285574583837058, 4.681167470394978E-9, 1.2594239577671516E-22}, {0.5969108642017853, 0.5312675526909317, 0.19366585111210113, 0.04511890895222645, 0.007757849567481219, 0.0010587670446855686, 4.966723006703803E-9, 1.418787017051301E-22}, {0.5926543049203898, 0.5328681324067757, 0.1956121631369706, 0.04586607805763442, 0.007935520550756078, 0.0010896648462476912, 5.267815410311905E-9, 1.597180662110808E-22}, {0.5883850403332711, 0.5344438684183223, 0.197561824987791, 0.04662032272223957, 0.008116069375030587, 0.0011212618367638803, 5.58518829026957E-9, 1.7967435510168966E-22}, {0.5841032694452035, 0.535994697158414, 0.1995147088565711, 0.04738164452746645, 0.008299521527053681, 0.0011535690810345993, 5.919615993516648E-9, 2.0198398085320953E-22}, {0.5798091917642659, 0.5375205563686702, 0.20147068667856866, 0.04815004444112232, 0.008485902454232157, 0.0011865977346460267, 6.271904674575845E-9, 2.269081245106268E-22}, {0.5755030072913588, 0.5390213851024921, 0.20342963013998805, 0.048925522816548564, 0.00867523756181203, 0.0012203590436365727, 6.642893395399314E-9, 2.547351614327085E-22}, {0.5711849165096987, 0.5404971237279924, 0.20539141068569272, 0.04970807939181416, 0.00886755221005791, 0.0012548643441508403, 7.033455256012515E-9, 2.8578330821177913E-22}, {0.5668551203742886, 0.5419477139308545, 0.2073558995269321, 0.050497713288951314, 0.009062871711430661, 0.0012901250620810352, 7.444498556608236E-9, 3.204035094551872E-22}, {0.562513820301367, 0.543373098717117, 0.20932296764908334, 0.0512944230132334, 0.009261221327763544, 0.0013261527126958344, 7.876967991752916E-9, 3.5898258457052626E-22}, {0.5581612181578328, 0.5447732224158855, 0.21129248581940674, 0.05209820645249514, 0.009462626267437076, 0.0013629589002567073, 8.331845877376088E-9, 4.0194665625551027E-22}, {0.5537975162506513, 0.5461480306819713, 0.213264324594814, 0.05290906087649506, 0.00966711168255278, 0.0014005553176216917, 8.810153411223036E-9, 4.497648840627044E-22}, {0.5494229173162384, 0.5474974704984561, 0.21523835432964997, 0.05372698293632046, 0.00987470266610612, 0.00143895374583664, 9.312951967460002E-9, 5.029535281962561E-22}, {0.5450376245098233, 0.548821490179183, 0.2172144451834864, 0.05455196866383484, 0.01008542424915878, 0.001478166053713934, 9.841344426130147E-9, 5.620803706097539E-22}, {0.5406418413947935, 0.5501200393711742, 0.21919246712892776, 0.05538401347116777, 0.010299301398010526, 0.0015182041973986799, 1.0396476538167808E-8, 6.277695225194602E-22}, {0.5362357719320199, 0.5513930690569746, 0.2211722899594288, 0.0562231121502474, 0.0105163590113709, 0.0015590802199223865, 1.0979538326687811E-8, 7.007066496337496E-22}, {0.5318196204691633, 0.5526405315569213, 0.22315378329712254, 0.057069258872375433, 0.010736621917530881, 0.001600806250744141, 1.1591765525275721E-8, 7.816446487365608E-22}, {0.5273935917299633, 0.5538623805313383, 0.22513681660065943, 0.057922447187845, 0.01096011487153487, 0.0016433945052792933, 1.2234441054014418E-8, 8.714098117594364E-22}, {0.5229578908035095, 0.5550585709826585, 0.22712125917305595, 0.05878267002560089, 0.011186862552353061, 0.0016868572844156572, 1.2908896533991361E-8, 9.709085161432061E-22}, {0.5185127231334976, 0.5562290592574701, 0.2291069801695536, 0.05964991969294284, 0.011416889560054575, 0.0017312069740172426, 1.3616513841040542E-8, 1.0811344831370379E-21}, {0.5140582945074667, 0.5573738030484888, 0.23109384860548626, 0.06052418787527128, 0.011650220412981435, 0.0017764560444155353, 1.435872669948229E-8, 1.2031766487205162E-21}, {0.5095948110460232, 0.5584927613964553, 0.23308173336415663, 0.061405465635876136, 0.01188687954492372, 0.0018226170498883338, 1.5137022316633415E-8, 1.3382276950752979E-21}, {0.5051224791920501, 0.5595858946919589, 0.2350705032047208, 0.06229374341576824, 0.012126891302296043, 0.0018697026281261674, 1.5952943058869944E-8, 1.4875932939890065E-21}, {0.5006415056998996, 0.5606531646771851, 0.23706002677008076, 0.06318901103355376, 0.012370279941315612, 0.001917725499686304, 1.6808088170033522E-8, 1.6527021172584261E-21}, {0.4961520976245751, 0.56169453444759, 0.23905017259478356, 0.06409125768535125, 0.012617069625182055, 0.0019666984674343692, 1.770411553298255E-8, 1.83511667308536E-21}, {0.49165446231089743, 0.5627099684534979, 0.2410408091129279, 0.06500047194475193, 0.012867284421259305, 0.0020166344159736043, 1.8642743475098376E-8, 2.0365450316412547E-21}, {0.48714880738266053, 0.5636994325016254, 0.24303180466607696, 0.06591664176282264, 0.01312094829825969, 0.0020675463110617675, 1.9625752618566135E-8, 2.25885350743097E-21}, {0.48263534073177405, 0.5646628937565296, 0.24502302751117633, 0.06683975446815163, 0.013378085123430463, 0.0021194471990157123, 2.0654987776259647E-8, 2.5040803708279956E-21}, {0.47811427050739547, 0.5656003207419817, 0.24701434582847862, 0.06776979676693765, 0.013638718659743055, 0.0021723502061036675, 2.173235989406925E-8, 2.7744506661998374E-21}, {0.4735858051050505, 0.5665116833422654, 0.2490056277294717, 0.06870675474312155, 0.013902872563085165, 0.0022262685379252265, 2.285984804052059E-8, 3.072392219410984E-21}, {0.46905015315574483, 0.5673969528033991, 0.25099674126481236, 0.06965061385856117, 0.014170570379456035, 0.0022812154787790937, 2.4039501444542487E-8, 3.400552923200441E-21}, {0.4645075235150648, 0.5682561017342835, 0.25298755443226284, 0.07060135895324894, 0.014441835542164973, 0.00233720439101859, 2.5273441582251052E-8, 3.7618193950011294E-21}, {0.45995812525227064, 0.5690891041077748, 0.2549779351846323, 0.07155897424557267, 0.014716691369033563, 0.0023942487143949714, 2.656386431362716E-8, 4.159337108220021E-21}, {0.4554021676393807, 0.5698959352616804, 0.2569677514377197, 0.07252344333261901, 0.014995161059601513, 0.0024523619653885574, 2.7913042069973564E-8, 4.596532104852547E-21}, {0.45083986014024763, 0.5706765718996808, 0.2589568710782608, 0.07349474919052011, 0.015277267692336616, 0.002511557736527729, 2.9323326093047918E-8, 5.077134404585524E-21}, {0.4462714123996287, 0.5714309920921754, 0.26094516197187545, 0.0744728741748431, 0.01556303422184886, 0.002571849695695803, 3.0797148726777134E-8, 5.605203233273418E-21}, {0.44169703423224804, 0.5721591752770524, 0.2629324919710185, 0.07545780002102251, 0.015852483476109014, 0.0026332515854258303, 3.233702576246839E-8, 6.185154201878912E-21}, {0.43711693561185494, 0.5728611022603844, 0.2649187289229298, 0.07644950784483566, 0.016145638153671878, 0.0026957772221833424, 3.3945558838441594E-8, 6.821788575676476E-21}, {0.43253132666027483, 0.5735367552170464, 0.2669037406775866, 0.07744797814292087, 0.016442520820904378, 0.0027594404956370793, 3.56254378950174E-8, 7.520324782755169E-21}, {0.4279404176364572, 0.5741861176912603, 0.26888739509565474, 0.0784531907933386, 0.016743153909218805, 0.0028242553679177374, 3.737944368580512E-8, 8.286432320653632E-21}, {0.42334441892551883, 0.5748091745970624, 0.27086956005644053, 0.07946512505617553, 0.017047559712311346, 0.002890235872864774, 3.921045034624354E-8, 9.126268230346484E-21}, {0.41874354102778377, 0.575405912218696, 0.2728501034658411, 0.08048375957419124, 0.017355760383406128, 0.0029573961152612946, 4.112142802035793E-8, 1.0046516317809593E-20}, {0.41413799454782, 0.5759763182109272, 0.27482889326429394, 0.081509072373508, 0.0176677779325051, 0.0030257502700570802, 4.311544554670598E-8, 1.1054429315056044E-20}, {0.4095279901834746, 0.5765203815992875, 0.27680579743472494, 0.08254104086434325, 0.01798363422364383, 0.0030953125815797794, 4.519567320449457E-8, 1.2157874184890128E-20}, {0.4049137387149064, 0.5770380927802373, 0.2787806840104933, 0.08357964184178462, 0.018303350972153493, 0.0031660973627342984, 4.7365385520859056E-8, 1.3365380786710279E-20}, {0.4002954509936191, 0.5775294435212567, 0.28075342108333456, 0.0846248514866079, 0.018626949741929247, 0.0032381189941904486, 4.962796414030639E-8, 1.46861941345447E-20}, {0.39567333793149195, 0.5779944269608593, 0.2827238768113008, 0.08567664536613774, 0.018954451942705383, 0.0033113919235588933, 5.1986900757333166E-8, 1.613033049316211E-20}, {0.3910476104898124, 0.5784330376085309, 0.2846919194266957, 0.0867349984351507, 0.019285878827337108, 0.0033859306645554117, 5.4445800113237815E-8, 1.7708637573612847E-20}, {0.38641847966830833, 0.5788452713445915, 0.2866574172440074, 0.08779988503682112, 0.019621251489089556, 0.003461749796153551, 5.70083830581579E-8, 1.9432859105962742E-20}, {0.3817861564941825, 0.5792311254199833, 0.2886202386678353, 0.08887127890370956, 0.019960590858934018, 0.0035388639617257075, 5.967848967937088E-8, 2.1315704084333377E-20}, {0.3771508520111486, 0.5795905984559827, 0.2905802522008129, 0.08994915315879363, 0.020303917702851688, 0.0036172878681726747, 6.246008249690709E-8, 2.3370920997706367E-20}, {0.37251277726847026, 0.5799236904438348, 0.2925373264515239, 0.09103348031654111, 0.020651252619145057, 0.003697036285041693, 6.535724972753302E-8, 2.5613377379337095E-20}, {0.367872143310002, 0.5802304027443164, 0.2944913301424139, 0.09212423228402601, 0.021002616035757347, 0.0037781240436331014, 6.837420861817297E-8, 2.8059145028108906E-20}, {0.36322916116323634, 0.5805107380872189, 0.2964421321176943, 0.09322138036208634, 0.02135802820760002, 0.0038605660360955764, 7.151530884984465E-8, 3.0725591276800645E-20}, {0.358584041828353, 0.58076470057076, 0.29838960135123976, 0.0943248952465245, 0.021717509213888632, 0.003944377214510045, 7.478503601319598E-8, 3.3631476705093705E-20}, {0.35393699626727465, 0.5809922956609167, 0.30033360695447836, 0.09543474702934983, 0.022081078955487297, 0.004029572589962325, 7.818801515673817E-8, 3.6797059719275446E-20}, {0.34928823539272746, 0.5811935301906851, 0.30227401818427385, 0.0965509052000633, 0.02244875715226193, 0.004116167231604525, 8.172901440887981E-8, 4.0244208446066376E-20}, {0.34463797005730823, 0.5813684123592645, 0.30421070445079945, 0.09767333864698423, 0.02282056334044245, 0.00420417626570528, 8.54129486748762E-8, 4.399652041487619E-20}, {0.3399864110425583, 0.5815169517311651, 0.306143535325403, 0.09880201565861921, 0.02319651686999432, 0.00429361487468887, 8.924488340981729E-8, 4.8079450531151087E-20}, {0.3353337690480449, 0.5816391592352428, 0.30807238054846253, 0.09993690392507248, 0.02357663690199928, 0.004384498296163245, 9.323003846878587E-8, 5.2520447873383205E-20}, {0.3306802546804506, 0.5817350471636562, 0.3099971100372325, 0.10107797053949893, 0.023960942406045977, 0.004476841821937091, 9.737379203532913E-8, 5.734910187789351E-20}, {0.32602607844267095, 0.5818046291707517, 0.31191759389367957, 0.10222518199959821, 0.0243494521576303, 0.004570660797025912, 1.0168168462939286E-7, 6.25972985087461E-20}, {0.321371450722922, 0.5818479202718706, 0.3138337024123078, 0.1033785042091507, 0.024742184735565727, 0.004665970618647225, 1.0615942319587852E-7, 6.829938704519748E-20}, {0.3167165817838575, 0.5818649368420833, 0.31574530608797224, 0.10453790247959545, 0.02513915851940409, 0.004762786735204938, 1.108128852749928E-7, 7.449235815600961E-20}, {0.31206168175169596, 0.5818556966148496, 0.31765227562368237, 0.10570334153164912, 0.02554039168686669, 0.004861124645262956, 1.1564812325556627E-7, 8.121603396885527E-20}, {0.3074069606053591, 0.5818202186806003, 0.3195544819383912, 0.10687478549696686, 0.025945902211286186, 0.004960999896508065, 1.206713687125288E-7, 8.851327088401528E-20}, {0.3027526281656229, 0.5817585234852497, 0.3214517961747737, 0.10805219791984412, 0.026355707859059295, 0.005062428084702192, 1.2588903682973645E-7, 9.643017592470649E-20}, {0.29809889408427864, 0.5816706328286291, 0.3233440897069917, 0.10923554175895993, 0.02676982618711066, 0.00516542485262407, 1.3130773090935538E-7, 1.0501633746179588E-19}, {0.2934459678333093, 0.5815565698628489, 0.32523123414844485, 0.11042477938916138, 0.02718827454036802, 0.005270005889000399, 1.3693424696901553E-7, 1.1432507119845336E-19}, {0.288794058694077, 0.5814163590905844, 0.3271131013595083, 0.11161987260328891, 0.027611070049248853, 0.00537618692742654, 1.4277557842795536E-7, 1.2441368235058932E-19}, {0.28414337574652637, 0.5812500263632892, 0.32898956345525543, 0.1128207826140429, 0.02803822962715878, 0.0054839837452768485, 1.488389208833898E-7, 1.353437450118383E-19}, {0.2794941278584016, 0.581057598879333, 0.33086049281316654, 0.1140274700558908, 0.02846976996800193, 0.005593412162604689, 1.5513167697833936E-7, 1.4718139974749421E-19}, {0.2748465236744786, 0.5808391051820665, 0.332725762080821, 0.11523989498701508, 0.028905707543703293, 0.005704488041032179, 1.6166146136216883E-7, 1.599976705203225E-19}, {0.27020077160581324, 0.5805945751578127, 0.334585244183575, 0.11645801689130195, 0.02934605860174362, 0.005817227282629796, 1.6843610574509219E-7, 1.738688021126935E-19}, {0.26555707981900545, 0.5803240400337834, 0.33643881233222206, 0.1176817946803704, 0.02979083916270666, 0.005931645828785855, 1.7546366404790762E-7, 1.8887661927414098E-19}, {0.2609156562254817, 0.5800275323759233, 0.33828634003063757, 0.11891118669564188, 0.030240065017839296, 0.006047759659065959, 1.827524176482365E-7, 2.0510890889139301E-19}, {0.256276708470793, 0.5797050860866808, 0.34012770108340534, 0.12014615071044962, 0.03069375172662444, 0.0061655847900624824, 1.9031088072454717E-7, 2.2265982654931854E-19}, {0.2516404439239324, 0.5793567364027032, 0.3419627696034276, 0.12138664393218927, 0.031151914614367327, 0.006285137274234198, 1.9814780569925483E-7, 2.416303289262065E-19}, {0.24700706966667116, 0.5789825198924637, 0.3437914200195163, 0.12263262300450829, 0.03161456876979486, 0.006406433198736048, 2.0627218878219205E-7, 2.6212863354554084E-19}, {0.24237679248291333, 0.5785824744538093, 0.345613527083966, 0.1238840440095362, 0.032081729042668754, 0.006529488684239215, 2.1469327561576012E-7, 2.8427070748911737E-19}, {0.23774981884807123, 0.5781566393114409, 0.3474289658801078, 0.12514086247015388, 0.03255341004141216, 0.00665431988374151, 2.2342056702307015E-7, 3.081807867631272E-19}, {0.2331263549184605, 0.5777050550143186, 0.3492376118298445, 0.12640303335230343, 0.03302962613075056, 0.006780942981368215, 2.3246382486040197E-7, 3.3399192809992503E-19}, {0.22850660652071716, 0.5772277634329943, 0.3510393407011647, 0.12767051106733635, 0.033510391429366425, 0.006909374191163373, 2.4183307797530347E-7, 3.6184659507376806E-19}, {0.22389077914123565, 0.5767248077568734, 0.35283402861563773, 0.12894324947440208, 0.033995719807568436, 0.007039629755871687, 2.515386282716737E-7, 3.918972805090754E-19}, {0.21927907791562887, 0.5761962324914023, 0.3546215520558874, 0.13022120188287534, 0.03448562488497519, 0.007171725945711077, 2.6159105688317195E-7, 4.2430716726492597E-19}, {0.21467170761821167, 0.5756420834551862, 0.3564017878730445, 0.13150432105482274, 0.034980120028213595, 0.007305679057135966, 2.7200123045630656E-7, 4.592508295897905E-19}, {0.21006887265150725, 0.5750624077770333, 0.35817461329417793, 0.13279255920750793, 0.03547921834863213, 0.00744150541159138, 2.827803075445617E-7, 4.96914977356107E-19}, {0.20547077703577765, 0.5744572538929286, 0.3599399059297032, 0.13408586801593608, 0.03598293270002929, 0.007579221354257963, 2.939397451149345E-7, 5.374992456055284E-19}, {0.20087762439857834, 0.5738266715429349, 0.3616975437807695, 0.13538419861543674, 0.0364912756763973, 0.007718843252787991, 3.054913051682518E-7, 5.812170319626641E-19}, {0.19628961796433905, 0.5731707117680249, 0.3634474052466227, 0.1366875016042851, 0.03700425960968128, 0.007860387496032422, 3.1744706147465313E-7, 6.282963846082624E-19}, {0.19170696054396844, 0.5724894269068397, 0.3651893691319456, 0.1379957270463619, 0.037521896567554114, 0.008003870492759146, 3.2981940642562684E-7, 6.789809436421869E-19}, {0.18712985452448644, 0.5717828705923778, 0.3669233146541741, 0.13930882447385115, 0.038044198351207106, 0.008149308670362452, 3.4262105800399774E-7, 7.335309388126124E-19}, {0.182558501858683, 0.5710510977486133, 0.3686491214507893, 0.14062674288997606, 0.038571176493156833, 0.008296718473563837, 3.5586506687326743E-7, 7.922242467407887E-19}, {0.1779931040548036, 0.570294164587044, 0.3703666695865849, 0.14194943077177302, 0.0391028422550681, 0.00844611636310425, 3.6956482358772017E-7, 8.553575109308732E-19}, {0.17343386216626352, 0.5695121286031685, 0.37207583956090934, 0.14327683607290292, 0.03963920662559333, 0.00859751881442782, 3.837340659247094E-7, 9.232473280219651E-19}, {0.16888097678139005, 0.5687050485728933, 0.3737765123148821, 0.14460890622650002, 0.040180280318228595, 0.008750942316357195, 3.9838688634054784E-7, 9.962315039149085E-19}, {0.16433464801319378, 0.5678729845488716, 0.3754685692385853, 0.14594558814805864, 0.04072607376918646, 0.008906403369760597, 4.135377395514352E-7, 1.074670383590091E-18}, {0.15979507548916913, 0.5670159978567704, 0.37715189217822703, 0.1472868282383565, 0.041276597135285725, 0.009063918486210635, 4.292014502408556E-7, 1.1589482586244778E-18}, {0.15526245834112642, 0.5661341510914699, 0.3788263634432792, 0.14863257238641525, 0.04183186029185832, 0.009223504186634979, 4.453932208948896E-7, 1.2494748566171446E-18}, {0.15073699519505246, 0.565227508113193, 0.3804918658135876, 0.14998276597249796, 0.04239187283067357, 0.009385176999959057, 4.6212863976689046E-7, 1.3466869169426926E-18}, {0.146218884161004, 0.5642961340435658, 0.38214828254645467, 0.15133735387114314, 0.04295664405788, 0.00954895346174077, 4.794236889729789E-7, 1.4510498574716878E-18}, {0.141708322823033, 0.5633400952616107, 0.38379549738369334, 0.1526962804542352, 0.043526182991964736, 0.00971485011279739, 4.972947527198181E-7, 1.5630595371270769E-18}, {0.1372055082291426, 0.5623594593996689, 0.3854333945586537, 0.15405948959411125, 0.04410049836173078, 0.009882883497824693, 5.157586256661343E-7, 1.683244119385647E-18}, {0.13271063688127815, 0.561354295339257, 0.387061858803219, 0.1554269246667041, 0.0446795986042924, 0.010053070164008485, 5.348325214194594E-7, 1.8121660420846757E-18}, {0.12822390472535, 0.5603246732068544, 0.38868077535477397, 0.1567985285547211, 0.045263491863088756, 0.010225426659628542, 5.545340811695688E-7, 1.950424099156153E-18}, {0.12374550714129119, 0.5592706643696237, 0.39029002996314227, 0.15817424365085833, 0.04585218598591565, 0.010399969532655092, 5.748813824601026E-7, 2.0986556401850972E-18}, {0.11927563893314905, 0.5581923414310623, 0.3918895088974941, 0.1595540118610512, 0.04644568852297626, 0.010576715329338016, 5.958929480998573E-7, 2.257538893974636E-18}, {0.11481449431921242, 0.5570897782265896, 0.39347909895322325, 0.16093777460775935, 0.04704400672495017, 0.010755680592788686, 6.175877552152418E-7, 2.42779542259961E-18}, {0.1103622669221739, 0.5559630498190639, 0.39505868745879325, 0.16232547283328744, 0.047647147541081604, 0.010936881861554759, 6.399852444453989E-7, 2.6101927127426093E-18}, {0.10591914975932841, 0.5548122324942362, 0.3966281622825521, 0.16371704700314071, 0.048255117617286694, 0.011120335668187879, 6.631053292814962E-7, 2.8055469114323494E-18}, {0.10148533523280934, 0.5536374037561347, 0.39818741183951434, 0.1651124371094146, 0.04886792329427966, 0.011306058537804371, 6.8696840555169E-7, 3.014725713644513E-18}, {0.09706101511985947, 0.5524386423223849, 0.39973632509811247, 0.16651158267422023, 0.04948557060571893, 0.011494066986639248, 7.115953610532922E-7, 3.238651409580484E-18}, {0.0926463805631427, 0.5512160281194638, 0.4012747915869144, 0.1679144227531427, 0.05010806527637235, 0.011684377520593304, 7.370075853336319E-7, 3.478304099809766E-18}, {0.0882416220610911, 0.5499696422778879, 0.40280270140130886, 0.16932089593873492, 0.05073541272030242, 0.011877006633773704, 7.632269796211656E-7, 3.734725086848887E-18}, {0.08384692945829329, 0.5486995671273371, 0.4043199452101561, 0.1707309403640438, 0.05136761803907117, 0.01207197080702795, 7.902759669083352E-7, 4.009020452152707E-18}, {0.07946249193591959, 0.5474058861917118, 0.4058264142624064, 0.17214449370617185, 0.05200468601996544, 0.012269286506471529, 8.181775021877258E-7, 4.3023648279150484E-18}, {0.07508849800218968, 0.5460886841841279, 0.4073220003936831, 0.17356149318987038, 0.0526466211342419, 0.012468970182009105, 8.469550828430412E-7, 4.616005373514194E-18}, {0.07072513548287758, 0.5447480470018461, 0.4088065960328319, 0.17498187559116785, 0.053293427535392984, 0.012671038265849675, 8.76632759196455E-7, 4.951265966896543E-18}, {0.06637259151186017, 0.5433840617211356, 0.4102800942084342, 0.17640557724102948, 0.05394510905743281, 0.01287550717101545, 9.07235145213856E-7, 5.309551621668527E-18}, {0.062031052521705585, 0.5419968165920783, 0.41174238855528594, 0.17783253402905094, 0.05460166921320422, 0.013082393289844885, 9.38787429369561E-7, 5.692353141164362E-18}, {0.05770070423430295, 0.5405864010333052, 0.413193373320841, 0.17926268140718418, 0.055263111192706424, 0.013291712992489756, 9.71315385672021E-7, 6.101252021275235E-18}, {0.05338173165153645, 0.5391529056266723, 0.41463294337161644, 0.18069595439349512, 0.055929437861443665, 0.013503482625406465, 1.0048453848520846E-6, 6.53792561436571E-18}, {0.04907431904600063, 0.5376964221118724, 0.4160609941995637, 0.1821322875759542, 0.056600651758795015, 0.013717718509841707, 1.0394044057153703E-6, 7.004152567165755E-18}, {0.04477864995175824, 0.5362170433809857, 0.417477421928402, 0.183571615116259, 0.057276755096405785, 0.013934436940312668, 1.0750200466603255E-6, 7.50181854611311E-18}, {0.0404949071551453, 0.534714863472968, 0.4188821233199132, 0.185013870753687, 0.05795774975659964, 0.014153654183081553, 1.111720537363479E-6, 8.032922264230566E-18}, {0.03622327268561681, 0.5331899775680751, 0.420274995780201, 0.18645898780898146, 0.0586436372908131, 0.014375386474625069, 1.1495347506335292E-6, 8.599581824259986E-18}, {0.031963927806639154, 0.5316424819822286, 0.42165593736591084, 0.18790689918826786, 0.05933441891805135, 0.014599650020098531, 1.1884922144357612E-6, 9.204041393435156E-18}, {0.027717053006627895, 0.5300724741613189, 0.42302484679041197, 0.18935753738700092, 0.060030095523365974, 0.014826460991794908, 1.2286231240884108E-6, 9.848678225966534E-18}, {0.023482827989930562, 0.5284800526754475, 0.42438162342994024, 0.19081083449394268, 0.060730667656354764, 0.015055835527598925, 1.2699583546325157E-6, 1.053601005002726E-17}, {0.019261431667856776, 0.5268653172131103, 0.42572616732970253, 0.19226672219517113, 0.061436135529683786, 0.015287789729436275, 1.312529473376844E-6, 1.1268702836777521E-17}, {0.015053042149753738, 0.5252283685753172, 0.42705837920994083, 0.19372513177811865, 0.0621464990176315, 0.015522339661718058, 1.3563687526194627E-6, 1.2049578969740977E-17}, {0.010857836734130509, 0.5235693086696566, 0.42837816047195726, 0.19518599413564083, 0.0628617576546556, 0.01575950134978065, 1.4015091825475273E-6, 1.2881625833655926E-17}, {0.006675991899829093, 0.521888240504297, 0.42968541320409825, 0.19664923977011475, 0.0635819106339823, 0.01599929077832102, 1.4479844843168657E-6, 1.3768004842765474E-17}, {0.0025076832972438364, 0.520185268181931, 0.4309800401876987, 0.19811479879756683, 0.06430695680621834, 0.016241723889827663, 1.4958291233129395E-6, 1.4712060929385455E-17}, {-0.0016469142604099124, 0.5184604968936599, 0.43226194490298464, 0.19958260095182945, 0.06503689467798585, 0.01648681658300723, 1.5450783225947513E-6, 1.5717332514500018E-17}, {-0.005787626805778896, 0.5167140329128209, 0.4335310315349353, 0.2010525755887276, 0.06577172241058027, 0.016734584711207062, 1.5957680765232864E-6, 1.678756198308075E-17}, {-0.009914281226004707, 0.5149459835887551, 0.43478720497910295, 0.2025246516902927, 0.06651143781865128, 0.01698504408083363, 1.6479351645760677E-6, 1.7926706687809797E-17}, {-0.014026705271306726, 0.5131564573405185, 0.43603037084739105, 0.20399875786900615, 0.06725603836890706, 0.017238210449767075, 1.7016171653493973E-6, 1.9138950505910648E-17}, {-0.018124727563514367, 0.511345563650537, 0.4372604354737905, 0.20547482237207054, 0.06800552117884195, 0.01749409952577198, 1.7568524707498745E-6, 2.0428715974854046E-17}, {-0.022208177604548976, 0.5095134130582007, 0.43847730592007245, 0.20695277308570847, 0.06875988301548755, 0.017752726964904427, 1.8136803003767639E-6, 2.1800677033811982E-17}, {-0.02627688578485289, 0.507660117153407, 0.43968088998143834, 0.20843253753948943, 0.06951912029418732, 0.018014108369915512, 1.8721407160967942E-6, 2.3259772398881827E-17}, {-0.03033068339176838, 0.5057857885700424, 0.4408710961921275, 0.20991404291068405, 0.07028322907739533, 0.01827825928865145, 1.9322746368129755E-6, 2.481121960129618E-17}, {-0.034369402617862595, 0.5038905409794132, 0.44204783383098, 0.21139721602864517, 0.07105220507349853, 0.018545195212450395, 1.9941238534290016E-6, 2.6460529719074897E-17}, {-0.03839287656920084, 0.5019744890836165, 0.4432110129269561, 0.21288198337921593, 0.07182604363566308, 0.018814931574535954, 2.0577310440108257E-6, 2.821352283386365E-17}, {-0.04240093927356617, 0.5000377486088594, 0.4443605442646107, 0.2143682711091642, 0.07260473976070489, 0.019087483748407824, 2.123139789146986E-6, 3.007634424604165E-17}, {-0.04639342568862513, 0.4980804362987228, 0.44549633938952476, 0.2158560050306438, 0.07338828808798444, 0.019362867046229366, 2.1903945875092516E-6, 3.2055481482572074E-17}, {-0.05037017171003992, 0.4961026699073698, 0.4466183106136899, 0.21734511062568115, 0.07417668289832569, 0.01964109671721239, 2.2595408716151673E-6, 3.415778213350953E-17}, {-0.054331014179525586, 0.4941045681927018, 0.44772637102084867, 0.2188355130506878, 0.07496991811295974, 0.01992218794599928, 2.330625023794071E-6, 3.6390472554580577E-17}, {-0.05827579089285236, 0.49208625090946073, 0.4488204344717895, 0.22032713714099864, 0.07576798729249298, 0.020206155851042577, 2.4036943923581606E-6, 3.8761177474805537E-17}, {-0.06220434060779243, 0.4900478388022782, 0.44990041560959476, 0.22181990741543503, 0.0765708836358998, 0.02049301548298207, 2.4787973079801623E-6, 4.12779405497466E-17}, {-0.0661165030520115, 0.48798945359867146, 0.45096622986484386, 0.22331374808089305, 0.07737859997954033, 0.020782781823019646, 2.55598310027919E-6, 4.3949245902642386E-17}, {-0.07001211893090352, 0.4859112180019888, 0.4520177934607689, 0.22480858303695603, 0.07819112879620285, 0.02107546978129192, 2.6353021146163412E-6, 4.678404069742718E-17}, {-0.07389102993536859, 0.48381325568430156, 0.4530550234183635, 0.2263043358805315, 0.07900846219417136, 0.021371094195240817, 2.7168057291016036E-6, 4.9791758789439195E-17}, {-0.07775307874953448, 0.4816956912792457, 0.4540778375614452, 0.22780092991051246, 0.07983059191631832, 0.021669669827982286, 2.800546371813632E-6, 5.2982345501491915E-17}, {-0.08159810905842066, 0.47955865037481216, 0.45508615452167, 0.22929828813246197, 0.08065750933922236, 0.021971211366673123, 2.886577538233935E-6, 5.636628357492575E-17}, {-0.08542596555554315, 0.4774022595060866, 0.4560798937434986, 0.23079633326332116, 0.08148920547231157, 0.02227573342087624, 2.9749538088970414E-6, 5.995462034727178E-17}, {-0.08923649395046335, 0.47522664614793986, 0.45705897548911645, 0.23229498773614135, 0.08232567095703221, 0.022583250520924313, 3.065730867258206E-6, 6.375899621024557E-17}, {-0.09302954097627555, 0.47303193870766674, 0.4580233208433024, 0.233794173704837, 0.08316689606604256, 0.02289377711628206, 3.1589655177801486E-6, 6.779167440395808E-17}, {-0.09680495439703829, 0.4708182665175787, 0.4589728517182527, 0.23529381304896385, 0.08401287070243312, 0.023207327573907276, 3.254715704240448E-6, 7.206557220547422E-17}, {-0.10056258301514283, 0.46858575982754486, 0.45990749085835203, 0.23679382737851665, 0.08486358439897147, 0.023523916176610607, 3.3530405282610322E-6, 7.659429357217769E-17}, {-0.10430227667862545, 0.4663345497974857, 0.4608271618448989, 0.23829413803875105, 0.08571902631737413, 0.02384355712141448, 3.4540002680614006E-6, 8.139216330281557E-17}, {-0.10802388628841612, 0.4640647684898204, 0.4617317891007792, 0.23979466611502598, 0.08657918524760334, 0.02416626451791102, 3.5576563974370084E-6, 8.647426278159572E-17}, {-0.11172726380552962, 0.46177654886186303, 0.46262129789509115, 0.24129533243766754, 0.08744404960719038, 0.024492052386619265, 3.6640716049644153E-6, 9.185646737330217E-17}, {-0.11541226225819258, 0.459470024758176, 0.4634956143477198, 0.24279605758685396, 0.08831360744058457, 0.024820934657341722, 3.773309813434654E-6, 9.755548554008097E-17}, {-0.11907873574891187, 0.4571453309028734, 0.46435466543386156, 0.24429676189752167, 0.08918784641852898, 0.02515292516752054, 3.8854361995163875E-6, 1.0358889975333006E-16}, {-0.1227265394614799, 0.45480260289188007, 0.46519837898849803, 0.24579736546429154, 0.09006675383746174, 0.025488037660593193, 4.0005172136503025E-6, 1.0997520927701076E-16}, {-0.12635552966791724, 0.45244197718514534, 0.4660266837108191, 0.2472977881464149, 0.09095031661894405, 0.025826285784348025, 4.118620600176302E-6, 1.1673387490168428E-16}, {-0.12996556373535456, 0.4500635910988093, 0.466839509168595, 0.24879794957274007, 0.0918385213091146, 0.02616768308927967, 4.239815417694924E-6, 1.238853657116698E-16}, {-0.13355650013284975, 0.4476675827973272, 0.4676367858024969, 0.250297769146698, 0.09273135407817026, 0.026512243026944562, 4.364172059664553E-6, 1.3145120797092413E-16}, {-0.1371281984381436, 0.44525409128554644, 0.46841844493036566, 0.2517971660513072, 0.09362880071987358, 0.026859978948316546, 4.491762275235825E-6, 1.394540362165576E-16}, {-0.1406805193443505, 0.4428232564007428, 0.4691844187514297, 0.2532960592541974, 0.09453084665108669, 0.02721090410214292, 4.622659190324764E-6, 1.4791764665233864E-16}, {-0.1442133246665861, 0.4403752188046112, 0.4699346403504701, 0.2547943675126522, 0.09543747691133211, 0.027565031633300742, 4.756937328926081E-6, 1.5686705293809162E-16}, {-0.14772647734853042, 0.4379101199752137, 0.47066904370193285, 0.25629200937866947, 0.09634867616238013, 0.027922374581153906, 4.894672634668113E-6, 1.6632854447457273E-16}, {-0.15121984146892656, 0.43542810219888595, 0.4713875636739897, 0.2577889032040401, 0.09726442868786331, 0.02828294587791082, 5.035942492610848E-6, 1.7632974728722057E-16}, {-0.15469328224801435, 0.4329293085621011, 0.4720901360325459, 0.25928496714544413, 0.09818471839291767, 0.028646758346982996, 5.180825751288483E-6, 1.8689968761611574E-16}, {-0.15814666605389852, 0.4304138829432918, 0.4727766974451936, 0.26078011916956434, 0.09910952880385084, 0.029013824701344493, 5.329402744997951E-6, 1.980688583235675E-16}, {-0.1615798604088518, 0.4278819700046319, 0.4734471854851141, 0.26227427705821654, 0.10003884306783749, 0.02938415754189269, 5.481755316334839E-6, 2.098692882349614E-16}, {-0.16499273399555187, 0.425333715183777, 0.47410153863492466, 0.2637673584134972, 0.10097264395264173, 0.029757769355810145, 5.6379668389781336E-6, 2.2233461453287415E-16}, {-0.16838515666325174, 0.42276926468556536, 0.474739696290473, 0.26525928066294624, 0.10191091384636658, 0.03013467251492789, 5.798122240725196E-6, 2.355001583289711E-16}, {-0.17175699943388442, 0.4201887654736786, 0.475361598764577, 0.2667499610647274, 0.10285363475723094, 0.030514879274090304, 5.962308026778355E-6, 2.4940300354288346E-16}, {-0.17510813450809934, 0.417592365262264, 0.47596718729071025, 0.26823931671282275, 0.10380078831337348, 0.030898401769521553, 6.1306123032845265E-6, 2.640820792220865E-16}, {-0.17843843527123318, 0.4149802125075173, 0.4765564040266335, 0.26972726454224344, 0.10475235576268421, 0.031285252017193906, 6.3031248011292305E-6, 2.795782454417999E-16}, {-0.1817477762992124, 0.4123524563992286, 0.47712919205797205, 0.27121372133425575, 0.10570831797266335, 0.03167544191119796, 6.479936899986425E-6, 2.959343829291031E-16}, {-0.18503603336438734, 0.40970924685228877, 0.47768549540173644, 0.2726986037216204, 0.10666865543030737, 0.03206898322211491, 6.66114165262541E-6, 3.131954865607891E-16}, {-0.18830308344130026, 0.40705073449816026, 0.4782252590097904, 0.2741818281938488, 0.10763334824202321, 0.0324658875953911, 6.8468338094763006E-6, 3.3140876289001773E-16}, {-0.19154880471238173, 0.4043770706763111, 0.47874842877226176, 0.2756633111024699, 0.10860237613356899, 0.032866166549714776, 7.037109843455259E-6, 3.5062373186252666E-16}, {-0.19477307657358267, 0.4016884074256111, 0.4792549515208993, 0.2771429686663143, 0.10957571845002358, 0.033269831475395514, 7.232067975050985E-6, 3.708923328890698E-16}, {-0.19797577963993299, 0.39898489747569443, 0.4797447750323726, 0.27862071697680924, 0.11055335415578259, 0.033676893632746084, 7.431808197673566E-6, 3.922690354468297E-16}, {-0.201156795751034, 0.39626669423828625, 0.4802178480315173, 0.2800964720032874, 0.11153526183458284, 0.03408736415046711, 7.636432303267217E-6, 4.148109543888907E-16}, {-0.20431600797648009, 0.39353395179849376, 0.4806741201945235, 0.28157014959830895, 0.11252141968955434, 0.034501254024034755, 7.846043908188096E-6, 4.3857797014732824E-16}, {-0.20745330062121128, 0.3907868249060642, 0.4811135421520686, 0.28304166550299537, 0.11351180554329993, 0.034918574114091265, 8.060748479348444E-6, 4.63632854022229E-16}, {-0.21056855923079415, 0.38802546896660883, 0.48153606549239253, 0.2845109353523752, 0.11450639683800258, 0.0353393351448387, 8.280653360628406E-6, 4.900413987558898E-16}, {-0.2136616705966353, 0.3852500400327933, 0.48194164276431867, 0.2859778746807424, 0.11550517063556111, 0.03576354770243613, 8.505867799556748E-6, 5.17872554598628E-16}, {-0.21673252276112037, 0.38246069479549644, 0.48233022748021515, 0.2874423989270246, 0.11650810361775284, 0.036191222233399954, 8.73650297426168E-6, 5.471985710800483E-16}, {-0.219781005022686, 0.3796575905749352, 0.4827017741189015, 0.28890442344016387, 0.1175151720864251, 0.036622369043008175, 8.972672020693172E-6, 5.78095144707285E-16}, {-0.22280700794081798, 0.37684088531175997, 0.4830562381284975, 0.2903638634845074, 0.11852635196371399, 0.03705699829370808, 9.214490060117725E-6, 6.10641572819601E-16}, {-0.22581042334097945, 0.3740107375581163, 0.4833935759292138, 0.2918206342452085, 0.11954161879229132, 0.03749512000352792, 9.46207422688705E-6, 6.449209138369653E-16}, {-0.22879114431946643, 0.3711673064686791, 0.4837137449160867, 0.29327465083363774, 0.12056094773563941, 0.03793674404449249, 9.715543696481697E-6, 6.810201541485721E-16}, {-0.2317490652481927, 0.3683107517916538, 0.4840167034616542, 0.294725828292804, 0.12158431357835414, 0.03838188014104294, 9.975019713830908E-6, 7.190303818960505E-16}, {-0.23468408177940198, 0.3654412338597494, 0.4843024109185751, 0.29617408160278486, 0.12261169072647592, 0.038830537868460815, 1.0240625621909752E-5, 7.590469679150385E-16}, {-0.23759609085030708, 0.3625589135811225, 0.48457082762218895, 0.2976193256861649, 0.12364305320784826, 0.039282726651296354, 1.0512486890614781E-5, 8.011697541080929E-16}, {-0.24048499068765786, 0.3596639524302926, 0.4848219148930196, 0.29906147541348416, 0.12467837467250513, 0.0397384557618015, 1.0790731145919307E-5, 8.455032495314818E-16}, {-0.24335068081223524, 0.3567565124390287, 0.4850556350392194, 0.30050044560869416, 0.12571762839308576, 0.04019773431836751, 1.1075488199309393E-5, 8.92156834488262E-16}, {-0.2461930620432729, 0.35383675618720967, 0.4852719513589551, 0.3019361510546216, 0.1267607872652779, 0.04066057128396735, 1.136689007750174E-5, 9.412449729302522E-16}, {-0.24901203650280557, 0.35090484679365636, 0.48547082814273573, 0.3033685064984403, 0.1278078238082891, 0.04112697546460309, 1.166507105244442E-5, 9.928874334820178E-16}, {-0.2518075076199434, 0.34796094790693877, 0.48565223067568186, 0.3047974266571497, 0.12885871016534575, 0.041596955507758264, 1.1970167671601666E-5, 1.0472095194108323E-15}, {-0.2545793801350736, 0.34500522369615544, 0.4858161252397354, 0.30622282622306096, 0.1299134181042209, 0.04207051990085568, 1.2282318788523749E-5, 1.1043423078777732E-15}, {-0.25732756010398744, 0.3420378388416891, 0.48596247911581164, 0.30764461986928904, 0.13097191901778946, 0.042547676969720206, 1.260166559370278E-5, 1.1644228988166368E-15}, {-0.2600519549019334, 0.33905895852593654, 0.4860912605858911, 0.3090627222552516, 0.1320341839246122, 0.04302843487704758, 1.2928351645715883E-5, 1.2275946737992987E-15}, {-0.2627524732275963, 0.3360687484240144, 0.48620243893505277, 0.3104770480321728, 0.1331001834695472, 0.04351280162087819, 1.326252290265618E-5, 1.2940075652583495E-15}, {-0.2654290251070018, 0.333067374694442, 0.4862959844534487, 0.3118875118485935, 0.13416988792438983, 0.044000785033077146, 1.3604327753853102E-5, 1.3638183364505997E-15}, {-0.26808152189734585, 0.33005500396979864, 0.486371868438218, 0.3132940283558866, 0.13524326718854116, 0.04449239277782014, 1.3953917051882686E-5, 1.4371908725579943E-15}, {-0.27070987629075066, 0.32703180334736126, 0.48643006319534254, 0.31469651221377665, 0.1363202907897036, 0.044987632350085106, 1.4311444144868862E-5, 1.5142964833360064E-15}, {-0.2733140023179436, 0.32399794037971746, 0.4864705420414419, 0.31609487809586395, 0.1374009278846054, 0.045486511074150214, 1.4677064909076629E-5, 1.5953142177334168E-15}, {-0.2758938153518628, 0.32095358306535804, 0.48649327930550984, 0.31748904069515355, 0.13848514725975294, 0.04598903610209827, 1.5050937781798271E-5, 1.6804311909217287E-15}, {-0.2784492321111866, 0.31789889983924835, 0.48649825033058997, 0.3188789147295867, 0.13957291733221114, 0.04649521441232729, 1.5433223794533092E-5, 1.769842924187129E-15}, {-0.2809801706637876, 0.31483405956337857, 0.48648543147539236, 0.32026441494757757, 0.14066420615041228, 0.047005052808068, 1.5824086606461948E-5, 1.8637536981532E-15}, {-0.2834865504301105, 0.3117592315172946, 0.48645480011584924, 0.32164545613355067, 0.14175898139499196, 0.0475185579159076, 1.6223692538217095E-5, 1.9623769198181694E-15}, {-0.2859682921864753, 0.3086745853886095, 0.4864063346466113, 0.32302195311348314, 0.14285721037965451, 0.0480357361843208, 1.6632210605948523E-5, 2.0659355039066362E-15}, {-0.28842531806830324, 0.3055802912634951, 0.486340014482484, 0.32439382076044787, 0.14395886005206499, 0.048556593882207524, 1.7049812555687183E-5, 2.174662269052354E-15}, {-0.2908575515732676, 0.3024765196171565, 0.4862558200598028, 0.32576097400015974, 0.1450638969947703, 0.049081137097437916, 1.7476672898006358E-5, 2.288800349345762E-15}, {-0.29326491756436746, 0.2993634413042879, 0.4861537328377488, 0.3271233278165224, 0.14617228742614763, 0.04960937173540447, 1.7912968942981508E-5, 2.4086036217975958E-15}, {-0.29564734227292566, 0.296241227549511, 0.4860337352996037, 0.32848079725717755, 0.14728399720138136, 0.050141303517581656, 1.835888083544976E-5, 2.534337150288097E-15}, {-0.29800475330151, 0.29311004993779755, 0.4858958109539443, 0.3298332974390541, 0.14839899181346733, 0.05067693798009287, 1.88145915905693E-5, 2.666277646590048E-15}, {-0.30033707962677697, 0.28997008040487526, 0.4857399443357765, 0.3311807435539182, 0.14951723639424552, 0.051216280472285214, 1.928028712967987E-5, 2.804713949073165E-15}, {-0.30264425160224023, 0.2868214912276173, 0.4855661210076084, 0.33252305087392403, 0.1506386957154605, 0.05175933615531199, 1.9756156316464725E-5, 2.9499475197171778E-15}, {-0.304926200960961, 0.2836644550144179, 0.4853743275604635, 0.33386013475716414, 0.15176333418984966, 0.052306110000723036, 2.024239099341476E-5, 3.1022929600814744E-15}, {-0.3071828608181614, 0.2804991446955532, 0.4851645516148322, 0.3351919106532186, 0.15289111587225904, 0.05285660678906318, 2.073918601859556E-5, 3.2620785469001086E-15}, {-0.3094141656737612, 0.27732573351352713, 0.48493678182156313, 0.3365182941087047, 0.15402200446078754, 0.05341083110847889, 2.1246739302717952E-5, 3.429646787992796E-15}, {-0.3116200514148369, 0.27414439501340504, 0.48469100786269365, 0.3378392007728243, 0.15515596329795833, 0.053968787353333075, 2.1765251846512556E-5, 3.605354999204676E-15}, {-0.3138004553180035, 0.270955303033134, 0.4844272204522188, 0.3391545464029098, 0.1562929553719181, 0.05453047972282847, 2.2294927778408956E-5, 3.789575903110757E-15}, {-0.3159553160517186, 0.26775863169385034, 0.4841454113368005, 0.34046424686996934, 0.15743294331766436, 0.05509591221963959, 2.2835974392520257E-5, 3.982698250244451E-15}, {-0.31808457367850984, 0.26455455539017636, 0.48384557329641487, 0.3417682181642282, 0.1585758894182998, 0.055665088648553226, 2.3388602186933067E-5, 4.185127463634081E-15}, {-0.32018816965712293, 0.2613432487805048, 0.4835277001449384, 0.3430663764006682, 0.15972175560631446, 0.05623801261511793, 2.3953024902303902E-5, 4.397286307456156E-15}, {-0.3222660468445935, 0.2581248867772733, 0.4831917867306741, 0.34435863782456466, 0.1608705034648957, 0.05681468752430233, 2.4529459560762243E-5, 4.619615580640123E-15}, {-0.3243181494982404, 0.25489964453722885, 0.48283782893681554, 0.34564491881701925, 0.1620220942292651, 0.05739511657916263, 2.5118126505120628E-5, 4.852574836285699E-15}, {-0.32634442327758106, 0.2516676974516819, 0.48246582368185026, 0.3469251359004896, 0.16317648878804358, 0.05797930277951924, 2.571924943839249E-5, 5.096643127781281E-15}, {-0.3283448152461697, 0.24842922113675217, 0.4820757689199025, 0.3481992057443153, 0.16433364768464306, 0.05856724892064278, 2.6333055463617748E-5, 5.352319782539899E-15}, {-0.33031927387335563, 0.24518439142360632, 0.4816676636410139, 0.3494670451702379, 0.16549353111868595, 0.05915895759194958, 2.695977512399688E-5, 5.62012520429821E-15}, {-0.33226774903596534, 0.24193338434868641, 0.4812415078713634, 0.3507285711579187, 0.16665609894745192, 0.05975443117570669, 2.7599642443333627E-5, 5.9006017049535576E-15}, {-0.33419019201990524, 0.23867637614393244, 0.48079730267342635, 0.35198370085044883, 0.16782131068735157, 0.06035367184574664, 2.8252894966786698E-5, 6.194314366944832E-15}, {-0.3360865555216868, 0.23541354322699723, 0.48033505014607236, 0.3532323515598561, 0.16898912551542775, 0.06095668156619219, 2.89197738019308E-5, 6.501851937214263E-15}, {-0.3379567936498729, 0.23214506219145617, 0.4798547534246016, 0.35447444077260437, 0.1701595022708832, 0.061563462090190695, 2.9600523660127147E-5, 6.823827753819532E-15}, {-0.3398008619264458, 0.22887110979700906, 0.47935641668071965, 0.35570988615508803, 0.17133239945663634, 0.06217401495865909, 3.0295392898203904E-5, 7.16088070629885E-15}, {-0.3416187172880977, 0.22559186295968015, 0.478840045122453, 0.35693860555911905, 0.1725077752409028, 0.0627883414990386, 3.100463356044658E-5, 7.513676230926034E-15}, {-0.34341031808744094, 0.22230749874201036, 0.47830564499400063, 0.35816051702740775, 0.17368558745880475, 0.06340644282406004, 3.17285014208986E-5, 7.882907342027329E-15}, {-0.34517562409414226, 0.2190181943432479, 0.4777532235755272, 0.3593755387990368, 0.1748657936140068, 0.06402831983051964, 3.246725602597226E-5, 8.269295700568311E-15}, {-0.346914596495976, 0.2157241270895342, 0.47718278918289275, 0.3605835893149256, 0.17604835088037823, 0.06465397319806525, 3.322116073737014E-5, 8.67359272125608E-15}, {-0.3486271978998006, 0.21242547442408738, 0.47659435116732307, 0.3617845872232898, 0.1772332161036826, 0.06528340338799346, 3.399048277531729E-5, 9.096580719440187E-15}, {-0.350313392332456, 0.2091224138973836, 0.47598791991501826, 0.3629784513850903, 0.17842034580329352, 0.06591661064205752, 3.4775493262103693E-5, 9.539074099134956E-15}, {-0.351973145241582, 0.20581512315733624, 0.4753635068466997, 0.3641651008794739, 0.1796096961739369, 0.06655359498128603, 3.557646726593778E-5, 1.0001920583526478E-14}, {-0.3536064234963589, 0.2025037799394741, 0.474721124417097, 0.3653444550092066, 0.18080122308746024, 0.06719435620481318, 3.639368384511066E-5, 1.0486002489368435E-14}, {-0.35521319538816887, 0.19918856205711916, 0.4740607861143736, 0.3665164333060952, 0.18199488209462736, 0.06783889388871948, 3.722742609247065E-5, 1.0992238046714128E-14}, {-0.356793430631179, 0.1958696473915642, 0.4733825064594911, 0.36768095553640145, 0.18319062842694012, 0.06848720738488454, 3.807798118020894E-5, 1.1521582765475417E-14}, {-0.3583471003628463, 0.19254721388225018, 0.4726863010055126, 0.3688379417062447, 0.18438841699848618, 0.06913929581985079, 3.8945640404955445E-5, 1.2075030850344591E-14}, {-0.35987417714434233, 0.18922143951694617, 0.471972186336846, 0.36998731206699464, 0.1855882024078127, 0.06979515809369899, 3.983069923318549E-5, 1.265361666566117E-14}, {-0.3613746349609023, 0.18589250232192944, 0.4712401800684256, 0.37112898712065406, 0.18678993893982634, 0.07045479287893545, 4.0733457346936396E-5, 1.3258416251853053E-14}, {-0.36284844922209236, 0.18256058035216807, 0.47049030084483295, 0.37226288762522924, 0.1879935805677189, 0.07111819861939084, 4.1654218689834584E-5, 1.3890548895130562E-14}, {-0.3642955967620005, 0.17922585168150718, 0.46972256833935766, 0.3733889346000901, 0.189199080954919, 0.07178537352913106, 4.2593291513432375E-5, 1.4551178752161702E-14}, {-0.3657160558393485, 0.17588849439285728, 0.4689370032529972, 0.37450704933131784, 0.19040639345706933, 0.07245631559138022, 4.355098842385468E-5, 1.5241516531508415E-14}, {-0.3671098061375249, 0.17254868656838718, 0.46813362731339564, 0.375617153377041, 0.19161547112403, 0.07313102255745553, 4.452762642875502E-5, 1.5962821233656693E-14}, {-0.36847682876453997, 0.16920660627972042, 0.46731246327372244, 0.3767191685727591, 0.1928262667019068, 0.07380949194571475, 4.552352698458077E-5, 1.6716401951527484E-14}, {-0.36981710625290204, 0.16586243157813818, 0.46647353491149074, 0.3778130170366529, 0.1940387326351053, 0.07449172104051564, 4.6539016044147194E-5, 1.750361973341105E-14}, {-0.37113062255941565, 0.1625163404847857, 0.4656168670273143, 0.3788986211748821, 0.19525282106841033, 0.0751777068911884, 4.757442410451992E-5, 1.8325889510324862E-14}, {-0.37241736306490153, 0.159168510980887, 0.4647424854436063, 0.37997590368686973, 0.1964684838490905, 0.07586744631102006, 4.863008625520552E-5, 1.918468208985364E-14}, {-0.37367731457383774, 0.15581912099796388, 0.463850417003215, 0.38104478757057203, 0.19768567252902813, 0.07656093587625235, 4.970634222664964E-5, 2.0081526218590543E-14}, {-0.37491046531392325, 0.1524683484080639, 0.46294068956800166, 0.3821051961277348, 0.19890433836687385, 0.07725817192509167, 5.080353643904249E-5, 2.1018010715360618E-14}, {-0.37611680493556277, 0.14911637101399522, 0.4620133320173572, 0.3831570529691352, 0.20012443233022661, 0.07795915055673254, 5.1922018051430713E-5, 2.1995786677470854E-14}, {-0.377296324511274, 0.14576336653957017, 0.46106837424665914, 0.38420028201980816, 0.20134590509783779, 0.07866386763039365, 5.306214101113558E-5, 2.301656976229677E-14}, {-0.3784490165350171, 0.14240951261985638, 0.4601058471656687, 0.3852348075242591, 0.20256870706184132, 0.07937231876436773, 5.422426410347698E-5, 2.408214254658233E-14}, {-0.3795748749214448, 0.13905498679143957, 0.45912578269686793, 0.38626055405165877, 0.20379278833000644, 0.08008449933508367, 5.5408751001801574E-5, 2.5194356965898505E-14}, {-0.3806738950050764, 0.13569996648269386, 0.4581282137737373, 0.3872774465010245, 0.20501809872801702, 0.08080040447618321, 5.6615970317816485E-5, 2.6355136836776773E-14}, {-0.3817460735393929, 0.13234462900406468, 0.45711317433897414, 0.3882854101063842, 0.2062445878017734, 0.08152002907760988, 5.7846295652225495E-5, 2.7566480464105875E-14}, {-0.38279140869585476, 0.12898915153836046, 0.4560806993426505, 0.3892843704419242, 0.20747220481972026, 0.08224336778471272, 5.910010564566907E-5, 2.883046333645457E-14}, {-0.38380990006284216, 0.12563371113105815, 0.45503082474031276, 0.39027425342711963, 0.20870089877519674, 0.0829704149973628, 6.0377784029966E-5, 3.014924091205932E-14}, {-0.38480154864451727, 0.12227848468061903, 0.4539635874910213, 0.39125498533184844, 0.2099306183888121, 0.08370116486908395, 6.167971967965688E-5, 3.152505149829425E-14}, {-0.3857663568596099, 0.11892364892881838, 0.4528790255553313, 0.3922264927814879, 0.21116131211084457, 0.08443561130619726, 6.300630666384797E-5, 3.296021922752044E-14}, {-0.38670432854012493, 0.11556938045108789, 0.451777177893215, 0.39318870276199197, 0.21239292812366342, 0.08517374796697968, 6.435794429835492E-5, 3.445715713229434E-14}, {-0.3876154689299732, 0.1122158556468718, 0.4506580844619236, 0.39414154262495255, 0.2136254143441762, 0.0859155682608367, 6.573503719814542E-5, 3.6018370322999644E-14}, {-0.38849978468352514, 0.10886325072999688, 0.44952178621379246, 0.3950849400926404, 0.2148587184262978, 0.08666106534748919, 6.71379953300799E-5, 3.764645927105291E-14}, {-0.38935728386408713, 0.10551174171905929, 0.4483683250939861, 0.396018823263028, 0.21609278776344357, 0.08741023213617452, 6.856723406594875E-5, 3.9344123200922616E-14}, {-0.39018797594230165, 0.10216150442782322, 0.44719774403818513, 0.39694312061479414, 0.2173275694910461, 0.0881630612848623, 7.002317423580622E-5, 4.111416359429197E-14}, {-0.3909918717944697, 0.0988127144556392, 0.4460100869702154, 0.39785776101230663, 0.21856301048909418, 0.08891954519948435, 7.150624218159882E-5, 4.295948780979006E-14}, {-0.3917689837007978, 0.09546554717787645, 0.44480539879961806, 0.398762673710588, 0.2197990573846954, 0.08967967603317951, 7.301686981108783E-5, 4.488311282181007E-14}, {-0.39251932534356737, 0.09212017773637292, 0.44358372541916213, 0.39965778836025917, 0.22103565655466126, 0.09044344568555299, 7.455549465206427E-5, 4.688816908203353E-14}, {-0.39324291180522897, 0.08877678102990344, 0.4423451137022994, 0.40054303501246313, 0.22227275412811506, 0.09121084580195066, 7.612255990685604E-5, 4.897790450737807E-14}, {-0.3939397595664191, 0.08543553170466527, 0.44108961150056103, 0.4014183441237686, 0.22351029598912206, 0.09198186777274807, 7.771851450712506E-5, 5.115568859819208E-14}, {-0.39460988650390205, 0.08209660414478166, 0.43981726764089635, 0.40228364656105126, 0.22474822777934253, 0.09275650273265473, 7.934381316895356E-5, 5.3425016690621975E-14}, {-0.3952533118884351, 0.07876017246282663, 0.43852813192295526, 0.4031388736063549, 0.2259864949007066, 0.09353474156003318, 8.099891644821864E-5, 5.5789514347189865E-14}, {-0.39587005638255834, 0.07542641049036748, 0.4372222551163124, 0.40398395696172945, 0.22722504251811107, 0.09431657487623336, 8.268429079625342E-5, 5.825294188972843E-14}, {-0.39646014203830926, 0.0720954917685275, 0.435899688957635, 0.40481882875404906, 0.22846381556213916, 0.09510199304494255, 8.440040861579302E-5, 6.081919907893382E-14}, {-0.39702359229486067, 0.0687675895385712, 0.4345604861477925, 0.4056434215398049, 0.22970275873180057, 0.09589098617154998, 8.614774831720519E-5, 6.349232994491534E-14}, {-0.397560431976085, 0.06544287673250937, 0.43320470034891145, 0.4064576683098778, 0.23094181649729406, 0.09668354410252755, 8.792679437500237E-5, 6.627652777323944E-14}, {-0.39807068728804273, 0.06212152596372568, 0.43183238618137193, 0.4072615024942873, 0.2321809331027921, 0.09747965642482595, 8.973803738463605E-5, 6.917614025108884E-14}, {-0.3985543858163952, 0.05880370951762641, 0.43044359922074793, 0.40805485796691576, 0.23342005256924508, 0.09827931246528608, 9.15819741195695E-5, 7.219567477828277E-14}, {-0.3990115565237442, 0.055489599342313775, 0.42903839599469323, 0.4088376690502114, 0.23465911869720843, 0.09908250129006659, 9.345910758862895E-5, 7.533980394803283E-14}, {-0.3994422297468965, 0.0521793670392793, 0.42761683397976874, 0.4096098705198662, 0.23589807506969038, 0.09988921170408709, 9.5369947093631E-5, 7.861337120244304E-14}, {-0.3998464371940529, 0.04887318385412653, 0.4261789715982159, 0.41037139760946817, 0.23713686505501927, 0.10069943225048708, 9.731500828728497E-5, 8.202139666789483E-14}, {-0.4002242119419247, 0.04557122066731204, 0.42472486821467315, 0.4111221860151322, 0.23837543180973356, 0.10151315121010122, 9.92948132313679E-5, 8.556908317559793E-14}, {-0.4005755884327758, 0.042273647984916354, 0.4232545841328383, 0.41186217190010316, 0.23961371828149086, 0.10233035660095026, 1.0130989045517124E-4, 8.926182247273083E-14}, {-0.40090060247139014, 0.03898063592943724, 0.4217681805920739, 0.41259129189933563, 0.2408516672119983, 0.10315103617774851, 1.0336077501421712E-4, 9.310520162973801E-14}, {-0.40119929122196696, 0.03569235423061058, 0.42026571976395977, 0.41330948312404725, 0.242089221139962, 0.10397517743142708, 1.0544800854924177E-4, 9.710500964950004E-14}, {-0.4014716932049417, 0.0324089722162572, 0.4187472647487888, 0.41401668316624685, 0.24332632240405788, 0.10480276758867392, 1.0757213934544604E-4, 1.0126724428424838E-13}, {-0.40171784829373447, 0.02913065880315615, 0.41721287957200903, 0.4147128301032364, 0.24456291314592135, 0.10563379361148988, 1.0973372239200879E-4, 1.0559811906624818E-13}, {-0.4019377977114248, 0.02585758248794626, 0.4156626291806107, 0.41539786250208627, 0.24579893531315725, 0.1064682421967614, 1.1193331944186318E-4, 1.1010407055843437E-13}, {-0.40213158402735466, 0.022589911338055525, 0.4140965794394603, 0.4160717194240846, 0.24703433066236902, 0.1073060997758497, 1.141714990717329E-4, 1.1479176583135359E-13}, {-0.40229925115365867, 0.019327812982658874, 0.4125147971275799, 0.41673434042915913, 0.24826904076220735, 0.10814735251419674, 1.1644883674242659E-4, 1.1966811017292463E-13}, {-0.40244084434172156, 0.01607145460366469, 0.4109173499343717, 0.4173856655802716, 0.24950300699643785, 0.10899198631094743, 1.1876591485938813E-4, 1.2474025503770805E-13}, {-0.40255641017856414, 0.01282100292673151, 0.40930430645579124, 0.41802563544778554, 0.250736170567028, 0.10983998679858917, 1.211233228335013E-4, 1.3001560624255143E-13}, {-0.4026459965831581, 0.009576624212314155, 0.40767573619046593, 0.4186541911138055, 0.25196847249725274, 0.11069133934260786, 1.2352165714214604E-4, 1.3550183241565026E-13}, {-0.4027096528026677, 0.006338484246740472, 0.4060317095357602, 0.41927127417648824, 0.2531998536348188, 0.11154602904116111, 1.2596152139050454E-4, 1.4120687370625784E-13}, {-0.40274742940862207, 0.0031067483333194366, 0.40437229778378914, 0.4198768267543261, 0.25443025465500696, 0.11240404072476799, 1.2844352637311475E-4, 1.4713895076245736E-13}, {-0.4027593782930149, -1.1841871651958724E-4, 0.40269757311737836, 0.42047079149040095, 0.2556596160638339, 0.11326535895601643, 1.3096829013566915E-4, 1.53306573984611E-13}, {-0.4027455526643345, -0.003336852592055239, 0.4010076086059724, 0.4210531115566098, 0.2568878782012305, 0.11412996802928707, 1.3353643803705567E-4, 1.5971855306228879E-13}, {-0.40270600704352283, -0.006548389492071093, 0.39930247820149, 0.42162373065786113, 0.2581149812442394, 0.11499785197049528, 1.3614860281164107E-4, 1.663840068026943E-13}, {-0.40264079725986407, -0.009752866133617564, 0.3975822567341289, 0.4221825930362409, 0.2593408652102294, 0.1158689945368492, 1.3880542463178967E-4, 1.7331237325879658E-13}, {-0.4025499804468043, -0.012950119760742599, 0.3958470199081176, 0.4227296434751501, 0.26056546996012786, 0.11674337921662599, 1.415075511706198E-4, 1.8051342016560313E-13}, {-0.40243361503769987, -0.01613998815318658, 0.39409684429741754, 0.4232648273034113, 0.2617887352016703, 0.11762098922896536, 1.442556376649927E-4, 1.8799725569321982E-13}, {-0.4022917607614975, -0.01932230963504464, 0.39233180734137135, 0.423788090399345, 0.2630106004926673, 0.11850180752368034, 1.4705034697873226E-4, 1.9577433952556142E-13}, {-0.40212447863834494, -0.022496923083391702, 0.39055198734030394, 0.42429937919481553, 0.264231005244288, 0.11938581678108558, 1.498923496660722E-4, 2.0385549427381038E-13}, {-0.4019318309751334, -0.025663667936874548, 0.38875746345107054, 0.4247986406792468, 0.26544988872436087, 0.12027299941184343, 1.5278232403532935E-4, 2.1225191723395182E-13}, {-0.40171388136096936, -0.02882238420426662, 0.38694831568255406, 0.4252858224036048, 0.266667190060691, 0.12116333755682757, 1.557209562127995E-4, 2.209751924979446E-13}, {-0.4014706946625805, -0.031972912472985913, 0.38512462489111526, 0.42576087248435124, 0.2678828482443928, 0.12205681308700414, 1.587089402068726E-4, 2.300373034283421E-13}, {-0.40120233701965224, -0.035115093917578215, 0.38328647277598993, 0.42622373960736387, 0.26909680213324044, 0.12295340760333101, 1.617469779723664E-4, 2.3945064550641355E-13}, {-0.4009088758400969, -0.03824877030816071, 0.38143394187463825, 0.4266743730318249, 0.27030899045503326, 0.12385310243667455, 1.648357794750733E-4, 2.4922803956407873E-13}, {-0.40059037979525575, -0.04137378401882934, 0.37956711555804573, 0.42711272259407906, 0.2715193518109772, 0.12475587864774454, 1.6797606275651956E-4, 2.593827454102275E-13}, {-0.40024691881503344, -0.04448997803602692, 0.3776860780259731, 0.42753873871145603, 0.2727278246790818, 0.1256617170270466, 1.7116855399893283E-4, 2.699284758622582E-13}, {-0.39987856408296557, -0.04759719596687402, 0.3757909143021589, 0.42795237238606315, 0.27393434741757267, 0.12657059809485313, 1.744139875904156E-4, 2.808794111939461E-13}, {-0.3994853880312209, -0.050695282047458455, 0.3738817102294742, 0.4283535752085435, 0.27513885826831896, 0.12748250210119189, 1.77713106190321E-4, 2.9225021401102716E-13}, {-0.39906746433553547, -0.05378408115108753, 0.3719585524650276, 0.42874229936180086, 0.2763412953602762, 0.12839740902585275, 1.810666607948285E-4, 3.040560445661712E-13}, {-0.39862486791008345, -0.05686343879649897, 0.3700215284752248, 0.42911849762469295, 0.2775415967129436, 0.12931529857841287, 1.8447541080271658E-4, 3.163125765253027E-13}, {-0.3981576749022794, -0.05993320115603064, 0.36807072653077805, 0.4294821233756873, 0.2787397002398354, 0.1302361501982794, 1.8794012408132767E-4, 3.290360131975341E-13}, {-0.39766596268751786, -0.06299321506375162, 0.36610623570167034, 0.4298331305964875, 0.2799355437519681, 0.13115994305475115, 1.9146157703272475E-4, 3.4224310424127396E-13}, {-0.3971498098638474, -0.06604332802354915, 0.3641281458520728, 0.430171473875622, 0.28112906496136014, 0.1320866560470983, 1.950405546600346E-4, 3.5595116285938537E-13}};
        boolean success = true;
        int i = 0;
        while (i < nus.length) {
            int j = 0;
            while (j < x.length) {
                double val = Bessel.i(x[j], nus[i], false);
                boolean cur_success = DebugFun.isEqual(besselI[j][i], val);
                success &= cur_success;
                if (!cur_success) {
                    System.err.println(String.format("Error: BesselI(%g, %f, FALSE) = %3.18g != %3.18g", x[j], nus[i], val, besselI[j][i]));
                }
                val = Bessel.j(x[j], nus[i]);
                cur_success = DebugFun.isEqual(besselJ[j][i], val);
                success &= cur_success;
                if (!cur_success) {
                    System.err.println(String.format("Error: BesselJ(%g, %f, FALSE) = %3.18g != %3.18g", x[j], nus[i], val, besselJ[j][i]));
                }
                ++j;
            }
            ++i;
        }
        return success;
    }

    /*
     * Opcode count of 37259 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    @Test
    public static final boolean test_besselKY() {
        double Inf = Double.POSITIVE_INFINITY;
        double NegInf = Double.NEGATIVE_INFINITY;
        double[] x = Utilities.seq(0.0, 4.0, 0.008);
        double[] nus = Utilities.c(0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 10.0, 20.0);
        double[][] besselK = new double[][]{{Inf, Inf, Inf, Inf, Inf, Inf, Inf, Inf}, {4.944340361297194, 124.97822282077173, 31249.50004555423, 1.5624875000999935E7, 1.1718687500249996E10, 1.1718703125124998E13, 1.730343603518701E29, 5.531774057585528E64}, {4.251434148566571, 62.46198980712353, 7812.000160039008, 1953062.501999559, 7.324062502499948E8, 3.662050781874994E11, 1.6897796631340025E26, 5.275497515293761E58}, {3.8463307631516948, 41.61451466835397, 3471.7225531259824, 578662.0400356654, 1.4466898173146948E8, 4.822357257252986E10, 2.9303104106585936E24, 1.5864866177114074E55}, {3.5591178101411143, 31.185062938590576, 1952.6255514720522, 244109.37899694513, 4.5772461187478684E7, 1.1443359406248669E10, 1.65014024899005E23, 5.031055646226289E52}, {3.3365414568643055, 24.92328551262633, 1249.5008170881808, 124975.00499433071, 1.8747500249966692E7, 3.749625024998333E9, 1.7717962519687121E22, 5.800368284597609E50}, {3.1548780014663373, 20.74564324134409, 867.5566797241368, 72317.13562025274, 9040509.509211317, 1.506823902004173E9, 2.86149390609158E21, 1.5129571404111124E49}, {3.001470489923707, 17.759142837816405, 637.2565718405097, 45536.08570287422, 4879503.581879792, 6.971174763542446E8, 6.125124097691253E20, 6.9324393439383555E47}, {2.8687624146284705, 15.517258851622946, 487.78310152784553, 30501.961104341968, 2860046.6366335875, 3.5753633154030275E8, 1.6113275823061225E20, 4.797794618751268E46}, {2.7518785980380533, 13.771902879825623, 385.30473637097197, 21419.590590156047, 1785351.1872493748, 1.9839377372940955E8, 4.961871257227589E19, 4.549723318672555E45}, {2.6474894673943257, 12.374209023706591, 312.00271506005913, 15612.509962026663, 1171250.2498670598, 1.17140637496668E8, 1.7300390932593748E19, 5.5313129026293815E44}, {2.5532195061338823, 11.22943521246131, 257.7676561529819, 11727.94107852982, 799890.1139195499, 7.272901102467398E7, 6.669800624145271E18, 8.221798779281408E43}, {2.4673141752271297, 10.274413214498752, 216.51758947728445, 9031.840641434683, 564706.5576791449, 4.706791164723684E7, 2.7938911747917517E18, 1.4427371480721767E43}, {2.3884406048950124, 9.465405946578109, 184.4154780390894, 7102.368407450017, 409936.4389847708, 3.15406745980052E7, 1.2547844324182671E18, 2.910287849591947E42}, {2.3155623517456023, 8.771168548586221, 158.94357214792814, 5685.3273166888775, 304730.04982333776, 2.17721174575551E7, 5.980003565716492E17, 6.610470999671612E41}, {2.247857464592531, 8.168784868169226, 138.39427193407963, 4621.311182670824, 231203.95340547527, 1.5418218204881024E7, 2.999485866723259E17, 1.6632492295121712E41}, {2.184663043561541, 7.641065155095554, 121.57630609192958, 3806.900630527895, 178570.04336208702, 1.1164434610760966E7, 1.573025093646889E17, 4.574793777112693E40}, {2.125436633494835, 7.174862140772227, 107.63811517426286, 3173.0017790308566, 140093.01071947676, 8243938.33821884, 8.578686287189816E16, 1.3607573179839016E40}, {2.069728666882139, 6.759948370521535, 95.95790047968123, 2672.2571839172224, 111440.00723036395, 6193783.769981913, 4.843484656431587E16, 4.338066487956515E39}, {2.017162365645756, 6.388248023027657, 86.07305740548335, 2271.4687060620636, 89749.31145459221, 4725919.44000039, 2.8204499995738108E16, 1.471162870392032E39}, {1.967418802798146, 6.05329915457051, 77.63365823492953, 1946.8947550278087, 73086.18697177776, 3656256.243343916, 1.6885905302490628E16, 5.27373858561809E38}, {1.9202256114824938, 5.749869565532148, 70.37105377257949, 1681.2511498650435, 60115.05497752414, 2864302.916746252, 1.0365725560070096E16, 1.987547985796898E38}, {1.875348322167841, 5.473677413505662, 64.07622802109583, 1461.7515869838655, 49896.51669338015, 2269485.2376497183, 6.509275446404187E15, 7.838521885741547E37}, {1.8325836263367583, 5.221184696645326, 58.58459119856857, 1278.7992542307447, 41758.5602726359, 1816868.3763253568, 4.172980525302435E15, 3.2219189728580073E37}, {1.791754074288471, 4.989442355701751, 53.765111946181705, 1125.0959412344873, 35213.01327552391, 1468333.9824213972, 2.7263149039066755E15, 1.3754009244697735E37}, {1.7527038555281458, 4.7759725432204725, 49.51242928773287, 995.0245582978779, 29900.24917822407, 1197004.9916872606, 1.8123852594002498E15, 6.079054722632976E36}, {1.7152954068151844, 4.57867805466839, 45.74104593247278, 884.214176756068, 25551.919221588276, 983650.3380839975, 1.2242715517478958E15, 2.7742820736060284E36}, {1.679406660347746, 4.395771880519409, 42.380998146638575, 789.2290708923449, 21965.410745156223, 814322.9603729746, 8.393298762826218E14, 1.3041360772031947E36}, {1.644928792335265, 4.225721849851573, 39.37458816601003, 707.3433676714592, 18986.071936508666, 678781.3411001238, 5.833746498566538E14, 6.30111566353863E35}, {1.6117643665615906, 4.067206723302772, 36.67389129158548, 636.3756772678798, 16494.665544771236, 569417.9461866209, 4.106803155990285E14, 3.1231818715380033E35}, {1.5798257925683408, 3.9190810643667353, 34.23883466229114, 574.5663254358858, 14398.396970559437, 480521.1320107505, 2.92567294110256E14, 1.5852967235063219E35}, {1.5490340365451882, 3.7803469072243114, 32.03570264319286, 520.4852282490447, 12624.420257055564, 407759.8483590737, 2.1075325788343112E14, 8.227719393996495E34}, {1.5193175367798823, 3.6501307346926444, 30.035963901566166, 472.962066696664, 11115.084402104629, 347819.3496324663, 1.5340616801508084E14, 4.360042700286855E34}, {1.4906112858959968, 3.5276646401685516, 28.215343408385024, 431.0328677975174, 9824.416884261052, 298140.63542116276, 1.1275947177412969E14, 2.3560675656192374E34}, {1.4628560500024015, 3.4122708123731544, 26.55308261156971, 393.89877980604535, 8715.496754803748, 256732.03862697506, 8.36472263269395E13, 1.2967722111209883E34}, {1.4359977009424632, 3.3033486785174353, 25.031345404638426, 360.8939973162092, 7758.474145037692, 222031.58385553598, 6.25902969842328E13, 7.261994502019258E33}, {1.4099866425277585, 3.2003641891231367, 23.634737955882873, 331.46061357638524, 6929.064187463909, 192805.46582090715, 4.72180063016589E13, 4.1337177788122065E33}, {1.3847773153079563, 3.102840839446086, 22.349918122376106, 305.12876141209614, 6207.392379178379, 168072.49036082777, 3.589707543711266E13, 2.3896244913414894E33}, {1.3603277673128158, 3.0103521077066513, 21.16527584433026, 281.50082374363114, 5577.102586573893, 147047.3583651619, 2.7490488318575484E13, 1.4017313366661083E33}, {1.3365992804869777, 2.922515055917477, 20.070670151752857, 260.23879905274896, 5024.662959627694, 129097.75058437826, 2.1198880160392453E13, 8.33712696943159E32}, {1.3135560443600813, 2.838984889929371, 19.05721160641865, 241.0541299701625, 4538.822148546966, 113711.6078436443, 1.645500822160463E13, 5.02434947472069E32}, {1.291164869956617, 2.759450314990685, 18.117081424777865, 223.69946769033052, 4110.1805147844825, 100472.00470633624, 1.2852775864367502E13, 3.0660053662668148E32}, {1.2693949381299336, 2.683629554289641, 17.243380380330176, 207.96196741536315, 3730.849941368958, 89037.72247620007, 1.00990038843441E13, 1.8933629944247192E32}, {1.248217577462652, 2.611266922599464, 16.430002011180466, 193.65780193632582, 3394.1823613657007, 79128.13132206889, 7.980338020833146E12, 1.1825499587534048E32}, {1.227606067657391, 2.5421298667553147, 15.671525765130772, 180.62764992505956, 3094.5519222150097, 70511.35315481164, 6.340331062430762E12, 7.466262660321242E31}, {1.2075354649828345, 2.476006400380094, 14.963126578205578, 168.7329683804421, 2827.1792662522403, 62994.93888509689, 5.063430783274811E12, 4.76292751460206E31}, {1.1879824468685367, 2.412702872895434, 14.300498060430678, 157.85289918192456, 2587.989071678766, 56418.484892198576, 4.063698434239108E12, 3.068558000996278E31}, {1.168925173179336, 2.352042023057493, 13.679786997953235, 147.8816909374536, 2373.494004084979, 50647.75411827744, 3.2767962669018433E12, 1.995720888018556E31}, {1.1503431620640407, 2.2938612755477563, 13.097537305541938, 138.7265415416096, 2180.699748893192, 45569.97131014978, 2.6542531107401313E12, 1.309777344761288E31}, {1.132217178576821, 2.238011245917241, 12.550641902644378, 130.30578576269662, 2007.0269545969804, 41090.03955304802, 2.1593301858594043E12, 8.670919414336557E30}, {1.1145291345244344, 2.184354424732687, 12.03630125818787, 122.54736700661138, 1850.2468063573585, 37127.483494153785, 1.7640196500624006E12, 5.788292397857109E30}, {1.0972619982067606, 2.132764016344313, 11.55198756852202, 115.3875440998935, 1708.4276360963675, 33613.96864402867, 1.4468508545205244E12, 3.895023594832211E30}, {1.0803997128991527, 2.0831229114747813, 11.095413710374062, 108.76979320353306, 1579.8905079921005, 30491.279562282387, 1.1912766035935737E12, 2.6412473689360826E30}, {1.0639271230785992, 2.0353227759673724, 10.664506255000168, 102.64387235144066, 1463.1721338697264, 27709.665266119864, 9.844787221848108E11, 1.8043474172754335E30}, {1.0478299075261925, 1.9892632406467792, 10.257381947557578, 96.96502201432806, 1356.993798813225, 25226.47981485183, 8.16478723188991E11, 1.2414328432814485E30}, {1.0320945185497776, 1.9448511794335501, 9.872327152338643, 91.69327983705759, 1260.2352340213058, 23005.06117113353, 6.794718578578467E11, 8.600125311027929E29}, {1.016708126665958, 1.9020000646892845, 9.507779844028835, 86.79289152923246, 1171.912577110535, 21013.803197074503, 5.673256986817975E11, 5.997323005594869E29}, {1.0016585701624696, 1.8606293903160174, 9.162313790846754, 82.23180299423491, 1091.1597216097273, 19225.384813691202, 4.752006071394876E11, 4.20900601243077E29}, {0.9869343090323693, 1.8206641544396354, 8.834624629892867, 77.98122130868848, 1017.2124863801748, 17616.127538208253, 3.9926099430234235E11, 2.9721774635221055E29}, {0.9725243828322906, 1.7820343946144024, 8.523517580350944, 74.01523422809697, 949.3951391239565, 16165.458270227356, 3.364545753467987E11, 2.1113079968746664E29}, {0.9584183720696728, 1.74467476942686, 8.227896578014924, 70.31047958621791, 887.1088914057387, 14855.458669681864, 2.843428066357029E11, 1.5084235500726314E29}, {0.9446063627695309, 1.7085241811797418, 7.946754646293063, 66.84585734751631, 829.8220499026412, 13670.486019685895, 2.4097004228558176E11, 1.0836957417537608E29}, {0.9310789139110863, 1.673525435022516, 7.679165345453489, 63.602278220937755, 777.061563179378, 12596.853297243164, 2.0476212262902808E11, 7.827540102695972E28}, {0.9178270274592306, 1.6396249304831432, 7.4242751642971, 60.562443694745845, 728.4057477207953, 11622.558439262924, 1.7444743859951437E11, 5.683323737578565E28}, {0.9048421207460821, 1.606772381861001, 7.181296737390617, 57.71065314272519, 683.4780132537015, 10737.054610231811, 1.4899523703919986E11, 4.147319243495508E28}, {0.8921160009844346, 1.5749205643763275, 6.949502787047233, 55.0326343108935, 641.9414371435106, 9931.054744211056, 1.2756720861984575E11, 3.041253661108008E28}, {0.8796408417181962, 1.5440250833475941, 6.728220702883325, 52.5153940445849, 603.4940621186208, 9196.364820084294, 1.0947935180819626E11, 2.240748770735851E28}, {0.8674091610354049, 1.5140441639937805, 6.516827683400257, 50.14708657742853, 567.8648117590927, 8525.74129193702, 9.417181917045212E10, 1.6585447454859963E28}, {0.8554138013874808, 1.4849384597410369, 6.314746373964821, 47.91689709183531, 534.8099348868542, 7912.768880722044, 8.118498870213792E10, 1.2330924274914515E28}, {0.8436479108743329, 1.4566708771588701, 6.121440944058644, 45.814938587728754, 504.10990385415374, 7351.755574155173, 7.01404082699251E10, 9.207505294038205E27}, {0.8321049258690587, 1.4292064158651003, 5.936413553958703, 43.83216037271298, 475.5667032615977, 6837.642206966965, 6.072556896993153E10, 6.904180992750448E27}, {0.8207785548684993, 1.4025120219258085, 5.759201167283318, 41.9602667211041, 449.00145526345335, 6365.9244253612915, 5.268169775507872E10, 5.198217404503487E27}, {0.8096627634670317, 1.3765564534401031, 5.589372671245167, 40.191644448198204, 424.25233567330974, 5932.5851954663885, 4.579393918510644E10, 3.9293362882817264E27}, {0.7987517603608784, 1.3513101571429953, 5.426526271124562, 38.51929831553041, 401.1727418416425, 5534.036309844881, 3.9883434066207214E10, 2.981665420448682E27}, {0.7880399842990261, 1.32674515498569, 5.270287129520951, 36.936793327424546, 379.6296789615265, 5167.06759010481, 3.480090911271928E10, 2.2710566573660262E27}, {0.7775220919047292, 1.3028349397635022, 5.120305224449737, 35.43820310276175, 359.5023362520672, 4828.802686463658, 3.0421474101752235E10, 1.7361315017947388E27}, {0.7671929462986014, 1.2795543789593853, 4.976253403401843, 34.018063611866246, 340.680828520503, 4516.660544144801, 2.664038696020661E10, 1.3319282499300936E27}, {0.757047606460607, 1.2568796260574195, 4.837825613140541, 32.671331659437556, 323.0650820362336, 4228.32174771442, 2.33695970948474E10, 1.0253738379555615E27}, {0.7470813172739234, 1.2347880386570107, 4.704735287328445, 31.393347572813713, 306.56384656438337, 3961.699072757216, 2.0534916289145264E10, 7.920416340343054E26}, {0.7372895001987079, 1.2132581027862437, 4.5767138761045425, 30.17980162243525, 291.0938178865657, 3714.9116736042797, 1.8073697110756264E10, 6.138197207845324E26}, {0.7276677445283883, 1.1922693628729355, 4.453509503506312, 29.026703759787384, 276.57885725151306, 3486.2624194037007, 1.5932922883874254E10, 4.772267626733605E26}, {0.7182117991851963, 1.1718023568853388, 4.334885740189328, 27.930356308671318, 262.9492960056645, 3274.217961316875, 1.4067632324863768E10, 3.721905050467027E26}, {0.7089175650153793, 1.151838556202026, 4.220620480265458, 26.88732928952799, 250.14131520155806, 3077.3911732109677, 1.2439617028123507E10, 2.9115819973814083E26}, {0.6997810875478772, 1.132360309812866, 4.110504912285425, 25.89443809466482, 238.09639130985906, 2894.5256586953765, 1.101634197929061E10, 2.284461802005113E26}, {0.6907985501832788, 1.1133507924909003, 4.004342575453815, 24.94872326543027, 226.7608003025098, 2724.4820602000705, 9.770048828600668E9, 1.797624470564275E26}, {0.6819662677826187, 1.094793956608756, 3.901948493102489, 24.047432151329275, 216.08517335777253, 2566.2259422427705, 8.677009294324245E9, 1.41854916353234E26}, {0.6732806806280598, 1.0766744873035805, 3.8031483762780027, 23.188002256361735, 206.0240982864094, 2418.8170520983317, 7.716902186787269E9, 1.122512961357175E26}, {0.6647383487297686, 1.05897776072165, 3.70777789103336, 22.368046099993833, 196.53576151166985, 2281.3997876134404, 6.872292461908264E9, 8.906602887640676E25}, {0.656335946455335, 1.0416898050982195, 3.615681983666186, 21.58533743956519, 187.58162607086953, 2153.1947246085374, 6.12819467596547E9, 7.085650389397799E25}, {0.6480702574599624, 1.0247972644501215, 3.5267142587243487, 20.8377987179577, 179.12614165724432, 2033.4910757656467, 5.471706414318425E9, 5.6515597209940065E25}, {0.6399381698973488, 1.008287364678371, 3.4407364051150457, 20.123489615317514, 171.13648319942766, 1921.6399696089582, 4.891699858970559E9, 4.519109094886325E25}, {0.6319366718927256, 0.9921478818958377, 3.35761766611206, 19.440596596797267, 163.58231489246316, 1817.0484525579311, 4.378561764115913E9, 3.6225050348295786E25}, {0.6240628472609475, 0.976367112811089, 3.277234349464994, 18.78742335990345, 156.43557695737357, 1719.1741294183118, 3.9239738210877705E9, 2.910806904435689E25}, {0.6163138714538018, 0.9609338470140358, 3.1994693741797047, 18.162382095292017, 149.67029272330888, 1627.5203683674304, 3.520726790694241E9, 2.344462771274506E25}, {0.6086870077219027, 0.9458373410221138, 3.124211850865822, 17.56398548392542, 143.26239390346228, 1541.6320057335242, 3.162562922598865E9, 1.8926786268373104E25}, {0.6011796034776085, 0.931067293957617, 3.0513566928397586, 16.990839361535297, 137.18956217864474, 1461.0914938735853, 2.844042116790629E9, 1.5314144883599281E25}, {0.593789086846394, 0.9166138247375668, 2.9808042554338074, 16.441635988455314, 131.43108541524094, 1385.515442397215, 2.560428050235377E9, 1.241853522335255E25}, {0.5865129633950206, 0.902467450667262, 2.9124600011972417, 15.915147869209743, 125.96772703116949, 1314.5515090152867, 2.3075911237943306E9, 1.009229171912316E25}, {0.5793488130256772, 0.888619067337531, 2.8462341888867257, 15.410222071861641, 120.78160718782786, 1247.875601539493, 2.0819256056238346E9, 8.219240395010488E24}, {0.5722942870260402, 0.8750599297337683, 2.7820415843335358, 14.925775002125361, 115.85609463073779, 1185.1893571307899, 1.8802787778615835E9, 6.70775652202395E24}, {0.5653471052658956, 0.8617816344721801, 2.719801191446346, 14.460787591703909, 111.17570812922567, 1126.2178688839606, 1.6998902499006612E9, 5.485401705633926E24}, {0.5585050535316256, 0.8487761030853542, 2.6594360017627006, 14.014300864286842, 106.72602657815013, 1070.707633321219, 1.5383398972829516E9, 4.494770131261305E24}, {0.5517659809904542, 0.8360355662853576, 2.6008727611016247, 13.585411846195282, 102.49360692430223, 1018.4246954177856, 1.3935031310372784E9, 3.690263017380547E24}, {0.5451277977769, 0.8235525491381415, 2.5440417519956897, 13.173269791835665, 98.4659091682748, 969.1529704546978, 1.263512406961463E9, 3.0355775052766967E24}, {0.5385884726943944, 0.8113198570881144, 2.4888765906946695, 12.777072696966332, 94.63122777074032, 922.6927243387001, 1.1467240550951443E9, 2.5017468840003416E24}, {0.5321460310254924, 0.7993305627763824, 2.4353140376359264, 12.396064075328413, 90.9786288614103, 878.8591960887599, 1.0416896523324692E9, 2.0656073738906943E24}, {0.5257985524445375, 0.7875779936004347, 2.383293820370091, 12.029529976478223, 87.4978927105462, 837.481348000499, 9.471312805985917E8, 1.7085957598477692E24}, {0.5195441690270468, 0.7760557199669224, 2.332758468015183, 11.67679622471077, 84.17946097767012, 798.4007305954595, 8.619201132156175E8, 1.415804272009385E24}, {0.5133810633504508, 0.7647575441927733, 2.2836531563892777, 11.3372258608098, 81.01438830090179, 761.4704508691597, 7.850578562645215E8, 1.175235968433789E24}, {0.5073074666811708, 0.7536774900131519, 2.2359255630416106, 11.01021677002054, 77.99429783382513, 726.5542335941043, 7.156606425892099E8, 9.772167618770727E23}, {0.5013216572433351, 0.7428097926577882, 2.189525731465581, 10.695199481137703, 75.11134037558628, 693.5255665319221, 6.529450357993925E8, 8.13930110689816E23}, {0.4954219585647289, 0.7321488894599709, 2.1444059438349337, 10.391635122950664, 72.35815677458267, 662.2669213804522, 5.962158520395937E8, 6.790479840297915E23}, {0.4896067378958557, 0.7216894109650291, 2.1005206016570814, 10.09901352550557, 69.72784331709617, 632.6690431424357, 5.448555499180884E8, 5.6743755819990807E23}, {0.48387440469823384, 0.7114261725074972, 2.057826113785617, 9.81685145474474, 67.21391983996752, 604.6303013659617, 4.983149750895824E8, 4.749276153660136E23}, {0.4782234091982993, 0.7013541662282811, 2.016280791277863, 9.544690970078555, 64.81030033126835, 578.0560973847132, 4.5610527660479796E8, 3.9812210998810046E23}, {0.47265224100349945, 0.6914685535051649, 1.975844748623423, 9.282097895346135, 62.51126580522865, 552.8583222886388, 4.1779083814965004E8, 3.342510789302326E23}, {0.4671594277773728, 0.6817646577718113, 1.9364798109062762, 9.028660394436795, 60.311439257695895, 528.9548608918151, 3.829830894227243E8, 2.810511788699572E23}, {0.4617435339706012, 0.6722379577021101, 1.8981494264964773, 8.783987643584492, 58.205762526397066, 506.26913744185003, 3.513350817493418E8, 2.3666977711640274E23}, {0.4564031596051975, 0.6628840807383001, 1.860818584898206, 8.547708593018832, 56.18947489645858, 484.7296992409728, 3.22536728111393E8, 1.9958780475331673E23}, {0.4511369391091613, 0.6536987969427219, 1.824453739408997, 8.319470811266237, 54.258093306213006, 464.2698347290225, 2.9631062151018524E8, 1.6855758508397293E23}, {0.4459435401990891, 0.6446780131544182, 1.7890227342707936, 8.098939405949393, 52.4073940214545, 444.8272229180703, 2.724083573320239E8, 1.4255263791141407E23}, {0.44082166280837054, 0.635817767433016, 1.7544947360170815, 7.885796015437486, 50.633395658150256, 426.3436113720512, 2.50607295453672E8, 1.2072707921630393E23}, {0.43577003805874037, 0.6271142237734898, 1.720840168742121, 7.679737866159232, 48.932343444311165, 408.7645201965786, 2.3070770646015814E8, 1.0238272335877366E23}, {0.43078742727308045, 0.6185636670764615, 1.6880306530382463, 7.480476890809171, 47.30069462138685, 392.03896974761284, 2.1253025376392305E8, 8.6942379725477E22}, {0.42587262102748347, 0.610162498359679, 1.6560389483655458, 7.28773890305946, 45.735104894289705, 376.1192299860409, 1.9591376979219106E8, 7.392814003379129E22}, {0.42102443824070834, 0.6019072301972346, 1.6248388986351774, 7.101262824737944, 44.23241584706284, 360.96058960124066, 1.8071328990102947E8, 6.294369360424536E22}, {0.41624172529924974, 0.5937944823739367, 1.5944053808030927, 6.920799961751289, 42.7896432483703, 346.5211432027854, 1.6679831240879992E8, 5.365989930971875E22}, {0.4115233552163542, 0.5858209777430315, 1.564714256285314, 6.746113325323008, 41.40396617748418, 332.76159503779684, 1.5405125722803468E8, 4.5802995138677726E22}, {0.40686822682339735, 0.5779835382762157, 1.5357423250191313, 6.576976995382198, 40.0727169073367, 319.64507783395015, 1.4236609910603762E8, 3.914494761045983E22}, {0.4022752639921259, 0.570279081295558, 1.5074672820067732, 6.413175523182275, 38.79337148655488, 307.136985496476, 1.3164715453969628E8, 3.3495540113737748E22}, {0.39774341488635045, 0.5627046158775895, 1.4798676761894072, 6.254503370452232, 37.563540967259975, 295.20481850322125, 1.2180800407635394E8, 2.869587667926629E22}, {0.39327165124174684, 0.5552572394204098, 1.4529228715097044, 6.10076438258722, 36.38096322983349, 283.8180409462016, 1.1277053400740388E8, 2.461303973844979E22}, {0.38885896767249806, 0.5479341343652169, 1.4266130100308634, 5.951771293573032, 35.243495359877635, 272.94794826234295, 1.044640834534963E8, 2.113569020912502E22}, {0.38450438100357254, 0.5407325650641737, 1.4009189769888613, 5.8073452605110205, 34.149106536261534, 262.5675447812744, 9.682468457166307E7, 1.817043827679644E22}, {0.38020692962750013, 0.5336498747870155, 1.3758223676629768, 5.6673154257682725, 33.09587139248539, 252.65143029506223, 8.979438512106012E7, 1.5638845472123786E22}, {0.37596567288456445, 0.5266834828592446, 1.3513054559572395, 5.531518504923094, 32.08196381664109, 243.17569492448672, 8.332064393603963E7, 1.3474944644659775E22}, {0.3717796904653856, 0.5198308819251781, 1.3273511645925513, 5.3997983988095575, 31.105651158027612, 234.11782161960082, 7.735579099917117E7, 1.1623185438467886E22}, {0.3676480818349198, 0.5130896353295109, 1.3039430368157792, 5.272005828087829, 30.165288811019217, 225.45659568954193, 7.185654480521786E7, 1.0036729873785147E22}, {0.36356996567695393, 0.5064573746114182, 1.2810652095382187, 5.147997988880326, 29.259315149105205, 217.17202080848324, 6.67835805793266E7, 8.67603641658789E21}, {0.35954447935821443, 0.4999317971055641, 1.2587023878214594, 5.027638228118008, 28.38624678414164, 209.24524099172692, 6.21011436755183E7, 7.507682102524443E21}, {0.35557077841125934, 0.4935106636447081, 1.2368398206339524, 4.910795737337394, 27.54467412779856, 201.65846807875567, 5.7776703149354614E7, 6.50338137523729E21}, {0.35164803603535927, 0.48719179635889465, 1.215463277806449, 4.7973452637576495, 26.73325723396416, 194.39491429896444, 5.3780641083814874E7, 5.639167703775103E21}, {0.3477754426146151, 0.4809730765665, 1.1945590281190164, 4.687166837548952, 25.950721902497285, 187.4387295311918, 5.008597376066348E7, 4.894710082281754E21}, {0.3439522052525941, 0.47485244275266614, 1.1741138184565558, 4.580145514279085, 25.195856026213992, 180.7749429003909, 4.6668101220187426E7, 4.252741446775657E21}, {0.34017754732280336, 0.46882788863090497, 1.15411485397368, 4.476171131595072, 24.46750616436468, 174.38940838412753, 4.350458214814801E7, 3.698580077342591E21}, {0.3364507080343517, 0.4628974612838856, 1.134549779213465, 4.375138079261351, 23.764574327117007, 168.26875412834417, 4.057493137706833E7, 3.2197283577457043E21}, {0.33277094201217977, 0.4570592593796322, 1.1154066601279884, 4.276945081735757, 23.086014956715786, 162.40033519622747, 3.7860437595587514E7, 2.80553597418636E21}, {0.3291375188912728, 0.451311431459572, 1.0966739669517693, 4.181494992520012, 22.43083209205387, 156.77218949628784, 3.53439991297821E7, 2.4469168606080223E21}, {0.3255497229242913, 0.4456521742950541, 1.078340557882153, 4.088694599572598, 21.798076704364913, 151.37299665609228, 3.3009975898621403E7, 2.1361110285076624E21}, {0.32200685260208706, 0.44007973130915107, 1.0603956635234815, 3.9984544411194913, 21.18684419264844, 146.1920396266795, 3.0844055856042683E7, 1.8664839268787335E21}, {0.3185082202865937, 0.4345923910607152, 1.0428288720544523, 3.910688631242223, 20.596272028265567, 141.21916881967934, 2.8833134417935763E7, 1.632357221275527E21}, {0.31505315185560506, 0.42918848578782887, 1.0256301150804874, 3.825314694663615, 20.02553753890639, 136.44476859470592, 2.6965205536613937E7, 1.428865907743207E21}, {0.3116409863589784, 0.423866390007934, 1.0087896541351857, 3.7422534101894662, 19.473855822833208, 131.85972592882902, 2.5229263230730876E7, 1.2518375263386453E21}, {0.308271075685817, 0.41862451917206556, 0.9922980677970352, 3.6614286622996315, 18.94047778495209, 127.45540111296688, 2.361521250736348E7, 1.097689941854545E21}, {0.3049427842422122, 0.41346132837075267, 0.9761462393895379, 3.582767300414707, 18.42468828686376, 123.22360033199755, 2.2113788727110717E7, 9.633447420287289E20}, {0.30165548863913805, 0.4083753110892704, 0.9603253452347355, 3.5061990053948686, 17.925804403597002, 119.15654999634327, 2.0716484564301424E7, 8.461537871360013E20}, {0.2984085773901147, 0.4033649980100473, 0.9448268434318573, 3.431656162855744, 17.443173780238318, 115.24687270284497, 1.9415483804287508E7, 7.438368467550865E20}, {0.29520145061827074, 0.39842895586014343, 0.9296424631344228, 3.3590737429124453, 16.97617308214292, 111.48756471197564, 1.8203601299658105E7, 6.544285938924066E20}, {0.2920335197724515, 0.3935657863018175, 0.9147641943006437, 3.288389185987399, 16.52420653284842, 107.87197483692677, 1.7074228478217773E7, 5.762335052003868E20}, {0.288904207352038, 0.3887741248643056, 0.900184277893399, 3.2195422943404033, 16.086704534216057, 104.3937846479005, 1.6021283858758872E7, 5.0778744834783484E20}, {0.2858129466401511, 0.3840526399150206, 0.8858951965073708, 3.152475129000554, 15.663122363697468, 101.04698990210973, 1.5039168086924322E7, 4.4782493158433856E20}, {0.28275918144493595, 0.379400031668476, 0.8718896654021969, 3.0871319117995224, 15.252938943971401, 97.82588311659083, 1.4122723053602234E7, 3.95251152702411E20}, {0.27974236584862766, 0.3748150312313171, 0.8581606239216478, 3.0234589322240573, 14.855655680514506, 94.72503720700496, 1.3267194703011744E7, 3.491181203147726E20}, {0.2767619639641191, 0.3702963996819245, 0.8447012272799542, 2.9614044588228885, 14.470795362968092, 91.73929012120382, 1.2468199177550424E7, 3.086042340711863E20}, {0.27381744969875754, 0.3658429271831268, 0.8315048386974264, 2.900918654919183, 14.097901126437595, 88.86373040148989, 1.1721691982116591E7, 2.7299680581372674E20}, {0.27090830652511183, 0.3614534321266308, 0.8185650218684919, 2.8419534983947883, 13.736535469117529, 86.0936836142586, 1.1023939882475909E7, 2.4167708375474848E20}, {0.26803402725846237, 0.35712676030784585, 0.8058755337461819, 2.784462705326466, 13.38627932287178, 83.42469959009621, 1.0371495280731404E7, 2.141074090817532E20}, {0.2651941138407741, 0.3528617841298385, 0.7934303176279573, 2.728401657267435, 13.046731173619431, 80.85254042145564, 9761172.83645337, 1.8982019104318862E20}, {0.26238807713092654, 0.3486574018352179, 0.781223496528572, 2.673727331979777, 12.717506228581147, 78.3731691687723, 9190028.124860402, 1.684084342904383E20}, {0.2596154367009798, 0.3445125367648043, 0.76924936682643, 2.6203982374347152, 12.39823562763138, 75.98273922933636, 8655338.143906271, 1.4951759249306278E20}, {0.25687572063826847, 0.3404261366419904, 0.7575023921706072, 2.568374348908482, 12.088565696178614, 73.67758432642974, 8154583.500478312, 1.328385562139585E20}, {0.25416846535312076, 0.3363971728817534, 0.7459771976363859, 2.5176170490115366, 11.788157237160668, 71.45420907919087, 7685432.122380116, 1.1810161173530293E20}, {0.2514932153920113, 0.3324246399233266, 0.7346685641177767, 2.4680890704982588, 11.496684859895067, 69.3092801163998, 7245724.357557548, 1.0507123180549921E20}, {0.24884952325595946, 0.32850755458558023, 0.7235714229461042, 2.419754441713049, 11.213836343667415, 67.23961769990619, 6833459.335312423, 9.354157983434382E19}, {0.24623694922399855, 0.3246449554442112, 0.712680850724302, 2.372578434537033, 10.93931203407358, 65.2421878257645, 6446782.476192653, 8.333262648608316E19}, {0.24365506118154182, 0.3208359022298757, 0.7019920643670784, 2.3265275147072426, 10.67282427025526, 63.314094773308724, 6083974.047993067, 7.428679240020327E19}, {0.24110343445348342, 0.3170794752464429, 0.6915004163376354, 2.281569294387453, 10.414096841284168, 61.452574074411146, 5743438.674973943, 6.626604332044895E19}, {0.2385816516418742, 0.3133747748085809, 0.6812013900720733, 2.2376724868765843, 10.1628644700576, 59.65498587703252, 5423695.716116806, 5.91493745801195E19}, {0.23608930246802368, 0.3097209206979254, 0.6710905955830875, 2.1948068633470474, 9.918872323168962, 57.91880867890302, 5123370.43608954, 5.283063096717303E19}, {0.23362598361887935, 0.3061170516371106, 0.6611637652349556, 2.152943211511288, 9.681875545310184, 56.24163340877488, 4841185.899673761, 4.721661572083897E19}, {0.23119129859754523, 0.3025623247809765, 0.6514167496822347, 2.1120532961205174, 9.451638816851059, 54.62115783418195, 4575955.526797482, 4.2225448998350406E19}, {0.22878485757780398, 0.2990559152242959, 0.641845513964953, 2.0721098212048292, 9.22793593332198, 53.055181276022395, 4326576.251084604, 3.778514176966067E19}, {0.22640627726251358, 0.2955970155253938, 0.6324461337534392, 2.033086393968908, 9.010549405603335, 51.54159961156965, 4092022.230044713, 3.383235589606549E19}, {0.22405518074575304, 0.2921848352450571, 0.6232147917362683, 1.9949574902621834, 8.799270079696036, 50.07840054871046, 3871339.059736817, 3.03113252491326E19}, {0.22173119737859792, 0.2888186005001617, 0.614147774145122, 1.9576984215466888, 8.593896775014777, 48.66365915532265, 3663638.4510014155, 2.7172916233745818E19}, {0.2194339626384098, 0.2854975535314654, 0.6052414674106603, 1.9212853032900068, 8.394235940207986, 47.29553362873858, 3468093.328209967, 2.4373809081759216E19}, {0.21716311800152827, 0.28222095228504096, 0.5964923549437876, 1.8856950247145774, 8.200101325567083, 45.97226129120427, 3283933.314971574, 2.187578385557347E19}, {0.21491831081925883, 0.278988070006845, 0.587897014036966, 1.850905219838305, 8.011313671142467, 44.692154798140265, 3110440.5743984347, 1.9645097307286622E19}, {0.2126991941970531, 0.2757981948499394, 0.5794521128804832, 1.8168942397448413, 7.827700409734904, 43.45359854684539, 2946945.974397478, 1.7651938632725713E19}, {0.21050542687678248, 0.27265062949390306, 0.5711544076888235, 1.7836411260251823, 7.64909538397923, 42.255045274063434, 2792825.5510546914, 1.5869953786295216E19}, {0.2083366731220089, 0.26954469077599064, 0.563000739932523, 1.7511255853352616, 7.47533857678224, 41.095012831557575, 2647497.245536563, 1.4275829420975768E19}, {0.20619260260616093, 0.26647970933361315, 0.5549880336710996, 1.7193279650171198, 7.306275854418952, 39.97208112951425, 2510417.892073914, 1.284892872097498E19}, {0.20407289030352627, 0.26345502925773395, 0.5471132929828673, 1.6882292297339507, 7.141758721631112, 38.88488923822932, 2381080.436537622, 1.1570972430551925E19}, {0.2019772163829743, 0.2604700077567879, 0.5393735994876219, 1.6578109390718703, 6.9816440881088795, 37.83213263911788, 2259011.3668826814, 1.042575927534104E19}, {0.19990526610432674, 0.2575240148307511, 0.5317661099583875, 1.6280552260637084, 6.825794045771693, 36.812560616639445, 2143768.338343447, 9.398920742486313E18}, {0.1978567297172964, 0.2546164329550008, 0.5242880540185795, 1.598944776592384, 6.674075656296979, 35.82497378324355, 2034937.9777242395, 8.47770585047849E18}, {0.19583130236291688, 0.25174665677362074, 0.5169367319211066, 1.5704628096335864, 6.526360748376156, 34.8682217299201, 1932133.8524593161, 7.650792113631964E18}, {0.19382868397738906, 0.2489140928018208, 0.5097095124060957, 1.5425930582995258, 6.382525724206321, 33.941200795387445, 1834994.5913272202, 6.908119402358351E18}, {0.19184857919827325, 0.24611815913715482, 0.5026038306340748, 1.5153197516474446, 6.242451374753183, 33.042851947370586, 1743182.144807612, 6.240743829661663E18}, {0.18989069727295696, 0.24335828517922928, 0.4956171861915867, 1.4886275972183918, 6.106022703346329, 32.17215876981301, 1656380.174074089, 5.64070916590675E18}, {0.1879547519693323, 0.24063391135761183, 0.4887471411663471, 1.4625017642734797, 5.973128757191896, 31.328145550232957, 1574292.5585332764, 5.100933605874631E18}, {0.18604046148861814, 0.23794448886765762, 0.4819913182891873, 1.4369278676964816, 5.843662466410386, 30.509875461778, 1496642.01265683, 4.615109991256755E18}, {0.18414754838026498, 0.2352894794139832, 0.4753473991401452, 1.4118919525331546, 5.71752049022859, 29.716448834852905, 1423168.803616305, 4.177617833925287E18}, {0.18227573945888212, 0.2326683549613281, 0.46881312241618267, 1.3873804791391176, 5.594603069974498, 28.94700151349625, 1353629.5619278213, 3.7834456955904036E18}, {0.18042476572312954, 0.23008059749255505, 0.46238628225812345, 1.3633803089095242, 5.474813888543138, 28.200703291964118, 1287796.1779502593, 3.4281226621529697E18}, {0.1785943622765178, 0.22752569877354833, 0.4560647266345036, 1.3398786905650204, 5.358059936018724, 27.47675642724172, 1225454.7776625531, 3.1076578099082286E18}, {0.1767842682500617, 0.225003160124779, 0.4498463557801333, 1.3168632469697628, 5.2442513811554825, 26.774394223452685, 1166404.771677817, 2.818486698963911E18}, {0.17499422672673612, 0.22251249219931704, 0.4437291206872639, 1.2943219624584086, 5.1333014484351205, 26.092879684367198, 1110457.9719387186, 2.557424049567898E18}, {0.17322398466768232, 0.22005321476707465, 0.4377110216473393, 1.2722431706501018, 5.025126300433763, 25.431504230427812, 1057437.7709839472, 2.321621861879823E18}, {0.1714732928401159, 0.21762485650507662, 0.43179010684140373, 1.2506155427285306, 4.919644925245222, 24.789586476916195, 1007178.3790834261, 2.1085323311241498E18}, {0.16974190574688916, 0.2152269547935597, 0.4259644709773174, 1.2294280761681249, 4.816779028720621, 24.166471070075843, 959524.1149134473, 1.9158749898039793E18}, {0.16802958155766262, 0.21285905551771167, 0.42023225397201297, 1.2086700838874107, 4.716452931296932, 23.56152757818567, 914328.7457851684, 1.7416075782691622E18}, {0.16633608204163988, 0.2105207128748655, 0.4145916396770945, 1.1883311838114092, 4.618593469198589, 22.974149434748153, 871454.8737536501, 1.5839002057448625E18}, {0.16466117250182416, 0.20821148918697374, 0.4090408546461596, 1.1684012888258462, 4.523129899807589, 22.403752931115, 830773.3642223893, 1.4411124170852616E18}, {0.16300462171075414, 0.205930954718192, 0.4035781669422869, 1.1488705971067128, 4.429993811007869, 21.84977625602199, 792162.8139222559, 1.3117728270140739E18}, {0.16136620184767986, 0.20367868749741008, 0.3982018849842032, 1.1297295828095106, 4.3391190343197055, 21.31167857964535, 755509.0553860855, 1.1945610243103112E18}, {0.15974568843713827, 0.20145427314557054, 0.39291035642969674, 1.110968987103202, 4.250441561649148, 20.788939179923332, 720704.6952626236, 1.0882914840396605E18}, {0.15814286028889235, 0.19925730470762537, 0.3877019670949124, 1.0925798095346124, 4.16389946548643, 20.281056609011248, 687648.6840179189, 9.918992571665914E17}, {0.15655749943919597, 0.19708738248898303, 0.38257513990821324, 1.0745532997096556, 4.079432822395561, 19.78754789785443, 656245.9147600447, 9.044272342715767E17}, {0.1549893910933501, 0.1949441138963055, 0.37752833389735185, 1.0568809492783875, 3.9969836396452543, 19.30794779697361, 626406.84909569, 8.25014804129739E17}, {0.1534383235695154, 0.19282711328251945, 0.37256004320874203, 1.0395544842114788, 3.916495784838783, 18.841808051660493, 598047.1680859255, 7.528877490061624E17}, {0.15190408824374826, 0.19073600179590974, 0.36766879615767334, 1.0225658573562566, 3.837914918407413, 18.388696709878484, 571087.4465145329, 6.873492370581187E17}, {0.1503864794962287, 0.18867040723317052, 0.36285315430835763, 1.005907241261003, 3.7611884288387736, 17.94819746125548, 545452.8488167331, 6.277717885267677E17}, {0.1488852946586477, 0.18662996389629, 0.3581117115827396, 0.9895710212566926, 3.686265370517804, 17.519909005641466, 521072.8451399189, 5.735901067303206E17}, {0.14740033396272514, 0.18461431245315302, 0.3534430933970477, 0.9735497887858489, 3.613096404063952, 17.103444449785638, 497880.94612202933, 5.242946774810639E17}, {0.145931400489828, 0.182623099801747, 0.34884595582510247, 0.9578363349686414, 3.541633739053907, 16.698430730763782, 475814.4550782294, 4.7942605165262234E17}, {0.14447830012166102, 0.180655978937862, 0.34431898478743755, 0.9424236443967946, 3.471831079024588, 16.304508064859572, 454814.23638341535, 4.385697354070335E17}, {0.1430408414920023, 0.17871260882617987, 0.33986089526532814, 0.9273048891462858, 3.4036435686561406, 15.921329420671132, 434824.4989273206, 4.013516212155143E17}, {0.14161883593945687, 0.1767926542746493, 0.335470430538853, 0.9124734230002041, 3.337027743039524, 15.548560015278817, 415792.5936013752, 3.6743390041387565E17}, {0.140212097461202, 0.17489578581204906, 0.3311463614481551, 0.8979227758735231, 3.271941478937859, 15.185876832370724, 397668.8238524516, 3.365114047470499E17}, {0.13882044266770044, 0.1730216795686448, 0.32688748567709697, 0.883646648431899, 3.2083439479550284, 14.832968161279847, 380406.2684087829, 3.0830833028540314E17}, {0.13744369073835552, 0.17117001715984617, 0.32269262705853535, 0.8696389068969357, 3.1461955715291055, 14.489533155940682, 363960.6153481061, 2.825753023331255E17}, {0.1360816633780859, 0.16934048557277698, 0.3185606349004748, 0.8558935780306967, 3.0854579776721236, 14.155281412824332, 348290.00673791836, 2.5908674457900362E17}, {0.13473418477479587, 0.1675327770556718, 0.31449038333238366, 0.8424048442925466, 3.0260939593813534, 13.829932566959299, 333354.89313301665, 2.3763851983496538E17}, {0.13340108155771996, 0.16574658901001654, 0.31048077067098545, 0.8291670391616948, 2.968067434650776, 13.51321590519065, 319117.8972665944, 2.1804581333167418E17}, {0.13208218275661923, 0.1639816238853531, 0.3065307188048672, 0.8161746426191131, 2.9113434080148024, 13.204869995873592, 305543.68631842936, 2.0014123274908205E17}, {0.13077731976180906, 0.16223758907667005, 0.3026391725972646, 0.803422276782739, 2.8558879335593588, 12.904642334237646, 292598.85218738613, 1.837731020022554E17}, {0.12948632628499768, 0.1605141968243059, 0.2988050993064174, 0.7909047016901654, 2.801668079338586, 12.612289002696858, 280251.79923592584, 1.6880392832213475E17}, {0.1282090383209154, 0.15881116411629104, 0.2950274880229018, 0.7786168112232275, 2.7486518931381143, 12.327574345416982, 268472.63901171763, 1.5510902440498317E17}, {0.12694529410971617, 0.15712821259306003, 0.29130534912337724, 0.766553629169163, 2.6968083695287004, 12.050270656485901, 257233.0914861345, 1.4257526938648997E17}, {0.12569493410013133, 0.15546506845446514, 0.2876377137401992, 0.7547103054132135, 2.6461074181564914, 11.780157881065263, 246506.3923814919, 1.3109999415606653E17}, {0.12445780091335899, 0.15382146236902683, 0.28402363324637436, 0.7430821122577703, 2.5965198332186885, 11.517023328932828, 236267.20618864443, 1.2058997808962197E17}, {0.12323373930767048, 0.15219712938535787, 0.2804621787553543, 0.7316644408633627, 2.5480172640756935, 11.260661399853833, 226491.5445041146, 1.1096054566774176E17}, {0.12202259614371669, 0.15059180884569914, 0.2769524406351767, 0.720452797806968, 2.5005721869529793, 11.010873320247212, 217156.6893414753, 1.0213475268069506E17}, {0.12082422035051815, 0.14900524430150847, 0.27349352803648996, 0.7094428017533321, 2.454157877688125, 10.76746689063909, 208241.12109541649, 9.404265281975931E16}, {0.11963846289212227, 0.14743718343104525, 0.2700845684340052, 0.6986301802351376, 2.4087483854803446, 10.530256243420219, 199724.45085889858, 8.66206364314781E16}, {0.11846517673491194, 0.14588737795889484, 0.2667247071809433, 0.6880107665380479, 2.364318507601821, 10.29906161044789, 191587.3568142032, 7.981083408143522E16}, {0.11730421681555075, 0.1443555835773798, 0.2634131070760566, 0.6775804966868061, 2.3208437650319453, 10.073709100055005, 183811.5244376238, 7.356057834903816E16}, {0.11615544000954918, 0.14284155986980515, 0.2601489479428205, 0.6673354065287175, 2.2783003789772485, 9.85403048304988, 176379.59027511856, 6.78219179653747E16}, {0.11501870510043788, 0.1413450702354881, 0.2569314262204059, 0.6572716289110019, 2.236665248241496, 9.639862987310584, 169275.08906258165, 6.255117902191088E16}, {0.11389387274953346, 0.13986588181652246, 0.25375975456605593, 0.6473853909486343, 2.195915927411959, 9.431049100596471, 162482.40397955923, 5.770856852700245E16}, {0.11278080546628381, 0.1384037654262318, 0.2506331614685067, 0.6376730113794324, 2.156030605829361, 9.227436381217522, 155986.71983933597, 5.325781607730983E16}, {0.1116793675791789, 0.13695849547926459, 0.2475508908721001, 0.6281308980032727, 2.116988087310412, 9.028877276219193, 149773.97903142613, 4.916584984879116E16}, {0.11058942520721435, 0.1355298499232871, 0.24451220181125297, 0.6187555452024431, 2.078767770593199, 8.83522894675659, 143830.84004468954, 4.540250350281116E16}, {0.10951084623189547, 0.1341176101722318, 0.24151636805495827, 0.6095435315402599, 2.0413496304769856, 8.646353100347289, 138144.63841063614, 4.194025095219267E16}, {0.10844350026976893, 0.13272156104105864, 0.2385626777610029, 0.6004915174351819, 2.004714199629185, 8.462115829706496, 132703.34991702295, 3.8753966244306504E16}, {0.10738725864547069, 0.13134149068198983, 0.23565043313960138, 0.5915962429077738, 1.96884255103347, 8.282387457882265, 127495.55595167351, 3.5820706097604144E16}, {0.1063419943652781, 0.12997719052217807, 0.23277895012615168, 0.5828545253979596, 1.9337162810540491, 8.107042389421498, 122510.410845582, 3.311951287792172E16}, {0.10530758209115512, 0.12862845520277127, 0.2299475580628327, 0.5742632576501214, 1.8993174930922554, 7.935958967310025, 117737.61109288194, 3.0631236024625516E16}, {0.10428389811527969, 0.12729508251933613, 0.22715559938877017, 0.56581940566368, 1.865628781812554, 7.769019335441881, 113167.36633318274, 2.8338370137046068E16}, {0.10327082033504198, 0.12597687336360544, 0.22440242933850874, 0.5575200067068914, 1.83263321791608, 7.606109306384122, 108790.37198916571, 2.6224908111187524E16}, {0.10226822822850413, 0.12467363166651449, 0.22168741564853717, 0.5493621673916814, 1.800314333440725, 7.447118234214383, 104597.78345921707, 2.42762078776296E16}, {0.10127600283030992, 0.12338516434249261, 0.21900993827161966, 0.5413430618074155, 1.7686561075676566, 7.291938892218318, 100581.19177129012, 2.247887143585398E16}, {0.10029402670803583, 0.1221112812349781, 0.2163693890986994, 0.5334599297115928, 1.7376429529150288, 7.140467355244021, 96732.60061017686, 2.0820635009696604E16}, {0.09932218393897282, 0.12085179506312418, 0.21376517168814346, 0.5257100747755171, 1.707259702300408, 6.992602886519486, 93044.40463594934, 1.929026926482377E16}, {0.0983603600873299, 0.11960652136966572, 0.21119670100210886, 0.5180908628830786, 1.6774915959542178, 6.848247828748051, 89509.36901653981, 1.7877488633461458E16}, {0.09740844218185028, 0.11837527846991718, 0.20866340314981757, 0.5105997204808524, 1.6483242691672586, 6.707307499305133, 86120.6101022901, 1.6572868885320164E16}, {0.09646631869383102, 0.11715788740187237, 0.20616471513753173, 0.5032341329777744, 1.6197437403559989, 6.569690089367283, 82871.57717483547, 1.5367772167868932E16}, {0.0955338795155376, 0.11595417187737872, 0.20370008462503267, 0.49599164319273814, 1.5917363995300835, 6.435306566812453, 79756.03520692888, 1.4254278814816828E16}, {0.09461101593900496, 0.11476395823435823, 0.20126896968840852, 0.48886984984850046, 1.5642889971470528, 6.304070582737173, 76768.04857376213, 1.322512528974035E16}, {0.0936976206352165, 0.11358707539004918, 0.19887083858896573, 0.4818664061103561, 1.5373886333399547, 6.175898381443521, 73901.96566004367, 1.2273647693050152E16}, {0.09279358763365338, 0.11242335479524276, 0.19650516954808395, 0.4749790181680914, 1.5110227475040563, 6.050708713755014, 71152.40431054127, 1.1393730315618828E16}, {0.09189881230220578, 0.1112726303894896, 0.1941714505278396, 0.46820544385978297, 1.485179108229447, 5.928422753526867, 68514.23807502944, 1.057975877203133E16}, {0.091013191327439, 0.11013473855725252, 0.19186917901723066, 0.46154349133606326, 1.4598458035668551, 5.808964017221979, 65982.58320159814, 9.82657729113112E15}, {0.09013662269520625, 0.10900951808498124, 0.18959786182383875, 0.454991017763519, 1.435011231614493, 5.692258286429551, 63552.78633510328, 9.129449781825284E15}, {0.08926900567160173, 0.10789681011908725, 0.18735701487077194, 0.44854592806594534, 1.4106640914142592, 5.578233533208706, 61220.41288017803, 8.484024328430362E15}, {0.0884102407842458, 0.10679645812479555, 0.1851461629987345, 0.44220617370221305, 1.3867933741460525, 5.466819848144432, 58981.23599069477, 7.886300802592306E15}, {0.08756022980389642, 0.10570830784585272, 0.1829648397730776, 0.4359697514795668, 1.3633883546094498, 5.357949371008266, 56831.22614988014, 7.332601308360624E15}, {0.0867188757263793, 0.10463220726506983, 0.18081258729568672, 0.42983470240119703, 1.3404385829823693, 5.251556223920511, 54766.54130744689, 6.819543203660141E15}, {0.08588608275483046, 0.10356800656568002, 0.1786889560215688, 0.42379911054698616, 1.3179338768468003, 5.147576446915446, 52783.51754213522, 6.344014465477295E15}, {0.08506175628224481, 0.10251555809349093, 0.17659350458000456, 0.4178611019863562, 1.29586431347203, 5.045947935815035, 50878.660219950376, 5.903151187817511E15}, {0.08424580287432427, 0.10147471631981286, 0.17452579960013642, 0.41201884372219083, 1.2742202223461971, 4.946610382320756, 49048.63562016328, 5.494317021133068E15}, {0.08343813025261965, 0.10044533780514404, 0.1724854155408679, 0.40627054266483886, 1.2529921779473543, 4.8495052162370165, 47290.26300280393, 5.115084379672288E15}, {0.08263864727795976, 0.09942728116359442, 0.1704719345249513, 0.40061444463523976, 1.2321709927455513, 4.754575549743195, 45600.50709293887, 4.763217259251533E15}, {0.08184726393416258, 0.09842040702803105, 0.16848494617714765, 0.39504883339624874, 1.2117477104278045, 4.6617661236349965, 43976.47095848675, 4.4366555224678255E15}, {0.08106389131202213, 0.0974245780159271, 0.16652404746634414, 0.3895720297112677, 1.1917135993381012, 4.57102325545899, 42415.389259696756, 4.1335005215038705E15}, {0.08028844159356606, 0.09643965869589857, 0.16458884255151934, 0.384182390429324, 1.1720601461249214, 4.48229478946751, 40914.62184970146, 3.8520019405649275E15}, {0.07952082803657798, 0.09546551555491162, 0.16267894263144872, 0.378878307595763, 1.1527790495890176, 4.395530048324047, 39471.64770676178, 3.5905457507497995E15}, {0.07876096495937973, 0.09450201696614552, 0.16079396579804772, 0.37365820758775614, 1.133862214724496, 4.310679786492257, 38084.05917995359, 3.34764317990665E15}, {0.07800876772586815, 0.09354903315749542, 0.15893353689325174, 0.3685205502738479, 1.1153017469464903, 4.227696145244403, 36749.55653110795, 3.121920608856573E15}, {0.07726415273080098, 0.09260643618069972, 0.1570972873693352, 0.3634638281967949, 1.0970899464989772, 4.146532609227751, 35465.942756813216, 2.912110313373043E15}, {0.07652703738532794, 0.09167409988107834, 0.1552848551525774, 0.35848656577897764, 1.0792193030365405, 4.0671439645299765, 34231.11867522482, 2.717041978563367E15}, {0.07579734010276086, 0.09075189986786676, 0.15349588451018104, 0.3535873185496836, 1.0616824903740945, 3.989486258186994, 33043.07826330506, 2.535634918880771E15}, {0.07507498028457912, 0.08983971348513255, 0.15173002592035775, 0.3487646723935929, 1.0444723613988378, 3.9135167590790463, 31899.90423094368, 2.3668909429683495E15}, {0.0743598783066656, 0.0889374197832612, 0.14998693594549317, 0.3440172428198142, 1.0275819431388968, 3.8391939201630008, 30799.763819183238, 2.2098878079561672E15}, {0.07365195550576809, 0.08804489949099732, 0.1482662771083082, 0.3393436742508417, 1.0110044319833298, 3.766477341990943, 29740.90481050319, 2.0637732127539142E15}, {0.07295113416618254, 0.08716203498802955, 0.14656771777093724, 0.33474263933082893, 0.9947331890483754, 3.6953277374672324, 28721.651739801528, 1.927759284350617E15}, {0.0722573375066535, 0.08628871027810602, 0.14489093201684375, 0.33021283825259046, 0.9787617356850016, 3.6257068977980507, 27740.402295356453, 1.8011175151929825E15}, {0.07157048966748726, 0.08542481096266862, 0.14323559953549786, 0.3257529981027657, 0.9630837491229955, 3.5575776595893283, 26795.623899655588, 1.6831741134035985E15}, {0.07089051569787422, 0.08457022421499436, 0.1416014055097424, 0.321361872224597, 0.9476930582470259, 3.4909038730507707, 25885.850460550773, 1.5733057309544762E15}, {0.0702173415434159, 0.08372483875483219, 0.13998804050577607, 0.3170382395977923, 0.9325836395002569, 3.4256503712653155, 25009.679283730566, 1.470935537961406E15}, {0.06955089403385302, 0.08288854482352434, 0.13839520036568387, 0.3127809042349593, 0.9177496129112636, 3.3617829404850044, 24165.76813800741, 1.3755296140392632E15}, {0.06889110087099076, 0.08206123415960129, 0.1368225861024488, 0.3085886945941192, 0.9031852382401621, 3.2992682914158475, 23352.832465390522, 1.2865936301829728E15}, {0.06823789061681718, 0.08124279997483953, 0.13526990379737786, 0.3044604630068162, 0.8888849112399921, 3.238074031455635, 22569.64272836094, 1.203669796936828E15}, {0.06759119268181163, 0.08043313693077238, 0.13373686449988104, 0.3003950851213662, 0.8748431600295674, 3.1781686378502068, 21815.021887186696, 1.1263340567072382E15}, {0.06695093731343912, 0.07963214111564315, 0.13222318412954007, 0.2963914593607908, 0.8610546415741076, 3.1195214317349143, 21087.843000510125, 1.0541934999795872E15}, {0.06631705558482744, 0.07883971002179149, 0.1307285833804087, 0.2924485063950083, 0.847514138270135, 3.0621025530294363, 20387.026942813176, 9.868839869361289E14}, {0.0656894793836233, 0.0780557425234628, 0.12925278762748552, 0.28856516862685944, 0.8342165546312138, 3.0058829361552433, 19711.540232716383, 9.240679575540885E14}, {0.06506814140102463, 0.07728013885503204, 0.12779552683530387, 0.28474040969156433, 0.821156914071256, 2.9508342865462915, 19060.39296639875, 8.654324147056156E14}, {0.06445297512098518, 0.07651280058963236, 0.12635653546858416, 0.28097321396921837, 0.8083303557822209, 2.896929057924626, 18432.636850736588, 8.106870660965949E14}, {0.06384391480958862, 0.07575363061817988, 0.12493555240489498, 0.27726258610994603, 0.7957321317031515, 2.8441404303136606, 17827.363331053213, 7.59562612081142E14}, {0.06324089550458897, 0.07500253312878631, 0.1235323208492725, 0.2736075505713466, 0.7833576035776003, 2.792442288762987, 17243.70180864842, 7.118091674834586E14}, {0.06264385300511403, 0.07425941358655054, 0.12214658825074748, 0.27000715116787666, 0.7712022400966048, 2.7418092027595584, 16680.817943537342, 6.671948065579282E14}, {0.062052723861529095, 0.07352417871372127, 0.1207781062207314, 0.26646045063182255, 0.7592616141244595, 2.6922164063010223, 16137.912038074412, 6.255042211306298E14}, {0.06146744536545792, 0.07279673647022292, 0.11942663045321503, 0.2629665301855335, 0.7475314000046486, 2.643639778607981, 15614.217497370535, 5.865374827986269E14}, {0.060887955539958, 0.0720769960345364, 0.11809192064673293, 0.2595244891245887, 0.7360073709433727, 2.5960558254527557, 15108.999362630306, 5.5010890082447144E14}, {0.060314193129847454, 0.07136486778492802, 0.11677374042805, 0.2561334444115894, 0.7246853964682147, 2.549441661083155, 14621.55291374296, 5.1604596805887075E14}, {0.059746097592180684, 0.07066026328101833, 0.11547185727752637, 0.25279253028027127, 0.7135614399595562, 2.503774990720512, 14151.202337655472, 4.841883878601409E14}, {0.05918360908687011, 0.06996309524568409, 0.1141860424561186, 0.24950089784964413, 0.7026315562524492, 2.459034093612063, 13697.299459240598, 4.5438717556033556E14}, {0.058626668467451515, 0.06927327754728639, 0.1129160709339769, 0.24625771474787717, 0.6918918893067288, 2.4151978066185005, 13259.222531546373, 4.265038285594919E14}, {0.058075217271990075, 0.06859072518221777, 0.1116617213205977, 0.24306216474565168, 0.6813386699432188, 2.37224550831821, 12836.375082477349, 4.0040955961573106E14}, {0.057529197714124965, 0.06791535425776188, 0.11042277579649402, 0.2399134473987183, 0.6709682136439667, 2.3301571036104525, 12428.184815113398, 3.7598458834396056E14}, {0.05698855267424977, 0.06724708197525896, 0.10919902004634524, 0.2368107776993975, 0.6607769184145071, 2.2889130088003515, 12034.102559017721, 3.531174863432394E14}, {0.05645322569082631, 0.06658582661357083, 0.1079902431935901, 0.2337533857367753, 0.6507612627062261, 2.2484941371492404, 11653.601270024388, 3.3170457174580744E14}, {0.05592316095182967, 0.06593150751283929, 0.10679623773642788, 0.23074051636535142, 0.6409178033969636, 2.2088818848744984, 11286.175076126367, 3.116493493223436E14}, {0.055398303286321934, 0.06528404505853147, 0.10561679948519229, 0.22777142888190421, 0.6312431738280482, 2.170058117583591, 10931.338367208175, 2.928619925908813E14}, {0.05487859815615255, 0.06464336066576683, 0.10445172750106577, 0.2248453967103462, 0.6217340818960341, 2.1320051571276286, 10588.624926484687, 2.752588646635647E14}, {0.05436399164778271, 0.06400937676391907, 0.10330082403610005, 0.2219617070943473, 0.612387308197447, 2.09470576886024, 10257.587101617168, 2.587620748281787E14}, {0.0538544304642322, 0.06338201678148851, 0.10216389447451307, 0.21911966079751455, 0.6031997042249275, 2.0581431492881475, 9937.79501358286, 2.432990681023713E14}, {0.05334986191714593, 0.06276120513123826, 0.10104074727522971, 0.21631857181091865, 0.5941681906131902, 2.02230091410025, 9628.83580147233, 2.2880224521940672E14}, {0.052850233918978376, 0.06214686719558943, 0.09993119391563704, 0.21355776706776675, 0.5852897554332888, 1.9871630865625813, 9330.312901482865, 2.1520861070700634E14}, {0.052355494975293945, 0.06153892931227004, 0.0988350488365251, 0.21083658616502696, 0.576561452533716, 1.952714086266888, 9041.845358463885, 2.024594469067919E14}, {0.05186559417718112, 0.060937318760212404, 0.09775212938818442, 0.20815438109181544, 0.5679803999269241, 1.9189387182211046, 8763.067168454585, 1.9050001195255153E14}, {0.05138048119377833, 0.06034196374569382, 0.09668225577763255, 0.2055105159643613, 0.5595437782198878, 1.8858221622703304, 8493.626650732473, 1.792792598822366E14}, {0.05090010626490992, 0.05975279338871602, 0.09562525101694286, 0.20290436676737297, 0.5512488290873911, 1.853349962837406, 8233.185847966817, 1.6874958120249775E14}, {0.05042442019383004, 0.059169737709618336, 0.09458094087264969, 0.2003353211016328, 0.543092853786753, 1.821508018972537, 7981.419953141709, 1.5886656235673144E14}, {0.04995337434007267, 0.058592727615919764, 0.09354915381620343, 0.19780277793765105, 0.5350732117127459, 1.7902825747017754, 7738.016761980443, 1.4958876266903206E14}, {0.049486920612406136, 0.0580216948893858, 0.09252972097545198, 0.1953061473752196, 0.5271873189915193, 1.7596602096645941, 7502.676149666785, 1.4087750744804088E14}, {0.04902501146189006, 0.05745657217331514, 0.09152247608712316, 0.19284485040870442, 0.5194326471123549, 1.7296278300310561, 7275.109570718531, 1.3269669603724331E14}, {0.04856759987503334, 0.05689729296004217, 0.09052725545028567, 0.19041831869792664, 0.511806721596141, 1.700172659689493, 7055.039580926084, 1.2501262369258519E14}, {0.048114639367051015, 0.05634379157865074, 0.08954389788076479, 0.1880259943444813, 0.5043071206994735, 1.6712822316958738, 6842.199380322604, 1.1779381625500125E14}, {0.04766608397521881, 0.055796003182895286, 0.08857224466649101, 0.1856673296733513, 0.496931474153334, 1.6429443799763834, 6636.332376203559, 1.110108766652399E14}, {0.0472218882523234, 0.05525386373932507, 0.08761213952375985, 0.18334178701967568, 0.4896774619353293, 1.6151472312750244, 6437.191765262063, 1.046363424417734E14}, {0.046782007260206857, 0.054717310015607604, 0.0866634285543815, 0.18104883852053688, 0.48254281307450586, 1.5878791973383382, 6244.540133952318, 9.864455331014986E13}, {0.04634639656340377, 0.054186279569047396, 0.08572596020369985, 0.17878796591163437, 0.4755253044877864, 1.5611289673296178, 6058.149076237062, 9.301152823433434E13}, {0.045915012222869464, 0.05366071073529614, 0.08479958521946086, 0.17655866032871767, 0.46862275984710794, 1.5348855004652622, 5877.798827916401, 8.771485115786072E13}, {0.04548781078979772, 0.053140542617250715, 0.08388415661151066, 0.17436042211365338, 0.46183304847636625, 1.509138018866157, 5703.277916774428, 8.27335648153571E13}, {0.045064749299526585, 0.05262571507413526, 0.08297952961230415, 0.17219276062500577, 0.45515408427730214, 1.483876000617231, 5534.382827817373, 7.804807202360073E13}, {0.04464578526553091, 0.052116168710763924, 0.08208556163820614, 0.1700551940530141, 0.4485838246834951, 1.4590891730285747, 5370.917682912253, 7.364004390603219E13}, {0.044230876673499876, 0.05161184486698059, 0.0812021122515662, 0.16794724923885193, 0.4421202696416491, 1.4347675060917144, 5212.693934168422, 6.9492334545922125E13}, {0.043819981975498516, 0.051112685607272425, 0.08032904312355024, 0.16586846149805848, 0.4357614606193898, 1.4109012061248865, 5059.530070436276, 6.558890160143152E13}, {0.04341306008421149, 0.050618633710553744, 0.07946621799771131, 0.16381837444803424, 0.4295054796388101, 1.3874807096013393, 4911.251336327405, 6.191473245087994E13}, {0.043010070367268005, 0.05012963266011701, 0.07861350265428294, 0.1617965398394962, 0.4233504483350278, 1.3644966771549163, 4767.689463189223, 5.84557754688949E13}, {0.04261097264164632, 0.04964562663374766, 0.07777076487517867, 0.1598025173917911, 0.4172945270390408, 1.341939987757346, 4628.682411494084, 5.519887606395766E13}, {0.04221572716815705, 0.04916656049400016, 0.07693787440968258, 0.1578358746319699, 0.4113359138841951, 1.3198017330618996, 4494.074124129003, 5.21317171354086E13}, {0.04182429464600316, 0.048692379778631376, 0.07611470294081399, 0.1558961867375243, 0.4054728439355837, 1.2980732119081828, 4363.714290096134, 4.9242763633384695E13}, {0.04143663620741617, 0.048223030691189044, 0.0753011240523523, 0.1539830363826951, 0.399703588341738, 1.2767459249830828, 4237.45811815787, 4.652121092863531E13}, {0.041052713412367, 0.0477584600917521, 0.07449701319650713, 0.1520960135882607, 0.3940264535079792, 1.2558115696330205, 4115.16611998228, 4.395693672082651E13}, {0.0406724882433502, 0.04729861548782005, 0.07370224766221894, 0.15023471557471801, 0.3884397802908181, 1.2352620348228132, 3996.703902365584, 4.154045623395236E13}, {0.04029592310024061, 0.046843445025348686, 0.07291670654407675, 0.14839874661877037, 0.38294194321281705, 1.2150893962366451, 3881.9419681284803, 3.9262880465963016E13}, {0.03992298079522101, 0.04639289747992919, 0.07214027071183851, 0.14658771791303823, 0.3775313496973348, 1.195285911516746, 3770.755525301832, 3.711587727679333E13}, {0.039553624547779914, 0.04594692224810833, 0.07137282278054191, 0.14480124742891431, 0.37220643932260766, 1.1758440156355836, 3663.02430423558, 3.5091635114767473E13}, {0.03918781797977814, 0.04550546933884675, 0.07061424708119164, 0.1430389597824816, 0.36696568309462035, 1.156756316397455, 3558.6323822814934, 3.318282919594072E13}, {0.03882552511058325, 0.045068489365113124, 0.06986442963201103, 0.14130048610342033, 0.3618075827382514, 1.1380155900655455, 3457.4680157169755, 3.1382589964435715E13}, {0.03846671035227061, 0.04463593353561135, 0.06912325811024544, 0.13958546390682763, 0.3567306700061815, 1.119614777110623, 3359.4234785924054, 2.9684473674303617E13}, {0.03811133850489023, 0.0442077536466387, 0.06839062182450578, 0.13789353696787948, 0.3517335060050801, 1.1015469780776879, 3264.394908199337, 2.8082434944983812E13}, {0.03775937475179813, 0.04378390207407225, 0.06766641168763983, 0.13622435519926326, 0.3468146805385891, 1.083805449566993, 3172.2821568708273, 2.6570801153110855E13}, {0.03741078465505127, 0.043364331765481205, 0.06695052019012021, 0.13457757453131255, 0.34197281146664454, 1.0663836003259843, 3082.988649838477, 2.5144248533299277E13}, {0.03706553415086527, 0.04294899623236324, 0.06624284137393813, 0.1329528567947792, 0.3372065440806892, 1.0492749874488259, 2996.421248883472, 2.379777986968124E13}, {0.03672358954513355, 0.042537849542502115, 0.06554327080699135, 0.13134986960617603, 0.33251455049434103, 1.032473312680271, 2912.4901215309724, 2.25267036684391E13}, {0.036384917509007214, 0.042130846312444535, 0.06485170555795622, 0.1297682862556286, 0.3278955290490953, 1.015972418820751, 2831.108615548587, 2.132661470941312E13}, {0.03604948507453469, 0.0417279417000943, 0.06416804417163327, 0.1282077855971742, 0.3233482037346539, 0.9997662862296645, 2752.1931385207176, 2.01933758821267E13}, {0.03571725963036007, 0.04132909139742134, 0.06349218664475613, 0.1266680519414484, 0.31887132362348275, 0.9838490294239288, 2675.663042280838, 1.9123101218296098E13}, {0.03538820891747939, 0.04093425162328372, 0.06282403440225401, 0.12514877495070198, 0.3144636623192151, 0.968214893768973, 2601.44051199373, 1.811214003912442E13}, {0.03506230102505387, 0.04054337911636063, 0.06216349027395804, 0.12364964953609062, 0.3101240174185248, 0.9528582522594189, 2529.450459689095, 1.7157062141453867E13}, {0.034739504386279256, 0.04015643112819419, 0.06151045847174205, 0.12217037575718359, 0.30585120998610926, 0.9377736023868083, 2459.6204220569475, 1.6254643952204377E13}, {0.034419787774310324, 0.03977336541633835, 0.06086484456708848, 0.12071065872363687, 0.301644084042428, 0.9229555630917964, 2391.8804623237, 1.5401855585488646E13}, {0.03410312029823994, 0.039394140237612854, 0.06022655546907074, 0.11927020849897989, 0.29750150606385833, 0.9083988717983388, 2326.1630760360586, 1.4595848741396852E13}, {0.03378947139913153, 0.03901871434146045, 0.05959549940274294, 0.11784874000646435, 0.2934223644949341, 0.894098381527454, 2262.403100587497, 1.3833945389711314E13}, {0.033478810846104275, 0.038647046963405415, 0.058971585887928425, 0.11644597293692577, 0.2894055692723462, 0.880049058088235, 2200.537628329581, 1.311362718577245E13}, {0.03317110873247041, 0.03827909781861189, 0.05835472571839929, 0.11506163165861097, 0.28545005136039464, 0.86624597734386, 2140.5059231173486, 1.2432525569390055E13}, {0.032866335471923414, 0.03791482709553982, 0.05774483094143773, 0.11369544512892266, 0.2815547622975847, 0.8526843225504048, 2082.2493401447036, 1.178841250110406E13}, {0.032564461794776796, 0.03755419544969726, 0.05714181483777238, 0.11234714680803806, 0.27771867375407744, 0.8393593817663559, 2025.711248932199, 1.1179191793263703E13}, {0.03226545874425233, 0.03719716399748705, 0.05654559190188095, 0.11101647457435512, 0.2739407770997043, 0.8262665453307634, 1970.8369593356065, 1.0602890996331988E13}, {0.03196929767281724, 0.036843694310146335, 0.05595607782265209, 0.10970317064172458, 0.2702200829822704, 0.8134013034080536, 1917.5736504495405, 1.0057653803550559E13}, {0.031675950238569436, 0.03649374840777725, 0.055373189464398814, 0.10840698147842506, 0.2665556209158762, 0.8007592435975841, 1865.8703022859218, 9.54173293963439E12}, {0.03138538840167018, 0.03614728875346724, 0.05479684484821632, 0.10712765772784072, 0.26294643887899494, 0.7883360486060659, 1815.6776301123225, 9.053483501519092E12}, {0.03109758442082341, 0.035804278247497476, 0.05422696313367707, 0.10586495413080119, 0.25939160292205143, 0.7761274939810633, 1766.948021340318, 8.591356721370971E12}, {0.030812510849801113, 0.03546468022163782, 0.0536634646008564, 0.10461862944954554, 0.2558901967842563, 0.7641294459038143, 1719.6354748587323, 8.153894124102112E12}, {0.030530140534013907, 0.035128458433526764, 0.053106270632681495, 0.1033884463932716, 0.2524413215194519, 0.7523378590396776, 1673.6955427112537, 7.739722053521817E12}, {0.030250446607126308, 0.03479557706113508, 0.052555303697597505, 0.10217417154523444, 0.24904409513074063, 0.7407487744445693, 1629.085274022292, 7.34754654301177E12}, {0.02997340248771596, 0.03446600069731155, 0.05201048733254432, 0.10097557529135799, 0.24569765221366577, 0.7293583175257974, 1585.7631610791066, 6.976148508245255E12}, {0.029698981875976128, 0.03413969434440949, 0.05147174612623728, 0.0997924317503244, 0.2424011436077253, 0.718162696055746, 1543.689087482172, 6.624379240988928E12}, {0.02942715875046092, 0.03381662340899266, 0.05093900570274633, 0.09862451870510759, 0.2391537360560051, 0.7071581982369272, 1502.8242782796422, 6.291156184438547E12}, {0.029157907364872476, 0.033496753696619135, 0.05041219270536685, 0.09747161753591718, 0.23595461187272188, 0.6963411908169371, 1463.131252005292, 5.975458971853667E12}, {0.02889120224488968, 0.033180051406702056, 0.049891234780777054, 0.0963335131545211, 0.23280296861847535, 0.685708117251927, 1424.5737745428585, 5.676325711479334E12}, {0.028627018185037597, 0.03286648312744561, 0.04937606056347548, 0.09520999393991464, 0.22969801878301077, 0.6752554959172146, 1387.1168147429585, 5.392849501880579E12}, {0.02836533024559712, 0.03255601583085521, 0.04886659966049335, 0.09410085167530527, 0.22663898947530176, 0.6649799183637227, 1350.7265017219377, 5.124175162874836E12}, {0.028106113749554344, 0.03224861686782064, 0.048362782636376354, 0.09300588148638389, 0.2236251221207681, 0.654878047618967, 1315.370083775009, 4.869496168233511E12}, {0.027849344279588854, 0.03194425396327077, 0.04786454099843018, 0.09192488178085245, 0.22065567216544607, 0.6449466165313438, 1281.0158888389276, 4.628051767242373E12}, {0.027594997675100607, 0.031642895211398764, 0.047371807182224834, 0.0908576541891798, 0.21772990878693696, 0.6351824261565222, 1247.6332864421704, 4.399124283065346E12}, {0.02734305002927465, 0.03134450907095665, 0.04688451453735236, 0.0898040035065581, 0.21484711461196226, 0.6255823441847681, 1215.1926510832534, 4.182036576653394E12}, {0.027093477686183278, 0.031049064360617912, 0.04640259731343322, 0.08876373763603236, 0.21200658544035925, 0.6161433034080703, 1183.6653269802903, 3.9761496656820415E12}, {0.026846257237924942, 0.03075653025440716, 0.045925990646366106, 0.08773666753277701, 0.20920762997535555, 0.6068623002259669, 1153.0235941373085, 3.780860488692817E12}, {0.026601365521799553, 0.030466876277195687, 0.04545463054481669, 0.08672260714949356, 0.20644956955996563, 0.5977363931890124, 1123.2406356751421, 3.595599805258672E12}, {0.026358779617519472, 0.030180072300261804, 0.04498845387694034, 0.0857213733829042, 0.2037317379193555, 0.5887627015788437, 1094.2905063768712, 3.419830223594005E12}, {0.026118476844455812, 0.02989608853691493, 0.04452739835733446, 0.08473278602131698, 0.2010534809090284, 0.5799384040238499, 1066.1481023999204, 3.2530443475904136E12}, {0.025880434758919508, 0.02961489553818237, 0.044071402534215806, 0.08375666769323864, 0.19841415626868503, 0.5712607371494671, 1038.7891321088748, 3.094763035781442E12}, {0.025644631151476544, 0.029336464188557662, 0.04362040577681825, 0.0827928438170114, 0.1958131333816186, 0.562726994262155, 1012.1900879850239, 2.9445337652269565E12}, {0.02541104404429714, 0.029060765701809776, 0.04317434826300727, 0.0818411425514519, 0.1932497930395083, 0.554334524066142, 986.3282195704572, 2.801929093762167E12}, {0.025179651688538023, 0.028787771616851716, 0.042733170967106146, 0.08090139474746896, 0.1907235272124762, 0.5460807294120451, 961.181507406272, 2.666545214480282E12}, {0.024950432561757635, 0.02851745379366798, 0.04229681564793037, 0.07997343390063923, 0.1882337388242793, 0.5379630660765012, 936.7286379261417, 2.5380005967135054E12}, {0.02472336536536366, 0.02824978440929967, 0.04186522483702608, 0.07905709610471967, 0.18577984153251093, 0.5299790415719792, 912.9489792680849, 2.4159347081461914E12}, {0.02449842902209244, 0.027984735953886432, 0.04143834182710844, 0.07815222000607583, 0.18336125951368681, 0.522126213985947, 889.8225579687996, 2.3000068130387812E12}, {0.02427560267351984, 0.027722281226764234, 0.04101611066069631, 0.07725864675900615, 0.18097742725309873, 0.5144021908486166, 867.3300365063952, 2.1898948418627756E12}, {0.02405486567760308, 0.027462393332618133, 0.0405984761189393, 0.07637621998194258, 0.17862778933931744, 0.5068046280284906, 845.452691658754, 2.085294327947546E12}, {0.023836197606253176, 0.02720504567768913, 0.04018538371063366, 0.07550478571450844, 0.176311800263233, 0.49933122865497237, 824.1723936460866, 1.9859174070202866E12}, {0.023619578242937474, 0.026950211966034223, 0.03977677966142322, 0.07464419237541459, 0.17402892422152139, 0.49197974206731243, 803.4715860275354, 1.891491875782603E12}, {0.023404987580311898, 0.026697866195838825, 0.039372610903182004, 0.07379429072117616, 0.1717786349244311, 0.48474796278919313, 783.3332663228966, 1.8017603059119282E12}, {0.02319240581788253, 0.02644798265578073, 0.03897282506357509, 0.07295493380563167, 0.16956041540778455, 0.4776337295282679, 763.740967331719, 1.7164792101048936E12}, {0.022981813359696, 0.02620053592144474, 0.038577370455794055, 0.07212597694024718, 0.16737375784909259, 0.4706349241999914, 744.6787391231371, 1.6354182569933755E12}, {0.022773190812058478, 0.025955500851787272, 0.03818619606846422, 0.07130727765518896, 0.16521816338768447, 0.46374947097510455, 726.1311316709035, 1.5583595319639275E12}, {0.02256651898128259, 0.0257128525856499, 0.03779925155571974, 0.07049869566114722, 0.1630931419487539, 0.45697533535013757, 708.0831781090803, 1.4850968410979624E12}, {0.022361778871462196, 0.025472566538321435, 0.03741648722744413, 0.06970009281189606, 0.16099821207123147, 0.4503105232403392, 690.5203785848676, 1.4154350556247756E12}, {0.022158951682274344, 0.025234618398147363, 0.03703785403967255, 0.06891133306757255, 0.15893290073938815, 0.4437530800944314, 673.4286846859665, 1.3491894944427527E12}, {0.02195801880680828, 0.024998984123186272, 0.03666330358515314, 0.06813228245866056, 0.15689674321808353, 0.4373010900306218, 656.7944844207884, 1.28618534241684E12}, {0.021758961829420925, 0.024765639937912212, 0.03629278808406424, 0.06736280905066366, 0.1548892828915707, 0.4309526749933179, 640.6045877306931, 1.2262571023032556E12}, {0.021561762523618595, 0.02453456232996246, 0.03592626037488467, 0.0666027829094527, 0.1529100711057735, 0.4247059939299996, 624.846212514252, 1.1692480782860242E12}, {0.02136640284996457, 0.02430572804692995, 0.03556367390541431, 0.06585207606727378, 0.15095866701395483, 0.418559241987729, 609.5069711443502, 1.1150098892350247E12}, {0.021172864954012126, 0.024079114093199596, 0.03520498272394196, 0.06511056248940235, 0.14903463742569434, 0.4125106497287831, 594.5748574596762, 1.0634020099122291E12}, {0.020981131164262697, 0.023854697726827894, 0.03485014147055798, 0.0643781180414302, 0.14713755665909906, 0.40655848236491643, 580.0382342129011, 1.014291338462402E12}, {0.02079118399014886, 0.023632456456465105, 0.034499105368608896, 0.06365462045717149, 0.1452670063961695, 0.40070103900976894, 565.8858209585319, 9.675517886270374E11}, {0.020603006120041744, 0.023412368038319357, 0.034151830216291375, 0.06293994930717511, 0.14342257554124818, 0.39493665194895333, 552.1066823641041, 9.230639052163337E11}, {0.020416580419282595, 0.023194410473162032, 0.033808272378383075, 0.06223398596783071, 0.14160386008247783, 0.38926368592736377, 538.6902169290111, 8.807145014639213E11}, {0.020231889928238062, 0.022978562003373736, 0.033468388778107726, 0.06153661359105546, 0.13981046295619895, 0.383680537453265, 525.6261460958938, 8.403963169732361E11}, {0.020048917860379052, 0.022764801110030337, 0.03313213688913212, 0.060847717074550015, 0.13804199391421834, 0.3781856341187301, 512.9045037400958, 8.020076950433273E11}, {0.0198676476003827, 0.0225531065100284, 0.03279947472769257, 0.06016718303261162, 0.13629806939388228, 0.37277743393601137, 500.51562602326044, 7.654522782357502E11}, {0.019688062702257134, 0.022343457153249324, 0.03247036084484828, 0.05949489976749221, 0.13457831239088755, 0.36745442468943174, 488.45014159768255, 7.306387211134434E11}, {0.019510146887488818, 0.022135832219761734, 0.03214475431885967, 0.05883075724129104, 0.13288235233476897, 0.36221512330240746, 476.69896214855635, 6.97480419147358E11}, {0.019333884043212148, 0.021930211117061504, 0.03182261474768909, 0.05817464704837026, 0.13120982496700048, 0.3570580752192142, 465.2532732617519, 6.658952528474149E11}, {0.019159258220400936, 0.02172657347734875, 0.03150390224162182, 0.05752646238828264, 0.12956037222164907, 0.35198185380112146, 454.10452560523515, 6.358053462313654E11}, {0.01898625363208152, 0.021524899154841317, 0.03118857741600517, 0.056886098039200916, 0.12793364210852373, 0.34698505973653365, 443.2444264127037, 6.071368387985623E11}, {0.018814854651567296, 0.02132516822312422, 0.03087660138410362, 0.05625345033183872, 0.12632928859876208, 0.3420663204647846, 432.66493125845426, 5.798196702257651E11}, {0.018645045810714234, 0.021127360972534398, 0.030567935750067735, 0.055628417123852386, 0.1247469715127975, 0.33722428961323725, 422.35823611291295, 5.537873770490808E11}, {0.018476811798197195, 0.020931457907580307, 0.030262542602014934, 0.05501089777471424, 0.12318635641065387, 0.3324576464473581, 412.316769668673, 5.2897690064022546E11}, {0.018310137457806817, 0.020737439744395916, 0.029960384505220254, 0.05440079312104789, 0.12164711448451446, 0.32776509533343995, 402.5331859272685, 5.0532840582662726E11}, {0.018145007786766514, 0.02054528740822833, 0.02966142449541468, 0.053798005452415185, 0.12012892245351195, 0.3231453652136527, 393.0003570372842, 4.8278510954368396E11}, {0.01798140793406958, 0.020354982030958892, 0.029365626072189767, 0.053202438487546994, 0.11863146246069142, 0.3185972090931206, 383.71136637477025, 4.612931189438922E11}, {0.017819323198835862, 0.020166504948656894, 0.029072953192506003, 0.052613997351007344, 0.11715442197209419, 0.3141194035387176, 374.65950185725336, 4.4080127842169525E11}, {0.017658739028687965, 0.019979837699165694, 0.02878337026430361, 0.052032588550283296, 0.11569749367791712, 0.30971074818929695, 365.8382494829937, 4.2126102504500433E11}, {0.017499641018146606, 0.01979496201972062, 0.02849684214021362, 0.05145811995329131, 0.11426037539569914, 0.30537006527706717, 357.24128708742893, 4.02626251914392E11}, {0.01734201490704488, 0.01961185984459817, 0.02821333411136759, 0.05089050076629173, 0.11284276997548909, 0.30109619915983743, 348.8624783090631, 3.848531789992487E11}, {0.017185846578961276, 0.01943051330279618, 0.027932811901304297, 0.050329641512203586, 0.11144438520695184, 0.2968880158638669, 340.69586675735263, 3.679002310267141E11}, {0.017031122059671045, 0.01925090471574429, 0.027655241659971422, 0.04977545400931098, 0.11006493372836708, 0.29274440263705287, 332.735670375409, 3.517279220241044E11}, {0.016877827515615805, 0.019073016595044436, 0.02738058995782089, 0.04922785135035378, 0.10870413293748021, 0.2886642675122044, 324.97627599062304, 3.3629874613897565E11}, {0.016725949252391126, 0.018896831640240887, 0.02710882377999601, 0.048686747881994744, 0.10736170490416316, 0.2846465388801555, 317.41223404656216, 3.2157707438293494E11}, {0.016575473713251777, 0.01872233273661928, 0.026839910520608835, 0.04815205918465528, 0.1060373762848445, 0.28069016507247213, 310.0382535097455, 3.0752905696597455E11}, {0.01642638747763457, 0.01854950295303445, 0.026573817977106368, 0.047623702052713185, 0.10473087823867067, 0.27679411395352427, 302.8491969451427, 2.941225309075111E11}, {0.016278677259698324, 0.018378325539766316, 0.026310514344723604, 0.04710159447505409, 0.10344194634535803, 0.27295737252168734, 295.8400757544622, 2.8132693262854504E11}, {0.016132329906880988, 0.018208783926403738, 0.026049968211022456, 0.04658565561597068, 0.10217032052470004, 0.2691789465194566, 289.0060455715273, 2.6911321524651123E11}, {0.015987332398473532, 0.018040861719755715, 0.025792148550514683, 0.04607580579640211, 0.10091574495769204, 0.26545786005225436, 282.34240180924166, 2.5745377031049463E11}, {0.015843671844210462, 0.01787454270178962, 0.025537024719367522, 0.04557196647550711, 0.09967796800923809, 0.2617931552157199, 275.84457535284986, 2.4632235372964417E11}, {0.01570133548287671, 0.017709810827596064, 0.025284566450190598, 0.045074060232564245, 0.09845674215240528, 0.258183891731277, 269.5081283943979, 2.356940156618567E11}, {0.015560310680930688, 0.01754665022337994, 0.025034743846902578, 0.04458201074919266, 0.09725182389419089, 0.25462914658977776, 263.3287504034817, 2.255450341432058E11}, {0.015420584931143322, 0.01738504518447738, 0.02478752737967639, 0.044095742791887285, 0.09606297370277006, 0.2511280137030296, 257.3022542295575, 2.1585285225118707E11}, {0.015282145851252874, 0.01722498017339817, 0.024542887879961568, 0.043615182194862226, 0.09488995593619096, 0.24767960356301483, 251.4245723312552, 2.0659601860670242E11}, {0.015144981182635272, 0.01706643981789325, 0.024300796535582293, 0.04314025584319614, 0.09373253877248594, 0.2442830429086166, 245.69175312830737, 1.977541310308567E11}, {0.01500907878898984, 0.01690940890904698, 0.024061224885910067, 0.04267089165627403, 0.09259049414116816, 0.24093747439967475, 240.09995747186605, 1.8930778318313666E11}, {0.01487442665504019, 0.016753872399393816, 0.023824144817109538, 0.042207018571519386, 0.0914635976560829, 0.23764205629819224, 234.6454552291316, 1.8123851401740228E11}, {0.01474101288525005, 0.016599815401058975, 0.023589528557456326, 0.041748566528411135, 0.090351628549585, 0.23439596215652414, 229.32462197836827, 1.7352875990142358E11}, {0.014608825702553915, 0.016447223183922822, 0.02335734867272563, 0.04129546645277987, 0.08925436960801265, 0.23119838051238126, 224.13393581052242, 1.661618092544342E11}, {0.014477853447102262, 0.016296081173808624, 0.023127578061650365, 0.040847650241378014, 0.08817160710843064, 0.22804851459048764, 219.06997423379752, 1.5912175956540903E11}, {0.014348084575021186, 0.016146374950693307, 0.022900189951447724, 0.040405050746718435, 0.08710313075661473, 0.22494558201073267, 214.12941117767218, 1.5239347666252258E11}, {0.014219507657186258, 0.01599809024694091, 0.022675157893412956, 0.03996760176217659, 0.0860487336262511, 0.22188881450266515, 209.30901409297056, 1.4596255611154266E11}, {0.014092111378010384, 0.01585121294555838, 0.02245245575857915, 0.03953523800735073, 0.08500821209932398, 0.2188774576261777, 204.60564114472254, 1.398152866277898E11}, {0.013965884534245614, 0.01570572907847349, 0.02223205773344219, 0.039107895113675795, 0.08398136580766713, 0.21591077049823817, 200.01623849466398, 1.3393861539276363E11}, {0.013840816033798553, 0.015561624824834397, 0.02201393831574939, 0.03868550961028543, 0.0829679975756529, 0.2129880255255226, 195.5378376703418, 1.2832011517263739E11}, {0.01371689489455936, 0.01541888650933074, 0.02179807231035115, 0.03826801891011811, 0.08196791336399598, 0.21010850814281404, 191.16755301789735, 1.2294795314156595E11}, {0.01359411024324402, 0.015277500600535746, 0.021584434825114178, 0.03785536129626187, 0.0809809222146464, 0.20727151655702838, 186.90257923570448, 1.1781086131816367E11}, {0.013472451314249874, 0.015137453709269263, 0.021373001266895626, 0.037447475908534006, 0.08000683619675053, 0.20447636149673967, 182.74018898614406, 1.1289810852861404E11}, {0.013351907448524132, 0.01499873258698132, 0.021163747337576904, 0.0370443027302906, 0.07904547035365597, 0.2017223659670739, 178.67773058288705, 1.081994738146745E11}, {0.01323246809244517, 0.014861324124155813, 0.020956649030156094, 0.03664578257546153, 0.0780966426509381, 0.1990088650098443, 174.71262575115415, 1.0370522120937215E11}, {0.013114122796716641, 0.014725215348734343, 0.020751682624898356, 0.03625185707580733, 0.07716017392542843, 0.1963352054688124, 170.84236745851553, 9.940607580746417E10}, {0.012996861215274037, 0.014590393424559612, 0.020548824685542987, 0.03586246866839293, 0.07623588783522145, 0.19370074575994872, 167.0645178138686, 9.529320106175037E10}, {0.01288067310420362, 0.014456845649838235, 0.020348052055566345, 0.035477560583274545, 0.07532361081064054, 0.19110485564658147, 163.37670603232544, 9.135817724013446E10}, {0.01276554832067362, 0.01432455945562274, 0.020149341854499774, 0.03509707683139571, 0.07442317200614262, 0.18854691601931867, 159.7766264638163, 8.759298098190445E10}, {0.01265147682187745, 0.01419352240431239, 0.01995267147430152, 0.03472096219268844, 0.0735344032531417, 0.18602631868063432, 156.26203668329512, 8.398996589508261E10}, {0.012538448663988911, 0.014063722188172671, 0.019758018575781865, 0.03434916220437582, 0.0726571390137323, 0.18354246613401096, 152.83075564050597, 8.054184413987901E10}, {0.012426454001129067, 0.01393514662787304, 0.01956536108508042, 0.033981623149471826, 0.07179121633529326, 0.18109477137753177, 149.48066186733814, 7.724166894628622E10}, {0.012315483084344847, 0.013807783671042885, 0.01937467719019499, 0.033618292045475395, 0.0709364748059548, 0.17868265770182468, 146.20969174087531, 7.408281801669298E10}, {0.012205526260599061, 0.013681621390845224, 0.01918594533756091, 0.033259116633254315, 0.07009275651090935, 0.176305558492253, 143.01583780029716, 7.105897776706229E10}, {0.012096573971771779, 0.013556647984568073, 0.018999144228680168, 0.0329040453661161, 0.06925990598954998, 0.17396291703526065, 139.89714711586956, 6.8164128362750595E10}, {0.011988616753672915, 0.013432851772233146, 0.018814252816799514, 0.03255302739906192, 0.06843777019341829, 0.17165418632877388, 136.85171970831007, 6.539252950742218E10}, {0.011881645235065855, 0.013310221195221673, 0.018631250303636684, 0.03220601257822034, 0.06762619844494552, 0.16937882889656827, 133.87770701688098, 6.2738706945764595E10}, {0.011775650136702029, 0.013188744814917098, 0.018450116136154, 0.03186295143045759, 0.06682504239697018, 0.16713631660651057, 130.97331041461706, 6.019743964283279E10}, {0.011670622270366271, 0.013068411311364464, 0.018270830003378626, 0.03152379515316106, 0.0660341559930166, 0.16492613049258853, 128.13677976915076, 5.77637476048544E10}, {0.011566552537932817, 0.012949209481946156, 0.018093371833268583, 0.031188495604192713, 0.06525339542831805, 0.1627477605806404, 125.36641204764908, 5.543288030822073E10}, {0.011463431930431872, 0.01283112824007392, 0.017917721789623982, 0.030857005292009514, 0.06448261911156994, 0.16060070571770355, 122.66054996443069, 5.320030570517628E10}, {0.011361251527126536, 0.012714156613896795, 0.017743860269042597, 0.030529277365947596, 0.06372168762739741, 0.15848447340489824, 120.01758066987753, 5.106169977640565E10}, {0.011260002494600015, 0.012598283745024839, 0.01757176789791907, 0.030205265606667194, 0.06297046369952307, 0.15639857963376752, 117.4359344793042, 4.90129366023134E10}, {0.011159676085853023, 0.01248349888726843, 0.017401425529487237, 0.029884924416755665, 0.062228812154620734, 0.15434254872599712, 114.91408364049612, 4.705007892629805E10}};
        double[][] besselY = new double[][]{{NegInf, NegInf, NegInf, NegInf, NegInf, NegInf, NegInf, NegInf}, {-3.1475437401469484, -79.59133507645453, -19894.686225373487, -9947263.521351667, -7.460427746327525E9, -7.460417799064004E12, -1.1015748676934542E29, -3.521642672511657E64}, {-2.706119141930136, -39.81293202023131, -4973.910383386984, -1243437.7829147256, -4.662841946826387E8, -2.3314085390353644E11, -1.0757624441194779E26, -3.358508652978345E58}, {-2.447761785070103, -26.55901923634492, -2210.803841243673, -368440.74785470916, -9.210797615983604E7, -3.0702290279197487E10, -1.8655532433484615E24, -1.0100040588508277E55}, {-2.264319109108718, -19.935695566552866, -1243.7166538004453, -155444.64602948911, -2.914462741387541E7, -7.286001408822823E9, -1.0505716738418782E23, -3.2029558103365507E52}, {-2.121900563502348, -15.964308918446552, -796.0935453588253, -79593.39022696407, -1.1938212440499252E7, -2.3875628947096233E9, -1.128060794224251E22, -3.692784619383516E50}, {-2.005412340260623, -13.318698426069394, -552.9403554126308, -46065.044252626496, -5757577.591222899, -9.595502001595638E8, -1.8219167895518105E21, -9.632368311299159E48}, {-1.9068042427008578, -11.430539600033466, -406.32675290135154, -29011.908953353646, -3108012.489677846, -4.439727723307389E8, -3.9000545257752356E20, -4.413692187815879E47}, {-1.8212719545791636, -10.015688250677323, -311.1689858790872, -19438.04592919227, -1822005.6368758962, -2.2773126656355783E8, -1.0260364523894538E20, -3.054700164833882E46}, {-1.7457172983642801, -8.916298169303747, -245.92923184896202, -13653.818804550807, -1137572.3044807182, -1.2638326890127525E8, -3.1597352230099644E19, -2.896838986337744E45}, {-1.6780254122712188, -8.037669616782377, -199.26371500728823, -9955.14808074763, -746436.8423410648, -7.463372908602573E7, -1.1017687641085495E19, -3.5219362792330384E44}, {-1.616688296201183, -7.3195448260148614, -164.7366032041366, -7480.707873543832, -509883.52750205714, -4.6345567246858925E7, -4.2479541262726175E18, -5.235226442657099E43}, {-1.5605928650398606, -6.721756166292852, -138.47599393272787, -5763.111324364035, -360055.9817788194, -2.9998902036910586E7, -1.7795572638251817E18, -9.186977761626813E42}, {-1.5088941370911537, -6.216498478842533, -118.03915353295757, -4533.750945096449, -261444.51537126215, -2.010658281607507E7, -7.993007263905454E17, -1.853274213632528E42}, {-1.4609355566051883, -5.783913423779172, -101.82323272516574, -3630.760112474997, -194403.18279272108, -1.388231086793903E7, -3.809642481414095E17, -4.209745973014084E41}, {-1.4161968752562522, -5.409440189830958, -88.7411396219264, -2952.6285472077157, -147542.68622076383, -9833226.452837048, -1.911060246517028E17, -1.0592586731235286E41}, {-1.3742588909514906, -5.082159756644852, -78.03448730662433, -2433.4955685753653, -113992.07028966362, -7122070.897535401, -1.0023308057297792E17, -2.913660149808794E40}, {-1.3347788971562082, -4.79372358297283, -69.16115614656186, -2029.3579277864935, -89461.33565796344, -5260402.15136418, -5.4669760477704584E16, -8.667067694882096E39}, {-1.297473161627608, -4.5376394329732825, -61.725296740779086, -1710.053936699779, -71190.52206575, -3953318.9497160777, -3.0870122900086468E16, -2.763206326814632E39}, {-1.2621041497978172, -4.30878275597995, -55.43240579730679, -1454.4387382257778, -57356.623050483395, -3017315.1954977424, -1.797860410064147E16, -9.371409802021482E38}, {-1.2284710300551709, -4.1030546708730835, -50.05971235585837, -1247.3897542255863, -46727.05607110362, -2335105.4138009558, -1.0765200815498044E16, -3.3596288245819317E38}, {-1.1964024986562354, -3.917137683210585, -45.436188968136435, -1077.8968853676568, -38450.881145591025, -1829916.4433808716, -6.609381235583082E15, -1.2662524894805792E38}, {-1.165751275870671, -3.7483180357078836, -41.428771857173466, -937.8146787182346, -31929.526184446284, -1450404.2846142948, -4.1510708416311355E15, -4.994227443692063E37}, {-1.1363898270219668, -3.594354410428273, -37.932679851546226, -821.0291206231853, -26734.75603612189, -1161559.6681020677, -2.661603387318818E15, -2.0529655928138346E37}, {-1.1082069952428915, -3.453379462002993, -34.86449573395495, -722.8902816620584, -22555.45680620537, -939087.8099768949, -1.739184177923232E15, -8.7645726697268E36}, {-1.0811053223721152, -3.3238249881118467, -32.157144558746346, -639.8190661868151, -19162.414841045706, -765856.7745756415, -1.1563671429678765E15, -3.874122311645825E36}, {-1.054998895872875, -3.204364372520213, -29.756196993744556, -569.0301931994904, -16384.576299145403, -629606.9813123929, -7.812710500694152E14, -1.7681747901568864E36}, {-1.0298116025316344, -3.093867821963205, -27.61711267490545, -508.33414467628586, -14092.775794999703, -521446.3249293868, -5.3572078502628675E14, -8.312587971160369E35}, {-1.0054757000826435, -2.9913671979157024, -25.70315999559327, -455.99363272339275, -12188.412002238141, -434844.4350186388, -3.7242454531845494E14, -4.016715074481271E35}, {-0.9819306397522842, -2.8960281268470496, -23.983829074446415, -410.61826626016006, -10595.454091446933, -364949.867645703, -2.6223016432949178E14, -1.9910975682620165E35}, {-0.9591220886335873, -2.8071276903333535, -22.43360866414436, -371.086350045406, -9254.725142471005, -308119.75173232146, -1.8685109203339047E14, -1.010762181344383E35}, {-0.9370011125385969, -2.724036434807375, -21.031034652037008, -336.48619988837015, -8119.764123937563, -261591.38876583948, -1.3462891811916414E14, -5.246413437816718E34}, {-0.9155234887297056, -2.6462037558212135, -19.757943353623528, -306.0716611445464, -7153.796614721682, -223250.072548908, -9.801762217045897E13, -2.780480563270646E34}, {-0.8946491245277676, -2.573145940849684, -18.598880730394082, -279.22807724693945, -6327.493783972775, -191463.00780071592, -7.206339924287406E13, -1.502672731370063E34}, {-0.8743415628147353, -2.504436323151246, -17.54063140153266, -255.44602546409374, -5617.298165600535, -164959.2059039634, -5.347080403367807E13, -8.27159699559559E33}, {-0.8545675593034499, -2.4396971243622287, -16.571840471855324, -234.30088104499953, -5004.161324778134, -142741.73696975881, -4.002015156390423E13, -4.632677378742477E33}, {-0.8352967194326583, -2.3785926573658767, -15.68270784560815, -215.4367940871917, -4472.5838356375525, -124023.0030847337, -3.019875215893476E13, -2.6373568492909754E33}, {-0.8165011850758933, -2.32082363200868, -14.864739571739513, -198.5540354455523, -4009.879222162429, -108176.56007705252, -2.2964296382932508E13, -1.5247938428940348E33}, {-0.798155363085852, -2.266122360442209, -14.110544376665525, -183.3989352272621, -3605.6052824771914, -94700.9506036462, -1.7591073446742873E13, -8.945427691917526E32}, {-0.7802356891477229, -2.214248700563763, -13.413666237543065, -169.75583126793708, -3251.1215504535553, -83192.33520600272, -1.3568808321280666E13, -5.3211936467351044E32}, {-0.7627204215724583, -2.164986608341531, -12.768445880562108, -157.4405868986848, -2939.242558469778, -73323.62337484577, -1.0535347860150922E13, -3.207231228706165E32}, {-0.7455894605897454, -2.1181411950283398, -12.169905631046474, -146.29534211041647, -2663.964401266816, -64828.44615220217, -8.231382576139486E12, -1.9574135478117475E32}, {-0.7288241894499822, -2.073536205081678, -11.61365322175048, -136.1842402443288, -2420.247779712692, -57488.762895772146, -6.469676382595036E12, -1.2089386816459516E32}, {-0.7124073342529523, -2.031011846273519, -11.095801074314018, -126.98993087830809, -2203.8448537798968, -51125.215970979756, -5.113950956844475E12, -7.551827461802817E31}, {-0.6963228399173087, -1.9904229159344453, -10.612898273346586, -118.61069382664041, -2011.1602919534787, -45589.57775966152, -4.06426061680815E12, -4.768694067630885E31}, {-0.6805557601120685, -1.951637177244827, -10.161873002359192, -110.95806284896841, -1839.1391744804473, -40758.801370049856, -3.246772966846457E12, -3.0425327935743114E31}, {-0.6650921593068198, -1.914533947503425, -9.73998364234223, -103.95485346925994, -1685.1761055303743, -36530.30831023453, -2.6065678471839727E12, -1.9604789956982238E31}, {-0.6499190253750479, -1.8790028667857528, -9.34477707454917, -97.53351920288625, -1547.041167652359, -32818.23600531539, -2.1025222922550283E12, -1.2752510334880575E31}, {-0.6350241914159123, -1.844942820670923, -8.974052999578479, -91.63477592493822, -1422.8193208275811, -29550.434407983, -1.7036492997887026E12, -8.370720530854983E30}, {-0.6203962656526001, -1.8122609950145385, -8.625833300748107, -86.20644615547634, -1310.8605874463387, -26666.050440504496, -1.3864579534217434E12, -5.542445973995327E30}, {-0.6060245684270096, -1.7808720442700512, -8.298335652923246, -81.2024844849624, -1209.7389316215126, -24113.57614794529, -1.1330365972360647E12, -3.700489641753923E30}, {-0.5918990754465046, -1.750697357763739, -7.989950717513, -76.58215281393232, -1118.2181788991386, -21849.264492267215, -9.296516500869364E11, -2.4905352902159506E30}, {-0.5780103665533467, -1.7216644107285684, -7.699222377334001, -72.30931998671375, -1035.2236620464219, -19835.838027059857, -7.65716737374266E11, -1.6891453548444144E30}, {-0.5643495793847528, -1.6937061888947338, -7.424830556911162, -68.35186510272, -959.8185435381832, -18041.43197524036, -6.330295719939677E11, -1.1541304772169739E30}, {-0.5509083673742977, -1.6667606770949461, -7.165576248806008, -64.68116755259032, -891.1839730927263, -16438.725741571972, -5.2520368119950244E11, -7.942116305478109E29}, {-0.5376788616160108, -1.64077040373111, -6.920368428070853, -61.27166985145847, -828.6024022736356, -15004.226553305554, -4.3724281029085925E11, -5.5029747289069445E29}, {-0.5246536361729314, -1.6156820341143103, -6.688212587551669, -58.10050178331131, -771.4435077246533, -13717.67642187121, -3.6522042826334937E11, -3.838233301256715E29}, {-0.5118256764637688, -1.591446006671338, -6.4682006685859585, -55.147156349345835, -719.1522776122802, -12561.559468427498, -3.060371026207377E11, -2.6942390628827753E29}, {-0.49918835040594917, -1.568016206839876, -6.259502196317654, -52.39320962348472, -671.2388981073641, -11520.691240503482, -2.572358871588471E11, -1.902897673867545E29}, {-0.4867353820318793, -1.545349674176956, -6.061356457700984, -49.822077933458495, -627.2701426964323, -10581.875255904375, -2.1686116099149664E11, -1.35200366825236E29}, {-0.4744608273285924, -1.5234063388023384, -5.873065584347819, -47.418806864096155, -586.862020216854, -9733.614863416806, -1.833501801041783E11, -9.661323475822128E28}, {-0.4623590520798944, -1.5021487838073762, -5.6939884225404995, -45.16988746652458, -549.6734804281715, -8965.870775290385, -1.554493793228723E11, -6.942392930733417E28}, {-0.45042471151529023, -1.4815420306949598, -5.523535089674064, -43.06309578925716, -515.4010107481142, -8269.856432406134, -1.321494905329107E11, -5.01553300357179E28}, {-0.43865273159191587, -1.46155334528899, -5.3611621306659805, -41.08735245364736, -483.7739861270407, -7637.86480829303, -1.1263503217531601E11, -3.6423830558537296E28}, {-0.42703829175488484, -1.4421520618722143, -5.206368199933452, -39.23259950010788, -454.55065719195574, -7063.1214191242, -9.624482434796779E10, -2.6585423431630817E28}, {-0.41557680903825345, -1.423309423587283, -5.058690204758989, -37.489692151481854, -427.5146807738777, -6539.6592428312515, -8.244099943823445E10, -1.9499483856193564E28}, {-0.4042639233835512, -1.4049984373742423, -4.917699854549185, -35.850303491028676, -402.4721125435039, -6062.212007774181, -7.078458629368349E10, -1.437008897272804E28}, {-0.39309548406579864, -1.3871937419240021, -4.783000567889433, -34.30684034680311, -379.248794359011, -5626.1229262055995, -6.0916201448766464E10, -1.0638753954591153E28}, {-0.382067537128358, -1.3698714873063342, -4.654224695615517, -32.85236892163129, -357.6880795870825, -5227.266448535464, -5.254072371435244E10, -7.911483885086102E27}, {-0.371176313738062, -1.3530092250865904, -4.531031023532192, -31.480548916451024, -337.6488485031093, -4861.98102359238, -4.541508754542381E10, -5.908870908968698E27}, {-0.36041821938099716, -1.3365858078809547, -4.413102523050984, -30.185575071054643, -319.0037732382487, -4527.011185475355, -3.933852730205857E10, -4.431761326491869E27}, {-0.34978982382723195, -1.3205812974184905, -4.300144322012524, -28.96212519562745, -301.6377978853197, -4219.457563330001, -3.414475446565453E10, -3.3375037933048535E27}, {-0.3392878517998137, -1.3049768802818151, -4.191881871400933, -27.805313893335775, -285.4468045175134, -3936.733637738794, -2.969566464213238E10, -2.523429201357142E27}, {-0.32890917428961225, -1.2897547905891091, -4.088059286631995, -26.710651282232774, -270.33644018836225, -3676.528255407661, -2.5876259374593006E10, -1.9153003734928701E27}, {-0.3186508004631565, -1.274898238959914, -3.988437844671688, -25.67400611692987, -256.2210836106986, -3436.7730697033217, -2.2590535813779316E10, -1.4591954803624874E27}, {-0.30850987011559045, -1.2603913471773878, -3.892794620475702, -24.69157278932729, -243.0229332727972, -3215.614204181302, -1.975814996110048E10, -1.115776240637545E27}, {-0.2984836466253157, -1.2462190880215664, -3.8009212481824695, -23.759841755284157, -230.67120133685853, -3011.3875442560125, -1.731170012092369E10, -8.562207928398009E26}, {-0.2885695103708689, -1.2323672298028199, -3.7126227941837406, -22.875572992169523, -219.1013998568181, -2822.597152421052, -1.5194509106766512E10, -6.593243011772164E26}, {-0.27876495257415573, -1.2188222851730244, -3.6277167306727174, -22.03577214221619, -208.25470771371374, -2647.896378033601, -1.3358808710291336E10, -5.094226322539009E26}, {-0.26906756953736116, -1.205571463834809, -3.5460319995601357, -21.237669039710354, -198.07740825085463, -2486.071296160981, -1.1764249538443792E10, -3.948988767566364E26}, {-0.2594750572437462, -1.1926026288072253, -3.467408157778833, -20.47869835731048, -188.52038894200692, -2336.026163417776, -1.0376674756541618E10, -3.0710447960338315E26}, {-0.24998520629512844, -1.1799042559399673, -3.391694595988721, -19.756482139052135, -179.53869558041995, -2196.7706237920584, -9.16710846659258E9, -2.3957660851405098E26}, {-0.24059589716119165, -1.1674653963983541, -3.318749823565498, -19.06881401558639, -171.09113446533442, -2067.408435561663, -8.110919110733985E9, -1.8746809824556442E26}, {-0.23130509571787536, -1.1552756418680696, -3.248440813523298, -18.41364492152529, -163.13991691110277, -1947.1275226821224, -7.187125967658441E9, -1.471305766817491E26}, {-0.2221108490540142, -1.1433250922526008, -3.180642401697774, -17.789070155948433, -155.65034113355605, -1835.1911814340044, -6.377822929860916E9, -1.1580842599007575E26}, {-0.21301128152711726, -1.1316043256577073, -3.1152367351131978, -17.193317645596395, -148.59050719661968, -1730.9302964322821, -5.667698641482443E9, -9.14132592405525E25}, {-0.20400459105075172, -1.1201043704764073, -3.0521127649853157, -16.624737286414963, -141.9310612444475, -1633.7364399746025, -5.043635997663552E9, -7.235711504336909E25}, {-0.19508904559741483, -1.1088166794051415, -2.9911657802794283, -16.08179125323525, -135.64496571312787, -1543.055745679269, -4.494377157785783E9, -5.742863677651101E25}, {-0.18626297990206944, -1.097733105237181, -2.9322969781581043, -15.56304517975205, -129.70729262200143, -1458.3834618884464, -4.010242764517368E9, -4.5700835601896146E25}, {-0.17752479235269403, -1.086845878293214, -2.8754130680215026, -15.067160121827587, -124.09503739681773, -1379.259102763765, -3.582896112266009E9, -3.6462144465290396E25}, {-0.16887294205526965, -1.0761475853614983, -2.8204259061711143, -14.592885226700247, -118.7869509829976, -1305.2621256954953, -3.205144670353694E9, -2.9164708516546277E25}, {-0.16030594606159787, -1.0656311500312077, -2.7672521584197423, -14.139051039088255, -113.7633882736263, -1236.0080728469152, -2.8707727153874254E9, -2.3385475432676556E25}, {-0.1518223767492366, -1.0552898143127363, -2.7158129882310247, -13.704563382595007, -109.00617110901088, -1171.1451225849146, -2.57439992531758E9, -1.8796823196941896E25}, {-0.14342085934365298, -1.0451171214478654, -2.666033768204372, -13.288397761371339, -104.49846430737094, -1110.351003393155, -2.3113616833910246E9, -1.5144317914812948E25}, {-0.13510006957343262, -1.0351068998209856, -2.6178438129291886, -12.889594232781082, -100.22466336351562, -1053.3302287833426, -2.0776075725638394E9, -1.2229819151318165E25}, {-0.12685873145006984, -1.0252532478900485, -2.571176131418479, -12.507252706944053, -96.17029260761352, -999.8116168468825, -1.8696151410699558E9, -9.898608583372443E24}, {-0.11869561516448057, -1.01555052006271, -2.5259671974988267, -12.140528633577011, -92.32191275232157, -949.5460625364393, -1.684316512696119E9, -8.029555034867655E24}, {-0.11060953509295637, -1.0059933134492873, -2.482156736683557, -11.788629040589665, -88.66703687612312, -902.3045346307827, -1.5190358209328814E9, -6.527577994086314E24}, {-0.102599347905798, -0.9965764554297408, -2.4396875281904795, -11.450808892480868, -85.1940539958978, -857.8762726983131, -1.371435780695122E9, -5.317856190043445E24}, {-0.09466395077235062, -0.9872949919769722, -2.39850522088667, -11.126367739773885, -81.89215947437002, -816.0671623043677, -1.2394719877607381E9, -4.341364897467056E24}, {-0.08680227965660667, -0.9781441766833588, -2.35855816205179, -10.814646633575592, -78.75129158976515, -776.6982692640759, -1.1213537650006642E9, -3.5514278388385316E24}, {-0.07901330769794718, -0.9691194604416485, -2.3197972379496976, -10.515025281883586, -75.76207366712643, -739.6045159767939, -1.0155105644115121E9, -2.9110459712863636E24}, {-0.07129604367196947, -0.9602164817351886, -2.2821757252868258, -10.226919426533563, -72.91576123451878, -704.6334848334544, -9.205630918567204E8, -2.390822760342336E24}, {-0.0636495305266962, -0.9514310574959565, -2.2456491527159166, -9.949778421707522, -70.20419372379517, -671.6443354015465, -8.352984529260813E8, -1.9673486543028634E24}, {-0.05607284398977662, -0.942759174492066, -2.210175171616151, -9.68308299673943, -67.61975028563934, -640.5068235959465, -7.586487280503453E8, -1.6219399949313185E24}, {-0.04856509124258979, -0.9341969812093498, -2.175713435446338, -9.426343187582736, -65.15530933300177, -611.100412364815, -6.896724767291219E8, -1.3396522029119777E24}, {-0.04112540965742778, -0.9257407801942823, -2.1422254870272006, -9.179096422764212, -62.80421146649317, -583.3134645818883, -6.275387475370239E8, -1.1085057396953082E24}, {-0.03375296559419272, -0.9173870208279843, -2.10967465316278, -8.940905750960708, -60.56022547039358, -557.0425098601943, -5.715132350021689E8, -9.188775434077777E23}, {-0.026446953253271253, -0.9091322925032677, -2.078025946059848, -8.711358198514548, -58.41751709918007, -532.1915779050047, -5.2094627858947796E8, -7.630214633003075E23}, {-0.019206593581467306, -0.9009733181787613, -2.0472459710487194, -8.490063246264905, -56.37062040233366, -508.6715918210163, -4.7526244458851767E8, -6.34689495945575E23}, {-0.012031133228075093, -0.8929069482860441, -2.017302840149298, -8.27665141602895, -54.414411360048085, -486.39981549349915, -4.339514701218214E8, -5.288319729359509E23}, {-0.004919843548357305, -0.8849301549674458, -1.988166091063007, -8.070772957928982, -52.54408362467336, -465.2993497868761, -3.965603809289857E8, -4.4135972734731115E23}, {0.002127980348131519, -0.8770400266237816, -1.959806611204787, -7.872096630540446, -50.75512618259283, -445.29867285689556, -3.6268662201765656E8, -3.6895502398298564E23}, {0.009113020506778887, -0.8692337627527551, -1.9321965664199539, -7.680308566539075, -49.04330276901638, -426.3312203628094, -3.319720635124078E8, -3.0892094046405537E23}, {0.016035936996958298, -0.8615086690601187, -1.9053093340586218, -7.495111217161905, -47.4046328841118, -408.33500180136264, -3.0409776374824476E8, -2.5906113275874813E23}, {0.0228973687429966, -0.8538621528269259, -1.8791194401058788, -7.3162223693725466, -45.83537427319333, -391.252249571439, -2.787793884063805E8, -2.1758366186688696E23}, {0.02969793431905284, -0.8462917185173723, -1.8536025000892515, -7.143374230143193, -44.33200674652622, -375.029097722669, -2.5576319874278885E8, -1.830239139913077E23}, {0.036438232709773075, -0.838794963612771, -1.828735163506292, -6.976312572738904, -42.89121722584566, -359.61528764816416, -2.3482253410485548E8, -1.5418270314987553E23}, {0.043118844038476135, -0.831369574658198, -1.8044950615346582, -6.814795940319167, -41.50988591507021, -344.963898255191, -2.1575472429463163E8, -1.3007647057220117E23}, {0.04974033026452153, -0.8240133235092566, -1.7808607578049764, -6.658594902562072, -40.18507350204001, -331.03109839189176, -1.9837837619246745E8, -1.098971413845729E23}, {0.056303235851412524, -0.8167240637672282, -1.757811702033138, -6.507491361370848, -38.91400930653466, -317.775919526418, -1.8253098663183513E8, -9.297970601167366E22}, {0.06280808840709715, -0.8094997273916796, -1.7353281863237908, -6.361277902045473, -37.69408029742915, -305.1600468700963, -1.6806684000826162E8, -7.877599224898882E22}, {0.06925539929784537, -0.8023383214803, -1.7133913039705913, -6.219757186595893, -36.52282090870908, -293.1476273110195, -1.548551546750847E8, -6.683340790982353E22}, {0.07564566423700235, -0.7952379252064052, -1.6919829105914845, -6.082741386141094, -35.39790359026885, -281.7050926810853, -1.427784469635036E8, -5.677768177435242E22}, {0.08197936384984181, -0.78819668690518, -1.671085587448995, -5.9500516495827025, -34.317130035027034, -270.8009970199902, -1.3173108578000043E8, -4.829882658213631E22}, {0.08825696421567694, -0.7812128213002889, -1.6506826068162548, -5.82151760596473, -33.27842302897213, -260.4058666258123, -1.216180142786892E8, -4.1139703148355065E22}, {0.09447891738831858, -0.774284606863021, -1.630757899259392, -5.696976898134567, -32.279818875351125, -250.4920617951283, -1.1235361816250376E8, -3.5086688024880575E22}, {0.10064566189591242, -0.767410383296638, -1.611296022716066, -5.576274745506772, -31.319460348386915, -241.03364925753982, -1.0386072280583023E8, -2.9962045246703164E22}, {0.10675762322112937, -0.7605885491390416, -1.59228213325832, -5.45926353390127, -30.395590135694434, -232.0062844012115, -9.606970367197698E7, -2.5617680904745294E22}, {0.11281521426262758, -0.7538175594773117, -1.573701957435712, -5.345802430583587, -29.506544732003746, -223.38710246867026, -8.891769647264518E7, -2.1930021725520083E22}, {0.1188188357786594, -0.7470959237680661, -1.5555417661018633, -5.235757022777562, -28.650748749922524, -215.15461797662644, -8.234789522660601E7, -1.8795808782808108E22}, {0.12476887681364378, -0.7404222037579586, -1.5377883496341753, -5.128998978051871, -27.82670961631165, -207.28863168081568, -7.630892785803643E7, -1.6128637487660059E22}, {0.1306657151084874, -0.7337950114989766, -1.5204289944626097, -5.025405725101817, -27.03301262543408, -199.7701444675806, -7.075430026293057E7, -1.3856107128262968E22}, {0.13650971749538873, -0.7272130074535307, -1.503451460829093, -4.924860153558097, -26.268316322393257, -192.58127760879722, -6.564190089163827E7, -1.1917469062632477E22}, {0.14230124027782698, -0.7206748986846172, -1.4868439617043514, -4.8272503315555, -25.53134819252419, -185.7051988663862, -6.093355886993114E7, -1.0261683472876215E22}, {0.14804062959639755, -0.7141794371266214, -1.4705951427938444, -4.7324692398876165, -24.82090063435958, -179.12605397759074, -5.659464952983503E7, -8.845811375582756E21}, {0.153728221781123, -0.7077254179325899, -1.4546940635689722, -4.64041452165922, -24.135827195581136, -172.82890309290795, -5.259374196172503E7, -7.633682147638387E21}, {0.15936434369083416, -0.7013116778940464, -1.4391301792639113, -4.5509882464267974, -23.475039052999577, -166.79966177546788, -4.890228384542732E7, -6.594787806257993E21}, {0.16494931304018778, -0.6949370939296462, -1.4238933237823004, -4.464096687890283, -22.837501719099667, -161.0250462041363, -4.54943193828184E7, -5.703364183083829E21}, {0.17048343871485766, -0.6886005816391911, -1.4089736934616044, -4.379650114265861, -22.22223195905203, -155.49252225301493, -4.234623664843288E7, -4.937626359606005E21}, {0.1759670210754072, -0.6823010939197139, -1.3943618316463249, -4.297562590531446, -21.628294903343562, -150.19025814763685, -3.943654110717665E7, -4.2791316086485245E21}, {0.18140035225032972, -0.6760376196405348, -1.3800486140243275, -4.217751791793251, -21.05480134232275, -145.1070804232617, -3.6745652427395046E7, -3.712247873642852E21}, {0.1867837164187143, -0.6698091823743678, -1.3660252346834463, -4.140138827074386, -20.500905190005213, -140.23243293352567, -3.425572205019E7, -3.2237097220542253E21}, {0.19211739008297635, -0.6636148391817168, -1.3522831928482155, -4.064648072874981, -19.965801105447134, -135.55633867850358, -3.1950469267999906E7, -2.802246898969919E21}, {0.1974016423320668, -0.6574536794459558, -1.3388142802590732, -3.9912070158980484, -19.448722260876597, -131.0693642401894, -2.981503382222024E7, -2.4382732162212755E21}, {0.20263673509555702, -0.6513248237566317, -1.325610569158715, -3.919746104376869, -18.948938246583708, -126.7625866306832, -2.7835843255548324E7, -2.123625650125614E21}, {0.20782292338897604, -0.6452274228386643, -1.3126644008524424, -3.8501986074779198, -18.465753103314956, -122.62756237413139, -2.6000493453662742E7, -1.851345274727165E21}, {0.21296045555075507, -0.6391606565252458, -1.2999683748113773, -3.7825004822889627, -17.998503473601698, -118.65629865785864, -2.42976409861825E7, -1.6154930982453505E21}, {0.21804957347112605, -0.6331237327723572, -1.2875153382892972, -3.7165902479347284, -17.54655686408264, -114.8412264012723, -2.2716906011522435E7, -1.41099505577926E21}, {0.2230905128132941, -0.6271158867129393, -1.2752983764256083, -3.652408866393129, -17.10931001145927, -111.17517510313218, -2.124878464682644E7, -1.2335113877950014E21}, {0.2280835032271969, -0.6211363797488477, -1.2633108028086097, -3.589899629613185, -16.686187345257313, -107.65134933876891, -1.98845698248418E7, -1.0793264394158768E21}, {0.2330287685561439, -0.6151844986788421, -1.2515461504747565, -3.5290080525620735, -16.27663954105872, -104.26330678888641, -1.8616279766332667E7, -9.45255580860266E20}, {0.2379265270366194, -0.6092595548609233, -1.2399981633210326, -3.4696817718530006, -15.880142158322062, -101.00493769079215, -1.743659329110973E7, -8.285664996352031E20}, {0.24277699149151477, -0.6033608834074516, -1.2286607879089195, -3.411870449628233, -15.496194357327516, -97.87044561133591, -1.633879127445402E7, -7.269125707777687E20}, {0.24758036951704912, -0.5974878424115365, -1.2175281656396733, -3.355525682392597, -15.124317690168429, -94.85432944857122, -1.5316703629923306E7, -6.382763892756919E20}, {0.25233686366362035, -0.5916398122032801, -1.206594625281814, -3.3006009145122497, -14.764054961067782, -91.95136657624765, -1.4364661265379373E7, -5.60921862482432E20}, {0.257046671610822, -0.5858161946345235, -1.1958546758328148, -3.247051356111678, -14.414969151627178, -89.15659705175484, -1.3477452517552897E7, -4.933535210851227E20}, {0.2617099863368469, -0.580016412390821, -1.1853029996980269, -3.194833905118819, -14.076642406920536, -86.46530881412028, -1.265028362243401E7, -4.3428192418438034E20}, {0.2663269962824918, -0.5742399083294192, -1.1749344461708133, -3.1439070732237875, -13.748675078625649, -83.87302380415373, -1.1878742825000366E7, -3.825942148583428E20}, {0.27089788550996674, -0.5684861448420979, -1.1647440251987997, -3.0942309155314858, -13.430684821647828, -81.37548494388881, -1.1158767772940021E7, -3.37329033422627E20}, {0.2754228338567015, -0.562754603241769, -1.1547269014219657, -3.045766963701874, -13.122305740930567, -78.96864391711416, -1.048661587567583E7, -2.9765512157913324E20}, {0.2799020170843375, -0.5570447831717984, -1.1448783884691176, -2.9984781623844676, -12.82318758537157, -76.64864969706628, -9858837.342669187, -2.6285305598799924E20}, {0.28433560702308114, -0.551356202037059, -1.135193943500024, -2.9523288087654844, -12.532994985969811, -74.41183777129507, -9272250.644126771, -2.3229963798036775E20}, {0.28872377171158997, -0.5456883944557748, -1.1256691619811832, -2.907284495057057, -12.251406735520613, -72.25472001733934, -8723920.163251843, -2.0545454003274744E20}, {0.2930666755325539, -0.5400409117312656, -1.1162997726838733, -2.863312053768348, -11.978115107354304, -70.17397518619691, -8211135.832426657, -1.8184887162806157E20}, {0.2973644793441255, -0.5344133213427353, -1.1070816328937245, -2.820379505607945, -11.712825210778751, -68.16643995365722, -7731394.566492491, -1.6107537920679182E20}, {0.30161734060735257, -0.5288052064543023, -1.0980107238216632, -2.7784560098760083, -11.455254381039818, -66.22910050241205, -7282383.324884351, -1.4278003870039435E20}, {0.30582541350975134, -0.5232161654414925, -1.0890831462065962, -2.7375118172129866, -11.205131601755918, -64.35908460048711, -6861963.651020104, -1.2665483599729879E20}, {0.3099888490851597, -0.5176458114344716, -1.0802951161007424, -2.697518224579642, -10.962196957915515, -62.553654143965076, -6468157.552253234, -1.1243156174904631E20}, {0.31410779533000144, -0.5120937718773096, -1.0716429608289801, -2.658447532350442, -10.726201117649314, -60.81019813421354, -6099134.597063674, -9.987647312078173E19}, {0.31818239731608544, -0.5065596881026178, -1.0631231151140526, -2.6202730034093014, -10.496904841103452, -59.12622606190512, -5753200.118150443, -8.878569720990055E19}, {0.322212797300062, -0.5010432149209187, -1.0547321173598847, -2.5829688241430713, -10.274078514846567, -57.49936167203567, -5428784.420851793, -7.898126955273758E19}, {0.3261991348296514, -0.4955440202241515, -1.0464666060856855, -2.5465100672342365, -10.05750171034267, -55.92733708592082, -5124432.905984704, -7.03077169575374E19}, {0.3301415468467536, -0.4900617846027288, -1.038323316503876, -2.5108726561599184, -9.846962765114265, -54.40798725779536, -4838797.024883789, -6.26291072988612E19}, {0.33404016778754914, -0.48459620097560097, -1.0302990772352516, -2.476033331309605, -9.642258385306146, -52.9392447451625, -4570625.992233171, -5.582650026586699E19}, {0.33789512967968816, -0.4791469742327999, -1.0223908071551164, -2.441969617638961, -9.44319326844043, -51.5191347734492, -4318759.189316137, -4.9795742694441435E19}, {0.3417065622366701, -0.47371382088996483, -1.0145955123644612, -2.4086597937818004, -9.249579745228438, -50.14577057683433, -4082119.196639446, -4.4445560299242996E19}, {0.3454745929495053, -0.4682964687543687, -1.0069102832805346, -2.3760828625465766, -9.061237439374452, -48.81734899832604, -3859705.400593563, -3.9695904581504066E19}, {0.3491993471757482, -0.46289465660199236, -0.9993322918414679, -2.344218522727974, -8.877992944371906, -47.53214633329397, -3650588.123953992, -3.54765196112317E19}, {0.3528809482259918, -0.4575081338652102, -0.9918587888198608, -2.31304714216792, -8.699679516352989, -46.28851440170352, -3453903.2346680886, -3.1725698427382407E19}, {0.3565195174479032, -0.45213666033066824, -0.984487101240498, -2.2825497320040484, -8.526136782109702, -45.08487683527208, -3268847.191560243, -2.8389203100769972E19}, {0.36011517430788226, -0.44678000584696226, -0.9772146298976092, -2.252707922046986, -8.357210461457305, -43.9197255666674, -3094672.489370418, -2.5419326174826324E19}, {0.3636680364704191, -0.44143795004173086, -0.9700388469673021, -2.223503937231077, -8.192752103160762, -42.791617508707176, -2930683.4689593585, -2.277407433423251E19}, {0.3671782198752255, -0.43611028204780394, -0.9629572937110232, -2.1949205750861394, -8.032618833691187, -41.699171412297396, -2776232.461604279, -2.041645783134234E19}, {0.3706458388122101, -0.43079680023805683, -0.9559675782660917, -2.1669411841806707, -7.876673118122511, -40.64106489257211, -2630716.2391049326, -1.831387149328898E19}, {0.3740710059943656, -0.4254973119686388, -0.9490673735195532, -2.139549643489613, -7.724782532519419, -39.61603161337211, -2493572.7439511125, -1.6437555096262543E19}, {0.3774538326286361, -0.42021163333025907, -0.94225441506178, -2.1127303426422674, -7.576819547205427, -38.62285862082777, -2364278.0760948854, -1.476212257642483E19}, {0.38079442848482337, -0.41493958890722343, -0.9355264992164055, -2.0864681630082993, -7.432661320335597, -37.66038381739596, -2242343.7149482775, -1.3265150990616236E19}, {0.38409290196259704, -0.4096810115439329, -0.9288814811433589, -2.0607484595820216, -7.292189501231729, -36.727493568246324, -2127313.9571106085, -1.192682137946891E19}, {0.3873493601566661, -0.4044357421185652, -0.9223172730119111, -2.0355570436272314, -7.155290042969167, -35.82312043240011, -2018763.5520383853, -1.0729604750544366E19}, {0.39056390892016635, -0.39920362932367215, -0.9158318422407876, -2.010880166046822, -7.0218530237335095, -34.94624101149797, -1916295.519421434, -9.657987314967149E18}, {0.3937366529263201, -0.3939845294534345, -0.9094232098025432, -1.9867045014432754, -6.89177247649304, -34.09587390951505, -1819539.133437416, -8.698229899258612E18}, {0.3968676957284195, -0.3887783061973362, -0.9030894485895343, -1.9630171328379094, -6.76494622655855, -33.27107779715453, -1728148.0603365023, -7.838157133013025E18}, {0.3999571398181852, -0.38358483044001584, -0.896828681838931, -1.939805537018355, -6.641275736626177, -32.47094957503438, -1641798.636971166, -7.066972598321273E18}, {0.403005086682546, -0.3784039800670743, -0.8906390816143428, -1.9170575704853556, -6.520665958921825, -31.694622630142604, -1560188.2789441943, -6.375096631758641E18}, {0.4060116368588891, -0.3732356397766244, -0.8845188673417408, -1.894761455971429, -6.4030251940868315, -30.941265180371293, -1483034.0080106645, -5.754023905680138E18}, {0.4089768899888256, -0.3680797008963707, -0.8784663043974617, -1.8729057695053173, -6.2882649564647215, -30.21007870225347, -1410071.0892461985, -5.19619829222685E18}, {0.41190094487051265, -0.3629360612060287, -0.8724797027461837, -1.8514794279974836, -6.176299845467586, -29.500296437320213, -1341051.7692921916, -4.694902839144453E18}, {0.4147838995095768, -0.3578046247648851, -0.866557415626856, -1.8304716773231349, -6.0670474227183515, -28.811181972769546, -1275744.1077162859, -4.244162968357849E18}, {0.41762585116867695, -0.3526853017443225, -0.86069783828466, -1.8098720808804512, -5.960428094681864, -28.142027892395248, -1213930.894189732, -3.8386612523211914E18}, {0.42042689641574815, -0.3475780082651325, -0.8548994067471638, -1.7896705086027769, -5.85636500051325, -27.492154493963476, -1155408.6447883744, -3.473662334687285E18}, {0.42318713117096063, -0.3424826662394464, -0.8491605966429088, -1.7698571264046052, -5.7547839048668115, -26.860908569450174, -1099986.6712762532, -3.144946745289615E18}, {0.42590665075243395, -0.33739920321712596, -0.8434799220607582, -1.7504223860421761, -5.655613095422569, -26.247662244762623, -1047486.2177350074, -2.848752518645451E18}, {0.4285855499207375, -0.3323275522364556, -0.8378559344483921, -1.7313570153704214, -5.558783284900455, -25.651811875764825, -997739.6593627902, -2.5817236634698255E18}, {0.43122392292221645, -0.32726765167899163, -0.8322872215484316, -1.7126520089789286, -5.464227517344687, -25.072776997612674, -950589.7586873947, -2.340864650876268E18}, {0.4338218635311696, -0.3222194451284213, -0.8267724063707078, -1.6942986191903784, -5.371881078472139, -24.509999324576153, -905888.9748229944, -2.1235001934703782E18}, {0.4363794650909142, -0.31718288123329685, -0.8213101461992841, -1.6762883474057422, -5.281681409889583, -23.962941797689318, -863498.8217519808, -1.9272396785214252E18}, {0.43889682055376983, -0.31215791357351247, -0.8158991316328912, -1.6586129357812969, -5.193568026994995, -23.43108767772109, -823289.2719354554, -1.7499456976346076E18}, {0.44137402251998603, -0.3071445005303966, -0.810538085657482, -1.6412643592231657, -5.107482440387587, -22.91393968110177, -785138.2018507976, -1.5897061844057078E18}, {0.4438111632756463, -0.30214260516029867, -0.8052257627496877, -1.6242348176858443, -5.023368080620567, -22.41101915657524, -748930.8763248397, -1.4448097317685998E18}, {0.4462083348295736, -0.29715219507155183, -0.7999609480099925, -1.6075167287617635, -4.941170226139162, -21.921865300472344, -714559.468778663, -1.3137237133084518E18}, {0.4485656289492658, -0.2921732423047007, -0.7947424563245036, -1.5911027205495731, -4.860835934254547, -21.4460344086189, -681922.6147268491, -1.195074878715601E18}, {0.45088313719588347, -0.2872057232158839, -0.7895691315542371, -1.5749856247893925, -4.782313975012011, -20.983099163003114, -650924.99608209, -1.0876321336675805E18}, {0.4531609509583196, -0.28224961836326895, -0.7844398457508888, -1.5591584702538408, -4.705554767818973, -20.53264795143148, -621476.9540069136, -9.902912495022158E17}, {0.4553991614863706, -0.2773049123964371, -0.7793534983980962, -1.5436144763841615, -4.630510320705273, -20.094284218500295, -593494.1282294723, -9.020612787355461E17}, {0.4575978599230353, -0.27237159394862415, -0.7743090156772494, -1.5283470471612584, -4.557134172094582, -19.667625846301913, -566897.1209011775, -8.220524793497029E17}, {0.459757137335962, -0.26744965553172145, -0.769305349756936, -1.5133497652019268, -4.485381334971976, -19.252304563372036, -541611.1832217353, -7.494655743179726E17}, {0.4618770847480671, -0.26253909343395126, -0.7643414781051538, -1.4986163860710116, -4.415208243338435, -18.84796538046556, -517565.92319290916, -6.835821934724662E17}, {0.46395779316734426, -0.257639907620126, -0.759416402823452, -1.4841408328006356, -4.346572700848459, -18.45426605182532, -494695.03298715304, -6.237563629234509E17}, {0.46599935361588757, -0.25275210163441214, -0.7545291500022029, -1.4699171906080604, -4.27943383153225, -18.07087656068075, -472936.03453206836, -5.694069231296081E17}, {0.46800185715814496, -0.24787568250551714, -0.7496787690962327, -1.4559397018041027, -4.213752032508664, -17.697478627780736, -452230.04201722785, -5.2001077067413606E17}, {0.4699653949284227, -0.24301066065422303, -0.7448643323200776, -1.4422027608844141, -4.1494889285998795, -17.333765241829973, -432521.5401271501, -4.750968310659231E17}, {0.4718900581576609, -0.2381570498031918, -0.7400849340621561, -1.428700909796259, -4.086607328763043, -16.979440210757993, -413758.17689368746, -4.342406806690805E17}, {0.47377593819949393, -0.23331486688897282, -0.7353396903171765, -1.4154288333737546, -4.0250711842582305, -16.634217732806647, -395890.570143524, -3.970597453523668E17}, {0.47562312655561756, -0.22848413197614048, -0.7306277381361315, -1.4023813549348674, -3.964845548476147, -16.297821986476503, -378872.1265924817, -3.63209011803129E17}, {0.477431714900476, -0.22366486817350073, -0.7259482350932546, -1.3895534320337317, -3.905896538352518, -15.969986738421902, -362658.87270829675, -3.323771948081191E17}, {0.47920179510528776, -0.21885710155229546, -0.7213003587693314, -1.3769401523621545, -3.8481912972997647, -15.650454968433264, -347209.2965281586, -3.0428331028863226E17}, {0.48093345926142417, -0.21406086106635086, -0.7166833062507973, -1.3645367297944362, -3.79169795958985, -15.338978510689484, -332484.1996768131, -2.78673609596239E17}, {0.4826267997031568, -0.20927617847410393, -0.7120962936440602, -1.3523385005698876, -3.7363856161253057, -15.035317710506012, -318446.55888602755, -2.5531883562162182E17}, {0.484281909029789, -0.20450308826245378, -0.7075385556045202, -1.3403409196076774, -3.682224281538528, -14.73924109584441, -305061.3963669408, -2.340117657241111E17}, {0.4858988801271842, -0.19974162757238004, -0.7030093448797712, -1.3285395569488616, -3.6291848625621683, -14.450525062886653, -292295.65843367664, -2.1456501042492406E17}, {0.4874778061887078, -0.19499183612627716, -0.6985079318664968, -1.3169300943206856, -3.5772391276162487, -14.168953575013724, -280118.10181988747, -1.9680904028539318E17}, {0.4890187807355924, -0.19025375615695025, -0.6940336041805819, -1.3055083218184418, -3.5263596775600696, -13.894317874561168, -268499.1871698857, -1.8059041646737062E17}, {0.49052189763674303, -0.18552743233822658, -0.6895856662399904, -1.2942701347003793, -3.4765199175595134, -13.626416206756758, -257410.97922300317, -1.6577020319455E17}, {0.4919872511279926, -0.18081291171713054, -0.6851634388599697, -1.2832115302913518, -3.4276940300225682, -13.365053555275178, -246827.05324400746, -1.5222254274275674E17}, {0.49341493583082185, -0.1761102436475794, -0.6807662588601616, -1.2723286049910623, -3.3798569485581225, -13.11004138887329, -236722.4072840387, -1.3983337572129494E17}, {0.4948050467705536, -0.17141947972555296, -0.6763934786832156, -1.2616175513829544, -3.3329843329151556, -12.861197418596516, -227073.37988579867, -1.2849929129861965E17}, {0.49615767939403516, -0.16674067372569457, -0.6720444660245146, -1.2510746554399481, -3.287052544861397, -12.618345365072274, -217857.57287381872, -1.1812649370247286E17}, {0.4974729295868179, -0.162073881539303, -0.6677186034726403, -1.2406962938233865, -3.242038624962401, -12.381314735430395, -209053.77889572043, -1.0862987281220422E17}, {0.4987508936898485, -0.15741916111367155, -0.6634152881602162, -1.230478931271718, -3.1979202702238356, -12.149940609413786, -200641.9134036398, -9.993216798138106E16}, {0.49999166851567683, -0.15277657239274106, -0.6591339314247822, -1.2204191180755553, -3.1546758125613277, -11.92406343426331, -192602.9507864899, -9.196321540128378E16}, {0.5011953513641977, -0.14814617725902252, -0.6548739584793662, -1.2105134876359285, -3.11228419806398, -11.703528827982247, -184918.86438373404, -8.465927035769189E16}, {0.5023620400379295, -0.14352803947675918, -0.6506348080924328, -1.2007587541026474, -3.070724967019079, -11.488187390604292, -177572.5701298205, -7.796239665939357E16}, {0.5034918328568466, -0.1389222246362897, -0.6464159322768978, -1.1911517100898372, -3.0299782346670443, -11.277894523107875, -170547.87359561262, -7.1819916340470056E16}, {0.5045848286727674, -0.1343288000995776, -0.6422167959879084, -1.1816892244658082, -2.9900246726569937, -11.072510253636624, -163829.42020906665, -6.6183913471251816E16}, {0.5056411268833155, -0.1297478349468788, -0.6380368768291103, -1.1723682402145708, -2.950845491174678, -10.871899070702483, -157402.64845219447, -6.101078656524944E16}, {0.5066608274454546, -0.1251793999245095, -0.6338756647671107, -1.1631857723663659, -2.9124224217157124, -10.675929763063362, -151253.74584506793, -5.626084465044507E16}, {0.5076440308886127, -0.12062356739368958, -0.6297326618538855, -1.1541389059947427, -2.8747377004783288, -10.484475265982297, -145369.60754036964, -5.189794259112901E16}, {0.5085908383273994, -0.11608041128042716, -0.6256073819568623, -1.145224794277763, -2.837774052350889, -10.297412513588725, -139737.79736382543, -4.788915170809043E16}, {0.509501351473927, -0.11155000702641893, -0.621499350496436, -1.1364406566210432, -2.8015146754705618, -10.114622297075993, -134346.51114685994, -4.4204462156717144E16}, {0.5103756726497454, -0.10703243154093756, -0.6174081041906829, -1.1277837768404284, -2.7659432263306023, -9.935989128481982, -129184.54220803932, -4.081651388998368E16}, {0.5112139047973887, -0.10252776315367862, -0.6133331908070287, -1.1192515014021556, -2.7310438054145516, -9.761401109811198, -124241.24884937066, -3.77003533613291E16}, {0.5120161514915582, -0.09803608156854221, -0.6092741689206675, -1.1108412377184966, -2.696800943336763, -9.59074980726866, -119506.52374236975, -3.483321341541315E16}, {0.5127825169499309, -0.09355746781832368, -0.6052306076794998, -1.1025504524968932, -2.663199587469393, -9.423930130386083, -114970.76508703562, -3.2194314076549412E16}, {0.5135131060436136, -0.08909200422028953, -0.6012020865753946, -1.0943766701407236, -2.630225089036978, -9.260840215831632, -110624.84943452408, -2.9764682178670212E16}, {0.5142080243072433, -0.0846397743326147, -0.5971881952215714, -1.0863174711998782, -2.5978631906604233, -9.101381315703742, -106460.106071436, -2.7526987990016092E16}, {0.514867377948744, -0.0802008629116588, -0.5931885331359108, -1.078370490869417, -2.5661000143330845, -8.945457690119193, -102468.29287027776, -2.546539717306231E16}, {0.5154912738587424, -0.07577535587005892, -0.5892027095300059, -1.0705334175346217, -2.534922049812275, -8.79297650391392, -98641.57351681968, -2.3565436587872696E16}, {0.5160798196196551, -0.07136334023561859, -0.5852303431037816, -1.0628039913608573, -2.5043161434103385, -8.643847727283864, -94972.49603084975, -2.1813872597253012E16}, {0.5166331235144463, -0.0669649041109713, -0.5812710618454997, -1.055180002926673, -2.4742694871699626, -8.497984040200596, -91453.97250217144, -2.019860066662185E16}, {0.5171512945350694, -0.06258013663399913, -0.5773245028369915, -1.047659291898677, -2.4447696084091914, -8.355300740444367, -88079.25996870735, -1.8708545172130116E16}, {0.5176344423905904, -0.05820912793898734, -0.57339031206395, -1.0402397457467405, -2.4158043596220855, -8.215715655104162, -84841.94236822744, -1.7333568438711762E16}, {0.51808267751501, -0.05385196911849597, -0.5694681442311321, -1.0329192984981683, -2.38736190872164, -8.07914905540122, -81735.91349957263, -1.6064388126777338E16}, {0.5184961110747757, -0.04950875218593031, -0.565557662582314, -1.0256959295294954, -2.3594307296120642, -7.945523574698884, -78755.36093330279, -1.4892502173345688E16}, {0.5188748549760038, -0.04517957003879271, -0.5616585387248606, -1.0185676623946553, -2.3319995930781374, -7.814764129567985, -75894.75081548655, -1.3810120571599124E16}, {0.5192190218714066, -0.04086451642259954, -0.5577704524587647, -1.011532563688277, -2.305057557979755, -7.686797843782495, -73148.81351188067, -1.2810103343081734E16}, {0.5195287251669337, -0.036563685895444606, -0.5538930916100208, -1.0045887419429402, -2.2785939627403744, -7.561553975126137, -70512.53004305506, -1.1885904119876612E16}, {0.5198040790281339, -0.03227717379319688, -0.5500261518682058, -0.9977343465592485, -2.252598417118447, -7.438963844895611, -67981.11926409364, -1.1031518810835512E16}, {0.52004519838624, -0.028005076195312287, -0.5461693366281357, -0.9909675667676274, -2.2270607942514182, -7.318960769991394, -65550.02574538936, -1.0241438876965492E16}, {0.5202521989439824, -0.023747489891249217, -0.542322356835478, -0.9842866306207917, -2.201971222962268, -7.201479997491729, -63214.90831373538, -9.510608786987276E15}, {0.520425197181137, -0.019504512347469978, -0.5384849308362017, -0.9776898040158665, -2.1773200803189825, -7.086458641609995, -60971.62921543439, -8.83438726540551E15}, {0.5205643103598112, -0.015276241675015742, -0.5346567842297519, -0.9711753897451907, -2.15309798443775, -6.973835622940233, -58816.2438654984, -8.2085119826409E15}, {0.5206696565294723, -0.011062776597640447, -0.530837649725833, -0.9647417265748467, -2.1292957875209866, -6.8635516098993685, -56744.99114920835, -7.629067370291792E15}, {0.5207413545317249, -0.00686421642049186, -0.5270272670047028, -0.9583871883500261, -2.105904569121743, -6.755548962279068, -54754.284244362985, -7.092455274798804E15}, {0.5207795240048366, -0.002680660999324805, -0.5232253825808629, -0.9521101831263373, -2.0829156296262648, -6.649771676823533, -52840.7019344676, -6.595368190014492E15}, {0.5207842853880227, 0.0014877892897633524, -0.519431749670056, -0.9459091523262287, -2.0603204839469313, -6.546165334753522, -51000.980384917355, -6.134764833737479E15}, {0.5207557599254893, 0.005641033580090072, -0.5156461280594656, -0.9397825699197017, -2.038110855417984, -6.44467705115995, -49232.0053559128, -5.707847855424495E15}, {0.5206940696702407, 0.00977897054364528, -0.5118682839810301, -0.9337289416285371, -2.0162786698868502, -6.345255426194027, -47530.80482742658, -5.312043482289604E15}, {0.5205993374876545, 0.013901498419865543, -0.5080979899877754, -0.9277468041532746, -1.9948160499940806, -6.2478504979837055, -45894.54201301555, -4.944982929052069E15}, {0.5204716870588286, 0.018008515043931805, -0.5043350248330832, -0.9218347244222171, -1.9737153096352422, -6.152413697209475, -44320.50874066072, -4.604485412900856E15}, {0.5203112428837031, 0.022099917874603213, -0.5005791733528074, -0.9159912988617592, -1.9529689485983335, -6.058897803275145, -42806.11918011201, -4.288542629975684E15}, {0.520118130283963, 0.026175604021597677, -0.4968302263501573, -0.9102151526873579, -1.9325696473705483, -5.967256902012101, -41348.90389743247, -3.9953045629815735E15}, {0.5198924754057208, 0.03023547027252713, -0.4930879804832677, -0.904504939214491, -1.9125102621084638, -5.8774463448580745, -39946.50421857673, -3.723066501594732E15}, {0.5196344052219892, 0.03427941311940026, -0.4893522381553812, -0.8988593391889783, -1.892783819765939, -5.789422709453915, -38596.6668849061, -3.470257168208775E15}, {0.5193440475349397, 0.03830732878469888, -0.4856228074075639, -0.8932770601360438, -1.8733835133742416, -5.703143761604243, -37297.23898454697, -3.2354278514258685E15}, {0.5190215309779561, 0.042319113247040845, -0.4818995018138852, -0.8877568357275412, -1.8543026974691175, -5.618568418550064, -36046.16314443757, -3.017242458617744E15}, {0.5186669850174843, 0.04631466226643346, -0.47818214037899354, -0.8822974251667717, -1.8355348836597432, -5.535656713503658, -34841.472968792565, -2.8144684069597485E15}, {0.5182805399546825, 0.05029387140913175, -0.4744705474380172, -0.8768976125903464, -1.8170737363346645, -5.4543697613980315, -33681.28871054166, -2.6259682796579715E15}, {0.5178623269268713, 0.05425663607210505, -0.47076455255872457, -0.8715562064865574, -1.7989130685000188, -5.374669725805173, -32563.813163076004, -2.450692180719895E15}, {0.5174124779087925, 0.058202851507123086, -0.46706399044588326, -0.8662720391297586, -1.7810468377455317, -5.296519786979348, -31487.32776036704, -2.2876707276292775E15}, {0.5169311257136756, 0.06213241284446847, -0.4633687008477545, -0.8610439660302521, -1.763469142333932, -5.219884110983307, -30450.188874206357, -2.1360086267356005E15}, {0.5164184039941159, 0.0660452151162819, -0.45967852846466406, -0.8558708653992099, -1.7461742174095882, -5.144727819857108, -29450.824297960764, -1.994878781112207E15}, {0.5158744472427668, 0.06994115327955078, -0.4559933228595897, -0.8507516376281633, -1.729156431322337, -5.0710169627908, -28487.729906840017, -1.8635168851225642E15}, {0.515299390792851, 0.07382012223874515, -0.4523129383707135, -0.8456852047826249, -1.7124102820626268, -4.998718488263883, -27559.466485244706, -1.7412164640060628E15}, {0.5146933708184922, 0.07768201686811, -0.4486372340258816, -0.8406705101094054, -1.6959303938042343, -4.927800217115881, -26664.656712295622, -1.6273243204916948E15}, {0.5140565243348664, 0.0815267320336198, -0.44496607345891737, -0.8357065175572086, -1.679711513550935, -4.858230816513758, -25801.982297147348, -1.5212363538060065E15}, {0.5133889891981829, 0.08535416261460234, -0.4412993248277417, -0.830792211310112, -1.6637485078836909, -4.789979774783438, -24970.181256163698, -1.4223937194931418E15}, {0.5126909041054922, 0.08916420352503805, -0.43763686073424807, -0.8259265953335365, -1.6480363598049859, -4.723017377073824, -24168.045324474595, -1.3302793012378568E15}, {0.5119624085943247, 0.09295674973454125, -0.4339785581458841, -0.8211086929323334, -1.6325701656771023, -4.657314681823044, -23394.417494853027, -1.2444144684039652E15}, {0.5112036430421616, 0.09673169628902907, -0.43032429831889313, -0.8163375463206229, -1.6173451322512313, -4.592843497997876, -22648.18967724483, -1.1643560952940398E15}, {0.5104147486657438, 0.10048893833108445, -0.42667396672317337, -0.81161221620304, -1.6023565737844268, -4.529576363078383, -21928.3004726527, -1.0896938202224848E15}, {0.5095958675202178, 0.1042283711200186, -0.4230274529687073, -0.8069317813670407, -1.587599909241527, -4.467486521760955, -21233.733055425782, -1.0200475243930968E15}, {0.5087471424981236, 0.10794989005163799, -0.4193846507335226, -0.802295338285947, -1.5730706595792598, -4.406547905353986, -20563.513158333742, -9.550650123008144E14}, {0.5078687173282224, 0.11165339067772273, -0.4157454576931376, -0.7977020007324052, -1.5587644451098455, -4.346735111841342, -19916.707155112745, -8.944198769515882E14}, {0.5069607365741734, 0.11533876872521966, -0.4121097754514599, -0.7931508994019629, -1.5446769829415405, -4.288023386589947, -19292.420235463254, -8.378095346284536E14}, {0.5060233456330577, 0.11900592011515708, -0.4084775094730929, -0.788641181546457, -1.5308040844936048, -4.230388603678477, -18689.794667752158, -7.84953415238552E14}, {0.5050566907337481, 0.12265474098128498, -0.40484856901701205, -0.7841720106169257, -1.517141653083296, -4.173807247825217, -18108.008144931297, -7.355912954670795E14}, {0.5040609189351365, 0.12628512768844538, -0.4012228670715816, -0.779742565915777, -1.5036856815825967, -4.118256396893985, -17546.27220942768, -6.894817630501756E14}, {0.50303617812421, 0.12989697685067852, -0.397600320290867, -0.7753520422579301, -1.4904322501424043, -4.063713704957668, -17003.83075298982, -6.464008014693928E14}, {0.5019826170139879, 0.133490185349069, -0.3939808489322169, -0.7709996496406821, -1.4773775239820603, -4.010157385899967, -16479.95858769218, -6.061404852741811E14}, {0.5009003851413135, 0.13706465034933554, -0.3903643767950752, -0.7666846129220375, -1.4645177512421124, -3.95756619753639, -15973.960084502269, -5.685077770635894E14}, {0.49978963286450806, 0.14062026931917015, -0.38675083116099507, -0.7624061715072651, -1.4518492608983258, -3.9059194262365478, -15485.16787600934, -5.333234179114519E14}, {0.49865051136088645, 0.14415694004532859, -0.3831401427348219, -0.7581635790434407, -1.4393684607349875, -3.8551968720302376, -15012.94162009363, -5.0042090370685675E14}, {0.4974831726241368, 0.14767456065047962, -0.3795322455870125, -0.7539561031217457, -1.427071835375637, -3.80537883418061, -14556.666821487352, -4.6964554050983144E14}, {0.496287769461567, 0.15117302960981313, -0.3759270770970661, -0.749783024987307, -1.4149559443694315, -3.756446097208335, -14115.753708340606, -4.4085357259610406E14}, {0.49506445549121864, 0.1546522457674148, -0.3723245778980323, -0.7456436392563549, -1.403017420331384, -3.7083799173512135, -13689.636161057299, -4.139113773892776E14}, {0.493813385138851, 0.15811210835240638, -0.3687246918220738, -0.7415372536404978, -1.391252967134804, -3.6611620094443245, -13277.77069081099, -3.8869472195837644E14}, {0.4925347136347972, 0.16155251699486142, -0.36512736584705163, -0.7374631886779082, -1.3796593581543082, -3.6147745342063446, -12879.635465286352, -3.65088076197239E14}, {0.49122859701069377, 0.1649733717414933, -0.361532550044111, -0.7334207774712275, -1.3682334345578404, -3.569200085918207, -12494.729379320917, -3.429839782034739E14}, {0.4898951920960852, 0.16837457307112427, -0.35794019752623857, -0.7294093654319997, -1.3569721036461746, -3.5244216804807733, -12122.571168242615, -3.222824477417397E14}, {0.4885346565149058, 0.17175602190993633, -0.35435026439776807, -0.7254283100314489, -1.3458723372384402, -3.4804227438386772, -11762.698561813922, -3.0289044401216706E14}, {0.4871471486818411, 0.17511761964650702, -0.3507627097048107, -0.721476980557427, -1.334931170102262, -3.43718710075803, -11414.667476801755, -2.847213642523523E14}, {0.48573282779856924, 0.1784592681466345, -0.34717749538658593, -0.717554757877358, -1.3241456984271363, -3.3946989639460465, -11078.051246294508, -2.6769457998309144E14}, {0.4842918538498836, 0.18178086976795443, -0.34359458622762784, -0.7136610342070069, -1.3135130783397253, -3.3529429235011206, -10752.43988398464, -2.5173500796610275E14}, {0.4828243875997014, 0.185082327374352, -0.34001394981084954, -0.7097952128849223, -1.3030305244598042, -3.311903936682375, -10437.4393817272, -2.367727131785037E14}, {0.4813305905869563, 0.1883635443501707, -0.3364355564714404, -0.7059567081523866, -1.2926953084956057, -3.2715673179879383, -10132.67103877055, -2.2274254132552328E14}, {0.4798106251213787, 0.19162442461422247, -0.33285937925157616, -0.7021449449387258, -1.2825047578773943, -3.2319187295318086, -9837.770821138329, -2.095837786117103E14}, {0.4782646542791645, 0.19486487263360072, -0.32928539385592237, -0.6983593586518306, -1.2724562544280928, -3.1929441717093097, -9552.388749718431, -1.9723983667310006E14}, {0.47669284189853406, 0.19808479343730057, -0.3257135786079086, -0.6945993949737466, -1.2625472330698655, -3.154629974141697, -9276.188315688856, -1.856579607400223E14}, {0.47509535257518354, 0.2012840926296452, -0.32214391440676016, -0.6908645096611956, -1.25277518056557, -3.1169627868906886, -9008.84592197904, -1.7478895925359606E14}, {0.47347235165762913, 0.20446267640352603, -0.31857638468526095, -0.687154168350891, -1.2431376342940368, -3.079929571934069, -8750.050349531444, -1.645869532997726E14}, {0.4718240052424458, 0.2076204515534554, -0.31501097536823475, -0.68346784636952, -1.2336321810581699, -3.0435175948938324, -8499.50224719001, -1.55009144354017E14}, {0.47015048016940275, 0.21075732548843518, -0.31144767483172564, -0.6798050285482629, -1.224256455924892, -3.0077144170086405, -8256.913644101374, -1.460155989484305E14}, {0.46845194401649765, 0.2138732062446434, -0.3078864738628615, -0.6761652090417327, -1.215008141095996, -2.9725078873426396, -8022.007483569934, -1.3756904898211061E14}, {0.4667285650948876, 0.21696800249794407, -0.30432736562037854, -0.6725478911512053, -1.2058849648089742, -2.9378861352229686, -7794.517177361236, -1.2963470649573189E14}, {0.4649805124437229, 0.22004162357621598, -0.3007703455958005, -0.6689525871520376, -1.19688470026697, -2.9038375628986186, -7574.186179497873, -1.2218009182337162E14}, {0.46320795582488283, 0.2230939794715098, -0.29721541157524756, -0.665378818125152, -1.1880051645969663, -2.8703508384134375, -7360.767578639344, -1.1517487411921431E14}, {0.46141106571761276, 0.22612498085203164, -0.29366256360186227, -0.6618261137924801, -1.1792442178354081, -2.8374148886864754, -7154.023708182665, -1.0859072333459175E14}, {0.4595900133130688, 0.22913453907395465, -0.290111803938842, -0.6582940123562653, -1.170599761940445, -2.8050188927929804, -6953.725773262646, -1.0240117279234936E14}, {0.45774497050876684, 0.23212256619306373, -0.28656313703305614, -0.6547820603421141, -1.162069739830028, -2.773152275439679, -6759.653493871392, -9.658149157137492E13}, {0.45587610990293975, 0.23508897497623185, -0.28301656947923987, -0.6512898124457022, -1.153652134445103, -2.74180470062813, -6571.594763354672, -9.110856597468694E13}, {0.4539836047888034, 0.23803367891273275, -0.27947210998474714, -0.6478168313830364, -1.1453449678371803, -2.71096606550019, -6389.345321579099, -8.596078941023442E13}, {0.4520676291487325, 0.2409565922253905, -0.2759297693348506, -0.6443626877441779, -1.1371463002795745, -2.6806264943598404, -6212.708442098539, -8.111796006488767E13}, {0.4501283576483483, 0.24385762988156653, -0.27238956035857675, -0.6409269598503373, -1.129054229401636, -2.650776332865802, -6041.494632680709, -7.656118579935877E13}, {0.44816596563051897, 0.24673670760398853, -0.26885149789506224, -0.6375092336142534, -1.1210668893453157, -2.621406142389571, -5875.5213485858685, -7.227279573532745E13}, {0.44618062910927336, 0.2495937418814225, -0.26531559876041655, -0.6341091024037653, -1.1131824499434209, -2.592506694533686, -5714.612718018974, -6.823625804615349E13}, {0.4441725247636319, 0.2524286499791851, -0.26178188171508776, -0.6307261669085027, -1.1053991159189498, -2.5640689658052245, -5558.599279204381, -6.4436103499516766E13}, {0.44214182993135054, 0.2552413499495067, -0.25825036743170593, -0.6273600350096017, -1.0977151261048972, -2.5360841324396697, -5407.317728558738, -6.085785433439384E13}, {0.4400887226025865, 0.2580317606417368, -0.25472107846340786, -0.6240103216523802, -1.0901287526839631, -2.508543565370502, -5260.610679462802, -5.748795808619078E13}, {0.4380133814134796, 0.26079980171240164, -0.25119403921261885, -0.6206766487218842, -1.0826383004475906, -2.4814388253399793, -5118.326431156755, -5.431372600281633E13}, {0.435915985639656, 0.26354539363510976, -0.24766927590029192, -0.617358644921241, -1.0752421060737958, -2.4547616581467464, -4980.318747306096, -5.132327572119446E13}, {0.4337967151896523, 0.26626845771031044, -0.24414681653558504, -0.6140559456527392, -1.0679385374232593, -2.428503990026062, -4846.446643806924, -4.8505477898370586E13}, {0.43165575059826145, 0.2689689160749054, -0.24062669088597063, -0.6107681929015683, -1.0607259928531663, -2.4026579231585634, -4716.574185419573, -4.584990651410989E13}, {0.4294932730198039, 0.2716466917117139, -0.23710893044776854, -0.607495035122151, -1.053602900548303, -2.377215731303637, -4590.570290839204, -4.334679258288626E13}, {0.42730946422132327, 0.27430170845879487, -0.2335935684170896, -0.6042361271270005, -1.0465677178689285, -2.352169855553589, -4468.308545830208, -4.098698103254564E13}, {0.4251045065757069, 0.2769338910186251, -0.2300806396611822, -0.6009911299780366, -1.0396189307149517, -2.327512900204926, -4349.667024068781, -3.8761890524829664E13}, {0.4228785830547341, 0.2795431649671378, -0.22657018069017099, -0.5977597108802993, -1.0327550529059653, -2.3032376287431986, -4234.528115354837, -3.666347600948409E13}, {0.42063187722205325, 0.28212945676261886, -0.22306222962918287, -0.594541543078001, -1.0259746255767017, -2.2793369599379707, -4122.778360870085, -3.468419381895379E13}, {0.41836457322608833, 0.28469269375446526, -0.21955682619084724, -0.5913363057528552, -1.019276216587481, -2.2558039640445777, -4014.3082951741458, -3.2816969124783363E13}, {0.4160768557928745, 0.2872328041918055, -0.21605401164816312, -0.5881436839246232, -1.0126584199492392, -2.2326318591094694, -3909.012294645011, -3.105516558989504E13}, {0.4137689102188266, 0.28974971723198345, -0.212553828807727, -0.5849633683538265, -1.0061198552627446, -2.2098140073760195, -3806.788432083538, -2.939255706297708E13}, {0.4114409223634403, 0.29224336294890696, -0.20905632198331084, -0.5817950554465674, -0.9996591671716077, -2.1873439117878033, -3707.5383372148244, -2.7823301172376582E13}, {0.4090930786419259, 0.2947136723412615, -0.20556153696978396, -0.5786384471614051, -0.9932750248287073, -2.1652152125864053, -3611.167062831369, -2.634191468720512E13}, {0.40672556601777843, 0.297160577340591, -0.20206952101737138, -0.5754932509182376, -0.9869661213756814, -2.1434216840009954, -3517.5829563349353, -2.49432505229178E13}, {0.40433857199528267, 0.2995840108192472, -0.19858032280623927, -0.5723591795091363, -0.9807311734351127, -2.1219572310268875, -3426.6975364447662, -2.3622476277453203E13}, {0.4019322846119549, 0.30198390659820556, -0.19509399242140316, -0.5692359510110866, -0.9745689206150759, -2.100815886290491, -3338.4253748508163, -2.2375054192205082E13}, {0.3995068924309236, 0.30436019945475545, -0.19161058132794856, -0.5661232887005868, -0.9684781250257128, -2.0799918069980823, -3252.6839826003925, -2.119672243965819E13}, {0.39706258453324833, 0.30671282513005543, -0.18813014234656206, -0.5630209209700583, -0.9624575708075083, -2.0594792719659316, -3169.393701016437, -2.008347764653467E13}, {0.3945995505101796, 0.3090417203365653, -0.18465272962936077, -0.5599285812460228, -0.9565060636709577, -2.0392726787294055, -3088.4775969547013, -1.9031558567783594E13}, {0.3921179804553581, 0.3113468227653489, -0.18117839863601604, -0.5568460079090021, -0.9506224304473216, -2.019366540728726, -3009.861362215826, -1.8037430832761438E13}, {0.38961806495695805, 0.3136280710932505, -0.17770720611016716, -0.553772944215098, -0.9448055186501667, -1.9997554845691363, -2933.473216936499, -1.70977726905188E13}, {0.3870999950897718, 0.3158854049899468, -0.1742392100561149, -0.5507091382192122, -0.9390541960474138, -1.9804342473533316, -2859.243816791972, -1.620946168627397E13}, {0.3845639624072397, 0.3181187651248739, -0.17077446971579222, -0.5476543426998635, -0.93336735024361, -1.961397674084034, -2787.1061638495166, -1.5369562205936473E13}, {0.38201015893342577, 0.3203280931740301, -0.16731304554600612, -0.5446083150855665, -0.9277438882721571, -1.9426407151346938, -2716.995520919677, -1.4575313829980828E13}, {0.3794387771549367, 0.32251333182665715, -0.16385499919594126, -0.5415708173827284, -0.9221827361972306, -1.9241584237863374, -2648.849329258989, -1.3824120442084309E13}, {0.37685001001279045, 0.32467442479180003, -0.16040039348492377, -0.5385416161050317, -0.9166828387251397, -1.9059459538286738, -2582.6071294842986, -1.3113540041757436E13}, {0.37424405089423207, 0.32681131680474285, -0.15694929238044028, -0.5355204822042645, -0.9112431588248746, -1.8879985572235936, -2518.2104855650286, -1.2441275213735426E13}, {0.37162109362449836, 0.32892395363332805, -0.15350176097640283, -0.5325071910025626, -0.9058626773576077, -1.8703115818292884, -2455.6029117656485, -1.1805164210182566E13}, {0.36898133245853243, 0.3310122820841539, -0.15005786547165814, -0.5295015221260297, -0.9005403927149088, -1.852880469183253, -2394.7298024162365, -1.1203172604809662E13}, {0.3663249620726489, 0.3330762500086534, -0.14661767314873508, -0.5265032594397023, -0.8952753204654514, -1.8357007523424913, -2335.538364394374, -1.0633385480833105E13}, {0.3636521775561523, 0.335115806309056, -0.14318125235282597, -0.5235121909838271, -0.8900664930099906, -1.8187680537793063, -2277.977552206744, -1.0094000117331127E13}, {0.3609631744029059, 0.33713090094423204, -0.1397486724709951, -0.5205281089114172, -0.8849129592443932, -1.8020780833310845, -2221.9980055636543, -9.583319140991006E12}, {0.35825814850285675, 0.33912148493541966, -0.13632000391161353, -0.5175508094270604, -0.8798137842305209, -1.7856266362025752, -2167.5519893444384, -9.099744112507553E12}, {0.35553729613351387, 0.3410875103718372, -0.13289531808401175, -0.5145800927269439, -0.8747680488747558, -1.769409591019155, -2114.593335856014, -8.641769518996073E12}, {0.352800813951382, 0.34302893041617954, -0.12947468737834847, -0.5116157629400708, -0.8697748496139774, -1.753422907929662, -2063.0773892912025, -8.207977145739416E12}, {0.3500488989833527, 0.34494569930999996, -0.12605818514569037, -0.5086576280706367, -0.8648332981087968, -1.7376626267574071, -2012.9609522974442, -7.797030802405653E12}, {0.34728174861805183, 0.34683777237897934, -0.1226458856782984, -0.505705499941542, -0.8599425209438687, -1.7221248651980139, -1964.202234570334, -7.407671380561312E12}, {0.34449956059714604, 0.34870510603808025, -0.11923786419011745, -0.5027591941390072, -0.8551016593350902, -1.7068058170627762, -1916.7608033901786, -7.03871222087647E12}, {0.3417025330066084, 0.35054765779659103, -0.11583419679746473, -0.49981852995827236, -0.8503098688435256, -1.6917017505662777, -1870.5975360232064, -6.68903476987721E12}, {0.3388908642679442, 0.3523653862630559, -0.11243496049991339, -0.49688333035034815, -0.8455663190958735, -1.6768090066570391, -1825.6745739124888, -6.357584507459777E12}, {0.3360647531293766, 0.3541582511500944, -0.1090402331613674, -0.4939534218697962, -0.8408701935113174, -1.6621239973899917, -1781.955278586718, -6.043367127643171E12}, {0.3332243986569963, 0.35592621327911095, -0.10565009349132437, -0.49102863462351554, -0.8362206890346006, -1.6476432043396572, -1739.404189218245, -5.745444956213615E12}, {0.3303700002258722, 0.3576692345848934, -0.10226462102632283, -0.48810880222050923, -0.8316170158751617, -1.6333631770528623, -1697.9869817644224, -5.46293359000632E12}, {0.3275017575111259, 0.3593872781201026, -0.09888389611156953, -0.4851937617226084, -0.827058397252187, -1.619280531539954, -1657.6704296293774, -5.194998743589939E12}, {0.32461987047897245, 0.3610803080596528, -0.09550799988274605, -0.48228335359613256, -0.8225440691454251, -1.6053919488034234, -1618.422365785759, -4.940853290065084E12}, {0.3217245393777233, 0.36274828970498396, -0.09213701424798662, -0.4793774216644607, -0.8180732800516223, -1.5916941734029373, -1580.2116462987256, -4.699754483572E12}, {0.31881596472875906, 0.36439118948822613, -0.08877102187003047, -0.4764758130614969, -0.8136452907464409, -1.578184012055778, -1543.0081151967474, -4.471001351923421E12}, {0.3158943473174667, 0.36600897497625645, -0.08541010614853947, -0.4735783781860039, -0.8092593740517197, -1.5648583322717282, -1506.7825706361843, -4.253932248544354E12}, {0.31295988818414616, 0.36760161487465004, -0.08205435120258209, -0.4706849706567883, -0.8049148146079486, -1.5517140610214744, -1471.5067323088276, -4.047922553613799E12}, {0.31001278861488496, 0.36916907903152363, -0.0787038418532787, -0.46779544726871497, -0.8006109086518246, -1.5387481834376124, -1437.153210043652, -3.852382514967391E12}, {0.3070532501324031, 0.37071133844127474, -0.07535866360660637, -0.4649096679495327, -0.7963469637987675, -1.5259577415473862, -1403.69547355612, -3.6667552199395254E12}, {0.30408147448686795, 0.3722283652482149, -0.07201890263635993, -0.4620274957174916, -0.7921222988302701, -1.5133398330362988, -1371.1078233002852, -3.490514689900549E12}, {0.3010976636466813, 0.3737201327500986, -0.06868464576726677, -0.45914879663973385, -0.787936243485968, -1.5008916100417784, -1339.3653623808034, -3.323164089782737E12}, {0.2981020197892374, 0.3751866154015473, -0.06535598045825272, -0.456273439791439, -0.7837881382603061, -1.48861027797607, -1308.4439694837024, -3.164234045390315E12}, {0.29509474529165486, 0.37662778881737174, -0.06203299478585553, -0.45340129721570777, -0.7796773342037009, -1.4764930943776113, -1278.3202727865341, -3.0132810617571157E12}, {0.2920760427214828, 0.378043629775789, -0.058715777427785915, -0.4505322438841667, -0.7756031927280782, -1.4645373677901006, -1248.971624810051, -2.869886036251464E12}, {0.28904611482738, 0.379434116221537, -0.05540441764663068, -0.4476661576582743, -0.7715650854166838, -1.4527404566685327, -1220.3760781751819, -2.73365286053538E12}, {0.2860051645297715, 0.38079922726888893, -0.05209900527369721, -0.44480291925131793, -0.767562393838068, -1.4410997683115028, -1192.5123622305239, -2.604207105865063E12}, {0.28295339491148, 0.3821389432045629, -0.04879963069299789, -0.4419424121910799, -0.7635945093641341, -1.4296127578190525, -1165.3598605169786, -2.4811947865740664E12}, {0.2798910092083357, 0.38345324549053283, -0.04550638482536945, -0.4390845227831605, -0.7596608329921619, -1.4182769270754259, -1138.8985890375807, -2.3642811969119443E12}, {0.27681821079976254, 0.38474211676673686, -0.04221935911272787, -0.43622914007494157, -0.7557607751707017, -1.407089823756038, -1113.1091753017615, -2.2531498167196133E12}, {0.2737352031993444, 0.3860055408536861, -0.0389386455024551, -0.43337615582017647, -0.7518937556292538, -1.3960490403580563, -1087.9728381146365, -2.1475012817116753E12}, {0.2706421900453706, 0.38724350275497316, -0.03566433643191602, -0.4305254644441916, -0.7480592032116365, -1.3851522132539553, -1063.4713680830387, -2.0470524144051982E12}, {0.2675393750913613, 0.38845598865968145, -0.03239652481310373, -0.42767696300968594, -0.7442565557129602, -1.3743970217674575, -1039.5871088111605, -1.9515353119860542E12}, {0.26442696219657397, 0.38964298594469465, -0.029135304017410574, -0.4248305511831132, -0.7404852597201131, -1.3637811872712662, -1016.3029387597853, -1.8606964876392683E12}, {0.26130515531649295, 0.39080448317690847, -0.025880767860524012, -0.4219861312016362, -0.736744770455686, -1.3533024723060407, -993.6022537441138, -1.77429606208939E12}, {0.2581741584932998, 0.3919404701153433, -0.022633010587444463, -0.4191436078406371, -0.7330345516252426, -1.342958679720042, -971.4689500461751, -1.6921070023021272E12}, {0.2550341758463288, 0.3930509377131595, -0.019392126857624037, -0.4163028883817735, -0.7293540752678679, -1.3327476518289412, -949.8874081188213, -1.6139144044906816E12}, {0.25188541156250627, 0.39413587811957596, -0.016158211730223998, -0.4134638825815664, -0.7257028216099071, -1.3226672695952448, -928.8424768591606, -1.53951481874928E12}, {0.24872806988677384, 0.39519528468168913, -0.012931360649489132, -0.4106265026405067, -0.7220802789218237, -1.3127154518268531, -908.319458430209, -1.4687156128044094E12}, {0.24556235511249958, 0.39622915194619907, -0.00971166943023824, -0.40779066317267315, -0.7184859433781066, -1.3028901543942473, -888.3040936103455, -1.4013343725308916E12}, {0.24238847157187404, 0.3972374756610361, -0.006499234243467794, -0.4049562811758435, -0.7149193189201488, -1.29318936946584, -868.7825476510043, -1.3371983370268865E12}, {0.23920662362629394, 0.39822025277689355, -0.0032941516020678907, -0.40212327600209247, -0.7113799171220301, -1.283611124761012, -849.7413966237607, -1.2761438661789019E12}, {0.236017015656735, 0.3991774814486645, -9.651834664961556E-5, -0.399291569328865, -0.7078672570591393, -1.2741534828204004, -831.1676142387496, -1.21801593877647E12}, {0.23281985205411235, 0.4001091610367835, 0.003093568368519456, -0.3964610851305106, -0.7043808651795642, -1.26481454029299, -813.0485591170487, -1.16266767935625E12}, {0.229615337209631, 0.40101529210847336, 0.006276011089470984, -0.3936317496502722, -0.7009202751781866, -1.2555924272395786, -795.3719625003198, -1.1099599120676677E12}, {0.22640367550512758, 0.40189587643889896, 0.009450712076385898, -0.3908034913727183, -0.6974850278734253, -1.2464853064522237, -778.1259163817039, -1.0597607399576615E12}, {0.22318507130340182, 0.4027509170122249, 0.012617573317338732, -0.38797624099660577, -0.6940746710865525, -1.2374913727892314, -761.2988620425178, -1.0119451481703921E12}, {0.21995972893854093, 0.40358041802258265, 0.015776496541939605, -0.3851499314081672, -0.690688759523541, -1.2286088525253398, -744.8795789799833, -9.66394629650294E11}, {0.21672785270623618, 0.4043843848749419, 0.01892738323487217, -0.38232449765481114, -0.6873268546593673, -1.2198360027166744, -728.8571742117105, -9.229968320230288E11}, {0.21348964685409333, 0.4051628241858912, 0.022070134649331802, -0.3794998769192263, -0.6839885246247266, -1.211171110580138, -713.2210719432795, -8.8164522441001E11}, {0.21024531557193646, 0.4059157437843251, 0.025204651820363494, -0.3766760084938802, -0.680673344095097, -1.2026124928868553, -697.9610035857443, -8.422387830078678E11}, {0.20699506298210724, 0.4066431527120396, 0.02833083557810087, -0.37385283375590433, -0.6773808941821015, -1.1941584953693305, -683.0669981104134, -8.046816943353076E11}, {0.2037390931297597, 0.40734506122423625, 0.03144858656090785, -0.3710302961423565, -0.6741107623271142, -1.1858074921419717, -668.5293727287362, -7.68883075116361E11}, {0.20047760997315134, 0.4080214807899353, 0.034557805228424304, -0.368208341125852, -0.6708625421970627, -1.1775578851346613, -654.3387238856079, -7.347567078314381E11}, {0.19721081737393098, 0.4086724240922972, 0.03765839187451567, -0.3653869161905551, -0.6676358335823692, -1.1694081035390291, -640.4859185548142, -7.022207910259926E11}, {0.19393891908742467, 0.40929790502885377, 0.040750246640129106, -0.3625659708085222, -0.6644302422969908, -1.1613566032671447, -626.9620858258374, -6.71197703521571E11}, {0.19066211875292058, 0.409897938711651, 0.043833269526055985, -0.35974545641639244, -0.6612453800805052, -1.1534018664222923, -613.7586087715582, -6.416137817252156E11}, {0.187380619883952, 0.41047254146729883, 0.046907360405602144, -0.35692532639241054, -0.6580808645021956, -1.145542400781552, -600.8671165868853, -6.133991092816118E11}, {0.18409462585858113, 0.4110217308369351, 0.04997241903716779, -0.35410553603378275, -0.6549363188670927, -1.1377767392898908, -588.279476988648, -5.864873183574171E11}, {0.18080433990968356, 0.41154552557609786, 0.053028345076735706, -0.35128604253435275, -0.6518113721239279, -1.1301034395654836, -575.9877888674946, -5.608154018897019E11}, {0.17750996511523345, 0.4120439456545098, 0.05607503809027098, -0.3484668049625926, -0.6487056587749522, -1.122521083415984, -563.9843751828594, -5.363235361701791E11}, {0.17421170438859163, 0.41251701225577636, 0.05911239756603301, -0.34564778423990195, -0.6456188187875861, -1.1150282763654964, -552.2617760924373, -5.1295491317429663E11}, {0.17090976046879566, 0.41296474777699194, 0.062140322926798, -0.34282894311920636, -0.6425504975078471, -1.107623647191961, -540.8127423078704, -4.9065558207920966E11}, {0.16760433591085405, 0.4133871758282624, 0.0651587135419964, -0.340010246163852, -0.6395003455755303, -1.1003058474747296, -529.6302286687152, -4.69374299447625E11}, {0.16429563307604425, 0.41378432123213804, 0.06816746873976365, -0.3371916597267856, -0.6364680188410877, -1.0930735511520633, -518.7073879270285, -4.490623875853493E11}, {0.1609838541222156, 0.4141562100229607, 0.07116648781890586, -0.33437315193001693, -0.6334531782841809, -1.0859254540883256, -508.0375647351905, -4.2967360060933014E11}, {0.1576692009940982, 0.4145028694461247, 0.07415567006078139, -0.3315546926443558, -0.6304554899338616, -1.0788602736506365, -497.6142898298836, -4.111639977902644E11}, {0.15435187541361722, 0.41482432795725016, 0.07713491474109826, -0.32873625346941726, -0.6274746247903459, -1.0718767482947476, -487.43127440537125, -3.934918237593221E11}, {0.15103207887021516, 0.41512061522127225, 0.08010412114162907, -0.32591780771389023, -0.62451025874835, -1.0649736371599405, -477.48240466952325, -3.766173951926482E11}, {0.14771001261118108, 0.4153917621114442, 0.08306318856184347, -0.32309933037606253, -0.6215620725219477, -1.0581497196727103, -467.76173657622445, -3.6050299360976013E11}, {0.14438587763198824, 0.41563780070825557, 0.0860120163304594, -0.3202807981245977, -0.6186297515709213, -1.0514037951590416, -458.2634907280775, -3.451127639432184E11}, {0.14105987466664088, 0.4158587642982655, 0.08895050381691305, -0.3174621892795564, -0.6157129860285663, -1.0447346824650592, -448.98204744351517, -3.304126185568385E11}, {0.13773220417803075, 0.41605468737285195, 0.09187855044274845, -0.3146434837936594, -0.6128114706309262, -1.0381412195858686, -439.91194198265976, -3.163701464084217E11}, {0.13440306634830357, 0.4162256056268766, 0.09479605569292801, -0.3118246632337841, -0.6099249046474171, -1.0316222633023768, -431.0478599264702, -3.029545270705897E11}, {0.13107266106923715, 0.4163715559572676, 0.09770291912706369, -0.3090057107626921, -0.60705299181282, -1.025176688825923, -422.3846327039253, -2.901364493398307E11}, {0.12774118793263028, 0.4164925764615163, 0.10059904039056938, -0.30618661112097967, -0.6041954402606016, -1.0188033894505149, -413.9172332621705, -2.778880341794263E11}, {0.12440884622070512, 0.41658870643609386, 0.10348431922573569, -0.3033673506092496, -0.6013519624575456, -1.0125012762125132, -405.64077187475704, -2.6618276175654318E11}, {0.12107583489652142, 0.4166599863747838, 0.10635865548272734, -0.30054791707049633, -0.5985222751396536, -1.0062692775575681, -397.55049208325516, -2.5499540234751804E11}, {0.11774235259440538, 0.41670645796693323, 0.10922194913050379, -0.29772829987270255, -0.5957060992492988, -1.0001063390146587, -389.6417667677259, -2.4430195089831778E11}, {0.11440859761039233, 0.4167281640956218, 0.11207410026766297, -0.2949084898916403, -0.5929031598735982, -0.9940114228770514, -381.91009434166114, -2.34079565039297E11}, {0.11107476789268407, 0.41672514883574824, 0.11491500913320978, -0.2920884794938721, -0.5901131861839779, -0.9879835078900281, -374.35109506720136, -2.2430650636485538E11}, {0.10774106103212279, 0.4166974574520391, 0.11774457611724902, -0.2892682625199514, -0.5873359113769104, -0.9820215889452226, -366.9605074865494, -2.1496208479933047E11}, {0.10440767425268047, 0.41664513639697287, 0.12056270177160291, -0.28644783426781206, -0.5845710726157909, -0.9761246767814122, -359.7341849656835, -2.0602660588064197E11}, {0.10107480440196519, 0.4165682333086255, 0.12336928682035457, -0.2836271914763469, -0.5818184109739325, -0.970291797691611, -352.6680923465803, -1.9748132080270618E11}, {0.09774264794174566, 0.4164667970084376, 0.12616423217031753, -0.2808063323091714, -0.5790776713786585, -0.9645219932363307, -345.75830270431845, -1.8930837906664804E11}, {0.0944114009384932, 0.41634087749889837, 0.1289474389214308, -0.2779852563385649, -0.5763486025564601, -0.9588143199628516, -339.0009942055459, -1.814907835992849E11}, {0.09108125905394304, 0.4161905259611541, 0.1317188083770816, -0.27516396452958924, -0.5736309569792055, -0.9531678491303796, -332.39244706493145, -1.740123482053207E11}, {0.08775241753567475, 0.41601579475253503, 0.13447824205435463, -0.2723424592243784, -0.5709244908113713, -0.9475816664409449, -325.9290405963313, -1.6685765722718478E11}, {0.08442507120771299, 0.41581673740400465, 0.13722564169420848, -0.2695207441265969, -0.568228963858276, -0.9420548717759106, -319.60725035551934, -1.6001202729351486E11}, {0.08109941446114899, 0.41559340861753186, 0.13996090927158072, -0.266698824286063, -0.5655441395152982, -0.9365865789379757, -313.42364537145454, -1.534614710439457E11}, {0.07777564124478321, 0.4153458642633842, 0.1426839470054207, -0.2638767060835321, -0.5628697847180515, -0.9311759153985306, -307.3748854631408, -1.4719266272411316E11}, {0.07445394505578992, 0.41507416137734304, 0.1453946573686502, -0.26105439721563733, -0.5602056698934976, -0.9258220220502473, -301.4577186392569, -1.4119290555070465E11}, {0.0711345189304047, 0.41477835815784436, 0.14809294309805426, -0.25823190667998575, -0.5575515689119852, -0.9205240529648032, -295.66897857783727, -1.3545010075195412E11}, {0.06781755543463473, 0.41445851396303984, 0.15077870720409936, -0.2554092447604034, -0.5549072590401807, -0.9152811751555897, -290.0055821833506, -1.2995271819420358E11}, {0.06450324665499314, 0.41411468930778417, 0.1534518529806827, -0.2525864230123287, -0.552272520894886, -0.910092568345326, -284.4645272186595, -1.2468976851012956E11}, {0.061191784189257706, 0.4137469458605449, 0.15611228401480998, -0.24976345424834956, -0.5496471383977136, -0.9049574247384435, -279.04289000939076, -1.1965077664886214E11}, {0.05788335913725457, 0.4133553464402381, 0.1587599041962035, -0.24694035252388222, -0.5470308987306094, -0.8998749487981499, -273.737823218361, -1.1482575677263806E11}, {0.05457816209166746, 0.41293995501298697, 0.16139461772684036, -0.2441171331229866, -0.544423592292196, -0.8948443570280509, -268.54655368776434, -1.1020518842876418E11}, {0.05127638312887331, 0.41250083668880805, 0.16401632913042105, -0.24129381254431845, -0.541825012654928, -0.889864877758245, -263.4663803469252, -1.0577999392957845E11}, {0.04797821179980485, 0.4120380577182213, 0.16662494326176874, -0.23847040848721215, -0.5392349565230377, -0.884935750935783, -258.49467218348616, -1.0154151687678317E11}, {0.044683837120839606, 0.4115516854887881, 0.16922036531616047, -0.23564693983789364, -0.5366532236912546, -0.8800562279193923, -253.62886627596836, -9.748150176998946E10}, {0.041393447564718765, 0.4110417885215725, 0.1718025008385865, -0.23282342665581887, -0.5340796170042799, -0.8752255712783719, -248.86646588572881, -9.35920746426117E10}, {0.038107231051492746, 0.41050843646753293, 0.1743712557329446, -0.22999989016013686, -0.5315139423170081, -0.8704430545955736, -244.2050386063947, -8.986572467132529E10}, {0.03482537493949708, 0.4099517001038394, 0.17692653627116378, -0.2271763527162735, -0.528956008455472, -0.8657079622743711, -239.64221456892406, -8.629528670823581E10}, {0.03154806601635749, 0.4093716513301173, 0.17946824910225972, -0.22435283782263304, -0.5264056271784965, -0.8610195893495248, -235.17568470050452, -8.287392468765259E10}, {0.02827549049002568, 0.408768363164621, 0.18199630126132257, -0.22152937009741672, -0.5238626131400521, -0.8563772413018674, -230.80319903556804, -7.95951158619716E10}, {0.025007833979845722, 0.40814190974033543, 0.1845106001784374, -0.2187059752655537, -0.5213267838522881, -0.8517802338767219, -226.52256507725284, -7.645263582361917E10}, {0.021745281507652134, 0.40749236630100566, 0.18701105368753518, -0.21588268014574422, -0.5187979596492323, -0.8472278929059612, -222.3316462076963, -7.344054427232718E10}, {0.01848801748889985, 0.4068198091970957, 0.1894975700351777, -0.2130595126376093, -0.5162759636511429, -0.8427195541336441, -218.22836014561486, -7.055317148920967E10}, {0.015236225723826916, 0.40612431588167847, 0.19197005788927435, -0.21023650170894953, -0.5137606217295032, -0.8382545630451386, -214.21067744965615, -6.778510548116018E10}, {0.011990089388650276, 0.40540596490625386, 0.1944284263477315, -0.2074136773831057, -0.5112517624726384, -0.8338322746996609, -210.27662006607875, -6.513117976105915E10}, {0.008749791026795283, 0.40466483591649755, 0.19687258494703477, -0.20459107072642155, -0.5087492171519457, -0.8294520535661509, -206.4242599193524, -6.258646173111217E10}, {0.005515512540159591, 0.403901009647942, 0.19930244367076436, -0.20176871383580777, -0.5062528196887275, -0.8251132733624225, -202.65171754432532, -6.014624163838722E10}, {0.0022874351804117606, 0.4031145679215871, 0.20171791295804326, -0.19894663982640165, -0.5037624066216085, -0.8208153168975023, -198.9571607586455, -5.78060220732655E10}, {-9.342604596746813E-4, 0.40230559363944235, 0.2041189037119183, -0.19612488281932286, -0.5012778170745287, -0.8165575759170988, -195.33880337417216, -5.5561507983071686E10}, {-0.004149394454851257, 0.4014741707800029, 0.20650532730767532, -0.19330347792952376, -0.498798892725302, -0.8123394509521336, -191.7949039461518, -5.340859717462244E10}, {-0.007357787555988118, 0.4006203843936562, 0.2088770956010868, -0.19048246125372986, -0.4963254777747234, -0.8081603511702609, -188.32376455897585, -5.1343371280820175E10}, {-0.010559261198630543, 0.39974432059802134, 0.21123412093659308, -0.18766186985847005, -0.4938574189162167, -0.8040196942303186, -184.92372964737618, -4.936208716772975E10}, {-0.013753637511518008, 0.3988460665732231, 0.21357631615541733, -0.1848417417681957, -0.49139456530601205, -0.7999169061396441, -181.5931848519521, -4.7461168759819244E10}, {-0.01694073932506501, 0.3979257105571001, 0.21590359460361505, -0.18202211595348503, -0.4889367685338426, -0.7958514211142002, -178.33055590796437, -4.5637199262220146E10}};
        boolean success = true;
        int i = 0;
        while (i < nus.length) {
            int j = 0;
            while (j < x.length) {
                double val = Bessel.k(x[j], nus[i], false);
                boolean cur_success = DebugFun.isEqual(besselK[j][i], val);
                success &= cur_success;
                if (!cur_success) {
                    System.err.println(String.format("Error: BesselK(%g, %f, FALSE) = %3.18g != %3.18g", x[j], nus[i], val, besselK[j][i]));
                }
                val = Bessel.y(x[j], nus[i]);
                cur_success = DebugFun.isEqualScaled(besselY[j][i], val);
                success &= cur_success;
                if (!cur_success) {
                    System.err.println(String.format("Error: BesselY(%g, %f, FALSE) = %3.18g != %3.18g", x[j], nus[i], val, besselY[j][i]));
                }
                ++j;
            }
            ++i;
        }
        return success;
    }

    @Test
    public static final boolean test_polygamma() {
        boolean success = true;
        double[] x = Utilities.seq(0.1, 4.0, 0.0195);
        double[] gamma = new double[]{9.51350769866873, 7.897715002366499, 6.739289515431184, 5.869275136483423, 5.192762747496919, 4.6523346496127775, 4.211218745784504, 3.8447766478567207, 3.5358820282110166, 3.272261740200624, 3.0448915074121605, 2.8469884724736456, 2.673356676835951, 2.519949189211996, 2.383567598008629, 2.2616510951364974, 2.152125467396248, 2.0532930433389667, 1.9637511991008605, 1.882331137013609, 1.8080512889238929, 1.7400814255604016, 1.6777147089402387, 1.6203457106871013, 1.567452962188477, 1.5185849833463965, 1.4733490073924358, 1.4314018141155804, 1.3924422257839248, 1.3562049245420187, 1.3224553277909663, 1.2909853164195728, 1.2616096549676203, 1.2341629765776045, 1.20849723159668, 1.184479518862474, 1.1619902344633415, 1.1409214851536165, 1.1211757234082105, 1.1026645689046648, 1.0853077874677195, 1.0690324035391523, 1.0537719263028336, 1.039465672901249, 1.026058174880051, 1.013498656212452, 1.001740573080357, 0.9907412070989087, 0.9804613049249683, 0.9708647582352727, 0.9619183189344449, 0.9535913451871438, 0.9458555744869904, 0.9386849204974153, 0.9320552908424797, 0.9259444234022478, 0.9203317389883179, 0.9151982085495871, 0.9105262332936073, 0.9062995363111094, 0.9025030644655062, 0.8991228994596712, 0.8961461771225697, 0.8935610140713578, 0.8913564410028691, 0.8895223419540723, 0.8880493989458894, 0.8869290414902247, 0.8861534004974444, 0.8857152661719563, 0.8856080495279048, 0.8858257471961063, 0.8863629092278952, 0.8872146096321083, 0.8883764194085191, 0.8898443818650695, 0.891614990027621, 0.8936851659699765, 0.8960522419088969, 0.8987139429239984, 0.9016683711759734, 0.9049139915087335, 0.9084496183319659, 0.9122744036903931, 0.9163878264348345, 0.9207896824181085, 0.9254800756459777, 0.9304594103198146, 0.9357283837135206, 0.9412879798325408, 0.9471394638076356, 0.9532843769804469, 0.9597245326418795, 0.9664620123879583, 0.9734991630611288, 0.9808385942480091, 0.988483176307375, 0.9964360389047113, 1.0047005700320009, 1.0132804154935846, 1.0221794788409142, 1.0314019217408528, 1.0409521647638895, 1.0508348885802161, 1.0610550355530712, 1.0716178117201494, 1.0825286891551371, 1.093793408702647, 1.1054179830809547, 1.117408700347996, 1.1297721277270947, 1.1425151157898488, 1.1556448029944943, 1.169168620578948, 1.1830942978085432, 1.1974298675792792, 1.2121836723781567, 1.2273643706029278, 1.2429809432442935, 1.259042700934284, 1.2755592913652516, 1.2925407070845538, 1.3099972936706825, 1.3279397582972379, 1.3463791786917858, 1.3653270124972803, 1.3847951070443747, 1.4047957095435706, 1.4253414777067985, 1.4464454908086701, 1.4681212611982715, 1.4903827462730341, 1.5132443609268769, 1.5367209904854706, 1.5608280041421658, 1.5855812689088205, 1.6109971640964535, 1.6370925963413818, 1.6638850151932385, 1.6913924292820095, 1.7196334230820092, 1.7486271742915138, 1.778393471847574, 1.8089527345963685, 1.8403260306403493, 1.8725350973842716, 1.905602362303162, 1.9395509644562092, 1.974404776771529, 2.01018842912777, 2.0469273322595942, 2.0846477025150896, 2.1233765874943478, 2.1631418925995534, 2.203972408528143, 2.2458978397418172, 2.2889488339454958, 2.333157012611597, 2.3785550025864293, 2.425176468816897, 2.4730561482371987, 2.5222298848567286, 2.5727346660920096, 2.6246086603870853, 2.6778912561685564, 2.7326231021832204, 2.788846149268075, 2.8466036936044166, 2.9059404215097278, 2.9669024558230923, 3.0295374039420504, 3.0938944075710366, 3.160024194243805, 3.2279791306847043, 3.2978132780761378, 3.3695824493021123, 3.443344268240509, 3.5191582311794876, 3.5970857704363333, 3.6771903202600855, 3.759537385102438, 3.8441946103446414, 3.9312318555715144, 4.020721270487266, 4.112737373571394, 4.207357133576795, 4.304660053976189, 4.404728260467026, 4.507646591649346, 4.613502692995543, 4.722387114235553, 4.834393410285808, 4.949618245855378, 5.068161503867769, 5.190126397842409, 5.315619588385413, 5.444751303945013, 5.57763546599326, 5.714389818801799, 5.8551360639861745, 6.0};
        double[] lgamma = new double[]{2.252712651734206, 2.066573477428187, 1.9079545062270862, 1.7697311400962992, 1.64726587683543, 1.5373691687872342, 1.4377520941104927, 1.3467155122864292, 1.2629627811563424, 1.1854814094900012, 1.1134652707774049, 1.0462617592795, 0.9833348651557127, 0.924238738308943, 0.8685983560781324, 0.8160951196148432, 0.7664559432934259, 0.7194448669343064, 0.6748565212053868, 0.6325109752149015, 0.5922496293352671, 0.5539319084306064, 0.5174325750802403, 0.48263952813610217, 0.44945198490146404, 0.41777896926291885, 0.3875380458665619, 0.3586542536930677, 0.3310592023958753, 0.30469030239360223, 0.2794901055718424, 0.25540573799623906, 0.23238840959208473, 0.21039298854336513, 0.1893776303823432, 0.16930345351109116, 0.15013425431810684, 0.13183625620167264, 0.11437788774462201, 0.09772958604714659, 0.08186362184970922, 0.06675394359394093, 0.05237603799676735, 0.038706805068647994, 0.02572444580397373, 0.013408361020979427, 0.0017390600384851994, -0.009301921945768826, -0.01973209875990773, -0.029568101302449613, -0.03882573947383293, -0.0475200586485388, -0.05566539126094577, -0.06327540400875138, -0.07036314111791744, -0.07694106406124378, -0.08302108807764005, -0.08861461579996704, -0.09373256826510794, -0.09838541355001106, -0.10258319325121909, -0.10633554700235483, -0.10965173520374881, -0.11254066012050426, -0.11501088548946925, -0.11707065476158642, -0.11872790809365795, -0.11999029819252091, -0.12086520510478806, -0.12135975003654238, -0.12148080827953177, -0.12123502131340298, -0.12062880814722333, -0.11966837595790458, -0.11835973007806627, -0.11670868338131667, -0.11472086510881213, -0.112401729177241, -0.10975656200502412, -0.10679048989048043, -0.10350848597295986, -0.0999153768054377, -0.09601584856480566, -0.09181445292402213, -0.08731561260840957, -0.0825236266566712, -0.07744267540563855, -0.07207682521632787, -0.06643003295758444, -0.06050615026239199, -0.0543089275708305, -0.04784201797266262, -0.041108980861604895, -0.03411328541248884, -0.026858313891742914, -0.01934736481090403, -0.011583655932205261, -0.003570327134678309, 0.00468955685135415, 0.013193003834044289, 0.021937091667171615, 0.030918965868251134, 0.04013583734158471, 0.04958498020062667, 0.05926372968437677, 0.06916948016286052, 0.07929968322704738, 0.08965184585884692, 0.10022352867709285, 0.11101234425565938, 0.12201595551008966, 0.13323207414933458, 0.14465845918938527, 0.15629291552578364, 0.1681332925621574, 0.18017748289209565, 0.19242342103182536, 0.20486908220129896, 0.21751248115143007, 0.23035167103533655, 0.24338474232157975, 0.25660982174747665, 0.2700250713106839, 0.2836286872973389, 0.29741889934513455, 0.31139396953978715, 0.32555219154344595, 0.3398918897536545, 0.35441141849155305, 0.36910916121808013, 0.38398352977698197, 0.39903296366351043, 0.41425592931774147, 0.4296509194414927, 0.4452164523378749, 0.460951071272561, 0.476853343855891, 0.4929218614449786, 0.5091552385650309, 0.5255521123491148, 0.5421111419956528, 0.5588310082429583, 0.5757104128601531, 0.592748078153835, 0.6099427464899073, 0.6272931798299852, 0.6447981592818383, 0.6624564846633509, 0.6802669740794941, 0.6982284635118297, 0.7163398064201025, 0.7345998733554664, 0.7530075515849377, 0.7715617447266713, 0.7902613723956751, 0.8091053698595931, 0.8280926877042127, 0.8472222915083465, 0.866493161527775, 0.8859042923879346, 0.9054546927850533, 0.925143385195446, 0.944969405592703, 0.9649318031724965, 0.9850296400847579, 1.0052619911729876, 1.025627943720452, 1.0461265972030496, 1.066757063048636, 1.087518464402587, 1.1084099358994068, 1.1294306234401956, 1.150579683975778, 1.171856285295324, 1.19325960582029, 1.2147888344035085, 1.2364431701332768, 1.2582218221422832, 1.28012400942123, 1.3021489606370027, 1.3242959139552575, 1.3465641168672902, 1.3689528260210535, 1.3914613070562138, 1.4140888344431144, 1.4368346913255363, 1.4596981693671498, 1.482678568601543, 1.5057751972857272, 1.5289873717570235, 1.5523144162932272, 1.575755662975959, 1.5993104515571221, 1.622978129328362, 1.6467580509934583, 1.6706495785435655, 1.6946520811352164, 1.7187649349710215, 1.7429875231829868, 1.7673192357183753, 1.791759469228055};
        double[] digamma = new double[]{-10.423754940411076, -8.764354868731754, -7.563473353711941, -6.652097050685903, -5.935263268216394, -5.355504106176275, -4.876000369141071, -4.472069429556017, -4.126543358061088, -3.827109842781753, -3.5647076955001453, -3.3325192335540788, -3.1253156072378334, -2.9390187889261132, -2.770400937959108, -2.6168733675221, -2.4763354286930603, -2.347064358642785, -2.227633695672177, -2.116851974159063, -2.013716050695126, -1.9173751421656826, -1.8271028122382096, -1.7422749286588393, -1.6623521568578332, -1.5868659362340942, -1.5154071562421199, -1.447616944315894, -1.3831791196262366, -1.3218139711954802, -1.2632730966424068, -1.207335096212884, -1.153801960983576, -1.1024960279185807, -1.0532574004797608, -1.005941753677447, -0.9604184582177053, -0.9165689708037617, -0.8742854474632824, -0.8334695445863138, -0.7940313786141076, -0.7558886203544257, -0.7189657039731174, -0.6831931340243913, -0.6485068765883049, -0.6148478228045096, -0.582161314921172, -0.5503967264921439, -0.5195070896133056, -0.48944876313788965, -0.46018113668836014, -0.4316663660195834, -0.40386913590923346, -0.3767564472763736, -0.35029742567449995, -0.32446314868396975, -0.29922649005177826, -0.27456197870294696, -0.2504456709847185, -0.22685503470856405, -0.20376884373062332, -0.18116708196300468, -0.15903085583987808, -0.13734231437640476, -0.1160845760579079, -0.0952416618832701, -0.07479843396223806, -0.05474053913255217, -0.035054357120965385, -0.015726952823293505, 0.003253967676374536, 0.02190009768748391, 0.04022256740094177, 0.05823197855724782, 0.07593843654134247, 0.09335158012628142, 0.11048060906606594, 0.1273343097186066, 0.1439210788625136, 0.16024894585593685, 0.17632559327189457, 0.19215837613213482, 0.20775433985044778, 0.22312023698639116, 0.23826254290140136, 0.2531874704011763, 0.26790098344092295, 0.2824088099634767, 0.29671645393436163, 0.31082920663244273, 0.3247521572499781, 0.3384902028514274, 0.3520480577363576, 0.3654302622481451, 0.37864119106682903, 0.39168506102147216, 0.4045659384545872, 0.4172877461687101, 0.42985426998285803, 0.4422691649245474, 0.4545359610810822, 0.4666580691320974, 0.4786387855836942, 0.4904812977230377, 0.5021886883109208, 0.513763940028549, 0.5252099396936432, 0.5365294822598998, 0.5477252746128789, 0.5587999391744758, 0.5697560173273097, 0.5805959726696, 0.5913221941103832, 0.6019369988142635, 0.6124426350043106, 0.6228412846311118, 0.6331350659155108, 0.6433260357720538, 0.6534161921197228, 0.6634074760861239, 0.6733017741109135, 0.6831009199538765, 0.6928066966127415, 0.7024208381555215, 0.7119450314718467, 0.7213809179475197, 0.7307300950662561, 0.7399941179423277, 0.7491745007876378, 0.7582727183165214, 0.7672902070913867, 0.7762283668121412, 0.7850885615521617, 0.7938721209434316, 0.8025803413132973, 0.8112144867751869, 0.8197757902754845, 0.8282654545986321, 0.8366846533324444, 0.8450345317954719, 0.8533162079281948, 0.8615307731496997, 0.8696792931814186, 0.8777628088394323, 0.8857823367967499, 0.8937388703169074, 0.9016333799601637, 0.9094668142635005, 0.917240100395575, 0.9249541447877152, 0.9326098337419997, 0.9402080340173895, 0.9477495933948705, 0.9552353412224766, 0.9626660889410479, 0.9700426305915353, 0.9773657433046026, 0.9846361877732737, 0.9918547087093035, 0.9990220352839505, 1.0061388815537715, 1.0132059468720425, 1.020223916286388, 1.027193460923151, 1.0341152383590435, 1.0409898929805657, 1.0478180563316695, 1.0546003474501302, 1.0613373731930524, 1.0680297285519327, 1.074677996957666, 1.0812827505758897, 1.0878445505930152, 1.094363947493303, 1.1008414813273109, 1.1072776819720316, 1.1136730693830315, 1.1200281538388712, 1.1263434361780995, 1.1326194080290806, 1.1388565520329128, 1.14505534205969, 1.151216243418334, 1.1573397130602268, 1.1634261997768696, 1.1694761443917565, 1.175489979946686, 1.1814681318826838, 1.1874110182157334, 1.193319049707484, 1.1991926300311118, 1.2050321559324926, 1.210838017386847, 1.2166105977510087, 1.2223502739114562, 1.2280574164282594, 1.233732389675057, 1.2393755519752125, 1.2449872557342667, 1.2505678475687931, 1.2561176684318007};
        double[] trigamma = new double[]{101.43329915079275, 71.4246251093381, 53.121141892819786, 41.136988866938744, 32.86236933154672, 26.907999623692824, 22.479093442498232, 19.09428362635923, 16.448201556205902, 14.33954091409155, 12.631226781506587, 11.227300303291974, 10.058957241535953, 9.075820235119423, 8.240316929079473, 7.523962135629175, 6.904841157753182, 6.3658703843150315, 5.893572423887532, 5.477198892384619, 5.1080924838814035, 4.779216529228313, 4.484803603602134, 4.2200899533102, 3.981112594539208, 3.7645527311627873, 3.567613787309649, 3.387925575747617, 3.22346839030784, 3.072512423628508, 2.9335690722009664, 2.8053515347796196, 2.686742730152292, 2.576769019836869, 2.4745785649535343, 2.3794234056725765, 2.2906445485773244, 2.207659498052769, 2.1299517840458164, 2.0570621287499895, 1.9885809652168538, 1.9241420762467178, 1.8634171656474403, 1.80611120869822, 1.7519584564060655, 1.7007189904157847, 1.652175743396191, 1.6061319142764394, 1.5624087195461718, 1.5208434315071528, 1.481287662300332, 1.4436058590681395, 1.4076739810144903, 1.3733783336068603, 1.3406145388957613, 1.30928662404304, 1.2793062127614299, 1.250591806562253, 1.2230681445581766, 1.1966656321319404, 1.1713198301079988, 1.1469709971912345, 1.1235636793976942, 1.1010463410232298, 1.0793710323991785, 1.058493090288008, 1.0383708672915013, 1.0189654870922586, 1.0002406227367526, 0.982162295503779, 0.964698692193474, 0.9478199989254658, 0.9314982497555241, 0.9157071886128714, 0.9004221432289539, 0.8856199098762298, 0.8712786478652563, 0.8573777828624003, 0.8438979181909524, 0.8308207533670435, 0.8181290092000547, 0.8058063588564994, 0.793837364347763, 0.7822074179565821, 0.770902688165583, 0.7599100696943152, 0.7492171372896392, 0.7388121029486201, 0.7286837762837217, 0.7188215277675203, 0.7092152546187112, 0.6998553491132242, 0.6907326691240431, 0.681838510711118, 0.6731645825987675, 0.6647029823924007, 0.6564461743994003, 0.6483869689307697, 0.6405185029707652, 0.6328342221113565, 0.6253278636570695, 0.6179934408136599, 0.6108252278812429, 0.6038177463790095, 0.5969657520345903, 0.5902642225765158, 0.5837083462731314, 0.5772935111658113, 0.5710152949483915, 0.5648694554484861, 0.5588519216697564, 0.5529587853573288, 0.5471862930514112, 0.5415308385967861, 0.5359889560782494, 0.5305573131542808, 0.5252327047632483, 0.5200120471783133, 0.5148923723889183, 0.509870822788312, 0.5049446461480149, 0.5001111908614783, 0.49536790144040954, 0.49071231424838724, 0.4861420534574354, 0.4816548272142024, 0.47724842400328615, 0.4729207091960844, 0.46866962177431326, 0.46449317121805744, 0.4603894345488728, 0.4563565535190809, 0.4523927319389581, 0.44849623313405995, 0.44466537752540586, 0.4408985403257105, 0.43719414934527345, 0.4335506829015333, 0.42996666782666126, 0.4264406775679153, 0.4229713303757931, 0.4195572875753217, 0.4161972519161028, 0.41288996599698935, 0.4096342107615152, 0.4064288040604236, 0.4032725992778585, 0.4001644840179732, 0.39710337884890423, 0.3940882361012287, 0.39111803871818634, 0.3881917991551037, 0.385308558325595, 0.3824673845922564, 0.3796673727996895, 0.37690764334781324, 0.3741873413035319, 0.37150563554893085, 0.3688617179642749, 0.36625480264416754, 0.36368412514532533, 0.361148941764499, 0.3586485288451469, 0.35618218211154723, 0.3537492160290941, 0.35134896318959397, 0.3489807737204373, 0.3466440147165748, 0.3443380696942872, 0.342062338065782, 0.3398162346337057, 0.337599189104698, 0.3354106456211635, 0.33325006231047466, 0.3311169108508556, 0.32901067605323825, 0.32693085545841144, 0.3248769589488186, 0.3228485083743893, 0.32084503719182067, 0.3188660901167506, 0.3169112227882899, 0.3149800014454105, 0.31307200261470153, 0.311186812809037, 0.30932402823671257, 0.3074832545206317, 0.3056641064271427, 0.30386620760414185, 0.30208919032807663, 0.30033269525950324, 0.2985963712068609, 0.2968798748981465, 0.2951828707601828, 0.29350503070519113, 0.29184603392438635, 0.2902055666883297, 0.2885833221537836, 0.2869790001768218, 0.2853923071319655, 0.28382295573711525};
        double[] tetragamma = new double[]{-2001.8614573783439, -1173.7727459269643, -746.4039459119567, -503.8977500392811, -356.17749546350376, -261.1005316183187, -197.15133832059558, -152.5607731412437, -120.52048621900704, -96.90507298014617, -79.11530644440364, -65.4580075651354, -54.79795957507979, -46.35464047252458, -39.57936796361909, -34.07876780914357, -29.565806201221505, -25.82770191875781, -22.70444433718682, -20.07413098963969, -17.842782642227753, -15.937154507119928, -14.299587371152485, -12.88426983414041, -11.654491050886971, -10.580598183741246, -9.638461537273814, -8.808309702609398, -8.073837303188471, -7.421515614144416, -6.840055595406931, -6.31998644788829, -5.853322463006178, -5.433297884951485, -5.054154552148343, -4.710970783416281, -4.399522708840889, -4.116171283302197, -3.857769751167999, -3.621587488581957, -3.405247031886275, -3.206671777163855, -3.0240423578878026, -2.8557601129106334, -2.700416373433126, -2.5567665459932654, -2.423708164549376, -2.3002622402152917, -2.185557361120924, -2.0788160940842966, -1.979343319567851, -1.8865161958295988, -1.7997755004345406, -1.7186181398340845, -1.642590652487892, -1.5712835595187058, -1.504326440362735, -1.4413836302640184, -1.3821504525250115, -1.3263499117789355, -1.2737297856837115, -1.2240600617489528, -1.177130673817232, -1.1327494992892033, -1.0907405837214026, -1.05094256410911, -1.0132072661367872, -0.9773984540522935, -0.9433907146947638, -0.9110684596595007, -0.8803250316826986, -0.8510619031292563, -0.8231879560142539, -0.7966188343212254, -0.7712763605302615, -0.7470880092632068, -0.7239864318145341, -0.7019090260839973, -0.6807975470771332, -0.6605977537058171, -0.6412590881150575, -0.6227343841939421, -0.6049796023066137, -0.5879535876105725, -0.5716178496206515, -0.5559363609330272, -0.540875373249141, -0.5264032490383457, -0.5124903073538566, -0.4991086824720684, -0.486232194163045, -0.473836228522179, -0.4618976284015554, -0.4503945925760718, -0.43930658286533214, -0.42861423850896485, -0.4182992971614246, -0.40834452193347825, -0.3987336339622827, -0.3894512500409544, -0.3804828248824811, -0.3718145976322691, -0.3634335422790699, -0.35532732164592307, -0.3474842446714735, -0.33989322671790745, -0.33254375266511865, -0.3254258425718103, -0.3185300197033196, -0.3118472807432129, -0.305369068021334, -0.29908724360516425, -0.29299406511421594, -0.2870821631288587, -0.2813445200755965, -0.27577445048047355, -0.2703655824910771, -0.2651118405756197, -0.26000742931489057, -0.2550468182095338, -0.2502247274312001, -0.24553611445168885, -0.24097616148928763, -0.23654026371617615, -0.23222401817503618, -0.22802321335691916, -0.22393381939601506, -0.21995197884026474, -0.21607399795978355, -0.21229633855784702, -0.2086156102517533, -0.20502856319322937, -0.20153208120022048, -0.19812317527390294, -0.1947989774766043, -0.19155673514801516, -0.18839380543865225, -0.18530765014098083, -0.18229583079994605, -0.17935600408590832, -0.17648591741412056, -0.1736834047959528, -0.17094638290805347, -0.1682728473665509, -0.165660869194243, -0.16310859146951318, -0.1606142261464377, -0.15817605103622706, -0.15579240694077673, -0.15346169492968628, -0.15118237375265042, -0.14895295737963637, -0.14677201266172948, -0.1446381571059726, -0.14255005675793442, -0.14050642418612308, -0.13850601656271994, -0.1365476338354401, -0.13463011698563948, -0.13275234636807542, -0.13091324012800348, -0.1291117526915439, -0.12734687332548972, -0.12561762476295218, -0.12392306189144472, -0.12226227050020387, -0.12063436608372705, -0.11903849269867861, -0.11747382187147612, -0.11593955155401889, -0.11443490512516366, -0.11295913043568252, -0.11151149889456521, -0.11009130459464359, -0.10869786347562585, -0.10733051252273337, -0.10598860899922749, -0.10467152971120752, -0.10337867030314657, -0.1021094445827121, -0.10086328387349601, -0.09963963639434933, -0.09843796666408658, -0.09725775493038592, -0.09609849662177464, -0.09495970182164415, -0.09384089476329291, -0.0927416133450476, -0.09166140866455855, -0.09059984457141257, -0.08955649723724828, -0.08853095474259898, -0.08752281667972729, -0.08653169377075068, -0.08555720750039286, -0.084598989762726, -0.08365668252130178, -0.0827299374820964, -0.08181841577872283, -0.08092178766939045, -0.08003973224511449};
        double[] pentagamma = new double[]{60004.512876790264, 29426.725176146512, 16076.772251783304, 9510.503246423508, 5980.314709734617, 3946.77978501686, 2708.9807661299337, 1920.8013783782114, 1399.7163333613883, 1044.09207426569, 794.6876877384881, 615.5971682121352, 484.3110993475488, 386.29668390349923, 311.9246169332274, 254.66608615589146, 210.0024957888753, 174.74817021249072, 146.61931150512575, 123.95362643573375, 105.52431187146115, 90.4143966732408, 77.93044335654866, 67.54237529183769, 58.84092960577553, 51.50718131867889, 45.29045045693138, 39.99210648444664, 35.45357162819403, 31.54734757624187, 28.17024211769496, 25.238212408091847, 22.682407259179655, 20.446106509515207, 18.48233710861149, 16.752003659904545, 15.222412955842753, 13.8661023555754, 12.659904036525326, 11.58419350913504, 10.622282939618083, 9.759928923607799, 8.984931210132808, 8.286804076551187, 7.656506025313668, 7.086216522183692, 6.569150850103819, 6.099405981304879, 5.671831797545025, 5.281923108155311, 4.9257287983578015, 4.599775139509226, 4.301000849169558, 4.026701933327708, 3.7744846996839057, 3.542225618103856, 3.328036936603632, 3.1302371497157075, 2.9473255696173544, 2.777960375890782, 2.620939622695819, 2.475184766806306, 2.339726349842502, 2.213691525882231, 2.0962931736656207, 1.9868203726021911, 1.8846300551822082, 1.789139676351002, 1.6998207638714176, 1.6161932334467821, 1.5378203690352295, 1.464304382872575, 1.3952824816600522, 1.3304233755153374, 1.2694241749198667, 1.212007628262241, 1.1579196588759302, 1.1069271658652968, 1.0588160576457384, 1.0133894911073682, 0.9704662927442471, 0.9298795410544087, 0.8914752920785844, 0.8551114321656209, 0.8206566439792014, 0.787989473435207, 0.75699748671722, 0.7275765077892395, 0.6996299279353495, 0.6730680798276125, 0.6478076694745827, 0.6237712601495586, 0.600886803053765, 0.5790872100468444, 0.5583099642855901, 0.538496765060463, 0.5195932035157278, 0.5015484662895595, 0.48431506442088385, 0.46784858514495165, 0.45210746444399524, 0.43705277843649426, 0.42264805188183074, 0.4088590822492689, 0.395653777953753, 0.3830020094980836, 0.3708754723835793, 0.3592475607609479, 0.3480932508912842, 0.33738899357515406, 0.3271126147867256, 0.3172432238208863, 0.3077611283251188, 0.2986477556453435, 0.2898855799666955, 0.28145805477687325, 0.2733495502218136, 0.26554529496149537, 0.2580313221680792, 0.2507944193397187, 0.2438220816315663, 0.2371024684310595, 0.23062436292774813, 0.22437713444896926, 0.21835070335180282, 0.21253550827912385, 0.20692247560338903, 0.20150299089620957, 0.1962688722748871, 0.1912123454890693, 0.1863260206216111, 0.18160287028770924, 0.1770362092255004, 0.1726196751796597, 0.1683472109871702, 0.16421304778142662, 0.16021168923724843, 0.15633789678525095, 0.15258667572941426, 0.14895326220664581, 0.14543311093167452, 0.14202188367479887, 0.13871543842385758, 0.1355098191853299, 0.13240124638273224, 0.12938610781348256, 0.1264609501281735, 0.12362247079874705, 0.12086751054442633, 0.11819304618643278, 0.11559618390453141, 0.11307415287030843, 0.11062429923380229, 0.10824408044170457, 0.105931059866821, 0.1036829017298478, 0.10149736629578526, 0.09937230532848387, 0.09730565778790923, 0.09529544575571944, 0.0933397705756917, 0.09143680919640415, 0.08958481070439027, 0.087782093036739, 0.0860270398628127, 0.08431809762540925, 0.08265377273230343, 0.08103262888966728, 0.07945328456939832, 0.07791441060287643, 0.07641472789412963, 0.07495300524581633, 0.07352805729183297, 0.0721387425307291, 0.07078396145445998, 0.06946265476733474, 0.06817380169032179, 0.06691641834615895, 0.0656895562209828, 0.06449230069844214, 0.0633237696624932, 0.06218311216529511, 0.06106950715682889, 0.05998216227305515, 0.05892031267960823, 0.057883219968192165, 0.05687017110300367, 0.055880477414657556, 0.054913473639228355, 0.053968517000155654, 0.05304498633088307, 0.05214228123621838, 0.05125982129051043, 0.05039704527084293, 0.0495534104235413, 0.04872839176237965, 0.04792148139696222, 0.04713218788983302, 0.0463600356409444, 0.04560456429818771, 0.04486532819275507};
        double[] hexagamma = new double[]{-2400015.607203195, -984868.0113398463, -462540.32713685, -239931.2681630441, -134322.06563539596, -79878.85593514646, -49887.94416800961, -32446.93675608204, -21836.055884519235, -15129.384794811105, -10749.451883108344, -7806.803840999136, -5780.140464336635, -4353.444113618946, -3329.364446430115, -2581.366172880453, -2026.385547042753, -1608.7292770587949, -1290.3344944710152, -1044.7317137309503, -853.2195539395107, -702.3917277962108, -582.5086022822323, -486.40663909515735, -408.75659580885963, -345.5516393995954, -293.7493658171229, -251.01832322660056, -215.55644098187406, -185.95955056410222, -161.12520850056765, -140.18166956985627, -122.43496151404433, -107.32911365719222, -94.41603104215636, -83.332502181886, -73.78252552956351, -65.52363202397632, -58.35623189795933, -52.11526615062452, -46.66362589642619, -41.88693635255556, -37.68940051529544, -33.990470430241146, -30.722168329786353, -27.826920748054363, -25.25579958698099, -22.96708757195324, -20.925103476659313, -19.099236289787406, -17.463148155707565, -15.994114200684397, -14.672473818105662, -13.481173053168835, -12.405381718439017, -11.43217202877307, -10.550248051961383, -9.74971727160087, -9.021897160166573, -8.359150947289596, -7.754747806363779, -7.202743522879963, -6.697878390341047, -6.235489635711149, -5.811436130938875, -5.422033519847584, -5.063998196253309, -4.734398822039495, -4.430614283082026, -4.150297154406479, -3.8913418902410464, -3.6518570749307777, -3.430141171239722, -3.2246612868330184, -3.03403455050966, -2.8570117493452587, -2.692462928185364, -2.5393646954507867, -2.396789015251806, -2.263893296411445, -2.139911615040778, -2.024146929515349, -1.9159641656732815, -1.8147840662942953, -1.7200777128441316, -1.6313616394318868, -1.5481934692232264, -1.4701680124279817, -1.3969137726451177, -1.3280898149775535, -1.263382955072843, -1.202505233229596, -1.1451916420408055, -1.0911980798151233, -1.0402995053032216, -0.9922882721248982, -0.9469726238001441, -0.9041753324824819, -0.863732466417034, -0.8254922728346701, -0.7893141644779635, -0.7550677992609373, -0.7226322437155577, -0.6918952118933221, -0.6627523722871863, -0.6351067161321666, -0.6088679811451814, -0.5839521253870685, -0.5602808464820128, -0.5377811419202374, -0.5163849066061116, -0.4960285642022297, -0.4766527291661753, -0.45820189668545364, -0.4406241579918129, -0.42387093878265786, -0.407896758697774, -0.3926590099970798, -0.3781177537621799, -0.36423553210333426, -0.3509771949961262, -0.3383097405003525, -0.32620216722902484, -0.31462533803925224, -0.3035518540104103, -0.2929559378594343, -0.2828133260193067, -0.27310116867568357, -0.2637979371188687, -0.25488333782468986, -0.24633823272886426, -0.23814456520568, -0.23028529130375922, -0.22274431582974388, -0.21550643290531546, -0.2085572706543859, -0.20188323970589217, -0.19547148522363916, -0.18930984219833769, -0.18338679375859177, -0.17769143227728645, -0.1722134230678124, -0.16694297048098913, -0.16187078622855422, -0.1569880597728105, -0.15228643063458402, -0.14775796248314166, -0.14339511888224865, -0.139190740576208, -0.13513802420857446, -0.13123050237436676, -0.12746202491406766, -0.12382674136455452, -0.12031908448841283, -0.11693375480888202, -0.11366570608302029, -0.11051013165059054, -0.10746245160069745, -0.1045183007023805, -0.10167351704921518, -0.09892413137153024, -0.09626635697312602, -0.09369658025240818, -0.09121135177065363, -0.08880737783270969, -0.08648151254782512, -0.08423075034052702, -0.08205221888350851, -0.07994317242639389, -0.0779009854960088, -0.07592314694541785, -0.07400725433050429, -0.07215100859427576, -0.07035220904038375, -0.06860874857855641, -0.0669186092257733, -0.06527985784805607, -0.06369064212872388, -0.06214918674986962, -0.06065378977465539, -0.059202819218811806, -0.05779470980045763, -0.05642795985803868, -0.05510112842681889, -0.053812832464951985, -0.052561744220713635, -0.05134658873299041, -0.05016614145760555, -0.049019226012509604, -0.04790471203528676, -0.04682151314682008, -0.04576858501532671, -0.04474492351531839, -0.0437495629763643, -0.04278157451683516, -0.041840064458088584, -0.04092417281482151, -0.040033071857561706, -0.03916596474350356, -0.038322084212110905, -0.0375006913421128};
        success &= DebugFun.printAllEqual(gamma, MathFunctions.gammafn(x));
        success &= DebugFun.printAllEqual(lgamma, MathFunctions.lgammafn(x));
        success &= DebugFun.printAllEqual(digamma, PolyGamma.digamma(x), 4.0E-14);
        success &= DebugFun.printAllEqual(trigamma, PolyGamma.trigamma(x));
        success &= DebugFun.printAllEqual(tetragamma, PolyGamma.tetragamma(x));
        success &= DebugFun.printAllEqual(pentagamma, PolyGamma.pentagamma(x));
        success &= DebugFun.printAllEqual(hexagamma, PolyGamma.psigamma(x, 4));
        double val = MathFunctions.lmvgammafn(1.6, 2);
        return success &= DebugFun.printBool(DebugFun.isEqual(0.4099007359681045, val));
    }

    public static final void main(String[] args) {
        TestMathFun.test_besselIJ();
        TestMathFun.test_besselKY();
        TestMathFun.test_polygamma();
    }
}

