/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms.activemq;

import java.lang.reflect.Method;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQConnectionFactoryFactory;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnMissingBean(value={ConnectionFactory.class})
class ActiveMQConnectionFactoryConfiguration {
    ActiveMQConnectionFactoryConfiguration() {
    }

    @Bean
    public ConnectionFactory jmsConnectionFactory(ActiveMQProperties properties) {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactoryFactory(properties).createConnectionFactory(ActiveMQConnectionFactory.class);
        if (properties.isPooled()) {
            PooledConnectionFactory pool = new PooledConnectionFactory();
            Method setConnectionFactory = this.findConnectionFactorySetter();
            Assert.state((setConnectionFactory != null ? 1 : 0) != 0, (String)"No supported setConnectionFactory method was found");
            ReflectionUtils.invokeMethod((Method)setConnectionFactory, (Object)pool, (Object[])new Object[]{connectionFactory});
            return pool;
        }
        return connectionFactory;
    }

    private Method findConnectionFactorySetter() {
        Method setter = this.findConnectionFactorySetter(ConnectionFactory.class);
        if (setter == null) {
            setter = this.findConnectionFactorySetter(Object.class);
        }
        return setter;
    }

    private Method findConnectionFactorySetter(Class<?> param) {
        return ReflectionUtils.findMethod(PooledConnectionFactory.class, (String)"setConnectionFactory", (Class[])new Class[]{param});
    }
}

