### R code from vignette source 'ordinalgmifs.Rnw'

###################################################
### code chunk number 1: ordinalgmifs.Rnw:93-94
###################################################
options(width = 70)


###################################################
### code chunk number 2: ordinalgmifs.Rnw:96-100
###################################################
library("ordinalgmifs")
data(hccframe)
cumulative.logit<-ordinal.gmifs(group ~ 1, x = hccframe[,-1], 
	data = hccframe)


###################################################
### code chunk number 3: ordinalgmifs.Rnw:105-106
###################################################
print(cumulative.logit)


###################################################
### code chunk number 4: ordinalgmifs.Rnw:109-110
###################################################
summary(cumulative.logit)


###################################################
### code chunk number 5: ordinalgmifs.Rnw:118-119
###################################################
plot(cumulative.logit)


###################################################
### code chunk number 6: ordinalgmifs.Rnw:127-130
###################################################
phat <- predict(cumulative.logit)
table(phat$class, hccframe$group)
head(phat$predicted)


###################################################
### code chunk number 7: ordinalgmifs.Rnw:134-141
###################################################
class<-character()
for (i in 1:dim(hccframe)[1]) {
	fit<-ordinal.gmifs(group ~ 1, x = hccframe[-i,-1],
		data = hccframe[-i,])
	class[i]<-predict(fit, newx=hccframe[i,-1,drop=FALSE])$class
	}
table(class, hccframe$group)


###################################################
### code chunk number 8: ordinalgmifs.Rnw:146-150
###################################################
cumulative.logit.2 <- ordinal.gmifs(group ~ DDIT3_P1313_R, 
     x = c("CDKN2B_seq_50_S294_F", "ERN1_P809_R", "GML_E144_F",
     	    "HDAC9_P137_R"),  data = hccframe)
summary(cumulative.logit.2)


###################################################
### code chunk number 9: ordinalgmifs.Rnw:153-154
###################################################
coef(cumulative.logit.2)


###################################################
### code chunk number 10: ordinalgmifs.Rnw:157-160
###################################################
phat<-predict(cumulative.logit.2)
head(phat$class)
head(phat$predicted)


###################################################
### code chunk number 11: ordinalgmifs.Rnw:163-169
###################################################
cumulative.logit.m1 <- ordinal.gmifs(group ~ DDIT3_P1313_R, 
     x = c("CDKN2B_seq_50_S294_F", "ERN1_P809_R", "GML_E144_F",
     	    "HDAC9_P137_R"),  data = hccframe[-1,])
predict(cumulative.logit.m1, neww=~DDIT3_P1313_R, newdata=hccframe[1,],
	newx=hccframe[1,c("CDKN2B_seq_50_S294_F", "ERN1_P809_R", 
	"GML_E144_F","HDAC9_P137_R")])


###################################################
### code chunk number 12: ordinalgmifs.Rnw:175-180
###################################################
adj.cat<-ordinal.gmifs(group ~ 1, x = hccframe[, 2:6], 
	data = hccframe, probability.model = "AdjCategory", link = "loge")
summary(adj.cat)
phat.adj <- predict(adj.cat)
table(phat.adj$class, hccframe$group)


###################################################
### code chunk number 13: ordinalgmifs.Rnw:193-200
###################################################
library("Biobase")
data(hccmethyl)
hccexprs.fit<-ordinal.gmifs(group ~ 1, x=t(exprs(hccmethyl)[1:5, ]), 
	data = pData(hccmethyl))
coef(hccexprs.fit)
phat<-predict(hccexprs.fit)
table(phat$class, pData(hccmethyl)$group)


