// Generated by CoffeeScript 1.5.0
(function() {
  var module;

  this.HTTP_STATUS = {
    "ok": 0,
    "loading": 1,
    "error": 2
  };

  module = angular.module('h2o.services.inspect');

  module.service('InspectDataService', function($http, $log, $rootScope) {
    var _this = this;
    this.offset = 0;
    this.defaultLimit = 100;
    this.maxLimit = 1000;
    this.limit = this.defaultLimit;
    this.data = {};
    this.columns = [];
    this.numCols = 0;
    this.numRows = 0;
    this.meta = {
      key: "",
      rowSize: 0,
      valueSizeBytes: 0,
      processingTime: 0
    };
    this.error = "";
    this.status = HTTP_STATUS.ok;
    this.isLoading = false;
    this.validateLimit = function() {
      var intLimitValue, isIntLimitValueInvalid;
      intLimitValue = parseInt(_this.limit);
      isIntLimitValueInvalid = isNaN(intLimitValue) || intLimitValue <= 0;
      if (isIntLimitValueInvalid) {
        return _this.limit = _this.defaultLimit;
      } else {
        if (intLimitValue > _this.maxLimit) {
          return _this.limit = _this.maxLimit;
        } else {
          return _this.limit = intLimitValue;
        }
      }
    };
    this.setStatus = function(status) {
      _this.status = status;
      if (status === HTTP_STATUS.ok) {
        _this.isLoading = false;
        _this.error = "";
      }
      if (status === HTTP_STATUS.loading) {
        _this.isLoading = true;
        _this.error = "";
      }
      if (status === HTTP_STATUS.error) {
        return _this.isLoading = false;
      }
    };
    this.apiURI = function() {
      return JSONApiServerURI();
    };
    this.apiFetchURIString = function() {
      return _this.apiURI().addQuery({
        offset: _this.offset,
        view: _this.limit != null ? _this.limit : void 0
      }).toString();
    };
    this.checkColumnValidity = function(column, data) {
      if (column.base == null) {
        $log.log("'base' missing from column", column);
        return false;
      }
      if (column.max == null) {
        $log.log("'max' missing from column", column);
        return false;
      }
      if (column.min == null) {
        $log.log("'min' missing from column", column);
        return false;
      }
      if (column.mean == null) {
        $log.log("'mean' missing from column", column);
        return false;
      }
      if (column.num_missing_values == null) {
        $log.log("'num_missing_values' missing from column", column);
        return false;
      }
      if (column.name == null) {
        $log.log("'name' missing from column", column);
        return false;
      }
      if (column.variance == null) {
        $log.log("'name' missing from column", column);
        return false;
      }
      if (column.type == null) {
        $log.log("'type' missing from column", column);
        return false;
      }
      return true;
    };
    this.checkRowValidity = function(row, data) {
      if (row.row == null) {
        $log.log("'row' missing from row", row);
        return false;
      }
      return true;
    };
    this.checkResponseValidity = function(data) {
      var colsValid, rowsValid;
      if (data.key == null) {
        $log.log("'key' missing from response");
        return false;
      }
      if (data.row_size == null) {
        $log.log("'row_size' missing from response");
        return false;
      }
      if (data.value_size_bytes == null) {
        $log.log("'value_size_bytes' missing from response");
        return false;
      }
      if (data.num_rows == null) {
        $log.log("'num_rows' missing from response");
        return false;
      }
      if (data.num_cols == null) {
        $log.log("'num_cols' missing from response");
        return false;
      }
      if (data.cols == null) {
        $log.log("'cols' missing from response");
        return false;
      }
      if (data.rows == null) {
        $log.log("'rows' missing from response");
        return false;
      }
      if (!data.status === "done") {
        $log.log("Wrong status: ", data.status);
        return false;
      }
      colsValid = true;
      angular.forEach(data.cols, function(c) {
        if (!_this.checkColumnValidity(c, data)) {
          return colsValid = false;
        }
      });
      if (!colsValid) {
        $log.log("Columns not valid: ", data.cols);
        return false;
      }
      rowsValid = true;
      angular.forEach(data.rows, function(r) {
        if (!_this.checkRowValidity(r, data)) {
          return rowsValid = false;
        }
      });
      if (!rowsValid) {
        $log.log("Rows not valid: ", data.cols);
        return false;
      }
      return true;
    };
    return this.fetch = function(newOffset) {
      _this.setStatus(HTTP_STATUS.loading);
      return $http({
        method: "GET",
        url: _this.apiFetchURIString()
      }).success(function(data, status, headers, config) {
        var newColumns, newRows, _ref, _ref1;
        if (!_this.checkResponseValidity(data)) {
          _this.error = (_ref = data.error) != null ? _ref : 'Received data is not valid';
          _this.setStatus(HTTP_STATUS.error);
          return;
        }
        newColumns = [];
        newColumns.push({
          name: "row",
          visual: "Row",
          unfilterable: true
        });
        angular.forEach(data.cols, function(c) {
          c.visual = c.name;
          return newColumns.push(c);
        });
        newRows = [];
        angular.forEach(data.rows, function(r) {
          return newRows.push(r);
        });
        _this.numRows = data.num_rows;
        _this.numCols = data.num_cols;
        _this.rows = newRows;
        _this.columns = newColumns;
        _this.limit = _this.rows.length > 0 ? _this.rows.length : null;
        _this.meta = {
          key: data.key,
          rowSize: data.row_size,
          valueSizeBytes: data.value_size_bytes,
          processingTime: (_ref1 = data.response.time) != null ? _ref1 : 0
        };
        _this.setStatus(HTTP_STATUS.ok);
        return $log.log('Done', _this.numRows, _this.numCols, data);
      }).error(function(data, status, headers, config) {
        $log.log('Error');
        _this.error = "Could not communicate with the backend.";
        return _this.setStatus(HTTP_STATUS.error);
      });
    };
  });

  module.service('InspectColumnService', function($http, $log, $rootScope, InspectDataService) {
    var _this = this;
    this.tableData = [];
    this.tableHeaders = [];
    this.filterableTableHeaders = [];
    this.orderedTableHeaders = [];
    this.shownTableHeaders = {};
    this.filteredTableHeaders = [];
    this.columnsShown = 0;
    this.defaultOrder = [];
    this.init = function() {
      var $scope, prepareDataFunc;
      prepareDataFunc = function(newVal, oldVal, scope) {
        if (newVal == null) {
          return;
        }
        return _this.prepareData();
      };
      $scope = $rootScope.$new();
      $scope.$watch((function() {
        return InspectDataService.rows;
      }), prepareDataFunc);
      return $scope.$watch((function() {
        return InspectDataService.columns;
      }), prepareDataFunc);
    };
    this.columnForColumnName = function(cName) {
      var column, _i, _len, _ref;
      _ref = this.tableHeaders;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        column = _ref[_i];
        if (column.name === cName) {
          return column;
        }
      }
      return null;
    };
    this.prepareData = function() {
      var newDefaultOrder, newFilterableTableHeaders, newTableData, newTableHeaders;
      newTableData = [];
      newDefaultOrder = [];
      newTableHeaders = [];
      newFilterableTableHeaders = [];
      angular.forEach(InspectDataService.columns, function(c) {
        var _ref;
        newTableHeaders.push(c);
        newDefaultOrder.push(c);
        if (!((_ref = c.unfilterable) != null ? _ref : false)) {
          return newFilterableTableHeaders.push(c);
        }
      });
      angular.forEach(InspectDataService.rows, function(r) {
        return newTableData.push(r);
      });
      _this.defaultOrder = newDefaultOrder;
      _this.tableData = newTableData;
      _this.tableHeaders = newTableHeaders;
      _this.filterableTableHeaders = newFilterableTableHeaders;
      return _this.refilter();
    };
    this.resetFiltering = function() {
      angular.forEach(_this.tableHeaders, function(c) {
        return _this.shownTableHeaders[c.name] = true;
      });
      return _this.orderedTableHeaders = _this.tableHeaders;
    };
    this.revertToDefaultOrder = function() {
      return _this.setNewColumnOrder(_this.defaultOrder);
    };
    this.setNewColumnOrder = function(newOrderedTableHeaders) {
      _this.orderedTableHeaders = newOrderedTableHeaders;
      return _this.refilter();
    };
    this.setNewColumnOrderByNames = function(newOrder) {
      var newOrderedTableHeaders;
      newOrderedTableHeaders = [];
      angular.forEach(newOrder, function(cName) {
        return newOrderedTableHeaders.push(_this.columnForColumnName(cName));
      });
      return _this.setNewColumnOrder(newOrderedTableHeaders);
    };
    this.refilter = function() {
      var newColumnsShown, newFilteredTableHeaders;
      if ((_this.orderedTableHeaders == null) || _this.orderedTableHeaders.length === 0) {
        _this.resetFiltering();
      }
      newFilteredTableHeaders = [];
      angular.forEach(_this.orderedTableHeaders, function(c) {
        return newFilteredTableHeaders.push(c);
      });
      newColumnsShown = 0;
      angular.forEach(newFilteredTableHeaders, function(c) {
        var _ref;
        c.shown = (_ref = _this.shownTableHeaders[c.name]) != null ? _ref : true;
        return newColumnsShown += c.shown;
      });
      _this.columnsShown = newColumnsShown;
      return _this.filteredTableHeaders = newFilteredTableHeaders;
    };
    return this.init();
  });

}).call(this);
