### R code from vignette source 'ees.Rnw'

###################################################
### code chunk number 1: ees.Rnw:43-51
###################################################
library(eventstudies)
data(eesData)
input <- eesData$sp500
# Suppress messages
  deprintize<-function(f){
    return(function(...) {capture.output(w<-f(...));return(w);});
  }
output <- deprintize(ees)(input, prob.value=5)


###################################################
### code chunk number 2: ees.Rnw:72-73
###################################################
output$data.summary


###################################################
### code chunk number 3: ees.Rnw:83-84
###################################################
str(output$lower.tail$data)


###################################################
### code chunk number 4: ees.Rnw:98-99
###################################################
output$lower.tail$extreme.event.distribution


###################################################
### code chunk number 5: ees.Rnw:109-110
###################################################
output$lower.tail$runlength


###################################################
### code chunk number 6: ees.Rnw:117-118
###################################################
output$lower.tail$quantile.values


###################################################
### code chunk number 7: ees.Rnw:126-127
###################################################
output$lower.tail$yearly.extreme.event


###################################################
### code chunk number 8: ees.Rnw:145-148
###################################################
sum(output$lower.tail$yearly.extreme.event[,"number.lowertail"])
output$lower.tail$extreme.event.distribution[,"unclstr"]
output$lower.tail$runlength


###################################################
### code chunk number 9: ees.Rnw:164-167
###################################################
eesPlot(z=eesData, response.series.name="nifty", event.series.name="sp500",
        titlestring="S&P500", ylab="(Cum.) change in NIFTY", prob.value=5, 
        width=5)


###################################################
### code chunk number 10: ees.Rnw:174-175
###################################################
res <- deprintize(eesPlot)(z=eesData, response.series.name="nifty", event.series.name="sp500",titlestring="S&P500", ylab="(Cum.) change in NIFTY", prob.value=5, width=5)


