/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.Fit;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import com.garmin.fit.csv.CSVWriter;
import java.util.ArrayList;
import java.util.Collection;

public class MesgCSVWriter
implements MesgListener,
MesgDefinitionListener {
    private CSVWriter csv;
    private boolean showInvalidsAsEmptyCells = false;

    public MesgCSVWriter(String string) {
        this.csv = new CSVWriter(string);
    }

    public void close() {
        this.csv.close();
    }

    public void showInvalidsAsEmptyCells() {
        this.showInvalidsAsEmptyCells = true;
    }

    @Override
    public void onMesgDefinition(MesgDefinition mesgDefinition) {
        ArrayList<FieldDefinition> arrayList = mesgDefinition.getFields();
        Mesg mesg = Factory.createMesg(mesgDefinition.getNum());
        this.csv.clear();
        this.csv.set("Type", "Definition");
        this.csv.set("Local Number", mesgDefinition.getLocalNum());
        if (mesg == null) {
            this.csv.set("Message", "unknown");
        } else {
            this.csv.set("Message", mesg.getName());
        }
        int n = 0;
        for (FieldDefinition fieldDefinition : arrayList) {
            Field field = Factory.createField(mesgDefinition.getNum(), fieldDefinition.getNum());
            ++n;
            if (field == null) {
                this.csv.set("Field " + n, "unknown");
            } else {
                this.csv.set("Field " + n, field.getName());
            }
            this.csv.set("Value " + n, fieldDefinition.getSize() / Fit.baseTypeSizes[fieldDefinition.getType() & 0x1F]);
            this.csv.set("Units " + n, "");
        }
        this.csv.writeln();
    }

    @Override
    public void onMesg(Mesg mesg) {
        Collection<Field> collection = mesg.getFields();
        this.csv.clear();
        this.csv.set("Type", "Data");
        this.csv.set("Local Number", mesg.getLocalNum());
        this.csv.set("Message", mesg.getName());
        int n = 0;
        for (Field field : collection) {
            int n2 = mesg.GetActiveSubFieldIndex(field.getNum());
            this.csv.set("Field " + ++n, field.getName(n2));
            String string = field.getStringValue(0, n2);
            if (string == null || this.showInvalidsAsEmptyCells && string.equals(Fit.baseTypeInvalidMap.get(field.getType(n2)).toString())) {
                string = "";
            }
            for (int i = 1; i < field.getNumValues(); ++i) {
                string = string + "|";
                String string2 = field.getStringValue(i, n2);
                if (string2 == null) continue;
                string = string + string2;
            }
            string = string.replaceAll("\"", "\"\"");
            string = "\"" + string + "\"";
            this.csv.set("Value " + n, string);
            this.csv.set("Units " + n, field.getUnits(n2));
        }
        this.csv.writeln();
    }
}

