/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.search.stopcriteria;

import java.util.concurrent.TimeUnit;
import org.jamesframework.core.search.Search;
import org.jamesframework.core.search.stopcriteria.StopCriterion;

public class MaxTimeWithoutImprovement
implements StopCriterion {
    private final long maxTimeWithoutImprovement;

    public MaxTimeWithoutImprovement(long maxTimeWithoutImprovement, TimeUnit timeUnit) {
        this.maxTimeWithoutImprovement = timeUnit.toMillis(maxTimeWithoutImprovement);
        if (this.maxTimeWithoutImprovement <= 0L) {
            throw new IllegalArgumentException("Error while creating stop criterion: maximum time without improvement should be at least 1 millisecond.");
        }
    }

    @Override
    public boolean searchShouldStop(Search<?> search) {
        return search.getTimeWithoutImprovement() >= this.maxTimeWithoutImprovement;
    }

    public String toString() {
        return "{max time without improvement: " + this.maxTimeWithoutImprovement + " ms}";
    }
}

