/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect;

import com.miraisolutions.xlconnect.CellStyle;
import com.miraisolutions.xlconnect.Common;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellAlignment;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorderPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyles;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPatternFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STBorderStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPatternType;

public class XCellStyle
extends Common
implements CellStyle {
    private final XSSFWorkbook workbook;
    private final int xfId;
    private final int styleXfId;
    private XSSFCellAlignment cellAlignment;

    public XCellStyle(XSSFWorkbook workbook, int xfId, int styleXfId) {
        this.workbook = workbook;
        this.xfId = xfId;
        this.styleXfId = styleXfId;
    }

    private CTXf getCoreXf() {
        if (this.xfId < 0) {
            return this.workbook.getStylesSource().getCellXfAt(0);
        }
        return this.workbook.getStylesSource().getCellXfAt(this.xfId);
    }

    private CTXf getStyleXf() {
        return this.workbook.getStylesSource().getCellStyleXfAt(this.styleXfId);
    }

    private CTXf getXf() {
        if (this.styleXfId > -1) {
            return this.workbook.getStylesSource().getCellStyleXfAt(this.styleXfId);
        }
        return this.getCoreXf();
    }

    private CTBorder getCTBorder() {
        CTBorder ct;
        CTXf xf = this.getXf();
        if (xf.getApplyBorder()) {
            int idx = (int)xf.getBorderId();
            XSSFCellBorder cf = this.workbook.getStylesSource().getBorderAt(idx);
            ct = (CTBorder)cf.getCTBorder().copy();
        } else {
            ct = CTBorder.Factory.newInstance();
        }
        return ct;
    }

    private CTFill getCTFill() {
        CTFill ct;
        CTXf xf = this.getXf();
        if (xf.getApplyFill()) {
            int fillIndex = (int)xf.getFillId();
            XSSFCellFill cf = this.workbook.getStylesSource().getFillAt(fillIndex);
            ct = (CTFill)cf.getCTFill().copy();
        } else {
            ct = CTFill.Factory.newInstance();
        }
        return ct;
    }

    private XSSFCellAlignment getCellAlignment() {
        if (this.cellAlignment == null) {
            this.cellAlignment = new XSSFCellAlignment(this.getCTCellAlignment());
        }
        return this.cellAlignment;
    }

    private CTCellAlignment getCTCellAlignment() {
        CTXf xf = this.getXf();
        if (xf.getAlignment() == null) {
            xf.setAlignment(CTCellAlignment.Factory.newInstance());
        }
        return xf.getAlignment();
    }

    @Override
    public void setBorderBottom(short border) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        CTBorderPr cTBorderPr = pr = ct.isSetBottom() ? ct.getBottom() : ct.addNewBottom();
        if (border == 0) {
            ct.unsetBottom();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
        }
        int idx = this.workbook.getStylesSource().putBorder(new XSSFCellBorder(ct));
        CTXf xf = this.getXf();
        xf.setBorderId((long)idx);
        xf.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)idx);
    }

    @Override
    public void setBorderLeft(short border) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        CTBorderPr cTBorderPr = pr = ct.isSetLeft() ? ct.getLeft() : ct.addNewLeft();
        if (border == 0) {
            ct.unsetLeft();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
        }
        int idx = this.workbook.getStylesSource().putBorder(new XSSFCellBorder(ct));
        CTXf xf = this.getXf();
        xf.setBorderId((long)idx);
        xf.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)idx);
    }

    @Override
    public void setBorderRight(short border) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        CTBorderPr cTBorderPr = pr = ct.isSetRight() ? ct.getRight() : ct.addNewRight();
        if (border == 0) {
            ct.unsetRight();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
        }
        int idx = this.workbook.getStylesSource().putBorder(new XSSFCellBorder(ct));
        CTXf xf = this.getXf();
        xf.setBorderId((long)idx);
        xf.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)idx);
    }

    @Override
    public void setBorderTop(short border) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        CTBorderPr cTBorderPr = pr = ct.isSetTop() ? ct.getTop() : ct.addNewTop();
        if (border == 0) {
            ct.unsetTop();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
        }
        int idx = this.workbook.getStylesSource().putBorder(new XSSFCellBorder(ct));
        CTXf xf = this.getXf();
        xf.setBorderId((long)idx);
        xf.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)idx);
    }

    private void setBottomBorderColor(XSSFColor color) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        if (color == null && !ct.isSetBottom()) {
            return;
        }
        CTBorderPr cTBorderPr = pr = ct.isSetBottom() ? ct.getBottom() : ct.addNewBottom();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
        int idx = this.workbook.getStylesSource().putBorder(new XSSFCellBorder(ct));
        CTXf xf = this.getXf();
        xf.setBorderId((long)idx);
        xf.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)idx);
    }

    @Override
    public void setBottomBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed((int)color);
        this.setBottomBorderColor(clr);
    }

    private void setLeftBorderColor(XSSFColor color) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        if (color == null && !ct.isSetLeft()) {
            return;
        }
        CTBorderPr cTBorderPr = pr = ct.isSetLeft() ? ct.getLeft() : ct.addNewLeft();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
        int idx = this.workbook.getStylesSource().putBorder(new XSSFCellBorder(ct));
        CTXf xf = this.getXf();
        xf.setBorderId((long)idx);
        xf.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)idx);
    }

    @Override
    public void setLeftBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed((int)color);
        this.setLeftBorderColor(clr);
    }

    private void setRightBorderColor(XSSFColor color) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        if (color == null && !ct.isSetRight()) {
            return;
        }
        CTBorderPr cTBorderPr = pr = ct.isSetRight() ? ct.getRight() : ct.addNewRight();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
        int idx = this.workbook.getStylesSource().putBorder(new XSSFCellBorder(ct));
        CTXf xf = this.getXf();
        xf.setBorderId((long)idx);
        xf.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)idx);
    }

    @Override
    public void setRightBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed((int)color);
        this.setRightBorderColor(clr);
    }

    private void setTopBorderColor(XSSFColor color) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        if (color == null && !ct.isSetTop()) {
            return;
        }
        CTBorderPr cTBorderPr = pr = ct.isSetTop() ? ct.getTop() : ct.addNewTop();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
        int idx = this.workbook.getStylesSource().putBorder(new XSSFCellBorder(ct));
        CTXf xf = this.getXf();
        xf.setBorderId((long)idx);
        xf.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)idx);
    }

    @Override
    public void setTopBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed((int)color);
        this.setTopBorderColor(clr);
    }

    @Override
    public void setDataFormat(String format) {
        XSSFDataFormat dataFormat = this.workbook.createDataFormat();
        short fmtId = dataFormat.getFormat(format);
        CTXf xf = this.getXf();
        xf.setApplyNumberFormat(true);
        xf.setNumFmtId((long)fmtId);
        this.getCoreXf().setNumFmtId((long)fmtId);
    }

    private void setFillBackgroundColor(XSSFColor color) {
        CTFill ct = this.getCTFill();
        CTPatternFill ptrn = ct.getPatternFill();
        if (color == null) {
            if (ptrn != null) {
                ptrn.unsetBgColor();
            }
        } else {
            if (ptrn == null) {
                ptrn = ct.addNewPatternFill();
            }
            ptrn.setBgColor(color.getCTColor());
        }
        int idx = this.workbook.getStylesSource().putFill(new XSSFCellFill(ct));
        CTXf xf = this.getXf();
        xf.setFillId((long)idx);
        xf.setApplyFill(true);
        this.getCoreXf().setFillId((long)idx);
    }

    @Override
    public void setFillBackgroundColor(short bg) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed((int)bg);
        this.setFillBackgroundColor(clr);
    }

    private void setFillForegroundColor(XSSFColor color) {
        CTFill ct = this.getCTFill();
        CTPatternFill ptrn = ct.getPatternFill();
        if (color == null) {
            if (ptrn != null) {
                ptrn.unsetFgColor();
            }
        } else {
            if (ptrn == null) {
                ptrn = ct.addNewPatternFill();
            }
            ptrn.setFgColor(color.getCTColor());
        }
        int idx = this.workbook.getStylesSource().putFill(new XSSFCellFill(ct));
        CTXf xf = this.getXf();
        xf.setFillId((long)idx);
        xf.setApplyFill(true);
        this.getCoreXf().setFillId((long)idx);
    }

    @Override
    public void setFillForegroundColor(short fg) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed((int)fg);
        this.setFillForegroundColor(clr);
    }

    @Override
    public void setFillPattern(short fp) {
        CTPatternFill ptrn;
        CTFill ct = this.getCTFill();
        CTPatternFill cTPatternFill = ptrn = ct.isSetPatternFill() ? ct.getPatternFill() : ct.addNewPatternFill();
        if (fp == 0 && ptrn.isSetPatternType()) {
            ptrn.unsetPatternType();
        } else {
            ptrn.setPatternType(STPatternType.Enum.forInt((int)(fp + 1)));
        }
        int idx = this.workbook.getStylesSource().putFill(new XSSFCellFill(ct));
        CTXf xf = this.getXf();
        xf.setFillId((long)idx);
        xf.setApplyFill(true);
        this.getCoreXf().setFillId((long)idx);
    }

    @Override
    public void setWrapText(boolean wrap) {
        this.getCellAlignment().setWrapText(wrap);
    }

    public static XCellStyle create(XSSFWorkbook workbook, String name) {
        int styleXfSize = 0;
        CTXf xf = CTXf.Factory.newInstance();
        xf.setNumFmtId(0L);
        xf.setFontId(0L);
        xf.setFillId(0L);
        xf.setBorderId(0L);
        if (name != null) {
            CTCellStyles ctCellStyles = workbook.getStylesSource().getCTStylesheet().getCellStyles();
            if (ctCellStyles == null) {
                ctCellStyles = workbook.getStylesSource().getCTStylesheet().addNewCellStyles();
                ctCellStyles.setCount(0L);
            }
            if (ctCellStyles.getCount() == 0L) {
                CTCellStyle standardCellStyle = ctCellStyles.addNewCellStyle();
                standardCellStyle.setName("Standard");
                standardCellStyle.setXfId(0L);
                standardCellStyle.setBuiltinId(0L);
                ctCellStyles.setCount(1L);
            }
            CTXf styleXf = CTXf.Factory.newInstance();
            styleXf.setNumFmtId(0L);
            styleXf.setFontId(0L);
            styleXf.setFillId(0L);
            styleXf.setBorderId(0L);
            styleXfSize = workbook.getStylesSource().putCellStyleXf(styleXf);
            xf.setXfId((long)(styleXfSize - 1));
            CTCellStyle ctCellStyle = ctCellStyles.addNewCellStyle();
            ctCellStyle.setName(name);
            ctCellStyle.setXfId((long)(styleXfSize - 1));
            ctCellStyles.setCount(ctCellStyles.getCount() + 1L);
        }
        int xfSize = workbook.getStylesSource().putCellXf(xf);
        return new XCellStyle(workbook, xfSize - 1, styleXfSize - 1);
    }

    public static XCellStyle get(XSSFWorkbook workbook, String name) {
        StylesTable stylesSource = workbook.getStylesSource();
        CTCellStyles ctCellStyles = stylesSource.getCTStylesheet().getCellStyles();
        if (ctCellStyles != null) {
            int i = 0;
            while ((long)i < ctCellStyles.getCount()) {
                CTCellStyle ctCellStyle = ctCellStyles.getCellStyleArray(i);
                if (ctCellStyle.getName().equals(name)) {
                    int styleXfId = (int)ctCellStyle.getXfId();
                    return new XCellStyle(workbook, -1, styleXfId);
                }
                ++i;
            }
        }
        return null;
    }

    public static void set(XSSFCell c, XCellStyle cs) {
        if (cs.xfId < 0) {
            CTXf styleXf = cs.getStyleXf();
            CTXf xf = CTXf.Factory.newInstance();
            xf.setNumFmtId(styleXf.getNumFmtId());
            xf.setFontId(styleXf.getFontId());
            xf.setFillId(styleXf.getFillId());
            xf.setBorderId(styleXf.getBorderId());
            xf.setAlignment(styleXf.getAlignment());
            xf.setXfId((long)cs.styleXfId);
            int xfSize = cs.workbook.getStylesSource().putCellXf(xf);
            c.setCellStyle((org.apache.poi.ss.usermodel.CellStyle)new XSSFCellStyle(xfSize - 1, cs.styleXfId, cs.workbook.getStylesSource(), cs.workbook.getTheme()));
        } else if (cs.styleXfId < 0) {
            int styleXfId = 0;
            int id = (int)cs.workbook.getStylesSource().getCellXfAt(cs.xfId).getXfId();
            if (id > 0) {
                styleXfId = id;
            }
            c.setCellStyle((org.apache.poi.ss.usermodel.CellStyle)new XSSFCellStyle(cs.xfId, styleXfId, cs.workbook.getStylesSource(), cs.workbook.getTheme()));
        } else {
            c.setCellStyle((org.apache.poi.ss.usermodel.CellStyle)new XSSFCellStyle(cs.xfId, cs.styleXfId, cs.workbook.getStylesSource(), cs.workbook.getTheme()));
        }
    }
}

