/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.properties.paragraph;

import java.math.BigInteger;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.properties.paragraph.AbstractParagraphProperty;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class Indent
extends AbstractParagraphProperty {
    protected static Logger log = LoggerFactory.getLogger(Indent.class);
    public static final String CSS_NAME = "margin-left";
    public static final String FO_NAME = "start-indent";
    public static final String FO_NAME_TEXT_INDENT = "text-indent";

    public String getCssName() {
        return CSS_NAME;
    }

    public Indent(PPrBase.Ind val) {
        this.setObject(val);
    }

    public Indent(PPrBase.Ind pPrDirectIndent, PPrBase.Ind numberingIndent) {
        PPrBase.Ind val = Context.getWmlObjectFactory().createPPrBaseInd();
        if (pPrDirectIndent != null) {
            StyleUtil.apply(pPrDirectIndent, val);
        }
        if (numberingIndent != null) {
            if (val.getHanging() == null && val.getFirstLine() == null && numberingIndent.getHanging() != null) {
                val.setHanging(numberingIndent.getHanging());
            }
            if (val.getFirstLine() == null && numberingIndent.getFirstLine() != null) {
                val.setFirstLine(numberingIndent.getFirstLine());
            }
            if (val.getLeft() == null && numberingIndent.getLeft() != null) {
                val.setLeft(numberingIndent.getLeft());
            }
        }
        this.setObject(val);
    }

    public Indent(CSSValue value) {
        this.debug(CSS_NAME, value);
        PPrBase.Ind ind = Context.getWmlObjectFactory().createPPrBaseInd();
        CSSPrimitiveValue cssPrimitiveValue = (CSSPrimitiveValue)value;
        int twip = Indent.getTwip(cssPrimitiveValue);
        ind.setLeft(BigInteger.valueOf(twip));
        this.setObject(ind);
    }

    public static int getTwip(CSSPrimitiveValue cssPrimitiveValue) {
        int twip;
        short ignored = 1;
        float fVal = cssPrimitiveValue.getFloatValue(ignored);
        log.debug("margin-left: " + fVal);
        if (fVal == 0.0f) {
            return 0;
        }
        short type = cssPrimitiveValue.getPrimitiveType();
        if (5 == type) {
            twip = UnitsOfMeasurement.pxToTwip(fVal);
        } else if (6 == type) {
            twip = UnitsOfMeasurement.mmToTwip(fVal * 10.0f);
        } else if (7 == type) {
            twip = UnitsOfMeasurement.mmToTwip(fVal);
        } else if (8 == type) {
            twip = UnitsOfMeasurement.inchToTwip(fVal);
        } else if (9 == type) {
            twip = UnitsOfMeasurement.pointToTwip(fVal);
        } else if (1 == type) {
            log.error("Indent: No support for unspecified unit: CSS_NUMBER ");
            twip = 0;
        } else {
            log.error("Indent: No support for unit " + type);
            twip = 0;
        }
        return twip;
    }

    public String getCssProperty() {
        String prop = "position: relative; ";
        BigInteger left = ((PPrBase.Ind)this.getObject()).getLeft();
        if (left != null) {
            prop = prop + Indent.composeCss(CSS_NAME, UnitsOfMeasurement.twipToBest(left.intValue()));
        }
        BigInteger firstline = ((PPrBase.Ind)this.getObject()).getFirstLine();
        BigInteger hanging = ((PPrBase.Ind)this.getObject()).getHanging();
        if (hanging != null) {
            prop = prop + Indent.composeCss(FO_NAME_TEXT_INDENT, "-" + UnitsOfMeasurement.twipToBest(hanging.intValue()));
        } else if (firstline != null) {
            prop = prop + Indent.composeCss(FO_NAME_TEXT_INDENT, UnitsOfMeasurement.twipToBest(firstline.intValue()));
        }
        if (left == null && firstline == null && hanging == null) {
            log.debug("What to do with " + XmlUtils.marshaltoString(this.getObject(), true, true));
            prop = "";
        }
        return prop;
    }

    public void setXslFO(Element foElement) {
        boolean updated = false;
        BigInteger left = ((PPrBase.Ind)this.getObject()).getLeft();
        if (left != null) {
            foElement.setAttribute(FO_NAME, UnitsOfMeasurement.twipToBest(left.intValue()));
            updated = true;
        }
        BigInteger firstLine = ((PPrBase.Ind)this.getObject()).getFirstLine();
        BigInteger hanging = ((PPrBase.Ind)this.getObject()).getHanging();
        if (hanging != null) {
            foElement.setAttribute(FO_NAME_TEXT_INDENT, UnitsOfMeasurement.twipToBest(-hanging.intValue()));
        } else if (firstLine != null) {
            foElement.setAttribute(FO_NAME_TEXT_INDENT, UnitsOfMeasurement.twipToBest(firstLine.intValue()));
            updated = true;
        }
        if (!updated) {
            log.warn("Only left/first-line indentation is handled at present");
        }
    }

    public boolean isHanging() {
        return ((PPrBase.Ind)this.getObject()).getHanging() != null;
    }

    public int getNumberPosition() {
        boolean updated = false;
        BigInteger left = ((PPrBase.Ind)this.getObject()).getLeft();
        int leftInt = 0;
        if (left != null) {
            leftInt = left.intValue();
        }
        BigInteger firstLine = ((PPrBase.Ind)this.getObject()).getFirstLine();
        BigInteger hanging = ((PPrBase.Ind)this.getObject()).getHanging();
        if (hanging != null) {
            int hangingInt = hanging.intValue();
            return leftInt - hangingInt;
        }
        int firstLineInt = 0;
        if (firstLine != null) {
            firstLineInt = firstLine.intValue();
        }
        return leftInt + firstLineInt;
    }

    public void setXslFOListBlock(Element foElement, int pdbs) {
        boolean updated = false;
        BigInteger left = ((PPrBase.Ind)this.getObject()).getLeft();
        int leftInt = 0;
        if (left != null) {
            leftInt = left.intValue();
        }
        BigInteger firstLine = ((PPrBase.Ind)this.getObject()).getFirstLine();
        BigInteger hanging = ((PPrBase.Ind)this.getObject()).getHanging();
        if (hanging != null) {
            int hangingInt = hanging.intValue();
            foElement.setAttribute(FO_NAME, UnitsOfMeasurement.twipToBest(leftInt - hangingInt));
            foElement.setAttribute("provisional-distance-between-starts", UnitsOfMeasurement.twipToBest(hangingInt));
            foElement.setAttribute(FO_NAME_TEXT_INDENT, UnitsOfMeasurement.twipToBest(0));
        } else {
            int firstLineInt = 0;
            if (firstLine != null) {
                firstLineInt = firstLine.intValue();
            }
            foElement.setAttribute("provisional-distance-between-starts", UnitsOfMeasurement.twipToBest(pdbs));
            System.out.println("Using pdbs " + pdbs + "=" + UnitsOfMeasurement.twipToBest(pdbs));
            foElement.setAttribute(FO_NAME, UnitsOfMeasurement.twipToBest(leftInt - pdbs));
            foElement.setAttribute(FO_NAME_TEXT_INDENT, UnitsOfMeasurement.twipToBest(firstLineInt + pdbs));
        }
        updated = true;
        if (!updated) {
            log.warn("Only left/first-line indentation is handled at present");
        }
    }

    public void set(PPr pPr) {
        pPr.setInd((PPrBase.Ind)this.getObject());
    }
}

