/*
 * Decompiled with CFR 0.152.
 */
package nlcon;

import java.text.ParseException;
import org.nlogo.api.LogoList;

public class NLResult {
    private String type = null;
    private Object resultValue = null;

    public void setResultValue(Object o) throws Exception {
        this.logoToType(o);
    }

    public String getType() {
        return this.type;
    }

    public String getResultAsString() {
        return (String)this.resultValue;
    }

    public double getResultAsDouble() {
        return (Double)this.resultValue;
    }

    public boolean getResultAsBoolean() {
        return (Boolean)this.resultValue;
    }

    public double[] getResultAsDoubleArray() {
        return (double[])this.resultValue;
    }

    public boolean[] getResultAsBooleanArray() {
        return (boolean[])this.resultValue;
    }

    public String[] getResultAsStringArray() {
        return (String[])this.resultValue;
    }

    public Object getResultAsObject() {
        return this.resultValue;
    }

    public Object[] getResultAsObjectArray() {
        return (Object[])this.resultValue;
    }

    private void logoToType(Object o) throws Exception {
        if (o instanceof LogoList) {
            this.type = "LogoList";
            LogoList loli = (LogoList)o;
            this.resultValue = this.cast_logolist(loli, false);
        } else if (o instanceof String) {
            this.type = "String";
            this.resultValue = (String)o;
        } else if (o instanceof Double) {
            this.type = "Double";
            this.resultValue = (Double)o;
        } else if (o instanceof Boolean) {
            this.type = "Boolean";
            this.resultValue = (Boolean)o;
        } else {
            this.type = "Unknown";
            this.resultValue = null;
            throw new Exception("Found unknown datatype: " + o);
        }
    }

    private Object cast_logolist(LogoList logolist, Boolean recursive) throws Exception {
        try {
            if (logolist.get(0) instanceof LogoList) {
                Object[] lilist = new Object[logolist.size()];
                int i = 0;
                while (i < logolist.size()) {
                    NLResult nestedResult = new NLResult();
                    nestedResult.setResultValue(logolist.get(i));
                    lilist[i] = nestedResult;
                    ++i;
                }
                this.type = "NestedList";
                return lilist;
            }
            if (logolist.get(0) instanceof String) {
                String[] stringlist = new String[logolist.size()];
                int i = 0;
                while (i < logolist.size()) {
                    stringlist[i] = (String)logolist.get(i);
                    ++i;
                }
                if (!recursive.booleanValue()) {
                    this.type = "StringList";
                }
                return stringlist;
            }
            if (logolist.get(0) instanceof Double) {
                double[] dblist = new double[logolist.size()];
                int i = 0;
                while (i < logolist.size()) {
                    dblist[i] = (Double)logolist.get(i);
                    ++i;
                }
                if (!recursive.booleanValue()) {
                    this.type = "DoubleList";
                }
                return dblist;
            }
            if (logolist.get(0) instanceof Boolean) {
                boolean[] boollist = new boolean[logolist.size()];
                int i = 0;
                while (i < logolist.size()) {
                    if (!recursive.booleanValue()) {
                        this.type = "BoolList";
                    }
                    boollist[i] = (Boolean)logolist.get(i);
                    ++i;
                }
                return boollist;
            }
        }
        catch (Exception ex) {
            throw new ParseException("Java error in converting result: " + ex, 1);
        }
        return null;
    }
}

