/*
 * Decompiled with CFR 0.152.
 */
package org.bson.types;

import java.io.Serializable;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BSONTimestamp
implements Comparable<BSONTimestamp>,
Serializable {
    private static final long serialVersionUID = -3268482672267936464L;
    static final boolean D = Boolean.getBoolean("DEBUG.DBTIMESTAMP");
    final int _inc;
    final Date _time;

    public BSONTimestamp() {
        this._inc = 0;
        this._time = null;
    }

    public BSONTimestamp(int time, int inc) {
        this._time = new Date((long)time * 1000L);
        this._inc = inc;
    }

    public int getTime() {
        if (this._time == null) {
            return 0;
        }
        return (int)(this._time.getTime() / 1000L);
    }

    public int getInc() {
        return this._inc;
    }

    public String toString() {
        return "TS time:" + this._time + " inc:" + this._inc;
    }

    @Override
    public int compareTo(BSONTimestamp ts) {
        if (this.getTime() != ts.getTime()) {
            return this.getTime() - ts.getTime();
        }
        return this.getInc() - ts.getInc();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this._inc;
        result2 = 31 * result2 + this.getTime();
        return result2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BSONTimestamp) {
            BSONTimestamp t2 = (BSONTimestamp)obj;
            return this.getTime() == t2.getTime() && this.getInc() == t2.getInc();
        }
        return false;
    }
}

