/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.Polyadic;
import com.hp.hpl.jena.graph.impl.SimpleEventManager;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Iterator;
import java.util.Set;

public class MultiUnion
extends Polyadic {
    public MultiUnion() {
    }

    public MultiUnion(Graph[] graphs) {
        super(graphs);
    }

    public MultiUnion(Iterator graphs) {
        super(graphs);
    }

    public Reifier getReifier() {
        Graph base = this.getBaseGraph();
        return base == null ? super.getReifier() : base.getReifier();
    }

    public void performAdd(Triple t) {
        this.getRequiredBaseGraph().add(t);
    }

    public void performDelete(Triple t) {
        this.getRequiredBaseGraph().delete(t);
    }

    public boolean graphBaseContains(Triple t) {
        Iterator i = this.m_subGraphs.iterator();
        while (i.hasNext()) {
            if (!((Graph)i.next()).contains(t)) continue;
            return true;
        }
        return false;
    }

    public ExtendedIterator graphBaseFind(TripleMatch t) {
        Set seen = CollectionFactory.createHashedSet();
        ExtendedIterator i = NullIterator.instance;
        Iterator graphs = this.m_subGraphs.iterator();
        while (graphs.hasNext()) {
            ExtendedIterator newTriples = MultiUnion.recording(MultiUnion.rejecting(((Graph)graphs.next()).find(t), seen), seen);
            i = i.andThen(newTriples);
        }
        return SimpleEventManager.notifyingRemove(this, i);
    }

    public void addGraph(Graph graph) {
        if (!this.m_subGraphs.contains(graph)) {
            this.m_subGraphs.add(graph);
        }
    }
}

