/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest;
import com.amazonaws.services.simpleemail.waiters.GetIdentityVerificationAttributesFunction;
import com.amazonaws.services.simpleemail.waiters.IdentityExists;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonSimpleEmailServiceWaiters {
    private final AmazonSimpleEmailService client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonSimpleEmailServiceWaiters(AmazonSimpleEmailService client) {
        this.client = client;
    }

    public Waiter<GetIdentityVerificationAttributesRequest> identityExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetIdentityVerificationAttributesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new IdentityExists.IsSuccessMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }
}

