/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.UpdateBuildRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdateBuildRequestMarshaller
implements Marshaller<Request<UpdateBuildRequest>, UpdateBuildRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateBuildRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateBuildRequest> marshall(UpdateBuildRequest updateBuildRequest) {
        if (updateBuildRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateBuildRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.UpdateBuild");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateBuildRequest.getBuildId() != null) {
                jsonGenerator.writeFieldName("BuildId").writeValue(updateBuildRequest.getBuildId());
            }
            if (updateBuildRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(updateBuildRequest.getName());
            }
            if (updateBuildRequest.getVersion() != null) {
                jsonGenerator.writeFieldName("Version").writeValue(updateBuildRequest.getVersion());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

