/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.ListBuildsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListBuildsRequestMarshaller
implements Marshaller<Request<ListBuildsRequest>, ListBuildsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListBuildsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListBuildsRequest> marshall(ListBuildsRequest listBuildsRequest) {
        if (listBuildsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listBuildsRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.ListBuilds");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listBuildsRequest.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(listBuildsRequest.getStatus());
            }
            if (listBuildsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listBuildsRequest.getLimit().intValue());
            }
            if (listBuildsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listBuildsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

