/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisfirehose.model.Processor;
import com.amazonaws.services.kinesisfirehose.model.ProcessorParameter;
import com.amazonaws.services.kinesisfirehose.model.transform.ProcessorParameterJsonMarshaller;
import java.util.List;

public class ProcessorJsonMarshaller {
    private static ProcessorJsonMarshaller instance;

    public void marshall(Processor processor, StructuredJsonGenerator jsonGenerator) {
        if (processor == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<ProcessorParameter> parametersList;
            jsonGenerator.writeStartObject();
            if (processor.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(processor.getType());
            }
            if ((parametersList = processor.getParameters()) != null) {
                jsonGenerator.writeFieldName("Parameters");
                jsonGenerator.writeStartArray();
                for (ProcessorParameter parametersListValue : parametersList) {
                    if (parametersListValue == null) continue;
                    ProcessorParameterJsonMarshaller.getInstance().marshall(parametersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ProcessorJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ProcessorJsonMarshaller();
        }
        return instance;
    }
}

