/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.logs.model.Destination;

public class DestinationJsonMarshaller {
    private static DestinationJsonMarshaller instance;

    public void marshall(Destination destination, StructuredJsonGenerator jsonGenerator) {
        if (destination == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (destination.getDestinationName() != null) {
                jsonGenerator.writeFieldName("destinationName").writeValue(destination.getDestinationName());
            }
            if (destination.getTargetArn() != null) {
                jsonGenerator.writeFieldName("targetArn").writeValue(destination.getTargetArn());
            }
            if (destination.getRoleArn() != null) {
                jsonGenerator.writeFieldName("roleArn").writeValue(destination.getRoleArn());
            }
            if (destination.getAccessPolicy() != null) {
                jsonGenerator.writeFieldName("accessPolicy").writeValue(destination.getAccessPolicy());
            }
            if (destination.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(destination.getArn());
            }
            if (destination.getCreationTime() != null) {
                jsonGenerator.writeFieldName("creationTime").writeValue(destination.getCreationTime().longValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DestinationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DestinationJsonMarshaller();
        }
        return instance;
    }
}

