/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitosync.model.Dataset;

public class DatasetJsonMarshaller {
    private static DatasetJsonMarshaller instance;

    public void marshall(Dataset dataset, StructuredJsonGenerator jsonGenerator) {
        if (dataset == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (dataset.getIdentityId() != null) {
                jsonGenerator.writeFieldName("IdentityId").writeValue(dataset.getIdentityId());
            }
            if (dataset.getDatasetName() != null) {
                jsonGenerator.writeFieldName("DatasetName").writeValue(dataset.getDatasetName());
            }
            if (dataset.getCreationDate() != null) {
                jsonGenerator.writeFieldName("CreationDate").writeValue(dataset.getCreationDate());
            }
            if (dataset.getLastModifiedDate() != null) {
                jsonGenerator.writeFieldName("LastModifiedDate").writeValue(dataset.getLastModifiedDate());
            }
            if (dataset.getLastModifiedBy() != null) {
                jsonGenerator.writeFieldName("LastModifiedBy").writeValue(dataset.getLastModifiedBy());
            }
            if (dataset.getDataStorage() != null) {
                jsonGenerator.writeFieldName("DataStorage").writeValue(dataset.getDataStorage().longValue());
            }
            if (dataset.getNumRecords() != null) {
                jsonGenerator.writeFieldName("NumRecords").writeValue(dataset.getNumRecords().longValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DatasetJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DatasetJsonMarshaller();
        }
        return instance;
    }
}

