/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codebuild.model.EnvironmentVariable;
import com.amazonaws.services.codebuild.model.ProjectEnvironment;
import com.amazonaws.services.codebuild.model.transform.EnvironmentVariableJsonMarshaller;
import java.util.List;

public class ProjectEnvironmentJsonMarshaller {
    private static ProjectEnvironmentJsonMarshaller instance;

    public void marshall(ProjectEnvironment projectEnvironment, StructuredJsonGenerator jsonGenerator) {
        if (projectEnvironment == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<EnvironmentVariable> environmentVariablesList;
            jsonGenerator.writeStartObject();
            if (projectEnvironment.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(projectEnvironment.getType());
            }
            if (projectEnvironment.getImage() != null) {
                jsonGenerator.writeFieldName("image").writeValue(projectEnvironment.getImage());
            }
            if (projectEnvironment.getComputeType() != null) {
                jsonGenerator.writeFieldName("computeType").writeValue(projectEnvironment.getComputeType());
            }
            if ((environmentVariablesList = projectEnvironment.getEnvironmentVariables()) != null) {
                jsonGenerator.writeFieldName("environmentVariables");
                jsonGenerator.writeStartArray();
                for (EnvironmentVariable environmentVariablesListValue : environmentVariablesList) {
                    if (environmentVariablesListValue == null) continue;
                    EnvironmentVariableJsonMarshaller.getInstance().marshall(environmentVariablesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ProjectEnvironmentJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ProjectEnvironmentJsonMarshaller();
        }
        return instance;
    }
}

