/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.stepfunctions.AWSStepFunctionsAsync;
import com.amazonaws.services.stepfunctions.AWSStepFunctionsAsyncClientBuilder;
import com.amazonaws.services.stepfunctions.AWSStepFunctionsClient;
import com.amazonaws.services.stepfunctions.model.CreateActivityRequest;
import com.amazonaws.services.stepfunctions.model.CreateActivityResult;
import com.amazonaws.services.stepfunctions.model.CreateStateMachineRequest;
import com.amazonaws.services.stepfunctions.model.CreateStateMachineResult;
import com.amazonaws.services.stepfunctions.model.DeleteActivityRequest;
import com.amazonaws.services.stepfunctions.model.DeleteActivityResult;
import com.amazonaws.services.stepfunctions.model.DeleteStateMachineRequest;
import com.amazonaws.services.stepfunctions.model.DeleteStateMachineResult;
import com.amazonaws.services.stepfunctions.model.DescribeActivityRequest;
import com.amazonaws.services.stepfunctions.model.DescribeActivityResult;
import com.amazonaws.services.stepfunctions.model.DescribeExecutionRequest;
import com.amazonaws.services.stepfunctions.model.DescribeExecutionResult;
import com.amazonaws.services.stepfunctions.model.DescribeStateMachineRequest;
import com.amazonaws.services.stepfunctions.model.DescribeStateMachineResult;
import com.amazonaws.services.stepfunctions.model.GetActivityTaskRequest;
import com.amazonaws.services.stepfunctions.model.GetActivityTaskResult;
import com.amazonaws.services.stepfunctions.model.GetExecutionHistoryRequest;
import com.amazonaws.services.stepfunctions.model.GetExecutionHistoryResult;
import com.amazonaws.services.stepfunctions.model.ListActivitiesRequest;
import com.amazonaws.services.stepfunctions.model.ListActivitiesResult;
import com.amazonaws.services.stepfunctions.model.ListExecutionsRequest;
import com.amazonaws.services.stepfunctions.model.ListExecutionsResult;
import com.amazonaws.services.stepfunctions.model.ListStateMachinesRequest;
import com.amazonaws.services.stepfunctions.model.ListStateMachinesResult;
import com.amazonaws.services.stepfunctions.model.SendTaskFailureRequest;
import com.amazonaws.services.stepfunctions.model.SendTaskFailureResult;
import com.amazonaws.services.stepfunctions.model.SendTaskHeartbeatRequest;
import com.amazonaws.services.stepfunctions.model.SendTaskHeartbeatResult;
import com.amazonaws.services.stepfunctions.model.SendTaskSuccessRequest;
import com.amazonaws.services.stepfunctions.model.SendTaskSuccessResult;
import com.amazonaws.services.stepfunctions.model.StartExecutionRequest;
import com.amazonaws.services.stepfunctions.model.StartExecutionResult;
import com.amazonaws.services.stepfunctions.model.StopExecutionRequest;
import com.amazonaws.services.stepfunctions.model.StopExecutionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSStepFunctionsAsyncClient
extends AWSStepFunctionsClient
implements AWSStepFunctionsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSStepFunctionsAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSStepFunctionsAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSStepFunctionsAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSStepFunctionsAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSStepFunctionsAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSStepFunctionsAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSStepFunctionsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSStepFunctionsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSStepFunctionsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSStepFunctionsAsyncClientBuilder asyncBuilder() {
        return AWSStepFunctionsAsyncClientBuilder.standard();
    }

    AWSStepFunctionsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateActivityResult> createActivityAsync(CreateActivityRequest request) {
        return this.createActivityAsync(request, null);
    }

    @Override
    public Future<CreateActivityResult> createActivityAsync(final CreateActivityRequest request, final AsyncHandler<CreateActivityRequest, CreateActivityResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateActivityResult>(){

            @Override
            public CreateActivityResult call() throws Exception {
                CreateActivityResult result;
                try {
                    result = AWSStepFunctionsAsyncClient.this.createActivity(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateStateMachineResult> createStateMachineAsync(CreateStateMachineRequest request) {
        return this.createStateMachineAsync(request, null);
    }

    @Override
    public Future<CreateStateMachineResult> createStateMachineAsync(final CreateStateMachineRequest request, final AsyncHandler<CreateStateMachineRequest, CreateStateMachineResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateStateMachineResult>(){

            @Override
            public CreateStateMachineResult call() throws Exception {
                CreateStateMachineResult result;
                try {
                    result = AWSStepFunctionsAsyncClient.this.createStateMachine(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteActivityResult> deleteActivityAsync(DeleteActivityRequest request) {
        return this.deleteActivityAsync(request, null);
    }

    @Override
    public Future<DeleteActivityResult> deleteActivityAsync(final DeleteActivityRequest request, final AsyncHandler<DeleteActivityRequest, DeleteActivityResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteActivityResult>(){

            @Override
            public DeleteActivityResult call() throws Exception {
                DeleteActivityResult result;
                try {
                    result = AWSStepFunctionsAsyncClient.this.deleteActivity(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteStateMachineResult> deleteStateMachineAsync(DeleteStateMachineRequest request) {
        return this.deleteStateMachineAsync(request, null);
    }

    @Override
    public Future<DeleteStateMachineResult> deleteStateMachineAsync(final DeleteStateMachineRequest request, final AsyncHandler<DeleteStateMachineRequest, DeleteStateMachineResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteStateMachineResult>(){

            @Override
            public DeleteStateMachineResult call() throws Exception {
                DeleteStateMachineResult result;
                try {
                    result = AWSStepFunctionsAsyncClient.this.deleteStateMachine(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeActivityResult> describeActivityAsync(DescribeActivityRequest request) {
        return this.describeActivityAsync(request, null);
    }

    @Override
    public Future<DescribeActivityResult> describeActivityAsync(final DescribeActivityRequest request, final AsyncHandler<DescribeActivityRequest, DescribeActivityResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeActivityResult>(){

            @Override
            public DescribeActivityResult call() throws Exception {
                DescribeActivityResult result;
                try {
                    result = AWSStepFunctionsAsyncClient.this.describeActivity(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeExecutionResult> describeExecutionAsync(DescribeExecutionRequest request) {
        return this.describeExecutionAsync(request, null);
    }

    @Override
    public Future<DescribeExecutionResult> describeExecutionAsync(final DescribeExecutionRequest request, final AsyncHandler<DescribeExecutionRequest, DescribeExecutionResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeExecutionResult>(){

            @Override
            public DescribeExecutionResult call() throws Exception {
                DescribeExecutionResult result;
                try {
                    result = AWSStepFunctionsAsyncClient.this.describeExecution(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStateMachineResult> describeStateMachineAsync(DescribeStateMachineRequest request) {
        return this.describeStateMachineAsync(request, null);
    }

    @Override
    public Future<DescribeStateMachineResult> describeStateMachineAsync(final DescribeStateMachineRequest request, final AsyncHandler<DescribeStateMachineRequest, DescribeStateMachineResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeStateMachineResult>(){

            @Override
            public DescribeStateMachineResult call() throws Exception {
                DescribeStateMachineResult result;
                try {
                    result = AWSStepFunctionsAsyncClient.this.describeStateMachine(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetActivityTaskResult> getActivityTaskAsync(GetActivityTaskRequest request) {
        return this.getActivityTaskAsync(request, null);
    }

    @Override
    public Future<GetActivityTaskResult> getActivityTaskAsync(final GetActivityTaskRequest request, final AsyncHandler<GetActivityTaskRequest, GetActivityTaskResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetActivityTaskResult>(){

            @Override
            public GetActivityTaskResult call() throws Exception {
                GetActivityTaskResult result;
                try {
                    result = AWSStepFunctionsAsyncClient.this.getActivityTask(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetExecutionHistoryResult> getExecutionHistoryAsync(GetExecutionHistoryRequest request) {
        return this.getExecutionHistoryAsync(request, null);
    }

    @Override
    public Future<GetExecutionHistoryResult> getExecutionHistoryAsync(final GetExecutionHistoryRequest request, final AsyncHandler<GetExecutionHistoryRequest, GetExecutionHistoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetExecutionHistoryResult>(){

            @Override
            public GetExecutionHistoryResult call() throws Exception {
                GetExecutionHistoryResult result;
                try {
                    result = AWSStepFunctionsAsyncClient.this.getExecutionHistory(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListActivitiesResult> listActivitiesAsync(ListActivitiesRequest request) {
        return this.listActivitiesAsync(request, null);
    }

    @Override
    public Future<ListActivitiesResult> listActivitiesAsync(final ListActivitiesRequest request, final AsyncHandler<ListActivitiesRequest, ListActivitiesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListActivitiesResult>(){

            @Override
            public ListActivitiesResult call() throws Exception {
                ListActivitiesResult result;
                try {
                    result = AWSStepFunctionsAsyncClient.this.listActivities(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListExecutionsResult> listExecutionsAsync(ListExecutionsRequest request) {
        return this.listExecutionsAsync(request, null);
    }

    @Override
    public Future<ListExecutionsResult> listExecutionsAsync(final ListExecutionsRequest request, final AsyncHandler<ListExecutionsRequest, ListExecutionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListExecutionsResult>(){

            @Override
            public ListExecutionsResult call() throws Exception {
                ListExecutionsResult result;
                try {
                    result = AWSStepFunctionsAsyncClient.this.listExecutions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStateMachinesResult> listStateMachinesAsync(ListStateMachinesRequest request) {
        return this.listStateMachinesAsync(request, null);
    }

    @Override
    public Future<ListStateMachinesResult> listStateMachinesAsync(final ListStateMachinesRequest request, final AsyncHandler<ListStateMachinesRequest, ListStateMachinesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListStateMachinesResult>(){

            @Override
            public ListStateMachinesResult call() throws Exception {
                ListStateMachinesResult result;
                try {
                    result = AWSStepFunctionsAsyncClient.this.listStateMachines(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SendTaskFailureResult> sendTaskFailureAsync(SendTaskFailureRequest request) {
        return this.sendTaskFailureAsync(request, null);
    }

    @Override
    public Future<SendTaskFailureResult> sendTaskFailureAsync(final SendTaskFailureRequest request, final AsyncHandler<SendTaskFailureRequest, SendTaskFailureResult> asyncHandler) {
        return this.executorService.submit(new Callable<SendTaskFailureResult>(){

            @Override
            public SendTaskFailureResult call() throws Exception {
                SendTaskFailureResult result;
                try {
                    result = AWSStepFunctionsAsyncClient.this.sendTaskFailure(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SendTaskHeartbeatResult> sendTaskHeartbeatAsync(SendTaskHeartbeatRequest request) {
        return this.sendTaskHeartbeatAsync(request, null);
    }

    @Override
    public Future<SendTaskHeartbeatResult> sendTaskHeartbeatAsync(final SendTaskHeartbeatRequest request, final AsyncHandler<SendTaskHeartbeatRequest, SendTaskHeartbeatResult> asyncHandler) {
        return this.executorService.submit(new Callable<SendTaskHeartbeatResult>(){

            @Override
            public SendTaskHeartbeatResult call() throws Exception {
                SendTaskHeartbeatResult result;
                try {
                    result = AWSStepFunctionsAsyncClient.this.sendTaskHeartbeat(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SendTaskSuccessResult> sendTaskSuccessAsync(SendTaskSuccessRequest request) {
        return this.sendTaskSuccessAsync(request, null);
    }

    @Override
    public Future<SendTaskSuccessResult> sendTaskSuccessAsync(final SendTaskSuccessRequest request, final AsyncHandler<SendTaskSuccessRequest, SendTaskSuccessResult> asyncHandler) {
        return this.executorService.submit(new Callable<SendTaskSuccessResult>(){

            @Override
            public SendTaskSuccessResult call() throws Exception {
                SendTaskSuccessResult result;
                try {
                    result = AWSStepFunctionsAsyncClient.this.sendTaskSuccess(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartExecutionResult> startExecutionAsync(StartExecutionRequest request) {
        return this.startExecutionAsync(request, null);
    }

    @Override
    public Future<StartExecutionResult> startExecutionAsync(final StartExecutionRequest request, final AsyncHandler<StartExecutionRequest, StartExecutionResult> asyncHandler) {
        return this.executorService.submit(new Callable<StartExecutionResult>(){

            @Override
            public StartExecutionResult call() throws Exception {
                StartExecutionResult result;
                try {
                    result = AWSStepFunctionsAsyncClient.this.startExecution(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopExecutionResult> stopExecutionAsync(StopExecutionRequest request) {
        return this.stopExecutionAsync(request, null);
    }

    @Override
    public Future<StopExecutionResult> stopExecutionAsync(final StopExecutionRequest request, final AsyncHandler<StopExecutionRequest, StopExecutionResult> asyncHandler) {
        return this.executorService.submit(new Callable<StopExecutionResult>(){

            @Override
            public StopExecutionResult call() throws Exception {
                StopExecutionResult result;
                try {
                    result = AWSStepFunctionsAsyncClient.this.stopExecution(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

